/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.marshal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.javatools.marshal.Character2String;
import oracle.javatools.marshal.Class2String;
import oracle.javatools.marshal.StringConversion;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public final class ToStringManager {
    private static final Class<String> _stringClass = String.class;
    private static final Class<StringConversion> _stringConversionClass = StringConversion.class;
    @CodeSharingSafe(value="StaticField")
    private static ConcurrentHashMap<Class<?>, Method> __fromStringMethodMap = new ConcurrentHashMap(23);
    @CodeSharingSafe(value="StaticField")
    private static ConcurrentHashMap<Class<?>, Method> __fromStringMethodMap2 = new ConcurrentHashMap(23);
    @CodeSharingSafe(value="StaticField")
    private static ConcurrentHashMap<Class<?>, Method> __toStringMethodMap = new ConcurrentHashMap(23);
    @CodeSharingSafe(value="StaticField")
    private static Map<Class<?>, Class<?>> __primitiveToWrapped = ToStringManager.initPrimitiveWrapped();
    @CodeSharingSafe(value="StaticField")
    private static ConcurrentHashMap<Class<?>, Boolean> __stringConvertibles = ToStringManager.initStringConvertibles();
    @CodeSharingSafe(value="StaticField")
    private static final boolean dummy = ToStringManager.registerConverters();

    private static Map<Class<?>, Class<?>> initPrimitiveWrapped() {
        HashMap map = new HashMap(15);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Short.TYPE, Short.class);
        map.put(Float.TYPE, Float.class);
        map.put(Double.TYPE, Double.class);
        map.put(Character.TYPE, Character.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Boolean.TYPE, Boolean.class);
        return map;
    }

    private static ConcurrentHashMap<Class<?>, Boolean> initStringConvertibles() {
        ConcurrentHashMap map = new ConcurrentHashMap(23);
        map.put(_stringClass, true);
        map.put(Integer.class, true);
        map.put(Long.class, true);
        map.put(Short.class, true);
        map.put(Float.class, true);
        map.put(Double.class, true);
        map.put(Byte.class, true);
        map.put(Boolean.class, true);
        map.put(BigInteger.class, true);
        map.put(BigDecimal.class, true);
        return map;
    }

    private static boolean registerConverters() {
        boolean result = ToStringManager.registerCustomConverter(Character2String.class);
        return result &= ToStringManager.registerCustomConverter(Class2String.class);
    }

    private ToStringManager() {
    }

    public static boolean registerStringConvertible(Class clazz) {
        if (clazz == null) {
            return false;
        }
        return __stringConvertibles.put(clazz, true);
    }

    public static boolean registerCustomConverter(Class converterClass) {
        if (converterClass == null) {
            return false;
        }
        Class supportedClass = null;
        try {
            if (!Modifier.isPublic(converterClass.getModifiers())) {
                return false;
            }
            Method supportedClassMethod = converterClass.getMethod("supportedClass", null);
            if (!Modifier.isPublic(supportedClassMethod.getModifiers())) {
                return false;
            }
            supportedClass = (Class)supportedClassMethod.invoke(null, null);
            Class[] toStringArgs = new Class[]{supportedClass};
            Method toStringMethod = converterClass.getMethod("toString", toStringArgs);
            int toStringMethodModifiers = toStringMethod.getModifiers();
            if (!Modifier.isStatic(toStringMethodModifiers) || !Modifier.isPublic(toStringMethodModifiers)) {
                return false;
            }
            if (toStringMethod.getReturnType() != _stringClass) {
                return false;
            }
            Class[] fromStringArgs = new Class[]{_stringClass};
            Method fromStringMethod = converterClass.getMethod("fromString", fromStringArgs);
            int fromStringMethodModifiers = fromStringMethod.getModifiers();
            if (!Modifier.isStatic(fromStringMethodModifiers) || !Modifier.isPublic(fromStringMethodModifiers)) {
                return false;
            }
            if (fromStringMethod.getReturnType() != supportedClass) {
                return false;
            }
            __toStringMethodMap.put(supportedClass, toStringMethod);
            __fromStringMethodMap.put(supportedClass, fromStringMethod);
            try {
                fromStringArgs = new Class[]{_stringClass, ClassLoader.class};
                fromStringMethod = converterClass.getMethod("fromString", fromStringArgs);
                fromStringMethodModifiers = fromStringMethod.getModifiers();
                if (Modifier.isStatic(fromStringMethodModifiers) && Modifier.isPublic(fromStringMethodModifiers) && fromStringMethod.getReturnType() == supportedClass) {
                    __fromStringMethodMap2.put(supportedClass, fromStringMethod);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (ClassCastException classCastException) {}
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    public static Class wrapPrimitive(Class primitive) {
        if (primitive == null) {
            return null;
        }
        if (!primitive.isPrimitive()) {
            return primitive;
        }
        return __primitiveToWrapped.get(primitive);
    }

    public static boolean converterAvailable(Object object) {
        if (object == null) {
            return false;
        }
        return ToStringManager.converterAvailable(object.getClass());
    }

    public static boolean converterAvailable(String typeStr) {
        if (typeStr == null) {
            return false;
        }
        try {
            return ToStringManager.converterAvailable(Class.forName(typeStr));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean converterAvailable(Class type) {
        if (type == null) {
            return false;
        }
        if (type.isPrimitive()) {
            return true;
        }
        if (__stringConvertibles.containsKey(type) || _stringConversionClass.isAssignableFrom(type)) {
            return true;
        }
        if (__toStringMethodMap.containsKey(type) && __fromStringMethodMap.containsKey(type)) {
            return true;
        }
        return Enum.class.isAssignableFrom(type);
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return ToStringManager.toString(obj, obj.getClass());
    }

    public static String toString(Object obj, Class objClass) {
        if (obj == null || objClass == null) {
            return null;
        }
        if (objClass.isPrimitive()) {
            objClass = __primitiveToWrapped.get(objClass);
        }
        if (!objClass.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("obj cannot be printed as objClass");
        }
        if (__stringConvertibles.containsKey(objClass) || _stringConversionClass.isAssignableFrom(objClass)) {
            return obj.toString();
        }
        if (__toStringMethodMap.containsKey(objClass)) {
            Method toStringMethod = __toStringMethodMap.get(objClass);
            Object[] toStringArgs = new Object[]{obj};
            try {
                return (String)toStringMethod.invoke(null, toStringArgs);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return null;
        }
        if (Enum.class.isAssignableFrom(objClass)) {
            return ((Enum)obj).name();
        }
        throw new UnsupportedOperationException("Unable to convert the given object to a String: " + obj != null ? obj.getClass().getName() : "null");
    }

    public static Object fromString(String s, Class targetClass) {
        return ToStringManager.fromString(s, targetClass, null);
    }

    public static Object fromString(String s, Class targetClass, ClassLoader loader) {
        if (targetClass == null) {
            return null;
        }
        if (targetClass == _stringClass) {
            return s;
        }
        if (targetClass.isPrimitive()) {
            targetClass = __primitiveToWrapped.get(targetClass);
        }
        if (__stringConvertibles.containsKey(targetClass) || _stringConversionClass.isAssignableFrom(targetClass)) {
            try {
                Class[] constructorArgTypes = new Class[]{_stringClass};
                Constructor<?> constructor = targetClass.getConstructor(constructorArgTypes);
                Object[] constructorArgs = new Object[]{s};
                return constructor.newInstance(constructorArgs);
            }
            catch (NoSuchMethodException constructorArgTypes) {
            }
            catch (InstantiationException constructorArgTypes) {
            }
            catch (IllegalAccessException constructorArgTypes) {
            }
            catch (InvocationTargetException constructorArgTypes) {
                // empty catch block
            }
        }
        if (__fromStringMethodMap.containsKey(targetClass)) {
            Method fromStringMethod = __fromStringMethodMap.get(targetClass);
            try {
                if (loader == null || __fromStringMethodMap2.get(targetClass) == null) {
                    Object[] fromStringArgs = new Object[]{s};
                    return fromStringMethod.invoke(null, fromStringArgs);
                }
                fromStringMethod = __fromStringMethodMap2.get(targetClass);
                Object[] fromStringArgs = new Object[]{s, loader};
                return fromStringMethod.invoke(null, fromStringArgs);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return null;
        }
        if (Enum.class.isAssignableFrom(targetClass)) {
            return Enum.valueOf(targetClass, s);
        }
        throw new UnsupportedOperationException("Unable to convert the String \"" + s + "\" to an Object of type " + targetClass.getName());
    }
}

