/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickLocalVariable;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.ConstantExpressionEvaluator;
import oracle.javatools.parser.java.v2.internal.compiler.MethodObj;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalsSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.ThrowsClauseSym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.VariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceUnaryExpression;
import oracle.javatools.parser.java.v2.util.Conversions;
import oracle.javatools.parser.java.v2.util.SourceVisitor;

public class MethodSym
extends MemberSym
implements SourceMethod {
    public short methodXDimension;

    @Override
    public int getElementKind() {
        return 8;
    }

    @Override
    public boolean isConstructor() {
        return this.symKind == 6;
    }

    @Override
    public List<SourceVariable> getSourceParameters() {
        FormalsSym formals = this.getFormalsSym();
        if (formals != null) {
            return formals.getSourceParameters();
        }
        return Collections.emptyList();
    }

    @Override
    public List<SourceTypeReference> getSourceExceptions() {
        ThrowsClauseSym throwsSym = this.getThrowsSym();
        if (throwsSym != null) {
            return throwsSym.getSourceExceptions();
        }
        return Collections.emptyList();
    }

    @Override
    public SourceTypeReference getSourceReturnType() {
        return this.getTypeSym();
    }

    @Override
    public void setSourceReturnType(SourceTypeReference type) {
        if (this.isConstructor()) {
            MethodSym.unsupported("Constructor has no return type");
        }
        this.setTypeSym((TypeSym)type);
    }

    @Override
    public String getName() {
        ClassSym classSym;
        if (this.isConstructor() && (classSym = this.getOwningClassSym()) != null && classSym.getName().equals(super.getName())) {
            return "<init>";
        }
        return super.getName();
    }

    @Override
    public final SourceMethod getSourceElement() {
        if (this.symFile.isLightSourceFile) {
            SourceClass sourceClass;
            JavaClass owningClass = this.getOwningClass();
            if (owningClass != null && (sourceClass = owningClass.getSourceElement()) != null) {
                return CommonUtilities.getSourceElement(this, sourceClass);
            }
            return null;
        }
        return this;
    }

    @Override
    public List<SourceClass> getSourceAnonymousClasses() {
        return Collections.unmodifiableList(CommonUtilities.getSourceAnonymousClasses(this));
    }

    @Override
    public List<SourceClass> getSourceLocalClasses() {
        return Collections.unmodifiableList(CommonUtilities.getSourceLocalClasses(this));
    }

    @Override
    public Collection<JavaClass> getDeclaredAnonymousClasses() {
        return this.getCompiledObjects(this.getSourceAnonymousClasses());
    }

    @Override
    public Collection<JavaClass> getDeclaredLocalClasses() {
        return this.getCompiledObjects(this.getSourceLocalClasses());
    }

    private Collection<JavaClass> getCompiledObjects(List<SourceClass> sourceClasses) {
        ArrayList<JavaClass> declaredClasses = new ArrayList<JavaClass>();
        for (SourceClass sourceClass : sourceClasses) {
            JavaClass compiledObject = sourceClass.getCompiledObject();
            if (compiledObject == null) continue;
            declaredClasses.add(compiledObject);
        }
        return declaredClasses;
    }

    @Override
    public SourceFormalParameterList getFormalParameterList() {
        return this.getFormalsSym();
    }

    @Override
    public SourceThrowsClause getThrowsClause() {
        return this.getThrowsSym();
    }

    public FormalsSym getFormalsSym() {
        return (FormalsSym)this.getChildOrCreateSkeleton((byte)12);
    }

    public ThrowsClauseSym getThrowsSym() {
        return (ThrowsClauseSym)this.getChildOrCreateSkeleton((byte)24);
    }

    public boolean hasThrows() {
        return this.getChild((byte)24) != null;
    }

    public Expr getDefaultValueSym() {
        return (Expr)this.getChild((byte)102);
    }

    @Override
    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    @Override
    public String getTypeSignature() {
        return CommonUtilities.getTypeSignature(this);
    }

    @Override
    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    @Override
    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    @Override
    public final JavaTypeVariable getTypeParameter(String name) {
        return CommonUtilities.getTypeParameter(this, name);
    }

    @Override
    public JavaMethod getMethodErasure() {
        return this;
    }

    @Override
    public JavaType getReturnType() {
        return this.getResolvedType();
    }

    @Override
    public JavaType getResolvedType() {
        JavaType resolvedType = super.getResolvedType();
        if (resolvedType == null && this.isConstructor()) {
            return PrimitiveType.getVoidType();
        }
        return resolvedType;
    }

    @Override
    public Collection<JavaVariable> getParameters() {
        JavaType grandClass;
        ClassSym owningClass;
        FormalsSym formalsSym = this.getFormalsSym();
        if (formalsSym == null) {
            return Collections.emptyList();
        }
        List<JavaVariable> parameters = formalsSym.getParameters();
        if (this.isConstructor() && (owningClass = this.getOwningClassSym()) != null && (grandClass = MethodSym.getOuterClassOfNonstaticInner(owningClass)) != null) {
            ArrayList<JavaVariable> adjustedParameters = new ArrayList<JavaVariable>();
            QuickLocalVariable thisDollarZero = QuickLocalVariable.createLocalVariable(grandClass, "this$0");
            thisDollarZero.setOwner(this);
            adjustedParameters.add(thisDollarZero);
            adjustedParameters.addAll(parameters);
            return adjustedParameters;
        }
        return parameters;
    }

    @Override
    public JavaType[] getParameterTypes() {
        return CommonUtilities.getParameterTypes(this);
    }

    @Override
    public Collection<JavaType> getExceptions() {
        ThrowsClauseSym throwsSym = this.getThrowsSym();
        if (throwsSym != null) {
            return throwsSym.getExceptions();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasSubsignatureOf(JavaMethod other) {
        return Conversions.hasSubsignatureOf(this, other);
    }

    @Override
    public Collection<JavaMethod> getOverriddenMethods() {
        return this.getMethodObj().getOverriddenMethods();
    }

    @Override
    public Object getDefaultValue() {
        Object constantValue;
        Expr e = this.getDefaultValueSym();
        if (e != null && (constantValue = e.getConstantValue()) != null) {
            JavaType type = this.getReturnType();
            JavaType exprType = e.getResolvedType();
            if (type != null && exprType != null) {
                if (type.getArrayDimensions() == 1 && exprType.getArrayDimensions() == 0) {
                    Object casted = ConstantExpressionEvaluator.cast(constantValue, type.getBaseComponentType());
                    return new Object[]{casted != null ? casted : constantValue};
                }
                if (type.getArrayDimensions() == 1 && exprType.getArrayDimensions() == 1 && constantValue instanceof Object[]) {
                    Object[] valueArray = (Object[])constantValue;
                    Object[] castedArray = new Object[valueArray.length];
                    for (int x = 0; x < valueArray.length; ++x) {
                        Object oneValue = valueArray[x];
                        JavaType baseExpected = type.getComponentType();
                        Object casted = ConstantExpressionEvaluator.cast(oneValue, baseExpected);
                        castedArray[x] = casted != null ? casted : oneValue;
                    }
                    return castedArray;
                }
                Object casted = ConstantExpressionEvaluator.cast(constantValue, type);
                return casted != null ? casted : constantValue;
            }
            return constantValue;
        }
        return null;
    }

    @Override
    public List<SourceAnnotation> getSourceReceiverAnnotations() {
        SourceTypeReference receiverType;
        SourceVariable firstParameter;
        List<SourceVariable> parameters;
        if (this.getJdkVersion().isJdk8OrAbove() && (parameters = this.getSourceParameters()).size() > 0 && "this".equals((firstParameter = parameters.get(0)).getName()) && (receiverType = firstParameter.getSourceType()) != null) {
            return receiverType.getSourceAnnotations();
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<JavaAnnotation> getReceiverTypeAnnotations() {
        return new ArrayList<JavaAnnotation>(this.getSourceReceiverAnnotations());
    }

    public List<List<SourceAnnotation>> getExtraArrayDimensionsTypeAnnotations() {
        ArrayList listOfLists = null;
        List<SourceElement> children = this.getChildren(1);
        for (int i = 0; i < children.size(); ++i) {
            AnnotateSym annotateSym = (AnnotateSym)children.get(i);
            if (annotateSym.dimensionIndex <= 0) continue;
            if (listOfLists == null) {
                listOfLists = new ArrayList();
                for (int x = 0; x < this.methodXDimension; ++x) {
                    listOfLists.add(new ArrayList());
                }
            }
            ((List)listOfLists.get(annotateSym.dimensionIndex - 1)).add(annotateSym);
        }
        return listOfLists;
    }

    public boolean equals(Object o) {
        if (o instanceof JavaMethod) {
            return CommonUtilities.equals(this, (JavaMethod)o);
        }
        return false;
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    @Override
    public String printCompiledInfo() {
        return this.getUniqueIdentifier();
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 27: {
                return !this.isConstructor();
            }
            case 2: 
            case 12: 
            case 20: 
            case 24: 
            case 26: {
                return true;
            }
        }
        if (MethodSym.srcIsExpr(symKind)) {
            return true;
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected void checkAccessModifiers(CompilerDriver compiler) {
        super.checkAccessModifiers(compiler);
        ClassSym owningClass = this.getOwningClassSym();
        if (owningClass != null) {
            int modifiers = this.getModifiers();
            SourceBlock block = this.getBlock();
            if (block != null) {
                if ((modifiers & 0x400) != 0) {
                    compiler.error(this, (short)93, Character.valueOf('\u0400'));
                }
            } else {
                if ((modifiers & 0x402) == 1026) {
                    compiler.error(this, (short)93, Character.valueOf('\u0002'));
                }
                if ((modifiers & 0x410) == 1040) {
                    compiler.error(this, (short)93, Character.valueOf('\u0010'));
                }
            }
        }
    }

    @Override
    protected boolean isValidAccess(char access) {
        int allowed;
        if (this.isConstructor()) {
            allowed = 135;
        } else {
            ClassSym classSym = this.getOwningClassSym();
            if (classSym != null && classSym.isInterface()) {
                allowed = 1153;
                if (this.getJdkVersion().isJdk8OrAbove()) {
                    allowed = (char)(allowed | 0x208);
                }
                if (this.getJdkVersion().isJdk9OrAbove()) {
                    allowed = (char)(allowed | 2);
                }
            } else {
                allowed = classSym != null && classSym.getOwningClassSym() != null && !classSym.isStatic() ? 0 : 8;
                allowed = (char)(allowed | 0xDF7);
                if (this.getParent() == null && this.getJdkVersion().isJdk8OrAbove()) {
                    allowed = (char)(allowed | 0x200);
                }
            }
        }
        return super.isValidAccess((char)(access & ~allowed));
    }

    @Override
    protected void linkSelfTrigger(TreeSym parent, byte filter) {
        super.linkSelfTrigger(parent, filter);
        if (!this.isConstructor()) {
            return;
        }
        ClassSym classSym = this.getOwningClassSym();
        if (classSym != null && !classSym.isAnonymousClass()) {
            String className = classSym.getName();
            String thisName = this.getName();
            if (!thisName.equals(className)) {
                this.setName(className);
            }
        }
    }

    @Override
    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 26: {
                int typeIndex = this.indexOf((byte)27);
                if (typeIndex != -1) {
                    return typeIndex;
                }
            }
            case 27: {
                int nameIndex = this.indexOf((byte)20);
                if (nameIndex != -1) {
                    return nameIndex;
                }
            }
            case 20: {
                int formalsIndex = this.indexOf((byte)12);
                if (formalsIndex != -1) {
                    return formalsIndex;
                }
            }
            case 12: {
                int throwsIndex = this.indexOf((byte)24);
                if (throwsIndex != -1) {
                    return throwsIndex;
                }
            }
            case 24: {
                int blockIndex = this.indexOf((byte)2);
                if (blockIndex == -1) break;
                return blockIndex;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    @Override
    public void buildSelf() {
        TypeSym typeSym;
        super.buildSelf();
        if (this.isVarargs()) {
            this.makeVarArgsParameter();
        }
        if ((typeSym = this.getTypeSym()) != null) {
            List<List<SourceAnnotation>> typeAnnotations;
            if (this.methodXDimension > 0) {
                typeSym.typeXtraDimension = this.methodXDimension;
            }
            if ((typeAnnotations = this.getExtraArrayDimensionsTypeAnnotations()) != null) {
                typeSym.setExtraArrayDimensionsTypeAnnotations(typeAnnotations);
            }
        }
    }

    private void makeVarArgsParameter() {
        VariableSym variableSym = (VariableSym)this.getFormalsSym().getLastChild((byte)13);
        if (variableSym != null) {
            variableSym.symAccess = (char)(variableSym.symAccess | 0x80);
            variableSym.unsaveText();
            TypeSym typeSym = variableSym.getTypeSym();
            if (typeSym != null) {
                typeSym.symAccess = (char)(typeSym.symAccess | 0x80);
                typeSym.unsaveText();
            }
        }
    }

    private void removeVarArgsParameter() {
        VariableSym variableSym = (VariableSym)this.getFormalsSym().getLastChild((byte)13);
        if (variableSym != null) {
            variableSym.symAccess = (char)(variableSym.symAccess & 0xFFFFFF7F);
            TypeSym typeSym = variableSym.getTypeSym();
            if (typeSym != null) {
                typeSym.symAccess = (char)(typeSym.symAccess & 0xFFFFFF7F);
            }
        }
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        MethodSym sym = (MethodSym)super.cloneSelf(targetFile);
        sym.methodXDimension = this.methodXDimension;
        return sym;
    }

    @Override
    protected void add(Sym child, byte filter) {
        FormalsSym formals;
        if (!this.isValidChild(child, filter) && (formals = this.getFormalsSym()).isValidChild(child, filter)) {
            formals.add(child, filter);
            return;
        }
        super.add(child, filter);
    }

    @Override
    protected Sym createSkeleton(byte symKind) {
        Sym sym = super.createSkeleton(symKind);
        if (symKind == 12) {
            sym.symFlags = (byte)(sym.symFlags & 0xFFFFFFFB);
        }
        return sym;
    }

    @Override
    protected void setupSkeleton() {
        this.getFormalsSym();
        this.getThrowsSym();
    }

    @Override
    protected void setModifiersImpl(char access) {
        boolean hasVarargs;
        boolean hadVarargs = (this.symAccess & 0x80) != 0;
        super.setModifiersImpl(access);
        boolean bl = hasVarargs = (this.symAccess & 0x80) != 0;
        if (hadVarargs != hasVarargs) {
            if (hadVarargs) {
                this.removeVarArgsParameter();
            } else {
                this.makeVarArgsParameter();
            }
        }
    }

    public MethodObj getMethodObj() {
        MethodObj binding = (MethodObj)this.getInternalBinding(10);
        if (binding != null) {
            return binding;
        }
        binding = new MethodObj();
        binding.objSym = this;
        this.setInternalBinding(binding);
        return binding;
    }

    @Override
    protected JavaElement resolveImpl(CompilerDriver compiler) {
        compiler.resolve(this);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        if (compiler.skipCompilations()) {
            return super.compileImpl(compiler);
        }
        compiler.startMethodFlowAnalysis(this);
        try {
            this.checkAccessModifiers(compiler);
            this.checkAnnotations(compiler);
            this.checkForCyclicReference(compiler);
            JavaElement result = super.compileImpl(compiler);
            compiler.compile(this);
            JavaElement javaElement = result;
            return javaElement;
        }
        finally {
            compiler.endMethodFlowAnalysis(this);
        }
    }

    private void checkForCyclicReference(final CompilerDriver compiler) {
        final JavaClass cls = this.getOwningClass();
        if (cls != null && cls.isAnnotation()) {
            SourceVisitor visitor = new SourceVisitor(){

                @Override
                public void whenEnterUnaryExpression(SourceUnaryExpression sourceUnaryExpression) {
                    if (sourceUnaryExpression.getExpressionCode() == 14) {
                        this.cancelSubtree();
                    }
                }

                @Override
                public void whenEnterTypeRef(SourceTypeReference sourceType) {
                    JavaType resolvedType = sourceType.getResolvedType();
                    if (resolvedType != null && resolvedType.isArray()) {
                        resolvedType = resolvedType.getBaseComponentType();
                    }
                    if (resolvedType != null && cls.equals(resolvedType)) {
                        compiler.error((Sym)((Object)sourceType), (short)110, resolvedType);
                    }
                }
            };
            visitor.visit(this);
        }
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public void print(PrintWriter out, int argument) {
        switch (argument) {
            default: {
                this.print(out);
                break;
            }
            case 1: {
                MethodSym.print(this.getNameSym(), out);
                this.getFormalsSym().print_signature(out, false);
                break;
            }
            case 2: {
                this.print_modifiers(out);
                if (this.getSourceTypeParameters().size() > 0) {
                    this.print_ty_parameters(out);
                    out.print(' ');
                }
                if (this.symKind != 6) {
                    MethodSym.print(this.getTypeSym(), out, argument);
                    out.print(' ');
                }
                MethodSym.print(this.getNameSym(), out);
                this.getFormalsSym().print_signature(out, true);
                MethodSym.print(this.getThrowsSym(), out);
            }
        }
    }

    @Override
    public JavaMethod getNonParameterizedMethod() {
        return this;
    }
}

