/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.List;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.VariableSym;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;

public abstract class VardeclSym
extends MemberSym
implements SourceVariableDeclaration {
    @Override
    public abstract List<SourceVariable> getVariables();

    @Override
    protected void setModifiersImpl(char access) {
        this.setAccess(access);
        for (Sym sym : this.getVariables()) {
            sym.setAccess(access);
        }
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 27: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected void linkChildTrigger(Sym child, byte filter) {
        super.linkChildTrigger(child, filter);
        if (child instanceof VariableSym) {
            TypeSym owningType;
            VariableSym varSym = (VariableSym)child;
            if (this.symAccess != varSym.symAccess) {
                VardeclSym.unsupported("Modifier mismatch");
            }
            if ((owningType = this.getTypeSym()) == varSym.varType) {
                varSym.varType = null;
            }
            if (owningType == null) {
                TypeSym typeSym = varSym.getTypeSym();
                if (typeSym.isSynthetic()) {
                    typeSym = (TypeSym)typeSym.cloneSelf(this.symFile);
                } else {
                    typeSym.removeSelf();
                }
                typeSym.symAccess = (char)(typeSym.symAccess & 0xFFFFEFFF);
                varSym.varType = null;
                this.linkChild(0, typeSym, (byte)27);
            } else {
                String varTypeName;
                String owningTypeName;
                TypeSym varType = varSym.getTypeSym();
                if (varType == null) {
                    VardeclSym.panic("No type");
                }
                if ((owningTypeName = owningType.getName()).equals(varTypeName = varType.getName())) {
                    if (!varType.isSynthetic()) {
                        varType.removeSelf();
                        varSym.buildSelf();
                        varSym.useType(owningType);
                        varSym.varType.typeXtraDimension = varType.typeXtraDimension;
                    }
                } else {
                    VardeclSym.unsupported("Type mismatch");
                }
            }
            if (varSym.varType == null) {
                varSym.buildSelf();
                varSym.useType(this.getTypeSym());
            }
        }
    }

    @Override
    protected void unlinkChildTrigger(Sym removed, byte filter) {
        super.unlinkChildTrigger(removed, filter);
        if (removed instanceof VariableSym && this.getChild((byte)10) == null && this.getChild((byte)17) == null) {
            this.removeSelf();
        }
    }

    @Override
    public void buildSelf() {
        super.buildSelf();
        TypeSym typeSym = (TypeSym)this.getChild((byte)27);
        if (typeSym == null) {
            return;
        }
        for (VariableSym variableSym : this.getVariables()) {
            variableSym.useType(typeSym);
        }
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        VardeclSym sym = (VardeclSym)super.cloneSelf(targetFile);
        sym.buildSelf();
        return sym;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

