/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.IntersectionType;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.util.ArrayListHeap;

public class Conversions
extends ArrayListHeap
implements JavaConstants {
    public static int getPrimitiveCode(JavaType javaType) {
        if (javaType == null) {
            return -1;
        }
        PrimitiveType primitive = PrimitiveType.lookupPrimitive(javaType.getName());
        if (primitive != null) {
            return primitive.primCode;
        }
        return -1;
    }

    @Deprecated
    public static boolean applyWideningConversion(PrimitiveType subject, PrimitiveType target) {
        return Conversions.applyWideningConversion((JavaType)subject, (JavaType)target);
    }

    public static boolean applyWideningConversion(JavaType subject, JavaType target) {
        if (subject == null || target == null) {
            return false;
        }
        if (subject.isPrimitive() && target.isPrimitive()) {
            return PrimitiveType.applyWideningConversion(PrimitiveType.lookupPrimitive(subject.getName()), PrimitiveType.lookupPrimitive(target.getName()));
        }
        if (!subject.isPrimitive() && !target.isPrimitive()) {
            return Conversions.isSubtypeOf(subject, target);
        }
        return false;
    }

    @Deprecated
    public static boolean applyNarrowingConversion(PrimitiveType subject, PrimitiveType target) {
        return Conversions.applyNarrowingConversion((JavaType)subject, (JavaType)target);
    }

    public static boolean applyNarrowingConversion(JavaType subject, JavaType target) {
        if (subject == null || target == null) {
            return false;
        }
        if (subject.isPrimitive() && target.isPrimitive()) {
            return PrimitiveType.applyNarrowingConversion(PrimitiveType.lookupPrimitive(subject.getName()), PrimitiveType.lookupPrimitive(target.getName()));
        }
        if (!subject.isPrimitive() && !target.isPrimitive()) {
            return Conversions.isSubtypeOf(target, subject);
        }
        return false;
    }

    private static JdkVersion getJdkVersion(JavaElement[] javaElements) {
        if (javaElements != null) {
            for (JavaElement javaElement : javaElements) {
                if (javaElement == null || !javaElement.isSourceElement()) continue;
                return ((SourceElement)((Object)javaElement)).getJdkVersion();
            }
        }
        return JavaParser.getJdkVersion();
    }

    @Deprecated
    public static JavaType applyBoxingConversion(PrimitiveType input, JavaProvider provider) {
        return Conversions.applyBoxingConversion((JavaType)input, provider, null);
    }

    @Deprecated
    public static JavaType applyBoxingConversion(PrimitiveType input, JavaProvider provider, JdkVersion jdkVersion) {
        return Conversions.applyBoxingConversion((JavaType)input, provider, jdkVersion);
    }

    public static JavaType applyBoxingConversion(JavaType input, JavaProvider provider, JdkVersion jdkVersion) {
        if (input == null || !input.isPrimitive()) {
            return null;
        }
        if (jdkVersion == null) {
            jdkVersion = JavaParser.getJdkVersion();
        }
        if (!jdkVersion.isJdk5OrAbove()) {
            return null;
        }
        int primCode = Conversions.getPrimitiveCode(input);
        String autobox = PRIMITIVE_autoboxes[primCode];
        if (autobox != null && provider != null) {
            return provider.getClassByVMName(autobox);
        }
        return null;
    }

    @Deprecated
    public static PrimitiveType applyUnboxingConversion(JavaType input) {
        if (input == null) {
            return null;
        }
        JdkVersion jdkVersion = Conversions.getJdkVersion(new JavaElement[]{input});
        return PrimitiveType.applyUnboxingConversion(input, jdkVersion);
    }

    public static PrimitiveType applyUnboxingConversion(JavaType input, JdkVersion jdkVersion) {
        return PrimitiveType.applyUnboxingConversion(input, jdkVersion);
    }

    public static boolean applyAssignmentConversion(JavaType subject, JavaType target, boolean isConstantValue, JavaProvider provider) {
        return Conversions.applyAssignmentConversion(subject, null, target, isConstantValue, provider, null);
    }

    @Deprecated
    public static boolean applyAssignmentConversion(JavaType subject, SourceExpression subjectExpr, JavaType target, boolean isConstantValue, JavaProvider provider) {
        return Conversions.applyAssignmentConversion(subject, subjectExpr, target, isConstantValue, provider, null);
    }

    public static boolean applyAssignmentConversion(JavaType subject, SourceExpression subjectExpr, JavaType target, boolean isConstantValue, JavaProvider provider, JdkVersion jdkVersion) {
        if (subject == null || target == null) {
            return true;
        }
        if (jdkVersion == null) {
            jdkVersion = Conversions.getJdkVersion(new JavaElement[]{subjectExpr, subject, target});
        }
        if (target.getElementKind() == 12 || subject.getElementKind() == 12) {
            return Conversions.applyIntersectionTypeConversion(subject, subjectExpr, target, isConstantValue, provider, ConversionType.ASSIGNMENT, jdkVersion);
        }
        return Conversions.applyConversion(subject, subjectExpr, target, isConstantValue, provider, ConversionType.ASSIGNMENT, jdkVersion);
    }

    private static boolean applyConversion(JavaType subject, SourceExpression subjectExpr, JavaType target, boolean isConstantValue, JavaProvider provider, ConversionType conversionType, JdkVersion jdkVersion) {
        if (subject == null || target == null) {
            return true;
        }
        if (Conversions.applyConversion(subject, target, true, provider, conversionType, jdkVersion)) {
            return true;
        }
        if (isConstantValue && subject.isPrimitive()) {
            if (target.isPrimitive()) {
                return Conversions.applyNarrowingConversion(subject, target);
            }
            PrimitiveType primitiveTarget = PrimitiveType.applyUnboxingConversion(target, jdkVersion);
            if (primitiveTarget != null) {
                return Conversions.applyNarrowingConversion(subject, (JavaType)primitiveTarget);
            }
        }
        if (subjectExpr == null) {
            JavaElement owner;
            if (subject.getElementKind() != 3 && (owner = subject.getOwner()) != null && owner.getElementKind() == 8 && Conversions.getUpperBounds(subject).isEmpty() && Conversions.getLowerBounds(subject).isEmpty()) {
                return true;
            }
        } else {
            JavaHasType subjectExprObject;
            JavaElement subjectOwner = subject.getOwner();
            if (subject.getElementKind() == 10 && subjectOwner != null && subjectOwner.getElementKind() == 8 && (subjectExprObject = subjectExpr.getResolvedObject()).getElementKind() == 8 && CommonUtilities.isSameDeclaration((JavaMethod)subjectExprObject, (JavaMethod)subjectOwner)) {
                JavaType glb = target;
                Collection<JavaType> bounds = ((JavaTypeVariable)subject).getBounds();
                for (JavaType bound : bounds) {
                    if (Conversions.inheritsFrom(bound, glb, conversionType)) {
                        glb = bound;
                        continue;
                    }
                    if (Conversions.inheritsFrom(glb, bound, conversionType)) continue;
                    glb = null;
                    break;
                }
                if (glb != null) {
                    return true;
                }
            }
        }
        return false;
    }

    @Deprecated
    public static boolean applyMethodConversion(JavaType subject, JavaType target, boolean allowBoxing, JavaProvider provider) {
        return Conversions.applyMethodConversion(subject, target, allowBoxing, provider, null);
    }

    public static boolean applyMethodConversion(JavaType subject, JavaType target, boolean allowBoxing, JavaProvider provider, JdkVersion jdkVersion) {
        Collection<JavaType> actualTypeArguments;
        if (subject == null || target == null) {
            return false;
        }
        if (jdkVersion == null) {
            jdkVersion = Conversions.getJdkVersion(new JavaElement[]{subject, target});
        }
        if (subject.hasActualTypeArguments() && (actualTypeArguments = subject.getActualTypeArguments()).size() == 0) {
            return Conversions.applyMethodConversion(subject.getTypeErasure(), target, allowBoxing, provider, jdkVersion);
        }
        return Conversions.applyConversion(subject, target, allowBoxing, provider, ConversionType.METHOD, jdkVersion);
    }

    private static boolean applyConversion(JavaType subject, JavaType target, boolean allowBoxing, JavaProvider provider, ConversionType conversionType, JdkVersion jdkVersion) {
        if (subject == null || target == null) {
            return false;
        }
        if (subject.getElementKind() == 11 && target.getElementKind() == 11) {
            JavaWildcardType subjectWildcard = (JavaWildcardType)subject;
            JavaWildcardType targetWildcard = (JavaWildcardType)target;
            if (!targetWildcard.getLowerBounds().isEmpty() && !subjectWildcard.getUpperBounds().isEmpty()) {
                JavaType lowerBound = targetWildcard.getLowerBounds().iterator().next();
                JavaType upperBound = subjectWildcard.getUpperBounds().iterator().next();
                return upperBound.isSubtypeOf(lowerBound);
            }
            return false;
        }
        if (Conversions.isSubtypeOf(subject, target, conversionType)) {
            return true;
        }
        if (allowBoxing) {
            if (subject.isPrimitive()) {
                JavaType boxed;
                if (provider == null) {
                    provider = target.getProvider();
                }
                if ((boxed = Conversions.applyBoxingConversion(subject, provider, jdkVersion)) != null) {
                    return Conversions.applyConversion(boxed, target, false, provider, conversionType, jdkVersion);
                }
                return false;
            }
            if (target.isPrimitive()) {
                JavaType boxedTarget;
                PrimitiveType unboxed = PrimitiveType.applyUnboxingConversion(subject, jdkVersion);
                if (unboxed != null) {
                    return Conversions.applyConversion(unboxed, target, false, provider, conversionType, jdkVersion);
                }
                if (provider == null) {
                    provider = subject.getProvider();
                }
                if ((boxedTarget = Conversions.applyBoxingConversion(target, provider, jdkVersion)) != null) {
                    return Conversions.applyConversion(subject, boxedTarget, false, provider, conversionType, jdkVersion);
                }
                return false;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean applyCastingConversion(JavaType subject, JavaType target, JavaProvider provider) {
        return Conversions.applyCastingConversion(subject, target, provider, null);
    }

    public static boolean applyCastingConversion(JavaType subject, JavaType target, JavaProvider provider, JdkVersion jdkVersion) {
        Collection<JavaType> actualTypeArguments;
        if (subject == null || target == null) {
            return true;
        }
        if (jdkVersion == null) {
            jdkVersion = Conversions.getJdkVersion(new JavaElement[]{subject, target});
        }
        if (target.getElementKind() == 12 || subject.getElementKind() == 12) {
            return Conversions.applyIntersectionTypeConversion(subject, null, target, true, provider, ConversionType.CASTING, jdkVersion);
        }
        if (subject.hasActualTypeArguments() && (actualTypeArguments = subject.getActualTypeArguments()).size() == 0) {
            return false;
        }
        boolean assignable = Conversions.applyConversion(subject, null, target, true, provider, ConversionType.CASTING, jdkVersion);
        if (assignable) {
            return true;
        }
        if (subject.isPrimitive() && target.isPrimitive()) {
            return Conversions.getPrimitiveCode(subject) == 1 && Conversions.getPrimitiveCode(target) == 2;
        }
        while (subject.isArray() && target.isArray()) {
            subject = subject.getComponentType();
            target = target.getComponentType();
            if (subject != null && target != null) continue;
            return true;
        }
        if (subject.isInterface() || subject.getElementKind() == 10 ? Conversions.isInterfaceToClassCast(subject, target) : target.isInterface() && !subject.isFinal()) {
            return true;
        }
        return Conversions.isSubtypeOf(target, subject, ConversionType.CASTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean applyIntersectionTypeConversion(JavaType subject, SourceExpression subjectExpr, JavaType target, boolean isConstantValue, JavaProvider provider, ConversionType conversionType, JdkVersion jdkVersion) {
        ArrayList targetTypes = ArrayListHeap.allocArrayList();
        ArrayList subjectTypes = ArrayListHeap.allocArrayList();
        try {
            if (target.getElementKind() == 12) {
                targetTypes.addAll(((IntersectionType)target).getTypes());
            } else {
                targetTypes.add(target);
            }
            if (subject.getElementKind() == 12) {
                subjectTypes.addAll(((IntersectionType)subject).getTypes());
            } else {
                subjectTypes.add(subject);
            }
            block9: for (Object targetType : targetTypes) {
                for (Object subjectType : subjectTypes) {
                    switch (conversionType) {
                        case CASTING: {
                            if (!Conversions.applyCastingConversion((JavaType)subjectType, (JavaType)targetType, provider, jdkVersion)) break;
                            continue block9;
                        }
                        case ASSIGNMENT: {
                            if (!Conversions.applyAssignmentConversion((JavaType)subjectType, subjectExpr, (JavaType)targetType, isConstantValue, provider, jdkVersion)) break;
                            continue block9;
                        }
                        default: {
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ArrayListHeap.freeArrayList(targetTypes);
            ArrayListHeap.freeArrayList(subjectTypes);
        }
    }

    private static boolean isInterfaceToClassCast(JavaType subject, JavaType target) {
        if (subject.getElementKind() == 10) {
            Collection<JavaType> bounds = ((JavaTypeVariable)subject).getBounds();
            for (JavaType bound : bounds) {
                boolean result;
                if (bound == null || !(result = Conversions.isInterfaceToClassCast(bound, target))) continue;
                return true;
            }
            return false;
        }
        if (target.getElementKind() == 3 && !target.isFinal()) {
            String targetDescriptor = target.getDescriptor();
            if (targetDescriptor.equals(subject.getDescriptor())) {
                return false;
            }
            for (JavaType subjectBaseType : subject.getHierarchy()) {
                if (!targetDescriptor.equals(subjectBaseType.getDescriptor())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean inheritsFrom(JavaType subject, JavaType target) {
        return Conversions.inheritsFrom(subject, target, ConversionType.CASTING);
    }

    private static boolean inheritsFrom(JavaType subject, JavaType target, ConversionType conversionType) {
        if (subject == null || target == null) {
            return false;
        }
        String targetDescriptor = target.getDescriptor();
        if ("Ljava/lang/Object;".equals(target.getTypeSignature())) {
            return true;
        }
        if (targetDescriptor.equals(subject.getDescriptor())) {
            return Conversions.isCompatibleTypeArgumentList(subject, target, conversionType);
        }
        boolean targetIsInterface = target.isInterface();
        for (JavaType subjectBaseType : subject.getHierarchy()) {
            if (targetIsInterface != subjectBaseType.isInterface() || !targetDescriptor.equals(subjectBaseType.getDescriptor())) continue;
            return Conversions.isCompatibleTypeArgumentList(subjectBaseType, target, conversionType);
        }
        return false;
    }

    private static boolean isCompatibleTypeArgumentList(JavaType subject, JavaType target, ConversionType conversionType) {
        return Conversions.isCompatibleTypeArgumentList(subject, target, conversionType, 1);
    }

    private static boolean isCompatibleTypeArgumentList(JavaType subject, JavaType target, ConversionType conversionType, int recurseLevel) {
        if (recurseLevel > 5) {
            return true;
        }
        if (!subject.hasActualTypeArguments() && !target.hasActualTypeArguments()) {
            return true;
        }
        if (!subject.hasActualTypeArguments() || !target.hasActualTypeArguments()) {
            if (recurseLevel == 1) {
                return true;
            }
            if (!target.hasActualTypeArguments()) {
                JavaType bound;
                JavaWildcardType targetWildcard;
                Collection<JavaType> targetBounds;
                if (target.getElementKind() == 11 && (targetBounds = (targetWildcard = (JavaWildcardType)target).getUpperBounds()) != null && targetBounds.size() > 0 && (bound = targetBounds.iterator().next()) != null && (bound = bound.getTypeErasure()) != null && !Conversions.inheritsFrom(subject, bound, conversionType)) {
                    return false;
                }
                return false;
            }
        }
        Collection<JavaType> subjectTypeArgs = subject.getActualTypeArguments();
        Collection<JavaType> targetTypeArgs = target.getActualTypeArguments();
        if (recurseLevel == 1 && subjectTypeArgs.size() == 0) {
            return true;
        }
        if (subjectTypeArgs.size() != targetTypeArgs.size()) {
            return false;
        }
        Iterator<JavaType> subjectTypeArgIter = subjectTypeArgs.iterator();
        Iterator<JavaType> targetTypeArgIter = targetTypeArgs.iterator();
        while (subjectTypeArgIter.hasNext()) {
            Boolean result;
            JavaType subjectTypeArg = subjectTypeArgIter.next();
            JavaType targetTypeArg = targetTypeArgIter.next();
            if (subjectTypeArg == null || targetTypeArg == null || (result = Conversions.isCompatibleTypeArguments(subjectTypeArg, targetTypeArg, conversionType, recurseLevel)) == null) continue;
            return result;
        }
        return true;
    }

    private static Boolean isCompatibleTypeArguments(JavaType subject, JavaType target, ConversionType conversionType, int recurseLevel) {
        if (subject.isArray() && target.isArray()) {
            return Conversions.isCompatibleTypeArguments(subject.getComponentType(), target.getComponentType(), conversionType, recurseLevel);
        }
        if (target.getElementKind() == 3) {
            if (subject.getElementKind() == 3) {
                if (!subject.getDescriptor().equals(target.getDescriptor())) {
                    return false;
                }
                if (!Conversions.isCompatibleTypeArgumentList(subject, target, conversionType, recurseLevel + 1)) {
                    return false;
                }
            } else if (subject.getElementKind() == 11 && conversionType == ConversionType.ASSIGNMENT) {
                return false;
            }
            return null;
        }
        if (target.getElementKind() == 10) {
            JavaType bound;
            Collection<JavaType> bounds;
            if (subject.getElementKind() == 3 && (bounds = ((JavaTypeVariable)target).getBounds()) != null && !bounds.isEmpty() && (bound = bounds.iterator().next()) != null) {
                if (conversionType != ConversionType.ASSIGNMENT) {
                    if ((bound = bound.getTypeErasure()) != null && !Conversions.inheritsFrom(subject, bound, conversionType)) {
                        return false;
                    }
                } else {
                    if (!subject.getDescriptor().equals(bound.getDescriptor())) {
                        return false;
                    }
                    if (!Conversions.isCompatibleTypeArgumentList(subject, bound, conversionType, recurseLevel + 1)) {
                        return false;
                    }
                }
            }
        } else if (target.getElementKind() == 11) {
            JavaWildcardType targetWildcard = (JavaWildcardType)target;
            Collection<JavaType> targetUpperBounds = targetWildcard.getUpperBounds();
            for (JavaType targetBound : targetUpperBounds) {
                if (targetBound == null) continue;
                if (subject.getElementKind() == 10) {
                    if (targetBound.getElementKind() == 10) {
                        if (Conversions.isSubtypeOf(subject.getTypeErasure(), targetBound.getTypeErasure(), conversionType)) continue;
                        return false;
                    }
                    Collection<JavaType> typeVarBounds = ((JavaTypeVariable)subject).getBounds();
                    if (typeVarBounds == null || typeVarBounds.isEmpty() || typeVarBounds.size() == 1 && "java.lang.Object".equals(typeVarBounds.iterator().next().getRawName())) continue;
                    for (JavaType typeVarBound : typeVarBounds) {
                        if (typeVarBound == null || (typeVarBound = typeVarBound.getTypeErasure()) == null || Conversions.isSubtypeOf(typeVarBound, targetBound, conversionType)) continue;
                        return false;
                    }
                    continue;
                }
                if (subject.getElementKind() == 11) {
                    JavaWildcardType subjectWildcard = (JavaWildcardType)subject;
                    Collection<JavaType> subjectUpperBounds = subjectWildcard.getUpperBounds();
                    for (JavaType subjectBound : subjectUpperBounds) {
                        Boolean result;
                        if (subjectBound == null || !(subjectBound.getElementKind() == 10 ? (result = Conversions.isCompatibleTypeArguments(subjectBound, targetBound, conversionType, recurseLevel)) != null && result == false : !Conversions.isSubtypeOf(subjectBound, targetBound, conversionType))) continue;
                        return false;
                    }
                    continue;
                }
                if (Conversions.isSubtypeOf(subject, targetBound, conversionType)) continue;
                return false;
            }
            if (conversionType == ConversionType.ASSIGNMENT) {
                Collection<JavaType> lowerBounds = targetWildcard.getLowerBounds();
                for (JavaType bound : lowerBounds) {
                    if (Conversions.inheritsFrom(bound, subject, conversionType)) continue;
                    return false;
                }
            }
        }
        return null;
    }

    public static boolean isSubtypeOf(JavaType subject, JavaType target) {
        return Conversions.isSubtypeOf(subject, target, ConversionType.CASTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isIntersectionSubtypeOf(JavaType subject, JavaType target, ConversionType conversionType) {
        ArrayList targetTypes = ArrayListHeap.allocArrayList();
        ArrayList subjectTypes = ArrayListHeap.allocArrayList();
        try {
            if (target.getElementKind() == 12) {
                targetTypes.addAll(((IntersectionType)target).getTypes());
            } else {
                targetTypes.add(target);
            }
            if (subject.getElementKind() == 12) {
                subjectTypes.addAll(((IntersectionType)subject).getTypes());
            } else {
                subjectTypes.add(subject);
            }
            block4: for (Object subjectType : subjectTypes) {
                for (Object targetType : targetTypes) {
                    if (!Conversions.isSubtypeOf((JavaType)subjectType, (JavaType)targetType, conversionType)) continue;
                    continue block4;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ArrayListHeap.freeArrayList(targetTypes);
            ArrayListHeap.freeArrayList(subjectTypes);
        }
    }

    private static boolean isSubtypeOf(JavaType subject, JavaType target, ConversionType conversionType) {
        if (subject == null || target == null) {
            return false;
        }
        if (subject.getElementKind() == 12 || target.getElementKind() == 12) {
            return Conversions.isIntersectionSubtypeOf(subject, target, conversionType);
        }
        if (subject.equals(target)) {
            return true;
        }
        if (subject.isPrimitive()) {
            if (target.isPrimitive()) {
                return Conversions.applyWideningConversion(subject, target);
            }
            return Conversions.getPrimitiveCode(subject) == 8;
        }
        if (target.isPrimitive()) {
            return false;
        }
        if (subject.isArray() && target.isArray()) {
            JavaType subjectComponent = subject.getComponentType();
            if (subjectComponent == null) {
                return false;
            }
            if (!subjectComponent.isPrimitive()) {
                return Conversions.isSubtypeOf(subjectComponent, target.getComponentType(), conversionType);
            }
            return Conversions.getPrimitiveCode(subjectComponent) == 8;
        }
        return Conversions.isSubtypeOfImpl(subject, target, conversionType);
    }

    public static boolean isSubtypeOfImpl(JavaType subject, JavaType target) {
        return Conversions.isSubtypeOfImpl(subject, target, ConversionType.ASSIGNMENT);
    }

    public static boolean isSubtypeOfImpl(JavaType subject, JavaType target, ConversionType conversionType) {
        Collection targetLowerBounds;
        if (subject == null || target == null) {
            return false;
        }
        if (subject.equals(target)) {
            return true;
        }
        String targetTypeSignature = target.getTypeSignature();
        if (conversionType != ConversionType.METHOD && ("*".equals(targetTypeSignature) || "+Ljava/lang/Object;".equals(targetTypeSignature))) {
            return true;
        }
        if ("Ljava/lang/Object;".equals(targetTypeSignature)) {
            return true;
        }
        int subjectKind = subject.getElementKind();
        int targetKind = target.getElementKind();
        if (targetKind == 3) {
            if (subjectKind == 3) {
                return Conversions.inheritsFrom(subject, target, conversionType);
            }
            if (subject.getElementKind() == 10 || subject.getElementKind() == 11) {
                Collection<JavaType> subjectUpperBounds = Conversions.getUpperBounds(subject);
                for (JavaType bound : subjectUpperBounds) {
                    if (bound.equals(subject)) {
                        return false;
                    }
                    if (!Conversions.isSubtypeOfImpl(bound, target, conversionType)) continue;
                    return true;
                }
            }
            return false;
        }
        if (target.getElementKind() == 10) {
            Collection<JavaType> targetUpperBounds = Conversions.getUpperBounds(target);
            if (targetUpperBounds.isEmpty()) {
                if (conversionType != ConversionType.ASSIGNMENT) {
                    return true;
                }
                if (subject.getElementKind() == 10) {
                    Collection<JavaType> typeVarBounds = ((JavaTypeVariable)subject).getBounds();
                    for (JavaType typeVarBound : typeVarBounds) {
                        if (typeVarBound.getElementKind() != 10) continue;
                        return Conversions.isSubtypeOf(typeVarBound, target, conversionType);
                    }
                } else if (subject.getElementKind() == 11) {
                    Collection<JavaType> wildcardUpperBounds = Conversions.getUpperBounds(subject);
                    for (JavaType upperBound : wildcardUpperBounds) {
                        if (upperBound.getElementKind() != 10) continue;
                        return Conversions.isSubtypeOf(upperBound, target, conversionType);
                    }
                }
                return false;
            }
            return Conversions.satisfiesBounds(subject, target, targetUpperBounds, true, conversionType);
        }
        return target.getElementKind() == 11 && !(targetLowerBounds = Conversions.getLowerBounds(target)).isEmpty() && Conversions.satisfiesBounds(subject, target, targetLowerBounds, false, conversionType);
    }

    private static Collection<JavaType> getUpperBounds(JavaType type) {
        if (type.getElementKind() == 10) {
            JavaTypeVariable variable = (JavaTypeVariable)type;
            return variable.getBounds();
        }
        JavaWildcardType wildcard = (JavaWildcardType)type;
        return wildcard.getUpperBounds();
    }

    private static Collection getLowerBounds(JavaType type) {
        if (type.getElementKind() == 10) {
            return kEmptyCollection;
        }
        JavaWildcardType wildcard = (JavaWildcardType)type;
        return wildcard.getLowerBounds();
    }

    private static boolean satisfiesBounds(JavaType subject, JavaType target, Collection bounds, boolean upper, ConversionType conversionType) {
        if (bounds == kEmptyCollection) {
            return true;
        }
        if (bounds.isEmpty()) {
            return true;
        }
        for (JavaType bound : bounds) {
            if (bound.equals(target)) {
                return false;
            }
            if (!(upper ? !Conversions.satisfiesUpperBound(subject, bound, conversionType) : !Conversions.satisfiesLowerBound(subject, bound, conversionType))) continue;
            return false;
        }
        return true;
    }

    private static boolean satisfiesUpperBound(JavaType subject, JavaType bound, ConversionType conversionType) {
        if (subject.getElementKind() == 3) {
            return Conversions.isSubtypeOf(subject, bound, conversionType);
        }
        Collection<JavaType> subjectBounds = Conversions.getUpperBounds(subject);
        if (subjectBounds.isEmpty()) {
            return conversionType != ConversionType.ASSIGNMENT;
        }
        for (JavaType subjectBound : subjectBounds) {
            if (!Conversions.isSubtypeOf(subjectBound, bound, conversionType)) continue;
            return true;
        }
        return false;
    }

    private static boolean satisfiesLowerBound(JavaType subject, JavaType bound, ConversionType conversionType) {
        int subjectKind = subject.getElementKind();
        if (subjectKind == 3) {
            return Conversions.isSubtypeOf(subject, bound, conversionType) || Conversions.isSubtypeOf(bound, subject, conversionType);
        }
        Collection subjectBounds = Conversions.getLowerBounds(subject);
        if (subjectBounds.isEmpty()) {
            return true;
        }
        for (JavaType subjectBound : subjectBounds) {
            if (!Conversions.isSubtypeOf(bound, subjectBound, conversionType)) continue;
            return true;
        }
        return false;
    }

    public static JavaType applyUnaryPromotion(JavaType subject, JdkVersion jdkVersion) {
        if (subject == null) {
            return null;
        }
        if (!subject.isPrimitive()) {
            subject = Conversions.applyUnboxingConversion(subject, jdkVersion);
        }
        if (subject == null) {
            return null;
        }
        byte target = PRIMITIVE_unary[Conversions.getPrimitiveCode(subject)];
        return PrimitiveType.PRIMITIVE_objects[target];
    }

    public static JavaType applyBinaryPromotion(JavaType lhs, JavaType rhs, JdkVersion jdkVersion) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (!lhs.isPrimitive()) {
            lhs = PrimitiveType.applyUnboxingConversion(lhs, jdkVersion);
        }
        if (lhs == null) {
            return null;
        }
        if (!rhs.isPrimitive()) {
            rhs = PrimitiveType.applyUnboxingConversion(rhs, jdkVersion);
        }
        if (rhs == null) {
            return null;
        }
        byte prim = PRIMITIVE_binary[Conversions.getPrimitiveCode(lhs)][Conversions.getPrimitiveCode(rhs)];
        if (prim != -1) {
            return PrimitiveType.PRIMITIVE_objects[prim];
        }
        return null;
    }

    public static boolean hasSubsignatureOf(JavaMethod subject, JavaMethod target) {
        if (subject == null || target == null) {
            return false;
        }
        if (!target.getName().equals(subject.getName())) {
            return false;
        }
        Collection<JavaVariable> subjectParams = subject.getParameters();
        Collection<JavaVariable> targetParams = target.getParameters();
        Iterator<JavaVariable> subjectIterator = subjectParams.iterator();
        Iterator<JavaVariable> targetIterator = targetParams.iterator();
        int subjectParamsSize = subjectParams.size();
        int targetParamsSize = targetParams.size();
        if (subjectIterator.hasNext()) {
            if (subject.isSourceElement() && ((SourceElement)((Object)subject)).getJdkVersion().isJdk8OrAbove() && "this".equals(subjectIterator.next().getName())) {
                --subjectParamsSize;
            } else {
                subjectIterator = subjectParams.iterator();
            }
        }
        if (targetIterator.hasNext()) {
            if (target.isSourceElement() && ((SourceElement)((Object)target)).getJdkVersion().isJdk8OrAbove() && "this".equals(targetIterator.next().getName())) {
                --targetParamsSize;
            } else {
                targetIterator = targetParams.iterator();
            }
        }
        if (subjectParamsSize != targetParamsSize) {
            return false;
        }
        while (subjectIterator.hasNext()) {
            JavaType targetVarType;
            JavaVariable subjectVar = subjectIterator.next();
            JavaVariable targetVar = targetIterator.next();
            JavaType subjectVarType = subjectVar.getResolvedType();
            if (Conversions.typesOverrideEqual(subjectVarType, targetVarType = targetVar.getResolvedType())) continue;
            return false;
        }
        return true;
    }

    private static boolean typesOverrideEqual(JavaType subjectVarType, JavaType targetVarType) {
        JavaClass targetErasedType;
        if (subjectVarType == targetVarType) {
            return true;
        }
        if (subjectVarType == null && targetVarType == null) {
            return true;
        }
        if (subjectVarType == null || targetVarType == null) {
            return false;
        }
        if (subjectVarType.equals(targetVarType)) {
            return true;
        }
        if (subjectVarType.isArray() || targetVarType.isArray()) {
            if (!subjectVarType.isArray() || !targetVarType.isArray()) {
                return false;
            }
            if (subjectVarType.getArrayDimensions() != targetVarType.getArrayDimensions()) {
                return false;
            }
            return Conversions.typesOverrideEqual(subjectVarType.getBaseComponentType(), targetVarType.getBaseComponentType());
        }
        while (subjectVarType.getElementKind() == 10 && targetVarType.getElementKind() == 10) {
            subjectVarType = subjectVarType.getTypeErasure();
            targetVarType = targetVarType.getTypeErasure();
            if (subjectVarType == null && targetVarType == null) {
                return true;
            }
            if (subjectVarType != null && targetVarType != null) continue;
            return false;
        }
        if (subjectVarType.getElementKind() == 3 && targetVarType.getElementKind() == 3) {
            if (!targetVarType.hasActualTypeArguments() && !subjectVarType.hasActualTypeArguments()) {
                return targetVarType.getRawName().equals(subjectVarType.getRawName());
            }
            if (targetVarType.hasActualTypeArguments() && subjectVarType.hasActualTypeArguments()) {
                if (!targetVarType.getRawName().equals(subjectVarType.getRawName())) {
                    return false;
                }
                Collection<JavaType> targetTypeArgs = targetVarType.getActualTypeArguments();
                Collection<JavaType> subjectTypeArgs = subjectVarType.getActualTypeArguments();
                if (targetTypeArgs.size() != subjectTypeArgs.size()) {
                    return false;
                }
                Iterator<JavaType> targetTypeArgIter = targetTypeArgs.iterator();
                Iterator<JavaType> subjectTypeArgIter = subjectTypeArgs.iterator();
                while (subjectTypeArgIter.hasNext()) {
                    JavaType targetTypeArg = targetTypeArgIter.next();
                    JavaType subjectTypeArg = subjectTypeArgIter.next();
                    if (Conversions.typesOverrideEqual(subjectTypeArg, targetTypeArg)) continue;
                    return false;
                }
                return true;
            }
        } else if (subjectVarType.getElementKind() == 11 && targetVarType.getElementKind() == 11) {
            JavaWildcardType subjectWildcard = (JavaWildcardType)subjectVarType;
            JavaWildcardType targetWildcard = (JavaWildcardType)targetVarType;
            if (!Conversions.boundsOverrideEqual(subjectWildcard.getLowerBounds(), targetWildcard.getLowerBounds(), false)) {
                return false;
            }
            return Conversions.boundsOverrideEqual(subjectWildcard.getUpperBounds(), targetWildcard.getUpperBounds(), true);
        }
        if ((targetErasedType = targetVarType.getTypeErasure()) == null) {
            return false;
        }
        if (!targetVarType.equals(targetErasedType)) {
            return Conversions.typesOverrideEqual(subjectVarType, targetErasedType);
        }
        return false;
    }

    private static boolean boundsOverrideEqual(Collection<JavaType> subjectBounds, Collection<JavaType> targetBounds, boolean upperBounds) {
        if (subjectBounds == null && targetBounds == null) {
            return true;
        }
        if (subjectBounds == null || targetBounds == null) {
            return false;
        }
        if (upperBounds) {
            JavaType subjectType;
            JavaType targetType;
            if (subjectBounds.size() == 0 && targetBounds.size() == 1 && "java.lang.Object".equals((targetType = targetBounds.iterator().next()).getQualifiedName())) {
                return true;
            }
            if (subjectBounds.size() == 1 && targetBounds.size() == 0 && "java.lang.Object".equals((subjectType = subjectBounds.iterator().next()).getQualifiedName())) {
                return true;
            }
        }
        if (subjectBounds.size() != targetBounds.size()) {
            return false;
        }
        Iterator<JavaType> subjectIter = subjectBounds.iterator();
        Iterator<JavaType> targetIter = targetBounds.iterator();
        while (subjectIter.hasNext() && targetIter.hasNext()) {
            if (Conversions.typesOverrideEqual(subjectIter.next(), targetIter.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isReturnTypeSubstitutable(JavaMethod subject, JavaMethod target) {
        if (subject == null || target == null) {
            return false;
        }
        JavaType subjectType = subject.getReturnType();
        JavaType targetType = target.getReturnType();
        if (subjectType == null || targetType == null) {
            return false;
        }
        if (subjectType.equals(targetType)) {
            return true;
        }
        if (subjectType.isPrimitive() && targetType.isPrimitive()) {
            return subjectType.getName().equals(targetType.getName());
        }
        if (subjectType.isPrimitive() || targetType.isPrimitive()) {
            return false;
        }
        return Conversions.isSubtypeOf(subjectType, targetType.getTypeErasure());
    }

    public static enum ConversionType {
        ASSIGNMENT,
        CASTING,
        METHOD;

    }
}

