/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.old.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.plsql.old.symbol.ExpressionSymbol;
import oracle.javatools.parser.plsql.old.symbol.PlsqlSymbolFactory;

public class ExpressionList
extends ExpressionSymbol {
    private ExpressionSymbol[] expressionArray = null;
    private ArrayList expressions = ExpressionList.allocArrayList();

    public ExpressionSymbol[] getExpressions() {
        return this.expressionArray;
    }

    ExpressionList(int code, PlsqlSymbolFactory factory) {
        super(code, factory);
    }

    @Override
    void addOperand(ExpressionSymbol e) {
        if (e.getCategory() == 600) {
            ExpressionSymbol wrapper = e;
            e = e.getFirstOperand();
            this.recycleExpression(wrapper);
        }
        ExpressionList.verbosePrintln("EList: Adding operand, child: ", e);
        ExpressionList.verbosePrintln("EList:   Parent: ", this);
        this.expressions.add(e);
    }

    @Override
    void doneParsing() {
        super.doneParsing();
        this.generateExpressionArray();
        if (this.code == 610) {
            if (this.expressionArray.length == 1) {
                this.firstOperand = this.expressionArray[0];
            } else {
                this.code = 760;
            }
        }
    }

    private void generateExpressionArray() {
        this.expressionArray = ExpressionSymbol.EMPTY_ARRAY;
        this.expressionArray = this.expressions.toArray(this.expressionArray);
        ExpressionList.freeArrayList(this.expressions);
        this.expressions = null;
    }

    static void verbosePrintln(String msg, ExpressionSymbol e) {
        if (ExpressionList.verboseOutput(4)) {
            System.out.print(msg);
            System.out.println(e.verbose());
        }
    }
}

