/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.util;

import java.util.ArrayList;
import oracle.javatools.parser.util.ArrayListHeap;
import oracle.javatools.parser.util.ExpressionObject;
import oracle.javatools.parser.util.SimpleStack;

public class ExpressionStack
extends ArrayListHeap {
    private ArrayList expressions = null;
    private SimpleStack stack = new SimpleStack();
    private Object closingArgument = null;
    private int pos;
    private int size;

    public void add(ExpressionObject e) {
        if (this.expressions == null) {
            this.expressions = new ArrayList();
        }
        ExpressionStack.verbosePrintln("Adding ", e);
        this.expressions.add(e);
    }

    public void setClosingArgument(Object arg) {
        this.closingArgument = arg;
    }

    public ExpressionObject process() {
        if (this.expressions.size() == 1) {
            this.stack.push(this.expressions.get(0));
        } else {
            this.size = this.expressions.size();
            this.pos = 0;
            while (this.pos < this.size) {
                this.processOperand(1001);
            }
        }
        this.expressions = null;
        return (ExpressionObject)this.stack.pop();
    }

    private ExpressionObject current() {
        return (ExpressionObject)this.expressions.get(this.pos);
    }

    private void advance() {
        ++this.pos;
    }

    private boolean eof() {
        return this.size <= this.pos;
    }

    private void pushOperand(ExpressionObject e) {
        ExpressionStack.verbosePrintln("Pushing operand: ", e);
        this.stack.push(e);
    }

    private ExpressionObject popOperand() {
        ExpressionObject e = (ExpressionObject)this.stack.pop();
        ExpressionStack.verbosePrintln("Popping operand: ", e);
        return e;
    }

    private void processOperator(ExpressionObject e) {
        int type = e.classify();
        if (type == 3) {
            this.advance();
            ExpressionStack.verbosePrintln("Processing suffix operator: ", e);
            e.addOperand(this.popOperand());
        } else if (type == 4) {
            this.advance();
            this.processOperand(1001);
            this.processOperand(e.getPrecedence());
            ExpressionStack.verbosePrintln("Processing ternary operator: ", e);
            ExpressionObject thirdOp = this.popOperand();
            ExpressionObject secondOp = this.popOperand();
            e.addOperand(this.popOperand());
            e.addOperand(secondOp);
            e.addOperand(thirdOp);
        } else {
            this.advance();
            this.processOperand(e.getPrecedence());
            if (type == 1) {
                ExpressionStack.verbosePrintln("Processing prefix operator: ", e);
                e.addOperand(this.popOperand());
            } else {
                ExpressionStack.verbosePrintln("Processing infix operator: ", e);
                ExpressionObject secondOp = this.popOperand();
                e.addOperand(this.popOperand());
                e.addOperand(secondOp);
            }
        }
        e.closeOperator(this.closingArgument);
        this.pushOperand(e);
    }

    private void processOperand(int precedence) {
        ExpressionObject n;
        int otherClassify;
        ExpressionObject e = this.current();
        switch (e.classify()) {
            case 1: 
            case 2: 
            case 3: {
                this.processOperator(e);
                break;
            }
            case 0: {
                this.pushOperand(e);
                this.advance();
                break;
            }
            default: {
                throw new RuntimeException("processOperand: bad classify");
            }
        }
        while (!this.eof() && (otherClassify = (n = this.current()).classify()) != 0 && otherClassify != 1) {
            int otherPrecedence = n.getPrecedence();
            if (otherPrecedence < precedence) {
                this.processOperator(n);
                continue;
            }
            if (otherPrecedence != precedence || otherPrecedence + n.getAssociativity() >= precedence) break;
            this.processOperator(n);
        }
    }

    private static void verbosePrintln(String a, Object o) {
    }
}

