/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.util.UnexpectedExceptionError;

public class Maps {

    public static class ManagedCacheMap<K, V>
    extends CacheMap<K, V>
    implements ManagedCacheMapMBean {
        private HistoryDecorator history;
        private int maximumSize;
        @CodeSharingSafe(value="StaticField")
        private static final AtomicInteger nextId = new AtomicInteger(0);
        private static TabularType tabularType;
        private static CompositeType rowType;
        private static final String rowTypeName = "History";
        private static final String rowTypeDescription = "Collected history for one key in a ManagedCacheMap";
        @CodeSharingSafe(value="StaticField")
        private static final String[] columnNames;
        @CodeSharingSafe(value="StaticField")
        private static final String[] columnDescriptions;
        @CodeSharingSafe(value="StaticField")
        private static final OpenType[] columnTypes;

        public ManagedCacheMap(String name) {
            this(new UnboundedCacheStrategy(), name);
        }

        public ManagedCacheMap(CacheMap.Strength strength, String name) {
            this(new UnboundedCacheStrategy(strength), name);
        }

        public ManagedCacheMap(int bound, String name) {
            this(new BoundedLruCacheStrategy(bound), name);
        }

        public ManagedCacheMap(int bound, CacheMap.Strength strength, String name) {
            this(new BoundedLruCacheStrategy(bound, strength), name);
        }

        public ManagedCacheMap(CacheStrategy<K, V> strategy, String name) {
            super(strategy);
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            String beanName = "oracle.javatools.cache:type=CacheMap,name=" + name;
            try {
                try {
                    server.registerMBean(this, new ObjectName(beanName));
                }
                catch (InstanceAlreadyExistsException e) {
                    server.registerMBean(this, new ObjectName(beanName + " (" + nextId.getAndIncrement() + ")"));
                }
            }
            catch (Throwable e) {
                Logger.getLogger("jmx").log(Level.SEVERE, "mbean " + beanName + " not registered: " + e, e);
            }
        }

        @Override
        protected CacheStrategy<K, V> decoratedStrategy(CacheStrategy<K, V> strategy) {
            this.history = new HistoryDecorator(strategy);
            return this.history;
        }

        @Override
        public int getSize() {
            return this.size();
        }

        @Override
        public int getMaximumSize() {
            return this.maximumSize;
        }

        @Override
        public CompositeData getStatistics() throws OpenDataException {
            Statistics statistics = this.history.getStatistics();
            Object[] values = new Object[]{"totals", statistics.adds, statistics.changes, statistics.accesses, statistics.removes, statistics.purges, statistics.evicts};
            return new CompositeDataSupport(ManagedCacheMap.rowType(), columnNames, values);
        }

        @Override
        public void setCollectKeyStatistics(boolean collect) {
            this.history.setCollectKeyStatistics(collect);
        }

        @Override
        public boolean getCollectKeyStatistics() {
            return this.history.getCollectKeyStatistics();
        }

        @Override
        public int getTotalKeyCount() {
            return this.history.getTotalKeyCount();
        }

        @Override
        public TabularData getKeyStatistics() throws OpenDataException {
            TabularDataSupport table = new TabularDataSupport(ManagedCacheMap.tableType());
            for (Map.Entry entry : this.history.getKeyStatistics().entrySet()) {
                Object key = entry.getKey();
                Statistics statistics = (Statistics)entry.getValue();
                Object[] values = new Object[]{String.valueOf(key), statistics.adds, statistics.changes, statistics.accesses, statistics.removes, statistics.purges, statistics.evicts};
                table.put(new CompositeDataSupport(ManagedCacheMap.rowType(), columnNames, values));
            }
            return table;
        }

        @Override
        public void clearKeyStatistics() {
            this.history.clearKeyStatistics();
        }

        private static TabularType tableType() throws OpenDataException {
            if (tabularType == null) {
                tabularType = new TabularType("HistoryTable", "Collected history for a ManagedCacheMap", ManagedCacheMap.rowType(), new String[]{"key"});
            }
            return tabularType;
        }

        private static CompositeType rowType() throws OpenDataException {
            if (rowType == null) {
                rowType = new CompositeType(rowTypeName, rowTypeDescription, columnNames, columnDescriptions, columnTypes);
            }
            return rowType;
        }

        @Override
        void entryAddedInternal(LinkedEntry<K, V> entry) {
            super.entryAddedInternal(entry);
            int size = this.size();
            if (size > this.maximumSize) {
                this.maximumSize = size;
            }
        }

        static {
            columnNames = new String[]{"key", "adds", "changes", "accesses", "removes", "purges", "evicts"};
            columnDescriptions = new String[]{"Key of mapping", "Number of times key and value were added (initial, or after removal)", "Number of times value for key changed", "Number of times value for key was accessed", "Number of times key and value were removed", "Number of times value for key was collected", "Number of times key and value were evicted"};
            columnTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER};
        }

        private class HistoryDecorator
        extends CacheStrategy<K, V> {
            private final CacheStrategy<K, V> delegate;
            private Statistics statistics;
            private volatile boolean collectKeyStatistics;
            private volatile Map<K, Statistics> keyStatistics;

            public HistoryDecorator(CacheStrategy<K, V> delegate) {
                super(delegate.getInitialCapacity(), delegate.getLoadFactor(), delegate.getCanonicity(), delegate.getDefaultStrength());
                this.statistics = new Statistics();
                this.collectKeyStatistics = false;
                this.delegate = delegate;
            }

            private Statistics getStatistics() {
                return this.statistics;
            }

            public boolean getCollectKeyStatistics() {
                return this.collectKeyStatistics;
            }

            public void setCollectKeyStatistics(boolean collect) {
                this.collectKeyStatistics = collect;
                if (collect && this.keyStatistics == null) {
                    this.keyStatistics = new HashMap();
                }
            }

            private int getTotalKeyCount() {
                return this.keyStatistics != null ? this.keyStatistics.size() : -1;
            }

            private void clearKeyStatistics() {
                this.statistics = new Statistics();
                this.keyStatistics = this.collectKeyStatistics ? new HashMap() : null;
            }

            private Map<K, Statistics> getKeyStatistics() {
                return this.keyStatistics;
            }

            private Statistics getKeyStatistics(LinkedEntry<K, V> entry) {
                Object key = entry.getKey();
                Statistics statistics = this.keyStatistics.get(key);
                if (statistics == null) {
                    statistics = new Statistics();
                    this.keyStatistics.put(key, statistics);
                }
                return statistics;
            }

            @Override
            protected LinkedEntry<K, V> createEntry(int hashCode, K key, V value, LinkedEntry<K, V> next, ReferenceQueue<V> vReferenceQueue) {
                return this.delegate.createEntry(hashCode, key, value, next, vReferenceQueue);
            }

            @Override
            protected LinkedEntry<K, V> createDefaultEntry(int hashCode, K key, V value, LinkedEntry<K, V> next) {
                return this.delegate.createDefaultEntry(hashCode, key, value, next);
            }

            @Override
            protected LinkedEntry<K, V> createSoftEntry(int hashCode, K key, V value, LinkedEntry<K, V> next, ReferenceQueue<V> vReferenceQueue) {
                return this.delegate.createSoftEntry(hashCode, key, value, next, vReferenceQueue);
            }

            @Override
            protected LinkedEntry<K, V> createWeakEntry(int hashCode, K key, V value, LinkedEntry<K, V> next, ReferenceQueue<V> vReferenceQueue) {
                return this.delegate.createWeakEntry(hashCode, key, value, next, vReferenceQueue);
            }

            @Override
            protected LinkedEntry<K, V> createEvictedEntry(int hashCode, K key, V value, LinkedEntry<K, V> next, ReferenceQueue<V> vReferenceQueue) {
                return this.delegate.createEvictedEntry(hashCode, key, value, next, vReferenceQueue);
            }

            @Override
            protected void mapChanged(CacheMap<K, V> map) {
                this.delegate.mapChanged(map);
            }

            @Override
            protected void entryAdded(CacheMap<K, V> map, LinkedEntry<K, V> entry) {
                ++this.statistics.adds;
                if (this.collectKeyStatistics) {
                    ++this.getKeyStatistics(entry).adds;
                }
                this.delegate.entryAdded(map, entry);
            }

            @Override
            protected void entryChanged(CacheMap<K, V> map, LinkedEntry<K, V> oldEntry, V oldValue, LinkedEntry<K, V> newEntry) {
                ++this.statistics.changes;
                if (this.collectKeyStatistics) {
                    ++this.getKeyStatistics(oldEntry).changes;
                }
                this.delegate.entryChanged(map, oldEntry, oldValue, newEntry);
            }

            @Override
            protected void entryAccessed(CacheMap<K, V> map, LinkedEntry<K, V> entry) {
                ++this.statistics.accesses;
                if (this.collectKeyStatistics) {
                    ++this.getKeyStatistics(entry).accesses;
                }
                this.delegate.entryAccessed(map, entry);
            }

            @Override
            protected void entryRemoved(CacheMap<K, V> map, LinkedEntry<K, V> entry) {
                ++this.statistics.removes;
                if (this.collectKeyStatistics) {
                    ++this.getKeyStatistics(entry).removes;
                }
                this.delegate.entryRemoved(map, entry);
            }

            @Override
            protected void entryPurged(CacheMap<K, V> map, LinkedEntry<K, V> entry) {
                ++this.statistics.purges;
                if (this.collectKeyStatistics) {
                    ++this.getKeyStatistics(entry).purges;
                }
                this.delegate.entryPurged(map, entry);
            }

            @Override
            protected void entryEvicted(CacheMap<K, V> map, LinkedEntry<K, V> entry) {
                ++this.statistics.evicts;
                if (this.collectKeyStatistics) {
                    ++this.getKeyStatistics(entry).evicts;
                }
                this.delegate.entryEvicted(map, entry);
            }
        }

        private static class Statistics {
            public int adds;
            public int changes;
            public int accesses;
            public int removes;
            public int purges;
            public int evicts;

            private Statistics() {
            }
        }
    }

    public static interface ManagedCacheMapMBean {
        public int getSize();

        public int getMaximumSize();

        public CompositeData getStatistics() throws OpenDataException;

        public void setCollectKeyStatistics(boolean var1);

        public boolean getCollectKeyStatistics();

        public int getTotalKeyCount();

        public TabularData getKeyStatistics() throws OpenDataException;

        public void clearKeyStatistics();
    }

    public static class CacheMap<K, V>
    extends AbstractLinkedHashMap<K, V, LinkedEntry<K, V>> {
        public static final Strength STRONG = Strength.STRONG;
        public static final Strength HARD = Strength.STRONG;
        public static final Strength SOFT = Strength.SOFT;
        public static final Strength WEAK = Strength.WEAK;
        public static final Canonicity CANONICAL = Canonicity.CANONICAL;
        public static final Canonicity NOT_CANONICAL = Canonicity.NOT_CANONICAL;
        private transient LinkedEntry<K, V> eldest;
        private final CacheStrategy<K, V> strategy;

        public CacheMap() {
            this(new UnboundedCacheStrategy(16, 0.75f, NOT_CANONICAL, STRONG));
        }

        public CacheMap(Strength strength) {
            this(new UnboundedCacheStrategy(16, 0.75f, NOT_CANONICAL, strength));
        }

        public CacheMap(int bound) {
            this(new BoundedLruCacheStrategy(bound));
        }

        public CacheMap(int bound, Strength strength) {
            this(new BoundedLruCacheStrategy(bound, strength));
        }

        public CacheMap(int bound, Canonicity canonicity) {
            this(new BoundedLruCacheStrategy(bound, canonicity, STRONG));
        }

        public CacheMap(CacheStrategy<K, V> strategy) {
            super(strategy.getInitialCapacity(), strategy.getLoadFactor(), true, null);
            this.strategy = this.decoratedStrategy(strategy);
            strategy.mapConstructed(this);
        }

        protected CacheStrategy<K, V> decoratedStrategy(CacheStrategy<K, V> strategy) {
            return strategy;
        }

        @Override
        protected final LinkedEntry<K, V> createEntry(int hashCode, K key, V value, LinkedEntry<K, V> next) {
            return this.strategy.createEntry(hashCode, key, value, next, this.getQueue());
        }

        @Override
        protected final void mapChanged() {
            this.strategy.mapChanged(this);
        }

        @Override
        protected final void entryAdded(LinkedEntry<K, V> entry) {
            this.strategy.entryAdded(this, entry);
        }

        @Override
        protected final void entryChanged(LinkedEntry<K, V> oldEntry, V oldValue, LinkedEntry<K, V> newEntry) {
            this.strategy.entryChanged(this, oldEntry, oldValue, newEntry);
        }

        @Override
        protected final void entryAccessed(LinkedEntry<K, V> entry) {
            this.strategy.entryAccessed(this, entry);
        }

        @Override
        protected final void entryRemoved(LinkedEntry<K, V> entry) {
            this.strategy.entryRemoved(this, entry);
        }

        @Override
        protected final void entryPurged(LinkedEntry<K, V> entry) {
            this.strategy.entryPurged(this, entry);
        }

        @Override
        protected final void entryEvicted(LinkedEntry<K, V> entry) {
            this.strategy.entryEvicted(this, entry);
        }

        @Override
        protected final boolean removeEldestEntry(LinkedEntry<K, V> eldest) {
            return false;
        }

        @Override
        protected LinkedEntry<K, V> getEldestEntry() {
            return this.eldest;
        }

        @Override
        protected final boolean evictEntry(LinkedEntry<K, V> entry) {
            if (this.strategy.getCanonicity() == CANONICAL) {
                if (entry instanceof EvictedLinkedEntry) {
                    return false;
                }
                LinkedEntry<K, V> newEntry = this.strategy.createEvictedEntry(entry.keyHashCode(), entry.getKey(), entry.getValue(), null, this.getQueue());
                if (this.replaceEntryInternal(entry, newEntry, true)) {
                    if (entry == this.eldest) {
                        this.relink(entry, newEntry);
                        this.eldest = newEntry.getAfter();
                    } else {
                        this.unlink(entry);
                        this.linkBefore(newEntry, this.eldest);
                        this.change();
                    }
                    this.entryEvicted(entry);
                    return true;
                }
                return false;
            }
            return super.evictEntry(entry);
        }

        @Override
        public void clear() {
            this.eldest = null;
            super.clear();
        }

        @Override
        void link(LinkedEntry<K, V> entry) {
            if (this.eldest == null) {
                this.eldest = entry;
            }
            super.link(entry);
        }

        @Override
        void unlink(LinkedEntry<K, V> entry) {
            if (this.eldest == entry) {
                this.eldest = entry.getAfter();
            }
            super.unlink(entry);
        }

        @Override
        void relink(LinkedEntry<K, V> oldEntry, LinkedEntry<K, V> newEntry) {
            if (this.eldest == oldEntry) {
                this.eldest = newEntry;
            }
            super.relink(oldEntry, newEntry);
        }

        @Override
        void entryAccessedInternal(LinkedEntry<K, V> oldEntry, LinkedEntry<K, V> newEntry) {
            if (this.strategy.getCanonicity() == CANONICAL && oldEntry instanceof EvictedLinkedEntry) {
                newEntry = this.createEntry(oldEntry.keyHashCode(), oldEntry.getKey(), oldEntry.getValue(), (LinkedEntry<K, V>)null);
                this.replaceEntryInternal(oldEntry, newEntry, true);
            }
            super.entryAccessedInternal(oldEntry, newEntry);
        }

        public static enum Canonicity {
            CANONICAL,
            NOT_CANONICAL;

        }

        public static enum Strength {
            STRONG,
            SOFT,
            WEAK;

        }
    }

    public static class TimedEvictedLinkedEntry<K, V>
    extends EvictedLinkedEntry<K, V>
    implements TimedEntry<K, V> {
        private long time;

        protected TimedEvictedLinkedEntry(long time, int keyHashCode, K key, V value, LinkedEntry<K, V> next, ReferenceQueue<V> queue) {
            super(keyHashCode, key, value, next, queue);
            this.time = time;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public void setTime(long time) {
            this.time = time;
        }
    }

    public static class TimedWeakLinkedEntry<K, V>
    extends WeakLinkedEntry<K, V>
    implements TimedEntry<K, V> {
        private long time;

        protected TimedWeakLinkedEntry(long time, int keyHashCode, K key, V value, LinkedEntry<K, V> next, ReferenceQueue<V> queue) {
            super(keyHashCode, key, value, next, queue);
            this.time = time;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public void setTime(long time) {
            this.time = time;
        }
    }

    public static class TimedSoftLinkedEntry<K, V>
    extends SoftLinkedEntry<K, V>
    implements TimedEntry<K, V> {
        private long time;

        protected TimedSoftLinkedEntry(long time, int keyHashCode, K key, V value, LinkedEntry<K, V> next, ReferenceQueue<V> queue) {
            super(keyHashCode, key, value, next, queue);
            this.time = time;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public void setTime(long time) {
            this.time = time;
        }
    }

    public static class TimedStrongLinkedEntry<K, V>
    extends StrongLinkedEntry<K, V>
    implements TimedEntry<K, V> {
        private long time;

        protected TimedStrongLinkedEntry(long time, int keyHashCode, K key, V value, LinkedEntry<K, V> next) {
            super(keyHashCode, key, value, next);
            this.time = time;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public void setTime(long time) {
            this.time = time;
        }
    }

    public static interface TimedEntry<K, V>
    extends LinkedEntry<K, V> {
        public long getTime();

        public void setTime(long var1);
    }

    public static class TimedLruCacheStrategy<K, V>
    extends BoundedLruCacheStrategy<K, V> {
        private final long time;
        private final long period;
        private final Object lock;
        private volatile TimerTask task;
        private final List<WeakReference<CacheMap<K, V>>> maps;
        private static volatile Timer timer;

        public TimedLruCacheStrategy(int time) {
            this(time, 0);
        }

        public TimedLruCacheStrategy(int time, int period, Object lock) {
            this(time, period, lock, 0);
        }

        public TimedLruCacheStrategy(int time, int bound) {
            this(time, bound, bound > 0 ? bound + 1 : 16, bound > 0 ? 1.0f : 0.75f, CANONICAL, STRONG);
        }

        public TimedLruCacheStrategy(int time, int period, Object lock, int bound) {
            this(time, period, lock, bound, bound > 0 ? bound + 1 : 16, bound > 0 ? 1.0f : 0.75f, CANONICAL, STRONG);
        }

        public TimedLruCacheStrategy(int time, int bound, int initialCapacity, float loadFactor, CacheMap.Canonicity canonicity, CacheMap.Strength strength) {
            this(time, 0, null, bound, initialCapacity, loadFactor, canonicity, strength);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TimedLruCacheStrategy(int time, int period, Object lock, int bound, int initialCapacity, float loadFactor, CacheMap.Canonicity canonicity, CacheMap.Strength strength) {
            super(bound, initialCapacity, loadFactor, canonicity, strength);
            if (time < 0) {
                throw new IllegalArgumentException("time < 0");
            }
            if (period < 0) {
                throw new IllegalArgumentException("period < 0");
            }
            if (period > 0 && lock == null) {
                throw new IllegalArgumentException("period > 0 but lock == null");
            }
            this.time = time;
            this.period = period;
            this.lock = lock;
            if (period > 0) {
                this.maps = new ArrayList<WeakReference<CacheMap<K, V>>>();
                Class<TimedLruCacheStrategy> clazz = TimedLruCacheStrategy.class;
                synchronized (TimedLruCacheStrategy.class) {
                    if (timer == null) {
                        timer = new Timer("TimedLruCacheStrategy-periodic");
                    }
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                }
            } else {
                this.maps = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void mapConstructed(CacheMap<K, V> map) {
            if (this.period > 0L) {
                this.maps.add(new WeakReference<CacheMap<K, V>>(map));
                TimedLruCacheStrategy timedLruCacheStrategy = this;
                synchronized (timedLruCacheStrategy) {
                    if (this.task == null) {
                        this.task = new TimerTask(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                if (lock instanceof Lock) {
                                    ((Lock)lock).lock();
                                    try {
                                        this.runUnderLock();
                                    }
                                    finally {
                                        ((Lock)lock).unlock();
                                    }
                                }
                                if (lock != null) {
                                    Object object = lock;
                                    synchronized (object) {
                                        this.runUnderLock();
                                    }
                                }
                            }

                            private void runUnderLock() {
                                Iterator i = maps.iterator();
                                while (i.hasNext()) {
                                    WeakReference reference = (WeakReference)i.next();
                                    CacheMap map = (CacheMap)reference.get();
                                    if (map != null) {
                                        this.periodicTaskExecuted(map);
                                        continue;
                                    }
                                    i.remove();
                                }
                                if (maps.isEmpty()) {
                                    task = null;
                                    this.cancel();
                                }
                            }
                        };
                        timer.schedule(this.task, this.period, this.period);
                    }
                }
            }
        }

        @Override
        protected LinkedEntry<K, V> createDefaultEntry(int hashCode, K key, V value, LinkedEntry<K, V> next) {
            return new TimedStrongLinkedEntry<K, V>(System.currentTimeMillis(), hashCode, key, value, next);
        }

        @Override
        protected LinkedEntry<K, V> createSoftEntry(int hashCode, K key, V value, LinkedEntry<K, V> next, ReferenceQueue<V> queue) {
            return new TimedSoftLinkedEntry<K, V>(System.currentTimeMillis(), hashCode, key, value, next, queue);
        }

        @Override
        protected LinkedEntry<K, V> createWeakEntry(int hashCode, K key, V value, LinkedEntry<K, V> next, ReferenceQueue<V> queue) {
            return new TimedWeakLinkedEntry<K, V>(System.currentTimeMillis(), hashCode, key, value, next, queue);
        }

        @Override
        protected LinkedEntry<K, V> createEvictedEntry(int hashCode, K key, V value, LinkedEntry<K, V> next, ReferenceQueue<V> queue) {
            return new TimedEvictedLinkedEntry<K, V>(System.currentTimeMillis(), hashCode, key, value, next, queue);
        }

        protected void evictExpiredEntries(CacheMap<K, V> map) {
            long limit = System.currentTimeMillis() - this.time;
            LinkedEntry<K, V> eldest = map.getEldestEntry();
            while (eldest != null && ((TimedEntry)eldest).getTime() <= limit && map.evictEntry(eldest)) {
                eldest = map.getEldestEntry();
            }
        }

        protected void periodicTaskExecuted(CacheMap<K, V> map) {
            map.purge();
            this.evictExpiredEntries(map);
        }

        @Override
        protected void entryAdded(CacheMap<K, V> map, LinkedEntry<K, V> entry) {
            this.evictExpiredEntries(map);
            super.entryAdded(map, entry);
        }

        @Override
        protected void entryChanged(CacheMap<K, V> map, LinkedEntry<K, V> oldEntry, V oldValue, LinkedEntry<K, V> newEntry) {
            this.evictExpiredEntries(map);
        }

        @Override
        protected void entryAccessed(CacheMap<K, V> map, LinkedEntry<K, V> entry) {
            this.evictExpiredEntries(map);
        }

        @Override
        protected void entryRemoved(CacheMap<K, V> map, LinkedEntry<K, V> entry) {
            this.evictExpiredEntries(map);
        }

        @Override
        protected void entryPurged(CacheMap<K, V> map, LinkedEntry<K, V> entry) {
            this.evictExpiredEntries(map);
        }

        @Override
        protected void entryEvicted(CacheMap<K, V> map, LinkedEntry<K, V> entry) {
        }
    }

    public static class BoundedLruCacheStrategy<K, V>
    extends CacheStrategy<K, V> {
        private int bound;

        public BoundedLruCacheStrategy(int bound) {
            this(bound, bound + 1, 1.0f, CANONICAL, STRONG);
        }

        public BoundedLruCacheStrategy(int bound, CacheMap.Strength strength) {
            this(bound, bound + 1, 1.0f, CANONICAL, strength);
        }

        public BoundedLruCacheStrategy(int bound, CacheMap.Canonicity canonicity, CacheMap.Strength strength) {
            this(bound, bound + 1, 1.0f, canonicity, strength);
        }

        public BoundedLruCacheStrategy(int bound, int initialCapacity, float loadFactor, CacheMap.Canonicity canonicity, CacheMap.Strength strength) {
            super(initialCapacity, loadFactor, canonicity, strength);
            if (bound < 0) {
                throw new IllegalArgumentException("maximumSize < 0");
            }
            this.bound = bound;
        }

        @Override
        protected void entryAdded(CacheMap<K, V> map, LinkedEntry<K, V> entry) {
            if (this.bound > 0 && map.size() > this.bound) {
                map.evictEntry(map.getEldestEntry());
            }
        }
    }

    public static class UnboundedCacheStrategy<K, V>
    extends CacheStrategy<K, V> {
        public UnboundedCacheStrategy() {
            super(16, 0.75f, NOT_CANONICAL, STRONG);
        }

        public UnboundedCacheStrategy(CacheMap.Strength defaultStrength) {
            super(16, 0.75f, NOT_CANONICAL, defaultStrength);
        }

        public UnboundedCacheStrategy(CacheMap.Canonicity canonicity, CacheMap.Strength strength) {
            super(16, 0.75f, canonicity, strength);
        }

        public UnboundedCacheStrategy(int initialCapacity, float loadFactor, CacheMap.Canonicity canonicity, CacheMap.Strength strength) {
            super(initialCapacity, loadFactor, canonicity, strength);
        }
    }

    public static abstract class CacheStrategy<K, V>
    implements Serializable {
        public static final int DEFAULT_INITIAL_CAPACITY = 16;
        public static final float DEFAULT_LOAD_FACTOR = 0.75f;
        public static final CacheMap.Strength STRONG = CacheMap.Strength.STRONG;
        public static final CacheMap.Strength SOFT = CacheMap.Strength.SOFT;
        public static final CacheMap.Strength WEAK = CacheMap.Strength.WEAK;
        public static final CacheMap.Canonicity CANONICAL = CacheMap.Canonicity.CANONICAL;
        public static final CacheMap.Canonicity NOT_CANONICAL = CacheMap.Canonicity.NOT_CANONICAL;
        private final int initialCapacity;
        private final float loadFactor;
        private final CacheMap.Strength defaultStrength;
        private final CacheMap.Canonicity canonicity;

        protected CacheStrategy(int initialCapacity, float loadFactor, CacheMap.Canonicity canonicity, CacheMap.Strength defaultStrength) {
            this.initialCapacity = initialCapacity;
            this.loadFactor = loadFactor;
            this.canonicity = canonicity;
            this.defaultStrength = defaultStrength;
        }

        public int getInitialCapacity() {
            return this.initialCapacity;
        }

        public float getLoadFactor() {
            return this.loadFactor;
        }

        public CacheMap.Canonicity getCanonicity() {
            return this.canonicity;
        }

        public CacheMap.Strength getDefaultStrength() {
            return this.defaultStrength;
        }

        protected LinkedEntry<K, V> createEntry(int hashCode, K key, V value, LinkedEntry<K, V> next, ReferenceQueue<V> queue) {
            switch (this.getDefaultStrength()) {
                case STRONG: {
                    return this.createDefaultEntry(hashCode, key, value, next);
                }
                case SOFT: {
                    return this.createSoftEntry(hashCode, key, value, next, queue);
                }
                case WEAK: {
                    return this.createWeakEntry(hashCode, key, value, next, queue);
                }
            }
            throw new IllegalStateException();
        }

        protected LinkedEntry<K, V> createDefaultEntry(int hashCode, K key, V value, LinkedEntry<K, V> next) {
            return new StrongLinkedEntry<K, V>(hashCode, key, value, next);
        }

        protected LinkedEntry<K, V> createSoftEntry(int hashCode, K key, V value, LinkedEntry<K, V> next, ReferenceQueue<V> queue) {
            return new SoftLinkedEntry<K, V>(hashCode, key, value, next, queue);
        }

        protected LinkedEntry<K, V> createWeakEntry(int hashCode, K key, V value, LinkedEntry<K, V> next, ReferenceQueue<V> queue) {
            return new WeakLinkedEntry<K, V>(hashCode, key, value, next, queue);
        }

        protected LinkedEntry<K, V> createEvictedEntry(int hashCode, K key, V value, LinkedEntry<K, V> next, ReferenceQueue<V> queue) {
            return new EvictedLinkedEntry<K, V>(hashCode, key, value, next, queue);
        }

        protected void mapConstructed(CacheMap<K, V> map) {
        }

        protected void mapChanged(CacheMap<K, V> map) {
        }

        protected void entryAdded(CacheMap<K, V> map, LinkedEntry<K, V> entry) {
        }

        protected void entryChanged(CacheMap<K, V> map, LinkedEntry<K, V> oldEntry, V oldValue, LinkedEntry<K, V> newEntry) {
        }

        protected void entryAccessed(CacheMap<K, V> map, LinkedEntry<K, V> entry) {
        }

        protected void entryRemoved(CacheMap<K, V> map, LinkedEntry<K, V> entry) {
        }

        protected void entryPurged(CacheMap<K, V> map, LinkedEntry<K, V> entry) {
        }

        protected void entryEvicted(CacheMap<K, V> map, LinkedEntry<K, V> entry) {
        }
    }

    public static class EvictedLinkedEntry<K, V>
    extends WeakLinkedEntry<K, V> {
        public EvictedLinkedEntry(int keyHashCode, K key, V value, LinkedEntry<K, V> next, ReferenceQueue<V> queue) {
            super(keyHashCode, key, value, next, queue);
        }
    }

    public static class WeakLinkedEntry<K, V>
    extends WeakReference<V>
    implements LinkedEntry<K, V> {
        private final int keyHashCode;
        private final K key;
        private BaseEntry<K, V> next;
        private LinkedEntry<K, V> before;
        private LinkedEntry<K, V> after;

        protected WeakLinkedEntry(int keyHashCode, K key, V value, LinkedEntry<K, V> next, ReferenceQueue<V> queue) {
            super(value, queue);
            this.next = next;
            this.keyHashCode = keyHashCode;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return (V)this.get();
        }

        @Override
        public V setValue(V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BaseEntry<K, V> getNext() {
            return this.next;
        }

        @Override
        public void setNext(BaseEntry<K, V> next) {
            this.next = next;
        }

        @Override
        public int keyHashCode() {
            return this.keyHashCode;
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public final LinkedEntry<K, V> getBefore() {
            return this.before;
        }

        @Override
        public final LinkedEntry<K, V> getAfter() {
            return this.after;
        }

        @Override
        public final void setBefore(LinkedEntry<K, V> before) {
            this.before = before;
        }

        @Override
        public final void setAfter(LinkedEntry<K, V> after) {
            this.after = after;
        }

        @Override
        public boolean equals(Object object) {
            Object v2;
            V v1;
            Object k2;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)object;
            K k1 = this.getKey();
            return (k1 == (k2 = that.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = that.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K key = this.getKey();
            V value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    public static class SoftLinkedEntry<K, V>
    extends SoftReference<V>
    implements LinkedEntry<K, V> {
        private final int keyHashCode;
        private final K key;
        private BaseEntry<K, V> next;
        private LinkedEntry<K, V> before;
        private LinkedEntry<K, V> after;

        protected SoftLinkedEntry(int hash, K key, V value, LinkedEntry<K, V> next, ReferenceQueue<V> queue) {
            super(value, queue);
            this.keyHashCode = hash;
            this.key = key;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return (V)this.get();
        }

        @Override
        public V setValue(V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BaseEntry<K, V> getNext() {
            return this.next;
        }

        @Override
        public void setNext(BaseEntry<K, V> next) {
            this.next = next;
        }

        @Override
        public int keyHashCode() {
            return this.keyHashCode;
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public final LinkedEntry<K, V> getBefore() {
            return this.before;
        }

        @Override
        public final LinkedEntry<K, V> getAfter() {
            return this.after;
        }

        @Override
        public final void setBefore(LinkedEntry<K, V> before) {
            this.before = before;
        }

        @Override
        public final void setAfter(LinkedEntry<K, V> after) {
            this.after = after;
        }

        @Override
        public boolean equals(Object object) {
            Object v2;
            V v1;
            Object k2;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)object;
            K k1 = this.getKey();
            return (k1 == (k2 = that.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = that.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K key = this.getKey();
            V value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    public static class StrongLinkedEntry<K, V>
    implements LinkedEntry<K, V> {
        private final K key;
        private V value;
        private final int keyHashCode;
        private BaseEntry<K, V> next;
        private LinkedEntry<K, V> before;
        private LinkedEntry<K, V> after;

        protected StrongLinkedEntry(int keyHashCode, K key, V value, LinkedEntry<K, V> next) {
            this.keyHashCode = keyHashCode;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public BaseEntry<K, V> getNext() {
            return this.next;
        }

        @Override
        public void setNext(BaseEntry<K, V> next) {
            this.next = next;
        }

        @Override
        public int keyHashCode() {
            return this.keyHashCode;
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        @Override
        public final LinkedEntry<K, V> getBefore() {
            return this.before;
        }

        @Override
        public final LinkedEntry<K, V> getAfter() {
            return this.after;
        }

        @Override
        public final void setBefore(LinkedEntry<K, V> before) {
            this.before = before;
        }

        @Override
        public final void setAfter(LinkedEntry<K, V> after) {
            this.after = after;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K key = this.getKey();
            V value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    public static interface LinkedEntry<K, V>
    extends BaseEntry<K, V> {
        public LinkedEntry<K, V> getBefore();

        public LinkedEntry<K, V> getAfter();

        public void setBefore(LinkedEntry<K, V> var1);

        public void setAfter(LinkedEntry<K, V> var1);
    }

    public static class WeakEntry<K, V>
    extends WeakReference<V>
    implements BaseEntry<K, V> {
        private final int keyHashCode;
        private final K key;
        private BaseEntry<K, V> next;

        protected WeakEntry(int keyHashCode, K key, V value, WeakEntry<K, V> next, ReferenceQueue<V> queue) {
            super(value, queue);
            this.next = next;
            this.keyHashCode = keyHashCode;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return (V)this.get();
        }

        @Override
        public V setValue(V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BaseEntry<K, V> getNext() {
            return this.next;
        }

        @Override
        public void setNext(BaseEntry<K, V> next) {
            this.next = next;
        }

        @Override
        public int keyHashCode() {
            return this.keyHashCode;
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public boolean equals(Object object) {
            Object v2;
            V v1;
            Object k2;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)object;
            K k1 = this.getKey();
            return (k1 == (k2 = that.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = that.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K key = this.getKey();
            V value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    public static class SoftEntry<K, V>
    extends SoftReference<V>
    implements BaseEntry<K, V> {
        private final int keyHashCode;
        private final K key;
        private BaseEntry<K, V> next;

        protected SoftEntry(int keyHashCode, K key, V value, SoftEntry<K, V> next, ReferenceQueue<V> queue) {
            super(value, queue);
            this.next = next;
            this.keyHashCode = keyHashCode;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return (V)this.get();
        }

        @Override
        public V setValue(V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BaseEntry<K, V> getNext() {
            return this.next;
        }

        @Override
        public void setNext(BaseEntry<K, V> next) {
            this.next = next;
        }

        @Override
        public int keyHashCode() {
            return this.keyHashCode;
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public boolean equals(Object object) {
            Object v2;
            V v1;
            Object k2;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)object;
            K k1 = this.getKey();
            return (k1 == (k2 = that.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = that.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K key = this.getKey();
            V value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    public static class StrongEntry<K, V>
    implements BaseEntry<K, V> {
        private final K key;
        private V value;
        private final int keyHashCode;
        private BaseEntry<K, V> next;

        protected StrongEntry(int hash, K key, V value, BaseEntry<K, V> next) {
            this.next = next;
            this.keyHashCode = hash;
            this.value = value;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public BaseEntry<K, V> getNext() {
            return this.next;
        }

        @Override
        public void setNext(BaseEntry<K, V> next) {
            this.next = next;
        }

        @Override
        public int keyHashCode() {
            return this.keyHashCode;
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K key = this.getKey();
            V value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    public static interface BaseEntry<K, V>
    extends Map.Entry<K, V> {
        public BaseEntry<K, V> getNext();

        public void setNext(BaseEntry<K, V> var1);

        public int keyHashCode();

        public boolean isMutable();
    }

    public static class WeakLinkedHashMap<K, V>
    extends AbstractLinkedHashMap<K, V, WeakLinkedEntry<K, V>> {
        public WeakLinkedHashMap() {
            super(16, 0.75f, false, null);
        }

        public WeakLinkedHashMap(int initialCapacity) {
            super(initialCapacity, 0.75f, false, null);
        }

        public WeakLinkedHashMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, false, null);
        }

        public WeakLinkedHashMap(Map<? extends K, ? extends V> map) {
            super(map);
        }

        public WeakLinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
            super(initialCapacity, loadFactor, accessOrder, null);
        }

        @Override
        protected WeakLinkedEntry<K, V> createEntry(int hash, K key, V value, WeakLinkedEntry<K, V> next) {
            return new WeakLinkedEntry<K, V>(hash, key, value, next, this.getQueue());
        }
    }

    public static class SoftLinkedHashMap<K, V>
    extends AbstractLinkedHashMap<K, V, SoftLinkedEntry<K, V>> {
        public SoftLinkedHashMap() {
            super(16, 0.75f, false, null);
        }

        public SoftLinkedHashMap(int initialCapacity) {
            super(initialCapacity, 0.75f, false, null);
        }

        public SoftLinkedHashMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, false, null);
        }

        public SoftLinkedHashMap(Map<? extends K, ? extends V> map) {
            super(map);
        }

        public SoftLinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
            super(initialCapacity, loadFactor, accessOrder, null);
        }

        @Override
        protected SoftLinkedEntry<K, V> createEntry(int hash, K key, V value, SoftLinkedEntry<K, V> next) {
            return new SoftLinkedEntry<K, V>(hash, key, value, next, this.getQueue());
        }
    }

    public static class StrongLinkedHashMap<K, V>
    extends AbstractLinkedHashMap<K, V, StrongLinkedEntry<K, V>> {
        public StrongLinkedHashMap() {
            super(16, 0.75f, false, null);
        }

        public StrongLinkedHashMap(int initialCapacity) {
            super(initialCapacity, 0.75f, false, null);
        }

        public StrongLinkedHashMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, false, null);
        }

        public StrongLinkedHashMap(Map<? extends K, ? extends V> map) {
            super(map);
        }

        public StrongLinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
            super(initialCapacity, loadFactor, accessOrder, null);
        }

        @Override
        protected StrongLinkedEntry<K, V> createEntry(int hash, K key, V value, StrongLinkedEntry<K, V> next) {
            return new StrongLinkedEntry<K, V>(hash, key, value, next);
        }
    }

    public static class WeakHashMap<K, V>
    extends AbstractHashMap<K, V, WeakEntry<K, V>> {
        public WeakHashMap() {
            super(16, 0.75f, null);
        }

        public WeakHashMap(int initialCapacity) {
            super(initialCapacity, 0.75f, null);
        }

        public WeakHashMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, null);
        }

        public WeakHashMap(Map<? extends K, ? extends V> map) {
            super(map);
        }

        @Override
        protected WeakEntry<K, V> createEntry(int hash, K key, V value, WeakEntry<K, V> next) {
            return new WeakEntry<K, V>(hash, key, value, next, this.getQueue());
        }
    }

    public static class SoftHashMap<K, V>
    extends AbstractHashMap<K, V, SoftEntry<K, V>> {
        public SoftHashMap() {
            super(16, 0.75f, null);
        }

        public SoftHashMap(int initialCapacity) {
            super(initialCapacity, 0.75f, null);
        }

        public SoftHashMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, null);
        }

        public SoftHashMap(Map<? extends K, ? extends V> map) {
            super(map);
        }

        @Override
        protected SoftEntry<K, V> createEntry(int hash, K key, V value, SoftEntry<K, V> next) {
            return new SoftEntry<K, V>(hash, key, value, next, this.getQueue());
        }
    }

    public static class StrongHashMap<K, V>
    extends AbstractHashMap<K, V, StrongEntry<K, V>> {
        public StrongHashMap() {
            super(16, 0.75f, null);
        }

        public StrongHashMap(int initialCapacity) {
            super(initialCapacity, 0.75f, null);
        }

        public StrongHashMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, null);
        }

        public StrongHashMap(Map<? extends K, ? extends V> map) {
            super(map);
        }

        @Override
        protected StrongEntry<K, V> createEntry(int hash, K key, V value, StrongEntry<K, V> next) {
            return new StrongEntry<K, V>(hash, key, value, next);
        }
    }

    public static abstract class AbstractLinkedHashMap<K, V, E extends LinkedEntry<K, V>>
    extends AbstractHashMap<K, V, E> {
        private transient E after;
        private transient E before;
        private final boolean accessOrder;

        protected AbstractLinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder, Map<? extends K, ? extends V> map) {
            super(initialCapacity, loadFactor, map);
            this.accessOrder = accessOrder;
        }

        protected AbstractLinkedHashMap(Map<? extends K, ? extends V> map) {
            super(map);
            this.accessOrder = false;
        }

        protected void transfer(E[] newTable) {
            int newLength = newTable.length;
            for (Object entry = this.after; entry != null; entry = entry.getAfter()) {
                int i = AbstractLinkedHashMap.tableIndex(entry.keyHashCode(), newLength);
                entry.setNext(newTable[i]);
                newTable[i] = entry;
            }
        }

        public boolean evict(K key) {
            LinkedEntry entry = (LinkedEntry)this.getEntry(key);
            if (entry != null) {
                return this.evictEntry(entry);
            }
            return false;
        }

        @Override
        protected void mapChanged() {
        }

        protected void entryEvicted(E entry) {
        }

        protected E getEldestEntry() {
            if (this.isEmpty()) {
                return null;
            }
            return this.after;
        }

        protected boolean removeEldestEntry(E eldest) {
            return false;
        }

        protected boolean evictEntry(E entry) {
            if (this.replaceEntryInternal(entry, null, true)) {
                this.unlink(entry);
                this.change();
                this.entryEvicted(entry);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            super.clear();
            this.after = null;
            this.before = null;
        }

        @Override
        void entryAddedInternal(E entry) {
            this.link(entry);
            super.entryAddedInternal(entry);
            E eldest = this.getEldestEntry();
            if (this.removeEldestEntry(eldest)) {
                this.evictEntry(eldest);
            }
        }

        @Override
        void entryChangedInternal(E oldEntry, V oldValue, E newEntry) {
            if (this.accessOrder) {
                this.unlink(oldEntry);
                this.link(newEntry);
                this.change();
            } else if (oldEntry != newEntry) {
                this.relink(oldEntry, newEntry);
            }
            super.entryChangedInternal(oldEntry, oldValue, newEntry);
        }

        @Override
        void entryAccessedInternal(E oldEntry, E newEntry) {
            if (this.accessOrder) {
                this.unlink(oldEntry);
                this.link(newEntry);
                this.change();
            }
            super.entryAccessedInternal(oldEntry, newEntry);
        }

        @Override
        void entryRemovedInternal(E entry) {
            this.unlink(entry);
            super.entryRemovedInternal(entry);
        }

        @Override
        void entryPurgedInternal(E entry) {
            this.unlink(entry);
            super.entryPurgedInternal(entry);
        }

        @Override
        protected Iterator<E> createEntryIterator() {
            return new AbstractLinkedEntryIterator<E>(){

                @Override
                public E next() {
                    return this.nextEntry();
                }
            };
        }

        @Override
        protected Iterator<Map.Entry<K, V>> createEntrySetIterator() {
            return new AbstractLinkedEntryIterator<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    return this.nextEntry();
                }
            };
        }

        @Override
        protected Iterator<K> createKeySetIterator() {
            return new AbstractLinkedEntryIterator<K>(){

                @Override
                public K next() {
                    return this.nextEntry().getKey();
                }
            };
        }

        @Override
        protected Iterator<V> createValuesIterator() {
            return new AbstractLinkedEntryIterator<V>(){

                @Override
                public V next() {
                    return this.nextEntry().getValue();
                }
            };
        }

        void link(E entry) {
            if (this.after == null) {
                this.after = entry;
                this.before = this.after;
                entry.setBefore(null);
                entry.setAfter(null);
            } else {
                entry.setBefore(this.before);
                entry.setAfter(null);
                this.before.setAfter(entry);
                this.before = entry;
            }
        }

        void linkBefore(E entry, E existingEntry) {
            LinkedEntry before = existingEntry.getBefore();
            entry.setAfter(existingEntry);
            entry.setBefore(before);
            if (before == null) {
                assert (this.after == existingEntry);
                this.after = entry;
            } else {
                before.setAfter(entry);
            }
            existingEntry.setBefore(entry);
        }

        void unlink(E entry) {
            if (this.after == entry) {
                this.after = entry.getAfter();
            } else {
                entry.getBefore().setAfter(entry.getAfter());
            }
            if (this.before == entry) {
                this.before = entry.getBefore();
            } else {
                entry.getAfter().setBefore(entry.getBefore());
            }
            entry.setBefore(null);
            entry.setAfter(null);
        }

        void relink(E oldEntry, E newEntry) {
            newEntry.setBefore(oldEntry.getBefore());
            newEntry.setAfter(oldEntry.getAfter());
            if (this.after == oldEntry) {
                this.after = newEntry;
            } else {
                oldEntry.getBefore().setAfter(newEntry);
            }
            if (this.before == oldEntry) {
                this.before = newEntry;
            } else {
                oldEntry.getAfter().setBefore(newEntry);
            }
            oldEntry.setBefore(null);
            oldEntry.setAfter(null);
        }

        private abstract class AbstractLinkedEntryIterator<T>
        implements Iterator<T> {
            private E nextEntry;
            private E lastReturned;
            private int expectedChangeCount;

            private AbstractLinkedEntryIterator() {
                this.nextEntry = AbstractLinkedHashMap.this.after;
                this.lastReturned = null;
                this.expectedChangeCount = AbstractLinkedHashMap.this.getChangeCount();
            }

            @Override
            public boolean hasNext() {
                return this.nextEntry != null;
            }

            @Override
            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (AbstractLinkedHashMap.this.getChangeCount() != this.expectedChangeCount) {
                    throw new ConcurrentModificationException();
                }
                AbstractLinkedHashMap.this.removeExistingEntry(this.lastReturned);
                this.lastReturned = null;
                this.expectedChangeCount = AbstractLinkedHashMap.this.getChangeCount();
            }

            protected E nextEntry() {
                if (AbstractLinkedHashMap.this.getChangeCount() != this.expectedChangeCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.nextEntry;
                Object entry = this.lastReturned;
                this.nextEntry = entry.getAfter();
                return entry;
            }
        }
    }

    public static abstract class AbstractHashMap<K, V, E extends BaseEntry<K, V>>
    implements Map<K, V>,
    Cloneable,
    Serializable {
        public static final int DEFAULT_INITIAL_CAPACITY = 16;
        public static final int MAXIMUM_CAPACITY = 0x40000000;
        public static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private int threshold;
        private final float loadFactor;
        private transient E[] table;
        private transient int size;
        private volatile transient int changeCount = -1;
        private transient ReferenceQueue<V> queue;
        private transient boolean purging;
        private volatile transient Set<K> keySet;
        private volatile transient Collection<V> values;
        private transient Set<Map.Entry<K, V>> entrySet;
        private static final long serialVersionUID = 362498820763181265L;

        protected AbstractHashMap(int initialCapacity, float loadFactor, Map<? extends K, ? extends V> map) {
            int capacity;
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
            }
            if (initialCapacity > 0x40000000) {
                initialCapacity = 0x40000000;
            }
            if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
                throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
            }
            for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
            }
            this.loadFactor = loadFactor;
            this.threshold = (int)((float)capacity * loadFactor);
            this.table = this.createTable(capacity);
            this.mapConstructedInternal();
            if (map != null) {
                for (Map.Entry<K, V> e : map.entrySet()) {
                    this.addEntry(e.getKey(), e.getValue());
                }
            }
            this.mapInitializedInternal();
        }

        protected AbstractHashMap(Map<? extends K, ? extends V> map) {
            this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f, AbstractHashMap.notNull(map));
        }

        private static <K, V> Map<? extends K, ? extends V> notNull(Map<? extends K, ? extends V> map) {
            if (map == null) {
                throw new NullPointerException();
            }
            return map;
        }

        protected abstract E createEntry(int var1, K var2, V var3, E var4);

        protected int keyHashCode(Object key) {
            return key.hashCode();
        }

        protected boolean keyEquals(Object key1, Object key2) {
            return key1 == key2 || key1.equals(key2);
        }

        protected int valueHashCode(Object value) {
            return value.hashCode();
        }

        protected boolean valueEquals(Object value1, Object value2) {
            return value1 == value2 || value1.equals(value2);
        }

        protected void purge() {
            if (this.queue != null && !this.purging) {
                try {
                    this.purging = true;
                    Reference<V> entry = this.queue.poll();
                    while (entry != null) {
                        this.purgeEntry((BaseEntry)((Object)entry));
                        entry = this.queue.poll();
                    }
                }
                finally {
                    this.purging = false;
                }
            }
        }

        protected final ReferenceQueue<V> getQueue() {
            if (this.queue == null) {
                this.queue = new ReferenceQueue();
            }
            return this.queue;
        }

        protected void mapConstructed() {
        }

        protected void mapInitialized() {
        }

        protected void mapChanged() {
        }

        protected void entryAdded(E entry) {
        }

        protected void entryChanged(E oldEntry, V oldValue, E newEntry) {
        }

        protected void entryAccessed(E entry) {
        }

        protected void entryRemoved(E entry) {
        }

        protected void entryPurged(E entry) {
        }

        void mapConstructedInternal() {
            this.changeCount = -1;
            this.mapConstructed();
        }

        void mapInitializedInternal() {
            assert (this.changeCount < 0);
            this.changeCount = 0;
            this.mapInitialized();
        }

        void mapChangedInternal() {
            assert (this.changeCount >= 0);
            this.mapChanged();
        }

        void entryAddedInternal(E entry) {
            this.change();
            this.entryAdded(entry);
        }

        void entryChangedInternal(E oldEntry, V oldValue, E newEntry) {
            this.entryChanged(oldEntry, oldValue, newEntry);
        }

        void entryAccessedInternal(E oldEntry, E newEntry) {
            this.entryAccessed(newEntry);
        }

        void entryRemovedInternal(E entry) {
            this.change();
            this.entryRemoved(entry);
        }

        void entryPurgedInternal(E entry) {
            this.change();
            this.entryPurged(entry);
        }

        @Override
        public int size() {
            if (this.size > 0) {
                this.purge();
            }
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            if (this.size == 0) {
                return true;
            }
            this.purge();
            return this.size == 0;
        }

        @Override
        public V get(Object key) {
            E entry = this.getEntry(key);
            if (entry != null) {
                Object value = entry.getValue();
                this.entryAccessedInternal(entry, entry);
                return value;
            }
            return null;
        }

        @Override
        public V put(K key, V value) {
            this.purge();
            if (this.size >= this.threshold) {
                this.resize(2 * this.table.length);
            }
            return this.addEntry(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            int sizeToAdd = map.size();
            if (sizeToAdd == 0) {
                return;
            }
            if (sizeToAdd > this.threshold) {
                int newCapacity;
                int targetCapacity = Math.min((int)((float)sizeToAdd / this.loadFactor + 1.0f), 0x40000000);
                for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
                }
                if (newCapacity > this.table.length) {
                    this.resize(newCapacity);
                }
            }
            for (Map.Entry<K, V> e : map.entrySet()) {
                if (this.size >= this.threshold) {
                    this.resize(2 * this.table.length);
                }
                this.addEntry(e.getKey(), e.getValue());
            }
        }

        @Override
        public V remove(Object key) {
            E entry = this.removeKey(key, null);
            return entry != null ? (V)entry.getValue() : null;
        }

        @Override
        public void clear() {
            BaseEntry[] table = this.getTable(true);
            for (int i = 0; i < table.length; ++i) {
                table[i] = null;
            }
            this.size = 0;
            this.change();
        }

        @Override
        public boolean containsKey(Object key) {
            if (key != null) {
                int hash = this.keyHashCodeInternal(key);
                for (BaseEntry entry = this.getTable(true)[this.tableIndex(hash)]; entry != null; entry = entry.getNext()) {
                    if (hash != entry.keyHashCode() || !this.keyEquals(key, entry.getKey())) continue;
                    return true;
                }
            } else {
                int hash = this.keyHashCodeInternal(key);
                for (BaseEntry entry = this.getTable(true)[this.tableIndex(hash)]; entry != null; entry = entry.getNext()) {
                    if (hash != entry.keyHashCode() || null != entry.getKey()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            Iterator<E> iterator = this.createEntryIterator();
            if (value == null) {
                while (iterator.hasNext()) {
                    BaseEntry entry = (BaseEntry)iterator.next();
                    if (null != entry.getValue()) continue;
                    return true;
                }
            } else {
                while (iterator.hasNext()) {
                    BaseEntry entry = (BaseEntry)iterator.next();
                    if (!this.valueEquals(value, entry.getValue())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = new KeySet();
            }
            return this.keySet;
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = new Values();
            }
            return this.values;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new EntrySet();
            }
            return this.entrySet;
        }

        public Object clone() {
            try {
                AbstractHashMap clone = (AbstractHashMap)super.clone();
                clone.table = this.createTable(this.table.length);
                clone.entrySet = null;
                clone.size = 0;
                clone.mapConstructedInternal();
                for (Map.Entry<K, V> entry : this.entrySet()) {
                    clone.addEntry(entry.getKey(), entry.getValue());
                }
                clone.mapInitializedInternal();
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new UnexpectedExceptionError(e);
            }
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map)) {
                return false;
            }
            Map map = (Map)object;
            if (map.size() != this.size()) {
                return false;
            }
            try {
                for (Map.Entry<K, V> entry : this.entrySet()) {
                    K key = entry.getKey();
                    V value = entry.getValue();
                    if (!(value == null ? map.get(key) != null || !map.containsKey(key) : !this.valueEquals(value, map.get(key)))) continue;
                    return false;
                }
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.entrySet().hashCode();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("{");
            Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                Map.Entry<K, V> e = i.next();
                K key = e.getKey();
                V value = e.getValue();
                if (key == this) {
                    buf.append("(this Map)");
                } else {
                    buf.append(key);
                }
                buf.append("=");
                if (value == this) {
                    buf.append("(this Map)");
                } else {
                    buf.append(value);
                }
                if (!(hasNext = i.hasNext())) continue;
                buf.append(", ");
            }
            buf.append("}");
            return buf.toString();
        }

        protected void change() {
            if (this.changeCount >= 0) {
                ++this.changeCount;
                this.mapChangedInternal();
            }
        }

        protected int getChangeCount() {
            return this.changeCount;
        }

        protected Iterator<E> createEntryIterator() {
            return new AbstractEntryIterator<E>(){

                @Override
                public E next() {
                    return this.nextEntry();
                }
            };
        }

        protected Iterator<Map.Entry<K, V>> createEntrySetIterator() {
            return new AbstractEntryIterator<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    return this.nextEntry();
                }
            };
        }

        protected Iterator<K> createKeySetIterator() {
            return new AbstractEntryIterator<K>(){

                @Override
                public K next() {
                    return this.nextEntry().getKey();
                }
            };
        }

        protected Iterator<V> createValuesIterator() {
            return new AbstractEntryIterator<V>(){

                @Override
                public V next() {
                    return this.nextEntry().getValue();
                }
            };
        }

        protected V addEntry(K key, V value) {
            E newEntry;
            int keyHashCode = this.keyHashCodeInternal(key);
            int index = this.tableIndex(keyHashCode);
            E previous = this.table[index];
            Object e = previous;
            while (e != null) {
                BaseEntry next = e.getNext();
                if (keyHashCode == e.keyHashCode() && (key != null ? this.keyEquals(key, e.getKey()) : null == e.getKey())) {
                    Object oldValue = e.getValue();
                    if (e.isMutable()) {
                        e.setValue(value);
                        this.entryChangedInternal(e, oldValue, e);
                    } else {
                        BaseEntry newEntry2 = this.createEntry(keyHashCode, key, value, next);
                        if (previous == e) {
                            this.table[index] = newEntry2;
                        } else {
                            previous.setNext(newEntry2);
                        }
                        this.entryChangedInternal(e, oldValue, newEntry2);
                    }
                    return oldValue;
                }
                previous = e;
                e = next;
            }
            E oldEntry = this.table[index];
            this.table[index] = newEntry = this.createEntry(keyHashCode, key, value, oldEntry);
            ++this.size;
            this.entryAddedInternal(newEntry);
            return null;
        }

        protected E getEntry(Object key) {
            BaseEntry entry;
            BaseEntry[] table = this.getTable(true);
            if (key != null) {
                BaseEntry entry2;
                int hash = this.keyHashCodeInternal(key);
                for (entry2 = table[this.tableIndex(hash)]; !(entry2 == null || entry2.keyHashCode() == hash && this.keyEquals(key, entry2.getKey())); entry2 = entry2.getNext()) {
                }
                return (E)entry2;
            }
            boolean hash = false;
            for (entry = table[this.tableIndex(0)]; entry != null && (0 != entry.keyHashCode() || null != entry.getKey()); entry = entry.getNext()) {
            }
            return (E)entry;
        }

        protected E removeKey(Object key, Map.Entry<K, V> optionalEntryWithValue) {
            BaseEntry previous;
            BaseEntry[] table = this.getTable(true);
            int keyHashCode = this.keyHashCodeInternal(key);
            int index = this.tableIndex(keyHashCode);
            BaseEntry e = previous = table[index];
            while (e != null) {
                BaseEntry next = e.getNext();
                if (keyHashCode == e.keyHashCode() && (key != null ? this.keyEquals(key, e.getKey()) : null == e.getKey())) {
                    if (optionalEntryWithValue != null) {
                        V v1 = optionalEntryWithValue.getValue();
                        Object v2 = e.getValue();
                        if (v1 != null ? !this.valueEquals(v1, v2) : null != v2) {
                            return null;
                        }
                    }
                    --this.size;
                    if (previous == e) {
                        table[index] = next;
                    } else {
                        previous.setNext(next);
                    }
                    this.entryRemovedInternal(e);
                    return (E)e;
                }
                previous = e;
                e = next;
            }
            return null;
        }

        protected void removeExistingEntry(E entry) {
            if (this.replaceEntryInternal(entry, null, true)) {
                this.entryRemovedInternal(entry);
            }
        }

        protected void purgeEntry(E entry) {
            if (this.replaceEntryInternal(entry, null, false)) {
                this.entryPurgedInternal(entry);
            }
        }

        boolean replaceEntryInternal(E entry, E newEntry, boolean purge) {
            BaseEntry previous;
            BaseEntry[] table = this.getTable(purge);
            Object key = entry.getKey();
            int keyHashCode = key != null ? this.keyHashCodeInternal(key) : 0;
            int index = this.tableIndex(keyHashCode);
            BaseEntry e = previous = table[index];
            while (e != null) {
                BaseEntry next = e.getNext();
                if (entry == e) {
                    if (newEntry == null) {
                        --this.size;
                        if (previous == e) {
                            table[index] = next;
                        } else {
                            previous.setNext(next);
                        }
                    } else {
                        newEntry.setNext(e.getNext());
                        if (previous == e) {
                            table[index] = newEntry;
                        } else {
                            previous.setNext(newEntry);
                        }
                    }
                    return true;
                }
                previous = e;
                e = next;
            }
            return false;
        }

        private E[] createTable(int size) {
            return (BaseEntry[])Array.newInstance(BaseEntry.class, size);
        }

        private E[] getTable(boolean purge) {
            if (purge) {
                this.purge();
            }
            return this.table;
        }

        private int tableIndex(int hashCode) {
            return AbstractHashMap.tableIndex(hashCode, this.table.length);
        }

        private int keyHashCodeInternal(Object key) {
            if (key == null) {
                return 0;
            }
            int h = this.keyHashCode(key);
            h ^= h >>> 20 ^ h >>> 12;
            return h ^ h >>> 7 ^ h >>> 4;
        }

        private void resize(int newCapacity) {
            E[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity == 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return;
            }
            BaseEntry[] newTable = this.createTable(newCapacity);
            this.transfer(newTable);
            this.table = newTable;
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        }

        void transfer(BaseEntry[] newTable) {
            int newLength = newTable.length;
            for (Object entry : this.table) {
                while (null != entry) {
                    BaseEntry next = entry.getNext();
                    int i = AbstractHashMap.tableIndex(entry.keyHashCode(), newLength);
                    entry.setNext(newTable[i]);
                    newTable[i] = entry;
                    entry = next;
                }
            }
        }

        static final int tableIndex(int hashCode, int length) {
            return hashCode & length - 1;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
            s.defaultWriteObject();
            s.writeInt(this.table.length);
            s.writeInt(this.size);
            while (i.hasNext()) {
                Map.Entry<K, V> e = i.next();
                s.writeObject(e.getKey());
                s.writeObject(e.getValue());
            }
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            int tableLength = s.readInt();
            this.table = this.createTable(tableLength);
            this.mapConstructedInternal();
            int size = s.readInt();
            for (int i = 0; i < size; ++i) {
                this.addEntry(s.readObject(), s.readObject());
            }
            this.mapInitializedInternal();
        }

        protected int capacity() {
            return this.table.length;
        }

        protected float loadFactor() {
            return this.loadFactor;
        }

        private class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return AbstractHashMap.this.createEntrySetIterator();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object candidate = AbstractHashMap.this.getEntry(e.getKey());
                return candidate != null && candidate.equals(e);
            }

            @Override
            public boolean remove(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    return AbstractHashMap.this.removeKey(entry.getKey(), entry) != null;
                }
                return false;
            }

            @Override
            public int size() {
                return AbstractHashMap.this.size;
            }

            @Override
            public void clear() {
                AbstractHashMap.this.clear();
            }

            @Override
            public int hashCode() {
                int hash = 0;
                for (Map.Entry entry : this) {
                    if (entry == null) continue;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    hash += (key == null ? 0 : AbstractHashMap.this.keyHashCode(key)) ^ (value == null ? 0 : AbstractHashMap.this.valueHashCode(value));
                }
                return hash;
            }
        }

        private class Values
        extends AbstractCollection<V> {
            private Values() {
            }

            @Override
            public Iterator<V> iterator() {
                return AbstractHashMap.this.createValuesIterator();
            }

            @Override
            public int size() {
                return AbstractHashMap.this.size;
            }

            @Override
            public boolean contains(Object o) {
                return AbstractHashMap.this.containsValue(o);
            }

            @Override
            public void clear() {
                AbstractHashMap.this.clear();
            }

            @Override
            public int hashCode() {
                int hash = 0;
                for (Object value : this) {
                    if (value == null) continue;
                    hash += AbstractHashMap.this.valueHashCode(value);
                }
                return hash;
            }
        }

        private class KeySet
        extends AbstractSet<K> {
            private KeySet() {
            }

            @Override
            public Iterator<K> iterator() {
                return AbstractHashMap.this.createKeySetIterator();
            }

            @Override
            public int size() {
                return AbstractHashMap.this.size;
            }

            @Override
            public boolean contains(Object o) {
                return AbstractHashMap.this.containsKey(o);
            }

            @Override
            public boolean remove(Object o) {
                return AbstractHashMap.this.removeKey(o, null) != null;
            }

            @Override
            public void clear() {
                AbstractHashMap.this.clear();
            }

            @Override
            public int hashCode() {
                int hash = 0;
                for (Object key : this) {
                    if (key == null) continue;
                    hash += AbstractHashMap.this.keyHashCode(key);
                }
                return hash;
            }
        }

        private abstract class AbstractEntryIterator<T>
        implements Iterator<T> {
            private E lastEntry;
            private E nextEntry;
            private int tableIndexOfNextEntry;
            private int expectedChangeCount;

            protected AbstractEntryIterator() {
                BaseEntry[] table = AbstractHashMap.this.getTable(true);
                this.expectedChangeCount = AbstractHashMap.this.getChangeCount();
                this.tableIndexOfNextEntry = table.length;
                if (AbstractHashMap.this.size != 0) {
                    while (this.tableIndexOfNextEntry > 0 && (this.nextEntry = table[--this.tableIndexOfNextEntry]) == null) {
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return this.nextEntry != null;
            }

            protected E nextEntry() {
                if (AbstractHashMap.this.getChangeCount() != this.expectedChangeCount) {
                    throw new ConcurrentModificationException();
                }
                Object result = this.nextEntry;
                if (result == null) {
                    throw new NoSuchElementException();
                }
                BaseEntry next = result.getNext();
                if (next == null) {
                    BaseEntry[] table = AbstractHashMap.this.getTable(true);
                    int i = this.tableIndexOfNextEntry;
                    while (next == null && i > 0) {
                        next = table[--i];
                    }
                    this.tableIndexOfNextEntry = i;
                }
                this.nextEntry = next;
                this.lastEntry = result;
                return this.lastEntry;
            }

            @Override
            public void remove() {
                if (this.lastEntry == null) {
                    throw new IllegalStateException();
                }
                if (AbstractHashMap.this.getChangeCount() != this.expectedChangeCount) {
                    throw new ConcurrentModificationException();
                }
                AbstractHashMap.this.removeExistingEntry(this.lastEntry);
                this.lastEntry = null;
                this.expectedChangeCount = AbstractHashMap.this.getChangeCount();
            }
        }
    }
}

