/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.File;
import java.util.List;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;
import oracle.ideimpl.deferredupdate.task.TaskUtil;

public class CreateExtraInfoTask
extends AtomicTask {
    String _extraInfo;
    String _extensionID;
    private File _bundlesExtrasFile;

    public CreateExtraInfoTask(String extraInfo) {
        this._extraInfo = extraInfo;
    }

    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        this._bundlesExtrasFile = TaskUtil.findCFUBundlesExtrasFile(tc);
        String[] pieces = this._extraInfo.split(",");
        if (pieces.length >= 11) {
            this._extensionID = pieces[0];
            this.removeOldBundles();
            List<String> lines = TaskUtil.readFile(this._bundlesExtrasFile);
            lines.add(this._extraInfo);
            TaskUtil.writeFile(lines, this._bundlesExtrasFile);
        }
    }

    @Override
    public void rollback(TaskContext tc) {
    }

    private void removeOldBundles() throws TaskFailedException {
        List<String> bundlesInfoContent = TaskUtil.readFile(this._bundlesExtrasFile);
        if (this.removeBundleLine(bundlesInfoContent)) {
            TaskUtil.writeFile(bundlesInfoContent, this._bundlesExtrasFile);
        }
    }

    private boolean removeBundleLine(List<String> bundleLines) {
        boolean removedLine = false;
        for (int x = 0; x < bundleLines.size(); ++x) {
            String line = bundleLines.get(x);
            if (!line.startsWith(this._extensionID)) continue;
            bundleLines.remove(x);
            removedLine = true;
            break;
        }
        return removedLine;
    }
}

