/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.File;
import java.util.List;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;
import oracle.ideimpl.deferredupdate.task.TaskUtil;

public class DeleteExtraInfoTask
extends AtomicTask {
    private String _extensionID;

    public DeleteExtraInfoTask(String extensionID) {
        this._extensionID = extensionID;
    }

    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        File bundlesExtrasFile = TaskUtil.findCFUBundlesExtrasFile(tc);
        List<String> bundlesInfoContent = TaskUtil.readFile(bundlesExtrasFile);
        if (this.removeBundleLine(bundlesInfoContent)) {
            TaskUtil.writeFile(bundlesInfoContent, bundlesExtrasFile);
        }
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
    }

    private boolean removeBundleLine(List<String> bundleLines) {
        boolean removedLine = false;
        for (int x = 0; x < bundleLines.size(); ++x) {
            String line = bundleLines.get(x);
            if (!line.startsWith(this._extensionID)) continue;
            bundleLines.remove(x);
            removedLine = true;
            break;
        }
        return removedLine;
    }
}

