/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ide.util.MetaClass;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.EditorOptionsPanel;
import oracle.dbtools.raptor.config.NonUserConfigOptions;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.dbtools.raptor.navigator.db.DBNavigatorWindow;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.standalone.ExtrasArb;
import oracle.dbtools.raptor.standalone.IndexedPreferencesCommand;
import oracle.dbtools.raptor.standalone.RaptorContextSupport;
import oracle.dbtools.raptor.usage.UsagesTracker;
import oracle.dbtools.raptor.usages.UsageTrackerInitializer;
import oracle.dbtools.raptor.utils.DatabaseJDBCRegistry;
import oracle.dbtools.raptor.utils.URLChooserShortcuts;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ProductInformation;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.ceditor.options.DisplayOptionsPanel;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.db.model.SqlNode;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.URLChooserShortcutProvider;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.model.Node;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.PlSql;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.PlatformUtils;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.adapter.DatabaseProviderClassLoaderFactory;
import oracle.jdevimpl.runner.run.JRunner;

public class RaptorStandaloneAddin
implements Addin {
    private static final String INDEX_PREFERENCES_ON_STARTUP = "IndexedPreferencesCommand.onStartup";
    private static final String INDEX_PREFERENCES = "IndexedPreferencesCommand";

    public void initialize() {
        if (RaptorExtensionConstants.isStandAlone()) {
            IdeMainWindow ideMainWindow;
            if (NonUserConfigOptions.get((String)"raptor.user.agent.extras") != null) {
                ProductInformation.getProductInformation().setUserAgentExtras(NonUserConfigOptions.get((String)"raptor.user.agent.extras"));
            }
            DialogUtil.addURLChooserShortcutProvider((URLChooserShortcutProvider)URLChooserShortcuts.getInstance());
            DBConfig.getInstance().getURLFileChooserPaths().listenForNodeType(PlSqlNode.class);
            DBConfig.getInstance().getURLFileChooserPaths().listenForNodeType(SqlNode.class);
            DatabaseProvider.setClassLoaderFactory((DatabaseProviderClassLoaderFactory)new DatabaseProviderClassLoaderFactory(){

                public ClassLoader getClassLoader(String string) {
                    return RaptorClassLoader.findClassLoader((String)string);
                }
            });
            DatabaseJDBCRegistry.getInstance();
            JavaVersion javaVersion = new JavaVersion();
            if (!javaVersion.isSupported()) {
                ideMainWindow = Ide.getMainWindow();
                boolean bl = ideMainWindow.isVisible();
                ideMainWindow.setVisible(true);
                MessageDialog.critical((Component)ideMainWindow, (Object)ExtrasArb.format("JDK_VERSION_ERROR", javaVersion.currentVersion(), javaVersion.minSupportedJavaVersion()), (String)ExtrasArb.getString("JDK_VERSION_ERROR_TITLE"), null);
            }
            ideMainWindow = Preferences.getPreferences();
            EditorOptions editorOptions = EditorOptions.getInstance((PropertyStorage)ideMainWindow);
            EditorOptionsPanel.applyOptions((EditorOptions)editorOptions);
            DisplayOptions displayOptions = DisplayOptions.getInstance((PropertyStorage)ideMainWindow);
            displayOptions.setRightMarginColumnAtWrap(false);
            DisplayOptionsPanel.applyOptions((DisplayOptions)displayOptions);
            JRunner jRunner = JRunner.getInstance();
            IdeAction ideAction = jRunner.getActionRunProject();
            if (ideAction != null) {
                StubController.stubAction(ideAction);
            }
            Integer n = Ide.findOrCreateCmdID((String)"oracle.ide.cmd.RevertNodeCommand");
            MetaClass metaClass = new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.ide.replace"), "oracle.ide.cmd.RevertNodeCommand");
            final IdeAction ideAction2 = IdeAction.findOrCreate((int)n, (MetaClass)metaClass, (String)"oracle.ide.cmd.RevertNodeCommand");
            if (ideAction2 != null) {
                ideAction2.addController(new Controller(){

                    public boolean update(IdeAction ideAction, Context context) {
                        Node node;
                        Node node2 = node = context != null ? context.getNode() : null;
                        if (node != null && node instanceof PlSqlNode && DBURLFormatHelper.isDBURL((URL)node.getURL())) {
                            ideAction2.setEnabled(false);
                            return true;
                        }
                        return false;
                    }

                    public boolean handleEvent(IdeAction ideAction, Context context) {
                        return false;
                    }
                });
            }
            DBNavigatorWindow.setContextSupportClass(RaptorContextSupport.class);
            ExplorerManager.getExplorerManager().addStructureSupportForClass(new MetaClass(PlSqlNode.class.getClassLoader(), "oracle.dbtools.raptor.navigator.db.DBNavigatorWindow"));
            Recognizer.registerLowPriorityRecognizer((Recognizer)new Recognizer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Class<? extends Node> recognize(URL uRL) {
                    if (DBURLFormatHelper.isDBURL((URL)uRL)) {
                        String string = DBURLFormatHelper.getBaseType((URL)uRL);
                        if (PlSql.isPlSql((String)string)) return PlSqlNode.class;
                        if ("PACKAGE BODY".equals(string)) return PlSqlNode.class;
                        if ("TYPE BODY".equals(string)) return PlSqlNode.class;
                        if (!"BLOCK".equals(string)) return null;
                        return PlSqlNode.class;
                    }
                    if (uRL.getProtocol().startsWith("ide.")) return null;
                    if (!URLFileSystem.isRegularFile((URL)uRL)) return null;
                    InputStream inputStream = null;
                    try {
                        long l = System.currentTimeMillis();
                        inputStream = URLFileSystem.openInputStream((URL)uRL);
                        String string = IdeUtil.getIdeEncoding();
                        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
                        char[] cArray = new char[5000];
                        inputStreamReader.read(cArray, 0, 5000);
                        List list = LexerToken.parse((String)new String(cArray));
                        if (list.size() == 0) {
                            Class<? extends Node> clazz = null;
                            return clazz;
                        }
                        SqlEarley sqlEarley = SqlEarley.getInstance();
                        Matrix matrix = new Matrix((Parser)sqlEarley);
                        sqlEarley.parse(list, (Matriceable)matrix);
                        if (matrix.lastY() < 5) {
                            Class<? extends Node> clazz = null;
                            return clazz;
                        }
                        int n = 0;
                        for (LexerToken lexerToken : list) {
                            if (4 < n++) break;
                            if (!"PROCEDURE".equalsIgnoreCase(lexerToken.content) && !"FUNCTION".equalsIgnoreCase(lexerToken.content) && !"PACKAGE".equalsIgnoreCase(lexerToken.content) && !"TYPE".equalsIgnoreCase(lexerToken.content) && !"TRIGGER".equalsIgnoreCase(lexerToken.content) && !"OPERATOR".equalsIgnoreCase(lexerToken.content)) continue;
                            Class<PlSqlNode> clazz = PlSqlNode.class;
                            return clazz;
                        }
                        Class<SqlNode> clazz = SqlNode.class;
                        return clazz;
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                    catch (NullPointerException nullPointerException) {
                        return null;
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            });
            UsagesTracker.initTracker();
            UsageTrackerInitializer.init();
            if ("true".equalsIgnoreCase(System.getProperty(INDEX_PREFERENCES, "true"))) {
                IdeAction ideAction3 = IdeActions.getToolsPreferencesAction();
                ideAction3.setCommand(MetaClass.newMetaClass(IndexedPreferencesCommand.class));
            } else {
                System.setProperty(INDEX_PREFERENCES_ON_STARTUP, String.valueOf(Boolean.FALSE));
            }
            if ("true".equalsIgnoreCase(System.getProperty(INDEX_PREFERENCES_ON_STARTUP, "true"))) {
                Ide.getMainWindow().addWindowListener((WindowListener)new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent windowEvent) {
                        new IndexedPreferencesCommand().init();
                        Ide.getMainWindow().removeWindowListener((WindowListener)this);
                    }
                });
            }
        }
    }

    private static final class JavaVersion {
        private JavaVersion() {
        }

        String minSupportedJavaVersion() {
            return "1.8.0_05";
        }

        private String defaultMinVersion() {
            return PlatformUtils.isWindows() ? "1.8.0_05" : "1.8.0_05";
        }

        String currentVersion() {
            return System.getProperty("java.version");
        }

        private Version normalizedMinSupportedJavaVersion() {
            return this.normalize(this.minSupportedJavaVersion());
        }

        private Version normalizedCurrentVersion() {
            return this.normalize(this.currentVersion());
        }

        boolean isSupported() {
            Version version;
            Version version2 = this.normalizedMinSupportedJavaVersion();
            boolean bl = version2.compareTo(version = this.normalizedCurrentVersion()) <= 0;
            return bl;
        }

        private Version normalize(String string) {
            if (string.contains("-")) {
                string = string.substring(0, string.indexOf("-"));
            }
            string = string.trim();
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = null;
            boolean bl = true;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isDigit(c) || c == '.') {
                    if (stringBuilder2 == null) {
                        stringBuilder.append(c);
                        continue;
                    }
                    stringBuilder2.append(c);
                    continue;
                }
                if (stringBuilder2 != null) {
                    bl = false;
                    continue;
                }
                if (c != '_') continue;
                stringBuilder2 = new StringBuilder();
            }
            if (stringBuilder2 != null && bl) {
                stringBuilder.append('.');
                stringBuilder.append((CharSequence)stringBuilder2);
            }
            return new Version(stringBuilder.toString());
        }
    }

    private static class StubController
    implements Controller {
        private static Set<Integer> s_actions = new HashSet<Integer>();
        private static StubController INSTANCE = new StubController();

        private StubController() {
        }

        static void stubAction(IdeAction ideAction) {
            ideAction.addController((Controller)INSTANCE);
            s_actions.add(ideAction.getCommandId());
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            return s_actions.contains(ideAction.getCommandId());
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (s_actions.contains(ideAction.getCommandId())) {
                ideAction.setEnabled(false);
                return true;
            }
            return false;
        }
    }
}

