/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.startpage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorHashStructureAdapter;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public class MRUConnectionCache
extends RaptorHashStructureAdapter
implements ConnectionListener {
    private static final String DATA_KEY = "MRUConnectionCache";
    private static final String CONNECTIONS_KEY = "Connections";
    private static final String MRU_LIST_KEY = "MostRecentlyUsed";
    private static final int MRU_LIST_LENGTH = 10;
    private static MRUConnectionCache INSTANCE;

    public static MRUConnectionCache getInstance() {
        if (null == INSTANCE) {
            INSTANCE = new MRUConnectionCache(MRUConnectionCache.findOrCreate((PropertyStorage)Preferences.getPreferences(), (String)DATA_KEY));
        }
        return INSTANCE;
    }

    private MRUConnectionCache(HashStructure hashStructure) {
        super(hashStructure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMRUConnections() {
        ListStructure listStructure = this.getRootHash().getListStructure(MRUConnectionCache.encode((String)MRU_LIST_KEY));
        if (listStructure != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object = listStructure.iteratorLock();
            synchronized (object) {
                Iterator iterator = listStructure.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(MRUConnectionCache.decode((String)((String)iterator.next())));
                }
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public void addMRUConnection(String string) {
        if (Connections.isPrivateConnection((String)string) || Connections.isTemporaryConnection((String)string)) {
            return;
        }
        ListStructure listStructure = this.getRootHash().getOrCreateListStructure(MRUConnectionCache.encode((String)MRU_LIST_KEY));
        if (listStructure.contains((Object)string)) {
            listStructure.remove((Object)string);
        }
        listStructure.add(0, (Object)string);
        this.trimListStructure(listStructure);
    }

    private void trimListStructure(ListStructure listStructure) {
        int n = 10;
        while (listStructure.size() > n) {
            listStructure.remove(listStructure.size() - 1);
        }
    }

    private void handleConnectionRenamed(String string, String string2) {
        int n;
        ListStructure listStructure = this.getRootHash().getListStructure(MRUConnectionCache.encode((String)MRU_LIST_KEY));
        if (listStructure != null && (n = listStructure.indexOf((Object)string)) >= 0) {
            listStructure.remove(n);
            if (string2 != null) {
                listStructure.add(n, (Object)string2);
            }
        }
    }

    protected String getRootKey() {
        return CONNECTIONS_KEY;
    }

    public void connectionAdded(ConnectionEvent connectionEvent) {
    }

    public void connectionRemoved(ConnectionEvent connectionEvent) {
        this.handleConnectionRenamed(connectionEvent.getConnectionName(), null);
    }

    public void connectionRenamed(ConnectionEvent connectionEvent) {
        this.handleConnectionRenamed(connectionEvent.getOldName(), connectionEvent.getConnectionName());
    }

    public void connectionModified(ConnectionEvent connectionEvent) {
        this.handleConnectionRenamed(connectionEvent.getOldName(), connectionEvent.getConnectionName());
    }

    public void connectionOpened(ConnectionEvent connectionEvent) {
        this.addMRUConnection(connectionEvent.getConnectionName());
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
    }
}

