/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.startpage;

import java.awt.EventQueue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.raptor.startpage.IStartPageProvider;
import oracle.dbtools.raptor.startpage.Options;
import oracle.dbtools.raptor.startpage.StartPageAddin;
import oracle.dbtools.raptor.startpage.StartPageNode;
import oracle.dbtools.raptor.startpage.StartPageViewer;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;

public class StartPageController
implements Controller {
    public static final String SHOW_WELCOME_PAGE_CMD = "oracle.jdevimpl.help.welcomePage";
    public static final String SHOW_WELCOME_PAGE_ONSTARTUP_CMD = "oracle.jdevimpl.help.welcomePageOnStartup";
    private static final int STARTPAGE_CMD_ID = Ide.findCmdID((String)"oracle.jdevimpl.help.welcomePage");
    private static final int SHOW_STARTPAGE_ON_STARTUP_CMD_ID = Ide.findCmdID((String)"oracle.jdevimpl.help.welcomePageOnStartup");
    private static StartPageController _INSTANCE;

    static StartPageController getInstance() {
        if (null == _INSTANCE) {
            _INSTANCE = new StartPageController();
        }
        return _INSTANCE;
    }

    public final boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == STARTPAGE_CMD_ID) {
            this.showStartPage(false);
            return true;
        }
        if (n == SHOW_STARTPAGE_ON_STARTUP_CMD_ID) {
            boolean bl = Ide.getIdeArgs().hasArg("-nonag");
            if (!bl && Options.getShowOnStartup()) {
                this.showStartPage(true);
            }
            return true;
        }
        return false;
    }

    public final boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == STARTPAGE_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }

    private void showStartPage(boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EditorInfo editorInfo = StartPageController.getStartPageEditorInfo();
                if (editorInfo != null) {
                    EditorManager.getEditorManager().activateEditor(editorInfo);
                } else {
                    String string;
                    EditorManager editorManager = EditorManager.getEditorManager();
                    StartPageNode startPageNode = new StartPageNode();
                    URL uRL = null;
                    try {
                        if (Boolean.TRUE == Boolean.valueOf(System.getProperty("sqldeveloper.newstart.styling", "false"))) {
                            uRL = new URL("file://" + System.getProperty("oracle.product.home") + "/sqldeveloper/startpage/StartPage.html");
                        } else {
                            string = System.getProperty("sqldeveloper.newstart.url", null);
                            if (null == string) {
                                MetaResource metaResource;
                                IStartPageProvider iStartPageProvider = StartPageAddin.getStartPageProvider();
                                if (iStartPageProvider != null && (metaResource = iStartPageProvider.getStartPageMetaResource()) != null) {
                                    uRL = metaResource.toURL();
                                }
                            } else {
                                uRL = new URL(string);
                            }
                            if (null == uRL) {
                                uRL = this.getClass().getResource("/oracle/dbtools/raptor/startpage/StartPage.html");
                            }
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                    startPageNode.setURL(uRL);
                    string = Context.newIdeContext((Node)startPageNode);
                    editorManager.openEditorInFrame(StartPageViewer.class, (Context)string);
                }
            }
        };
        EventQueue.invokeLater(runnable);
    }

    private static EditorInfo getStartPageEditorInfo() {
        EditorManager editorManager = EditorManager.getEditorManager();
        List list = editorManager.getEditorsInfo();
        if (list != null && list.size() > 0) {
            for (EditorInfo editorInfo : list) {
                if (!(editorInfo._getEditor() instanceof StartPageViewer)) continue;
                return editorInfo;
            }
        }
        return null;
    }
}

