/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.startpage;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javafx.application.Platform;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.raptor.RaptorExtrasResources;
import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.standalone.connection.ConnectionUtils;
import oracle.dbtools.raptor.startpage.IStartPageProvider;
import oracle.dbtools.raptor.startpage.MRUConnectionCache;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public class StartPageProvider
implements IStartPageProvider {
    private String lastStatus;
    private URLFileChooser chooser;
    private static final String sTnsFolder = "TNS";

    @Override
    public String getStatusMessage() {
        return this.lastStatus;
    }

    @Override
    public MetaResource getStartPageMetaResource() {
        return new MetaResource(IStartPageProvider.class.getClassLoader(), "/oracle/dbtools/raptor/startpage/StartPage.html");
    }

    @Override
    public String getCurrentVersionUrl() {
        return "http://www.oracle.com/ocom/groups/public/@otn/documents/webcontent/4414489.xml";
    }

    @Override
    public String getVersionId() {
        return "sqldeveloperCurrentVersion";
    }

    @Override
    public void postProcess(Document document) {
        ((EventTarget)((Object)document.getElementById("newConnection"))).addEventListener("click", event -> this.newConnection(event), false);
        ((EventTarget)((Object)document.getElementById("loadTnsFile"))).addEventListener("click", event -> this.loadTnsFile(document, event), false);
        ArrayList arrayList = TNSHelper.getTNSEntries();
        LinkedHashMap linkedHashMap = TNSHelper.getTNSLookupLocations();
        this.appendTnsLinks(document, linkedHashMap, arrayList);
        this.appendConnectionMRU(document);
    }

    private void newConnection(Event event) {
        event.preventDefault();
        SwingUtilities.invokeLater(() -> {
            IdeAction ideAction = IdeAction.find((String)"DatabaseNavigator.NewConnection");
            try {
                Context context = DBNavigatorManager.getInstance().getNavigatorWindow().getContext();
                ideAction.performAction(context);
            }
            catch (Exception exception) {
                Logger.severe(this.getClass(), (Throwable)exception);
            }
        });
    }

    private void loadTnsFile(Document document, Event event) {
        event.preventDefault();
        SwingUtilities.invokeLater(() -> {
            try {
                URLFileChooser uRLFileChooser = this.getTnsFileChooser();
                int n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow());
                if (0 == n) {
                    File file = uRLFileChooser.getSelectedFile();
                    Platform.runLater(() -> {
                        try {
                            this.appendTnsLinks(document, file.getAbsolutePath(), TNSHelper.parseTnsFile((File)file));
                        }
                        catch (Throwable throwable) {
                            Logger.severe(this.getClass(), (Throwable)throwable);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                Logger.severe(this.getClass(), (Throwable)throwable);
            }
        });
    }

    private URLFileChooser getTnsFileChooser() {
        if (null == this.chooser) {
            this.chooser = new URLFileChooser();
            this.chooser.setFileSelectionMode(0);
            this.chooser.setSelectionMode(0);
            this.chooser.clearChooseableURLFilters();
            String string = RaptorExtrasResources.get("TNS_FILE_FILTER");
            String string2 = RaptorExtrasResources.get("TNS_FILE_FILTER_DESC");
            this.chooser.addChooseableURLFilter((URLFilter)new WildcardURLFilter(string, URLFileSystem.isLocalFileSystemCaseSensitive(), string2));
            this.chooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
            this.chooser.setPathContext("TNS_FILE");
        }
        return this.chooser;
    }

    private void appendTnsLinks(Document document, Object object, List<TCPTNSEntry> list) {
        Object object2;
        Object object3;
        Element element = document.getElementById("tnsList");
        boolean bl = false;
        if (list.size() > 0) {
            object3 = null;
            object3 = object instanceof Map ? String.valueOf(((Map)object).get("Actual")) : String.valueOf(object);
            object2 = document.createElement("div");
            object2.setAttribute("class", "border-bottom");
            object2.setTextContent((String)object3);
            element.appendChild((Node)object2);
            for (TCPTNSEntry tCPTNSEntry : list) {
                if (tCPTNSEntry.getHostname() == null) continue;
                Element element2 = document.createElement("a");
                element2.setAttribute("href", "#");
                element2.setAttribute("data-toggle", "tooltip");
                element2.setAttribute("data-placement", "auto right");
                element2.setAttribute("title", this.getTnsEntryTooltip(tCPTNSEntry));
                element2.setAttribute("tns-descriptor", tCPTNSEntry.getDescriptor());
                ((EventTarget)((Object)element2)).addEventListener("click", event -> this.addTnsConnection(event), false);
                element2.setTextContent(tCPTNSEntry.getName());
                element.appendChild(element2);
                bl = true;
            }
        }
        if (!bl) {
            object3 = document.createElement("p");
            object2 = RaptorExtrasResources.format("NO_TNS_ENTRIES", String.valueOf(object));
            object3.setTextContent((String)object2);
            element.appendChild((Node)object3);
        }
    }

    private String getTnsEntryTooltip(TCPTNSEntry tCPTNSEntry) {
        String string = null;
        String string2 = tCPTNSEntry.getServicename();
        String string3 = tCPTNSEntry.getHostname();
        String string4 = tCPTNSEntry.getPortno();
        String string5 = tCPTNSEntry.getSid();
        if (string2 != null) {
            string = "\\\\" + string3 + ":" + string4 + "\\" + string2;
        } else if (string5 != null) {
            string = string3 + ":" + string4 + ":" + string5;
        }
        return string;
    }

    private void addTnsConnection(Event event) {
        event.preventDefault();
        Element element = (Element)((Object)event.getTarget());
        this.addTnsConnection(element.getTextContent(), element.getAttribute("tns-descriptor"));
    }

    private void addTnsConnection(String string, String string2) {
        try {
            TCPTNSEntry tCPTNSEntry = new TCPTNSEntry(string, string2);
            String string3 = string;
            Properties properties = DatabaseConnectionStores.getInstance().getStore("IdeConnections").getProperties(string3);
            int n = 1;
            while (properties != null) {
                string3 = string + n++;
                properties = DatabaseConnectionStores.getInstance().getStore("IdeConnections").getProperties(string3);
            }
            String string4 = string3;
            ConnectionUtils.addConnection(string4, string4, null, tCPTNSEntry.getSid(), tCPTNSEntry.getHostname(), tCPTNSEntry.getPortno(), false, tCPTNSEntry.getServicename(), null, sTnsFolder);
            this.lastStatus = RaptorExtrasResources.format("TNS_ENTRY_ADDED", string4);
            Logger.info(this.getClass(), (String)this.lastStatus);
            SwingUtilities.invokeLater(() -> {
                try {
                    Ide.getStatusBar().setText(this.lastStatus);
                    this.dbnavSelect(sTnsFolder, string4);
                }
                catch (Exception exception) {
                    Logger.severe(this.getClass(), (Throwable)exception);
                }
            });
        }
        catch (Throwable throwable) {
            Logger.severe(this.getClass(), (Throwable)throwable);
        }
    }

    private void dbnavSelect(String string, String string2) {
        NavigatorTree navigatorTree = DBNavigatorManager.getInstance().getNavigatorWindow().getTree();
        NavigatorTreeNode navigatorTreeNode = this.findConnectionNode(navigatorTree, string, string2);
        if (navigatorTreeNode != null) {
            navigatorTree.setSelectedNode(navigatorTreeNode);
            if (null == string) {
                navigatorTree.expand(navigatorTreeNode, false);
            }
        }
    }

    private NavigatorTreeNode findConnectionNode(NavigatorTree navigatorTree, String string, String string2) {
        navigatorTree.refresh(navigatorTree.getRoot());
        NavigatorTreeNode navigatorTreeNode = (NavigatorTreeNode)navigatorTree.getRoot().getFirstChild();
        if (null == string2) {
            return null;
        }
        navigatorTree.expand(navigatorTreeNode, false);
        return this.findChildTreeNode(navigatorTree, navigatorTreeNode, string, string2);
    }

    private NavigatorTreeNode findChildTreeNode(NavigatorTree navigatorTree, NavigatorTreeNode navigatorTreeNode, String string, String string2) {
        ArrayList<NavigatorTreeNode> arrayList = new ArrayList<NavigatorTreeNode>();
        Iterator iterator = navigatorTreeNode.getChildNodes();
        while (iterator.hasNext()) {
            NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)iterator.next();
            if (string2.equals(navigatorTreeNode2.getShortLabel())) {
                return navigatorTreeNode2;
            }
            if (navigatorTreeNode2.getElement() instanceof DatabaseConnection || string != null && !string.equals(navigatorTreeNode2.getShortLabel()) || navigatorTreeNode2.isLeaf()) continue;
            arrayList.add(navigatorTreeNode2);
        }
        for (NavigatorTreeNode navigatorTreeNode2 : arrayList) {
            navigatorTree.expand(navigatorTreeNode2, false);
            NavigatorTreeNode navigatorTreeNode3 = this.findChildTreeNode(navigatorTree, navigatorTreeNode2, string, string2);
            if (navigatorTreeNode3 != null) {
                return navigatorTreeNode3;
            }
            navigatorTree.collapse(navigatorTreeNode2, false);
        }
        return null;
    }

    private void appendConnectionMRU(Document document) {
        Element element = document.getElementById("recentTab");
        Element element2 = document.getElementById("recent");
        Element element3 = document.getElementById("connList");
        Element element4 = document.getElementById("detectedTab");
        Element element5 = document.getElementById("detected");
        List<String> list = MRUConnectionCache.getInstance().getMRUConnections();
        for (String string : list) {
            Element element6 = document.createElement("a");
            element6.setAttribute("href", "#");
            element6.setAttribute("connectionName", string);
            ((EventTarget)((Object)element6)).addEventListener("click", event -> this.openConnection(event), false);
            element6.setTextContent(Connections.getDisplayName((String)string));
            element3.appendChild(element6);
        }
        if (list.isEmpty()) {
            element.setAttribute("class", "nav-link disabled");
            element2.setAttribute("class", "tab-pane container");
            element4.setAttribute("class", "nav-link active");
            element5.setAttribute("class", "tab-pane active container");
        } else {
            element4.setAttribute("class", "nav-link");
            element5.setAttribute("class", "tab-pane container");
            element.setAttribute("class", "nav-link active");
            element2.setAttribute("class", "tab-pane active container");
        }
    }

    private void openConnection(Event event) {
        event.preventDefault();
        String string = null;
        try {
            Element element = (Element)((Object)event.getTarget());
            string = element.getAttribute("connectionName");
            URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string);
            DatabaseConnection databaseConnection = DatabaseConnection.findOrCreateConnectionNode((URL)uRL);
            SwingUtilities.invokeLater(() -> {
                try {
                    this.dbnavSelect(null, databaseConnection.getShortLabel());
                }
                catch (Exception exception) {
                    Logger.severe(this.getClass(), (Throwable)exception);
                }
            });
        }
        catch (Throwable throwable) {
            Logger.severe(this.getClass(), string, (Throwable)throwable);
        }
    }
}

