/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.startpage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Collections;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Region;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.javafx.scene.SceneFactory;
import oracle.dbtools.raptor.RaptorExtrasResources;
import oracle.dbtools.raptor.editors.IStatusMessageProvider;
import oracle.dbtools.raptor.javafx.ui.JFXPanelFactory;
import oracle.dbtools.raptor.startpage.IStartPageProvider;
import oracle.dbtools.raptor.startpage.Options;
import oracle.dbtools.raptor.startpage.StartPageAddin;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.AsynchronousEditor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public class StartPageViewer
extends AsynchronousEditor
implements IStatusMessageProvider {
    private JComponent guiComponent;
    private JFXPanel fxPanel;
    private Browser webView;
    private boolean contentModelLoaded;
    private boolean initFxComplete;
    private String url;
    private SqldevCallback sqldevCallback = new SqldevCallback();
    private XLIFFHelper xliffHelper = new XLIFFHelper(((Object)((Object)this)).getClass().getClassLoader(), "/oracle/dbtools/raptor/startpage/StartPage.html");
    Pattern nonWhitespace = Pattern.compile(".*\\S.*");
    private static final String SPACE = " ";
    private static String INDENT = "  ";

    public StartPageViewer() {
        this.setEditorAttribute("horizontal_scrollbar_policy", 31);
        this.setEditorAttribute("vertical_scrollbar_policy", 21);
        this.setEditorAttribute("scrollable", Boolean.FALSE);
    }

    public String getStatusMessage() {
        return StartPageAddin.getStartPageProvider().getStatusMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isContentModelLoaded() {
        StartPageViewer startPageViewer = this;
        synchronized (startPageViewer) {
            return this.contentModelLoaded;
        }
    }

    protected Component getGUIComponent() {
        return this.guiComponent;
    }

    protected void getEditorContent(Context context) {
        try {
            if (null == this.getGUIComponent()) {
                this.createGUIComponent();
            }
        }
        catch (Exception exception) {
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
        }
    }

    protected void doSetContext(Context context) {
        this.loadContentModel(context);
    }

    protected void openImpl(boolean bl) {
    }

    protected void switchEditorGUI(Component component) {
        super.switchEditorGUI(component);
        EditorManager.getEditorManager().refreshEditorUI((Editor)this);
    }

    private void createGUIComponent() {
        if (null == this.guiComponent) {
            try {
                this.guiComponent = new JPanel(new BorderLayout());
                this.fxPanel = JFXPanelFactory.createJFXPanel();
                if (this.fxPanel != null) {
                    this.guiComponent.add((Component)this.fxPanel, "Center");
                    Platform.runLater(() -> {
                        try {
                            this.initFX(this.fxPanel);
                        }
                        finally {
                            this.initFxComplete = true;
                        }
                    });
                    while (!this.initFxComplete) {
                        Thread.sleep(200L);
                    }
                } else {
                    SwingUtilities.invokeLater(() -> EditorManager.getEditorManager().closeEditors(Collections.singletonList(this)));
                }
            }
            catch (Exception exception) {
                Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
            }
        }
    }

    private void initFX(JFXPanel jFXPanel) {
        try {
            Logger.fine(((Object)((Object)this)).getClass(), (String)"initFX START");
            this.webView = new Browser();
            this.showVersionInfo(this.webView.getEngine());
            Scene scene = SceneFactory.createScene((Parent)this.webView);
            jFXPanel.setScene(scene);
            Logger.fine(((Object)((Object)this)).getClass(), (String)"initFX END");
        }
        catch (Exception exception) {
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
        }
    }

    private void showVersionInfo(WebEngine webEngine) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append("Java:   ").append(System.getProperty("java.runtime.version")).append('\n').append("JavaFX: ").append(System.getProperty("javafx.runtime.version")).append('\n').append("OS:     ").append(System.getProperty("os.name")).append(',').append(System.getProperty("os.arch")).append('\n').append("WebKit: ").append(webEngine.getUserAgent()).append('\n').append(" JS ON: ").append(webEngine.isJavaScriptEnabled()).append('\n');
        Logger.info(((Object)((Object)this)).getClass(), (String)stringBuilder.toString());
    }

    private void loadContentModel(Context context) {
        if (this.webView != null) {
            try {
                this.url = context.getNode().getURL().toExternalForm();
                Platform.runLater(() -> {
                    try {
                        Logger.fine(((Object)((Object)this)).getClass(), (String)("loadContent START " + this.url));
                        WebEngine webEngine = this.webView.getEngine();
                        Worker worker = webEngine.getLoadWorker();
                        worker.stateProperty().addListener((observableValue, state, state2) -> {
                            this.logWorkerStatus((Worker<Void>)worker);
                            if (Worker.State.SUCCEEDED == state2) {
                                this.updateDocument(webEngine.getDocument());
                            }
                        });
                        worker.messageProperty().addListener((observableValue, string, string2) -> this.logWorkerStatus((Worker<Void>)worker, (String)string2));
                        webEngine.load(this.url);
                        Logger.fine(((Object)((Object)this)).getClass(), (String)("loadContent END " + this.url));
                    }
                    catch (Exception exception) {
                        Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
                    }
                });
            }
            catch (Exception exception) {
                Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
            }
        }
    }

    private void updateDocument(Document document) {
        Logger.fine(((Object)((Object)this)).getClass(), (String)"updateDocument");
        document.getElementById("versionString").setTextContent(RaptorExtrasResources.format("BANNER_VERSION_STRING", Ide.getProductVersion()));
        this.addShowOnStartupCheckbox(document);
        this.checkNewVersion(document);
        this.xliffNLS();
        StartPageAddin.getStartPageProvider().postProcess(document);
        NodeList nodeList = document.getElementsByTagName("a");
        int n = nodeList.getLength();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                EventTarget eventTarget = (EventTarget)((Object)nodeList.item(i));
                String string = ((Element)((Object)eventTarget)).getAttribute("href");
                if (string == null || !string.startsWith("http")) continue;
                eventTarget.addEventListener("click", event -> this.sqldevCallback.openHref(event), false);
            }
        }
        SwingUtilities.invokeLater(() -> {
            StartPageViewer startPageViewer = this;
            synchronized (startPageViewer) {
                this.contentModelLoaded = true;
            }
        });
    }

    private void addShowOnStartupCheckbox(Document document) {
        Element element = document.getElementById("showOnStartup");
        Element element2 = document.createElement("label");
        Element element3 = document.createElement("input");
        element3.setAttribute("type", "checkbox");
        element3.setAttribute("id", "showOnStartupCheckbox");
        if (Options.isShowOnStartup()) {
            element3.setAttribute("checked", "checked");
        }
        ((EventTarget)((Object)element3)).addEventListener("change", event -> this.sqldevCallback.setShowOnStartup(event), false);
        Text text = document.createTextNode(RaptorExtrasResources.getString("SHOW_ON_STARTUP"));
        element.appendChild(element2);
        element2.appendChild(element3);
        element2.appendChild(text);
    }

    private void xliffNLS() {
        Document document = this.webView.getEngine().getDocument();
        document.normalize();
        this.xliffNLS(document.getElementsByTagName("body"));
    }

    private void xliffNLS(NodeList nodeList) {
        int n = nodeList.getLength();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                String string;
                org.w3c.dom.Node node = nodeList.item(i);
                if (1 == node.getNodeType()) {
                    if ("img".equalsIgnoreCase(node.getNodeName()) && (string = ((Element)node).getAttribute("alt")) != null && !string.isEmpty()) {
                        ((Element)node).setAttribute("alt", this.xliffHelper.getTranslation(string));
                    }
                } else if (3 == node.getNodeType()) {
                    string = node.getNodeValue();
                    String string2 = "";
                    if (string.startsWith(SPACE)) {
                        string = string.substring(1);
                        string2 = SPACE;
                    }
                    if (string != null && this.nonWhitespace.matcher(string).matches()) {
                        String string3 = this.xliffHelper.getTranslation(string);
                        node.setNodeValue(string2 + string3);
                        this.injectAltText(node, string3);
                    }
                }
                this.xliffNLS(node.getChildNodes());
            }
        }
    }

    private void injectAltText(org.w3c.dom.Node node, String string) {
        org.w3c.dom.Node node2 = node.getParentNode();
        if (null == node2) {
            return;
        }
        if ("p".equalsIgnoreCase(node2.getNodeName()) && null == (node2 = node2.getParentNode())) {
            return;
        }
        NamedNodeMap namedNodeMap = node2.getAttributes();
        if (null == namedNodeMap) {
            return;
        }
        org.w3c.dom.Node node3 = namedNodeMap.getNamedItem("class");
        if (null == node3) {
            return;
        }
        if (node3.getNodeValue().indexOf("carousel-caption") > -1) {
            org.w3c.dom.Node node4 = node2.getPreviousSibling();
            if (3 == node4.getNodeType()) {
                node4 = node4.getPreviousSibling();
            }
            if (!"img".equalsIgnoreCase(node4.getNodeName())) {
                return;
            }
            ((Element)node4).setAttribute("alt", string);
        }
    }

    private void checkNewVersion(Document document) {
        try {
            IStartPageProvider iStartPageProvider = StartPageAddin.getStartPageProvider();
            Browser browser = new Browser();
            WebEngine webEngine = browser.getEngine();
            Worker worker = webEngine.getLoadWorker();
            worker.stateProperty().addListener((observableValue, state, state2) -> {
                this.logWorkerStatus((Worker<Void>)worker);
                if (Worker.State.SUCCEEDED == state2) {
                    Document document2 = webEngine.getDocument();
                    String string = iStartPageProvider.getVersionId();
                    Element element = null == document2 ? null : document2.getElementById(string);
                    this.updateVersionAlert(document, element);
                }
            });
            worker.messageProperty().addListener((observableValue, string, string2) -> this.logWorkerStatus((Worker<Void>)worker, (String)string2));
            webEngine.load(iStartPageProvider.getCurrentVersionUrl());
        }
        catch (Throwable throwable) {
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)throwable);
        }
    }

    private void updateVersionAlert(Document document, Element element) {
        String string;
        String string2 = null == element ? "0" : element.getTextContent();
        Version version = new Version(string2);
        Version version2 = new Version(Ide.getProductVersion());
        String string3 = string = version.compareTo(version2) > 0 ? string2 : null;
        if (string != null) {
            document.getElementById("newVersionAlert").setAttribute("class", "collapse show");
            Element element2 = document.getElementById("newVersion");
            element2.setTextContent(string);
            Element element3 = document.getElementById("newVersionAlertLabel");
            element3.setTextContent(RaptorExtrasResources.get("NEW_VERSION_ALERT_LABEL"));
            element3.appendChild(element2);
        } else {
            document.getElementById("newVersionAlert").setAttribute("class", "collapse");
        }
    }

    public static void printDocument(Document document, OutputStream outputStream) throws IOException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(new DOMSource(document), new StreamResult(new OutputStreamWriter(outputStream, "UTF-8")));
    }

    public static String describe(org.w3c.dom.Node node) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        StartPageViewer.describe(stringBuilder, "", node);
        return stringBuilder.toString();
    }

    private static void describe(StringBuilder stringBuilder, String string, org.w3c.dom.Node node) {
        NodeList nodeList;
        int n;
        int n2;
        stringBuilder.append(string).append('[').append('\n');
        stringBuilder.append(string).append("Name: ").append(node.getNodeName()).append('\n');
        stringBuilder.append(string).append("Value: ").append(node.getNodeValue()).append('\n');
        stringBuilder.append(string).append("Text: ").append(node.getTextContent()).append('\n');
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n3 = n2 = null == namedNodeMap ? 0 : namedNodeMap.getLength();
        if (n2 > 0) {
            stringBuilder.append(string).append("Attributes: ").append('\n');
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append(string + INDENT).append(namedNodeMap.item(i).getNodeName()).append(": ").append(namedNodeMap.item(i).getNodeValue()).append('\n');
            }
        }
        int n4 = n = null == (nodeList = node.getChildNodes()) ? 0 : nodeList.getLength();
        if (n > 0) {
            stringBuilder.append(string).append("Children: ").append('\n');
            for (int i = 0; i < n; ++i) {
                StartPageViewer.describe(stringBuilder, string + INDENT, nodeList.item(i));
            }
        }
        stringBuilder.append(string).append(']').append('\n');
    }

    private void logWorkerStatus(Worker<Void> worker) {
        this.logWorkerStatus(worker, null);
    }

    private void logWorkerStatus(Worker<Void> worker, String string) {
        String string2 = worker.getTitle() + ' ' + worker.getState() + (null == string ? "" : ' ' + string);
        Throwable throwable = worker.getException();
        if (Worker.State.FAILED == worker.getState()) {
            if (null == throwable) {
                Logger.severe(((Object)((Object)this)).getClass(), (String)string2);
            } else {
                Logger.severe(((Object)((Object)this)).getClass(), (String)string2, (Throwable)throwable);
            }
        } else if (null == throwable) {
            Logger.info(((Object)((Object)this)).getClass(), (String)string2);
        } else {
            Logger.info(((Object)((Object)this)).getClass(), (String)string2, (Throwable)throwable);
        }
    }

    public class SqldevCallback {
        public void setShowOnStartup(Event event) {
            try {
                Element element = (Element)((Object)event.getTarget());
                boolean bl = !Options.getShowOnStartup();
                Options.setShowOnStartup(bl);
                if (bl) {
                    element.setAttribute("checked", "checked");
                } else {
                    element.removeAttribute("checked");
                }
            }
            catch (Throwable throwable) {
                Logger.severe(this.getClass(), (Throwable)throwable);
            }
        }

        public void openHref(Event event) {
            String string = null;
            try {
                Element element = (Element)((Object)event.getTarget());
                string = element.getAttribute("href");
                while (!"a".equalsIgnoreCase(element.getTagName())) {
                    element = (Element)element.getParentNode();
                    string = element.getAttribute("href");
                }
                if (this.openHref(string)) {
                    event.preventDefault();
                }
            }
            catch (Throwable throwable) {
                Logger.severe(this.getClass(), string, (Throwable)throwable);
            }
        }

        public boolean openHref(String string) {
            try {
                URL uRL = new URL(string);
                if (null == uRL.getProtocol() || !uRL.getProtocol().startsWith("http")) {
                    return false;
                }
            }
            catch (Throwable throwable) {
                Logger.severe(this.getClass(), (String)string, (Throwable)throwable);
                return false;
            }
            SwingUtilities.invokeLater(() -> {
                try {
                    Desktop desktop;
                    Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                    if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                        desktop.browse(new URL(string).toURI());
                    } else {
                        Logger.severe(this.getClass(), (String)RaptorExtrasResources.getString("BROWSE_UNSUPPORTED"));
                    }
                }
                catch (Throwable throwable) {
                    Logger.severe(this.getClass(), (Throwable)throwable);
                }
            });
            return true;
        }
    }

    class Browser
    extends Region {
        final WebView browser = new WebView();
        final WebEngine webEngine = this.browser.getEngine();

        public Browser() {
            this.getStyleClass().add((Object)"browser");
            this.getChildren().add((Object)this.browser);
            this.browser.setContextMenuEnabled(false);
            this.webEngine.setJavaScriptEnabled(true);
            this.webEngine.setOnError(webErrorEvent -> Logger.severe(((Object)((Object)this)).getClass(), (String)webErrorEvent.getMessage(), (Throwable)webErrorEvent.getException()));
            this.webEngine.setOnAlert(webEvent -> Logger.warn(((Object)((Object)this)).getClass(), (String)((String)webEvent.getData())));
            this.webEngine.setOnStatusChanged(webEvent -> SwingUtilities.invokeLater(() -> {
                String string = (String)webEvent.getData();
                if (string != null && (string.startsWith("file:") || string.startsWith("bundleresource:"))) {
                    return;
                }
                Ide.getStatusBar().setText(string);
            }));
        }

        public WebEngine getEngine() {
            return this.webEngine;
        }

        protected void layoutChildren() {
            double d = this.getWidth();
            double d2 = this.getHeight();
            this.layoutInArea((Node)this.browser, 0.0, 0.0, d, d2, 0.0, HPos.CENTER, VPos.CENTER);
        }

        protected double computePrefWidth(double d) {
            return 750.0;
        }

        protected double computePrefHeight(double d) {
            return 500.0;
        }
    }
}

