/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.history;

import java.awt.Component;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.feedback.FeedbackApi;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.history.HistorianRegistration;
import oracle.ideimpl.history.HistorianRegistrations;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.history.DefaultHistoryEntry;
import oracle.jdeveloper.history.RestoreFromRevisionHelper;
import oracle.jdevimpl.history.RestoreFromRevisionTextNodeHelper;
import oracle.jdevimpl.resource.HistoryArb;

@FeedbackApi(value="BaseHistoryEntry")
public abstract class BaseHistoryEntry
extends DefaultHistoryEntry {
    public boolean canRestore(Context context) {
        try {
            return this.getHelper(context).canRestore(context.getNode());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void restore(Context context) throws Exception {
        if (this.canRestore(context)) {
            if (context.getNode().isReadOnly() && !URLFileSystem.setReadOnly((URL)context.getNode().getURL(), (boolean)false)) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)HistoryArb.format("RESTORE_READ_ONLY", URLFileSystem.getPlatformPathName((URL)context.getNode().getURL())), (String)HistoryArb.get("RESTORE_READ_ONLY_TITLE"), null);
                return;
            }
            Node node = context.getNode();
            CompareContributor contributor = this.getCompareContributor();
            this.getHelper(context).restore(node, contributor);
            node.save();
        }
    }

    private RestoreFromRevisionHelper getHelper(Context context) throws Exception {
        if (context.getNode() != null) {
            Class<?> nodeClass = context.getNode().getClass();
            String className = nodeClass.getCanonicalName();
            for (HistorianRegistration registration : HistorianRegistrations.getInstance().getRegistrations()) {
                Object helper;
                if (!className.equals(registration.getNodeClass().getClassName())) continue;
                if (registration.getRestoreHelperClass() == null || !((helper = registration.getRestoreHelperClass().newInstance()) instanceof RestoreFromRevisionHelper)) break;
                return (RestoreFromRevisionHelper)helper;
            }
        }
        return new RestoreFromRevisionTextNodeHelper();
    }
}

