/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DrawerConfig;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.CompareDrawer;
import oracle.javatools.compare.view.ComparePopupManager;
import oracle.javatools.compare.view.CompareViewDecoration;
import oracle.javatools.compare.view.IdeCompareView;
import oracle.javatools.compare.view.IdeCompareViewDecoration;
import oracle.javatools.compare.view.SplitPanel;
import oracle.javatools.compare.view.SplitPanelLayout;
import oracle.javatools.controls.ThrobberLabel;
import oracle.jdevimpl.compare.CompareViewOwner;
import oracle.jdevimpl.compare.DrawerEditor;
import oracle.jdevimpl.resource.CompareApiArb;
import oracle.jdevimpl.resource.CompareArb;

public abstract class BaseCompareEditor
extends DrawerEditor
implements CompareViewOwner,
ComparePopupManager {
    private Map<CompareDrawer, DrawerView> _drawerMap = new LinkedHashMap<CompareDrawer, DrawerView>();
    private CompareState _state = CompareState.DONE;
    private FocusableLabel _messageLabel;
    private String _errorMessage;
    private boolean _error;
    private CompareType _currentCompareType = null;
    private Collection<IdeCompareViewDecoration> _currentDecorations = Collections.emptySet();
    private SplitListener _splitListener;
    private final Map<IdeAction, IdeAction> _localActions = new HashMap<IdeAction, IdeAction>();

    @Override
    public final Component getGUI() {
        return super.getGUI();
    }

    private final FocusableLabel getMessageLabel() {
        if (this._messageLabel == null) {
            this._messageLabel = new FocusableLabel(" ");
            this._messageLabel.setOpaque(true);
        }
        return this._messageLabel;
    }

    protected final void updateFixedDrawerToolbars() {
        for (View view : this.getDrawerViews()) {
            if (!(view instanceof DrawerView) || this._drawerMap.containsValue(view)) continue;
            this.updateToolbarForDrawerView((DrawerView)view);
        }
    }

    protected final void augmentToolbarComponents() {
        for (Map.Entry<CompareDrawer, DrawerView> entry : this._drawerMap.entrySet()) {
            this.updateToolbarForDrawerView(entry.getValue());
        }
    }

    private final void updateToolbarForDrawerView(DrawerView view) {
        view.updateToolbar();
        view.getToolbar().repaint();
    }

    private final void setErrorMessage(String errorMessage) {
        this._errorMessage = errorMessage;
    }

    private final void setState(CompareState state) {
        if (this._state == state) {
            return;
        }
        this._state = state;
        if (this._state == CompareState.IN_PROGRESS) {
            this.setProgressVisible(true);
            this.showAncillaryProgress();
            return;
        }
        if (this._state == CompareState.DONE) {
            this.setProgressVisible(false);
            this.hideAncillaryProgress();
            this._error = false;
            return;
        }
        if (this._state == CompareState.ERROR) {
            this.setProgressVisible(false);
            this.hideAncillaryProgress();
            this.getMessageLabel().setText(this._errorMessage != null ? this._errorMessage : CompareArb.get("COMPARE_NOT_AVAILABLE"));
            this._error = true;
            return;
        }
    }

    private final void setProgressVisible(boolean visible) {
        for (DrawerView view : this._drawerMap.values()) {
            view.setInProgress(visible);
        }
    }

    protected final void addFixedCompareDrawer(CompareDrawer drawer) {
        this.addDrawerView(drawer);
    }

    protected final void stateInProgress() {
        this.setState(CompareState.IN_PROGRESS);
    }

    protected final void stateDone() {
        this.setSuppressPersistence(true);
        boolean wasError = this._error;
        this.setState(CompareState.DONE);
        if (wasError) {
            this.rebuildCompareDrawers();
        } else {
            this.maybeRebuildCompareDrawers();
        }
        this.setSuppressPersistence(false);
    }

    protected final void stateError(String message) {
        this.setSuppressPersistence(true);
        boolean wasError = this._error;
        if (!wasError) {
            this.removeCompareDrawers();
        }
        this.setErrorMessage(message);
        this.setState(CompareState.ERROR);
        if (!wasError) {
            this.addErrorDrawer();
        }
        this.setSuppressPersistence(false);
    }

    protected void showAncillaryProgress() {
    }

    protected void hideAncillaryProgress() {
    }

    protected final boolean hasCompareDrawers() {
        return !this._drawerMap.isEmpty();
    }

    private final void addErrorDrawer() {
        CompareDrawer errorDrawer = new CompareDrawer(CompareArb.get("COMPARE_TITLE"), (Component)this.getMessageLabel(), null);
        this._drawerMap.put(errorDrawer, this.addDrawerView(errorDrawer));
    }

    private final void maybeRebuildCompareDrawers() {
        if (this.mustRebuildCompareDrawers()) {
            this.rebuildCompareDrawers();
        }
    }

    private final boolean mustRebuildCompareDrawers() {
        if (this._drawerMap.isEmpty()) {
            return true;
        }
        if (this._currentCompareType == null) {
            return true;
        }
        CompareView compareView = this.getCompareView();
        if (compareView == null) {
            return true;
        }
        if (!compareView.getModel().getType().equals((Object)this._currentCompareType)) {
            return true;
        }
        Collection<IdeCompareViewDecoration> decorations = this.getCurrentDecorations();
        return !decorations.equals(this._currentDecorations);
    }

    private final void rebuildCompareDrawers() {
        this.removeCompareDrawers();
        this.setErrorMessage(null);
        this.createCompareDrawers();
    }

    private final void createCompareDrawers() {
        CompareView compareView = this.getCompareView();
        this._currentCompareType = compareView != null ? compareView.getModel().getType() : null;
        this._currentDecorations = this.getCurrentDecorations();
        if (compareView == null) {
            return;
        }
        ArrayList<Object> drawers = new ArrayList<Object>();
        if (compareView instanceof IdeCompareView) {
            IdeCompareView ideCompareView = (IdeCompareView)compareView;
            try {
                CompareViewDecoration[] secondaryDrawer = ideCompareView.getSecondaryDrawer();
                if (secondaryDrawer != null) {
                    drawers.add(secondaryDrawer);
                }
            }
            catch (UnsupportedOperationException secondaryDrawer) {
                // empty catch block
            }
            drawers.add(new CompareDrawer(ideCompareView));
            for (CompareViewDecoration decoration : ideCompareView.getDecorations()) {
                if (!decoration.canDecorate() || !(decoration instanceof IdeCompareViewDecoration)) continue;
                try {
                    IdeCompareViewDecoration ideDecoration = (IdeCompareViewDecoration)decoration;
                    CompareDrawer decorationDrawer = ideDecoration.getDrawer();
                    if (decorationDrawer == null) continue;
                    drawers.add(decorationDrawer);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        } else {
            drawers.add(new CompareDrawer(CompareApiArb.get((String)"SOURCE_COMPARE_TITLE"), compareView.getGUI(), null));
        }
        for (Object drawer : drawers) {
            this._drawerMap.put((CompareDrawer)drawer, this.addDrawerView((CompareDrawer)drawer));
        }
        ArrayList<SplitPanel> splitPanels = new ArrayList<SplitPanel>();
        for (CompareDrawer compareDrawer : drawers) {
            if (!(compareDrawer.getCompareView() instanceof BaseCompareView)) continue;
            splitPanels.add(((BaseCompareView)compareDrawer.getCompareView()).getSplitPanel());
        }
        for (SplitPanel splitPanel : splitPanels) {
            ArrayList slavePanels = new ArrayList(splitPanels);
            slavePanels.remove(splitPanel);
            splitPanel.setSlavePanels(slavePanels);
        }
        Iterator itr = splitPanels.iterator();
        if (itr.hasNext()) {
            this._splitListener = new SplitListener((SplitPanel)itr.next(), splitPanels);
            this._splitListener.attach();
        }
    }

    private final Collection<IdeCompareViewDecoration> getCurrentDecorations() {
        ArrayList<IdeCompareViewDecoration> currentDecorations = new ArrayList<IdeCompareViewDecoration>();
        CompareView compareView = this.getCompareView();
        if (compareView == null) {
            return currentDecorations;
        }
        if (compareView instanceof IdeCompareView) {
            IdeCompareView ideCompareView = (IdeCompareView)compareView;
            for (CompareViewDecoration decoration : ideCompareView.getDecorations()) {
                if (!decoration.canDecorate() || !(decoration instanceof IdeCompareViewDecoration)) continue;
                currentDecorations.add((IdeCompareViewDecoration)decoration);
            }
        }
        return currentDecorations;
    }

    private final DrawerView addDrawerView(CompareDrawer drawer) {
        DrawerView view = new DrawerView(drawer);
        DrawerConfig config = new DrawerConfig(view.getTabName(), DrawerConfig.State.VISIBLE);
        super.addDrawer(view, config, drawer.getRatio());
        return view;
    }

    private final void removeCompareDrawers() {
        for (Map.Entry<CompareDrawer, DrawerView> entry : this._drawerMap.entrySet()) {
            super.removeIfPresent(entry.getValue());
        }
        this._drawerMap.clear();
        if (this._splitListener != null) {
            this._splitListener.detach();
            this._splitListener = null;
        }
    }

    protected final IdeAction createLocalAction(int cmdId) {
        return this.createLocalAction(IdeAction.find((int)cmdId));
    }

    protected final IdeAction createLocalAction(IdeAction globalAction) {
        IdeAction localAction = globalAction.newLocalAction((View)this);
        this._localActions.put(globalAction, localAction);
        return localAction;
    }

    protected final IdeAction getLocalAction(int cmdId) {
        return this.getLocalAction(IdeAction.find((int)cmdId));
    }

    protected final IdeAction getLocalAction(IdeAction globalAction) {
        if (this._localActions.containsKey(globalAction)) {
            return this._localActions.get(globalAction);
        }
        return this.createLocalAction(globalAction);
    }

    public final IdeAction resolveGlobalAction(IdeAction action) {
        return action.isLocalAction() ? action : this.getLocalAction(action);
    }

    public final void showPopup(MouseEvent mouseEvent) {
        ContextMenu contextMenu = this.getContextMenu();
        if (contextMenu == null) {
            return;
        }
        Context context = new Context(this.getContext());
        Node element = context.getNode();
        context.setSelection(new Element[]{element});
        context.setElement((Element)element);
        context.setEvent((EventObject)mouseEvent);
        this.showPopupImpl(contextMenu, context);
    }

    protected void showPopupImpl(ContextMenu contextMenu, Context context) {
        contextMenu.show(context);
    }

    public final void hidePopup() {
    }

    private final class DrawerView
    extends View {
        private final String GUI_PROGRESS = "progress";
        private final String GUI_VIEW = "view";
        private final CompareDrawer _drawer;
        private final Toolbar _toolbar;
        private CardLayout _cardLayout;
        private JPanel _gui;

        DrawerView(CompareDrawer drawer) {
            super(ViewId.validate((String)drawer.getTitle()));
            this.GUI_PROGRESS = "progress";
            this.GUI_VIEW = "view";
            this.setOwner((View)BaseCompareEditor.this);
            this._drawer = drawer;
            this._toolbar = new Toolbar();
            this.updateToolbar();
        }

        public Toolbar getToolbar() {
            return this._toolbar;
        }

        final void updateToolbar() {
            IdeAction[] toolbarActions;
            this._toolbar.removeAll();
            Component[] toolbarComponents = this._drawer.getToolbarComponents();
            if (toolbarComponents != null) {
                for (Component component : toolbarComponents) {
                    if (component == null) {
                        this._toolbar.addSeparator();
                        continue;
                    }
                    this._toolbar.add(component);
                }
            }
            if ((toolbarActions = this._drawer.getToolbarActions()) != null && toolbarActions.length > 0) {
                for (IdeAction action : toolbarActions) {
                    if (action == null) {
                        this._toolbar.addSeparator();
                        continue;
                    }
                    this._toolbar.add((Component)new ToolButton((Action)BaseCompareEditor.this.resolveGlobalAction(action)));
                }
            } else {
                ToolButton prototype = new ToolButton((Action)IdeActions.getViewRefreshAction());
                this._toolbar.add(Box.createVerticalStrut(prototype.getPreferredSize().height));
            }
        }

        public String getTabName() {
            return this._drawer.getTitle();
        }

        public final Component getGUI() {
            if (this._gui == null) {
                this._cardLayout = new CardLayout();
                this._gui = new JPanel(this._cardLayout);
                this._gui.add(this._drawer.getGUI(), "view");
                this._gui.add((Component)new ThrobberLabel(), "progress");
            }
            return this._gui;
        }

        public Context getContext(EventObject event) {
            Context context = BaseCompareEditor.this.getContext(event);
            context.setProperty("DrawerWindow.DRAWER_VIEW", (Object)this);
            return context;
        }

        final void setInProgress(boolean inProgress) {
            if (inProgress == this._drawer.getGUI().isVisible()) {
                this._cardLayout.show(this._gui, inProgress ? this.GUI_PROGRESS : this.GUI_VIEW);
            }
        }

        public ContextMenu getContextMenu() {
            return BaseCompareEditor.this.getContextMenu();
        }
    }

    private final class SplitListener
    extends ComponentAdapter
    implements PropertyChangeListener {
        private final SplitPanel _masterPanel;
        private final Collection<SplitPanel> _splitPanels;
        private final Component _splitter;

        SplitListener(SplitPanel masterPanel, Collection<SplitPanel> splitPanels) {
            this._masterPanel = masterPanel;
            this._splitPanels = new ArrayList<SplitPanel>(splitPanels);
            this._splitter = ((SplitPanelLayout)masterPanel.getLayout()).getComponent("leftSplitTop");
        }

        final void attach() {
            this._splitter.addPropertyChangeListener(this);
            for (SplitPanel splitPanel : this._splitPanels) {
                splitPanel.addComponentListener((ComponentListener)this);
            }
        }

        final void detach() {
            this._splitter.removePropertyChangeListener(this);
            for (SplitPanel splitPanel : this._splitPanels) {
                splitPanel.removeComponentListener((ComponentListener)this);
            }
        }

        @Override
        public final void propertyChange(PropertyChangeEvent pce) {
            if (pce.getPropertyName().equals("lastSplitterLocation")) {
                this._masterPanel.correctSlaveSplitters();
                this._splitter.removePropertyChangeListener(this);
            }
        }

        @Override
        public final void componentResized(ComponentEvent e) {
            this._masterPanel.correctSlaveSplitters();
        }

        @Override
        public final void componentMoved(ComponentEvent e) {
            this._masterPanel.correctSlaveSplitters();
        }

        @Override
        public final void componentShown(ComponentEvent ce) {
            this._masterPanel.correctSlaveSplitters();
        }
    }

    private static enum CompareState {
        IN_PROGRESS,
        DONE,
        ERROR;

    }
}

