/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.net.URL;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.jdeveloper.history.RestoreFromRevisionHelper;

public class RestoreFromRevisionTextNodeHelper
extends RestoreFromRevisionHelper {
    private static final String FORM = ".form";

    @Override
    public boolean canRestore(Node node) {
        if (node instanceof TextNode) {
            URL[] urls;
            if (CompositeFileElementRegistry.isCompositeElement((Element)node) && (urls = CompositeFileElementRegistry.getCompositeFileURLs((Element)node)).length == 2 && URLFileSystem.getSuffix((URL)node.getURL()).equals(".java")) {
                for (URL url : urls) {
                    if (!URLFileSystem.getSuffix((URL)url).equals(FORM)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(Node node, CompareContributor contributor) {
        if (!(contributor instanceof TextCompareContributor)) {
            if (FeedbackManager.isOn()) {
                FeedbackManager.reportException((Throwable)new IllegalStateException());
            }
            return;
        }
        if (!(node instanceof TextNode)) {
            return;
        }
        TextBuffer inBuffer = ((TextCompareContributor)contributor).getTextBuffer();
        TextBuffer outBuffer = ((TextNode)node).acquireTextBuffer();
        inBuffer.readLock();
        outBuffer.beginEdit();
        try {
            outBuffer.removeToEnd(0);
            outBuffer.append(inBuffer.getChars(0, inBuffer.getLength()));
        }
        finally {
            inBuffer.readUnlock();
            outBuffer.endEdit();
        }
    }
}

