/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.Connection;
import java.sql.Date;
import java.sql.Timestamp;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.timesten.format.GenericResultsFormatter;

public class TimesTenNLSProvider
extends DefaultNLSProvider {
    private static final String TIMESTAMP_FORMAT = "yyyy-mm-dd hh:mi:ss.ff6";
    private static final String TIMESTEN_DATE_FORMAT = "yyyy-mm-dd";

    public TimesTenNLSProvider(Connection connection) {
        super(connection);
    }

    public Object getValue(Object object) {
        if (object instanceof Date) {
            GenericResultsFormatter.convertToOracleDate((Date)object);
        } else if (object instanceof Timestamp) {
            GenericResultsFormatter.convertToOracleTimestamp((Timestamp)object, true);
        }
        return super.getValue(object);
    }

    public String getDateFormat(FormatType formatType) {
        return this.getDateFormatHelper("NLS_DATE_FORM");
    }

    public String getTimeStampFormat(FormatType formatType) {
        return this.getDateFormatHelper("NLS_TS_FORM");
    }

    public String getTimeStampWithTimeZoneFormat() {
        return this.getDateFormatHelper("NLS_TS_TZ_FORM");
    }

    private String getDateFormatHelper(String string) {
        DBConfig dBConfig = DBConfig.getInstance();
        if (dBConfig != null) {
            return dBConfig.getString(string);
        }
        return null;
    }
}

