/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.commands;

import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.commands.TTExplainPlanNode;
import oracle.dbtools.raptor.timesten.connection.X10ConnectionProperties;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceTreeModel;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class TTAutotraceTreeModel
extends AutotraceTreeModel {
    private Connection theConnection;
    private String theCurrentSql;
    private boolean isAcadia;
    private static Logger _logger = Logger.getLogger(TTAutotraceTreeModel.class.getPackage().getName());

    public TTAutotraceTreeModel(AutotracePanel autotracePanel) {
        super(autotracePanel);
        this.isAcadia = Boolean.parseBoolean(X10ConnectionProperties.getTheInstance().getProperty(Connections.getDisplayName((String)autotracePanel.getContext().getConnectionName()), "isAcadia"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void explainPlan(String string, String string2, Connection connection) {
        boolean bl = false;
        boolean bl2 = false;
        Statement statement = null;
        Statement statement2 = null;
        this.theCurrentSql = string;
        this.originalSQL = string;
        try {
            Object object;
            bl = connection.getAutoCommit();
            if (bl) {
                connection.setAutoCommit(false);
                bl2 = true;
            }
            statement = connection.createStatement();
            statement.execute("call ttOptSetflag('GenPlan', 1)");
            statement2 = connection.prepareStatement(string);
            ResultSet resultSet = statement.executeQuery("select * from sys.plan order by step");
            TTExplainPlanNode tTExplainPlanNode = null;
            TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
            int n = Integer.MAX_VALUE;
            while (resultSet.next()) {
                tTExplainPlanNode = new TTExplainPlanNode(resultSet.getInt(1), resultSet.getInt(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7), this.isAcadia ? resultSet.getString(8) : "");
                int n2 = n = tTExplainPlanNode.depth() < n ? tTExplainPlanNode.depth() : n;
                if (treeMap.containsKey(tTExplainPlanNode.depth())) {
                    ((List)treeMap.get(tTExplainPlanNode.depth())).add(tTExplainPlanNode);
                    continue;
                }
                object = new ArrayList();
                object.add(tTExplainPlanNode);
                treeMap.put(tTExplainPlanNode.depth(), object);
            }
            object = null;
            List list = null;
            boolean bl3 = false;
            list = (List)treeMap.get(n);
            if (list != null) {
                if (list.size() > 1) {
                    object = new TTExplainPlanNode(n--, n, "SQL Developer Plan's root", "", "", "", "", "");
                    bl3 = true;
                    _logger.warning("Explain Plan: Plan is a forest, not a tree.");
                } else {
                    object = (TTExplainPlanNode)((Object)list.get(0));
                }
            }
            Iterator iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                for (TTExplainPlanNode tTExplainPlanNode2 : (List)treeMap.get(n3)) {
                    Object object2 = bl3 && n3 - 1 <= 0 ? object : this.getParentNode((List)treeMap.get(n3 - 1), tTExplainPlanNode2);
                    tTExplainPlanNode2.setTheParent((TTExplainPlanNode)((Object)object2));
                    if (object2 == null) continue;
                    object2.add((MutableTreeNode)((Object)tTExplainPlanNode2));
                }
            }
            this.root = object;
            resultSet.close();
        }
        catch (SQLException sQLException) {
            String string3 = TTSQLExceptionScrubber.getMessage(sQLException.getLocalizedMessage(), string);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)Messages.getString("TTAutotraceTreeModel.failedToExplainPlan"), null);
        }
        finally {
            try {
                if (bl2) {
                    connection.setAutoCommit(bl);
                }
                if (statement != null) {
                    statement.close();
                }
                if (statement2 != null) {
                    statement2.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private TTExplainPlanNode getParentNode(List<TTExplainPlanNode> list, TTExplainPlanNode tTExplainPlanNode) {
        TTExplainPlanNode tTExplainPlanNode2 = null;
        int n = Integer.MAX_VALUE;
        if (list == null) {
            _logger.warning("Explain Plan: List of parent steps is empty.");
            return null;
        }
        for (TTExplainPlanNode tTExplainPlanNode3 : list) {
            if (tTExplainPlanNode3.getTheStep() <= tTExplainPlanNode.getTheStep() || tTExplainPlanNode3.getTheStep() >= n) continue;
            n = tTExplainPlanNode3.getTheStep();
            tTExplainPlanNode2 = tTExplainPlanNode3;
        }
        if (tTExplainPlanNode2 == null) {
            _logger.warning("Explain Plan: Step numbers of parent nodes are less than child step number.");
        }
        return tTExplainPlanNode2;
    }

    public void fetchPlan(String string, String string2, Connection connection) {
        this.reload();
    }

    public void reload(String string, String string2, Connection connection) {
        this.reload();
    }

    private void reload() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TTAutotraceTreeModel.this.fireTreeStructureChanged(this, new TreeNode[]{(TreeNode)TTAutotraceTreeModel.this.root}, null, null);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public List<String> displayedColumns() {
        List<String> list = TTExplainPlanNode.SysPlanColumns.getDisplayedColumns(this.isAcadia);
        return list;
    }

    public Object getValueAt(Object object, int n) {
        if (object instanceof TTExplainPlanNode) {
            Object object2 = ((TTExplainPlanNode)((Object)object)).getValue(n);
            return object2;
        }
        return super.getValueAt(object, n);
    }
}

