/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableAttrPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableColsPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableColsTableModel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableTreeNode;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableTreePanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTreeNodeSelectionListener;
import oracle.dbtools.raptor.utils.DBObject;

public final class CGCTablesPanel
extends DialogBase {
    private CGCTableTreePanel _treePanel;
    private CGCTableColsPanel _tableColsPanel;
    private CGCTableAttrPanel _tableAttrPanel;

    public CGCTablesPanel(DBObject dBObject, String string, List<JComponent> list) {
        super(dBObject, string, "CGCTablesPanel", list);
        CGCTablesPanel.LOUD("tab 1: tables");
    }

    public CGCTableTreeNode getCurrentSelection() {
        return this._treePanel.getCurrentSelection();
    }

    public void cgTypeChanged() {
        this._tableColsPanel.cgTypeChanged();
    }

    public void startOver() {
        this._treePanel.startOver();
        this._tableColsPanel.startOver();
        this._tableAttrPanel.startOver();
    }

    public void nodeSelected(CGCTableTreeNode cGCTableTreeNode) {
        this._tableAttrPanel.nodeSelected(cGCTableTreeNode);
    }

    public void fixupWhereBox() {
        this._tableAttrPanel.fixupWhereBox();
    }

    public CGCTableColsTableModel getTableModel(CGCTableTreeNode cGCTableTreeNode) {
        return this._tableColsPanel.getTableModel(cGCTableTreeNode);
    }

    public CGCTableTreeNode getRootTable() {
        return this._treePanel.getRootTable();
    }

    @Override
    protected void initGUI() {
        this._tableColsPanel = new CGCTableColsPanel(this._dbObject, null, this._textValues);
        this._tableAttrPanel = new CGCTableAttrPanel(this._dbObject, null, this._textValues);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(Messages.getString("TimesTen.common.columns"), this._tableColsPanel);
        jTabbedPane.addTab(Messages.getString("TimesTen.common.tableAttribs"), this._tableAttrPanel);
        this._treePanel = new CGCTableTreePanel(this._dbObject, null, this._textValues, new CGCTreeNodeSelectionListener[]{this._tableColsPanel, this._tableAttrPanel});
        JSplitPane jSplitPane = new JSplitPane(1, true, this._treePanel, jTabbedPane);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setUI(new BasicSplitPaneUI(){

            @Override
            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    @Override
                    public void setBorder(Border border) {
                        super.setBorder(BorderFactory.createRaisedBevelBorder());
                    }
                };
            }
        });
        this.addFull(jSplitPane);
    }

    @Override
    public String getSql() {
        return this._treePanel.getSql();
    }

    @Override
    public boolean validateValues() {
        return this._treePanel.validateValues() && this._tableColsPanel.validateValues() && this._tableAttrPanel.validateValues();
    }

    @Override
    public void idleInit() {
        CGCTablesPanel.LOUD("  CGCTableTreePanel");
        this._treePanel.idleInit();
        CGCTablesPanel.LOUD("  CGCTableColsPanel");
        this._tableColsPanel.idleInit();
        CGCTablesPanel.LOUD("  CGCTableAttrPanel");
        this._tableAttrPanel.idleInit();
    }
}

