/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.connection;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.advisor.IndexAdvicePanel;
import oracle.dbtools.raptor.timesten.advisor.WorksheetIndexAdvisorPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;

public class ConnectionCapturePanels {
    private static Logger LOGGER = Logger.getLogger(ConnectionCapturePanels.class.getPackage().getName());
    private static final String HOME_DIR = System.getProperty("user.home");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int NUM_PANELS = 3;
    private final JPanel[] _panels = new JPanel[3];
    private final String[] _titles = new String[]{Messages.getString("IndexAdvisor.configuration"), Messages.getString("IndexAdvisor.indexRecommendations"), Messages.getString("TTJpanel.SQL")};
    private final JEWTDialog _dialog;
    private final String[] _captureModes = new String[]{Messages.getString("IndexAdvisor.executeSQL"), Messages.getString("IndexAdvisor.prepareSQL")};
    private final DBObject _dbObject;
    private String _hints;
    private final Connections _connections = Connections.getInstance();
    private String _connectionName;

    public ConnectionCapturePanels(JEWTDialog jEWTDialog, DBObject dBObject) {
        this._dbObject = dBObject;
        this._dialog = jEWTDialog;
        this._panels[0] = new ConfigurationPanel();
        this._panels[1] = new IndexAdvicePanel(dBObject.getConnectionName(), dBObject.getConnection(), jEWTDialog, false);
        this._panels[2] = new WorkLoadScriptPanel();
    }

    public JPanel[] getPanels() {
        return this._panels;
    }

    public String[] getTitles() {
        return this._titles;
    }

    public ConfigurationPanel getConfigurationPanel() {
        return (ConfigurationPanel)this._panels[0];
    }

    public IndexAdvicePanel getIndexAdvicePanel() {
        return (IndexAdvicePanel)this._panels[1];
    }

    public WorkLoadScriptPanel getWorkLoadScriptPanel() {
        return (WorkLoadScriptPanel)this._panels[2];
    }

    public String getSqlScript() {
        return this.getConfigurationPanel()._sqlScriptFile;
    }

    public String getHints() {
        return this._hints;
    }

    public int getCaptureMode() {
        return this.getConfigurationPanel()._captureMode;
    }

    public boolean includeOlapOptimizerHints() {
        return this.getConfigurationPanel().includeOlapOptimizerHints();
    }

    public boolean validateSelection() {
        return this.getConfigurationPanel().validateSelection();
    }

    public static class BIServerOptimizerHints {
        static final String HINTS_FILE = System.getProperty("biserver.timesten.indexadvisor.hints.file");
        private BasicEditorPane theHintsPane;

        public BIServerOptimizerHints() {
            this.initGUI();
        }

        private void initGUI() {
            this.theHintsPane = WorksheetIndexAdvisorPanel.createEditorPane();
            this.theHintsPane.setPreferredSize(new Dimension(600, 400));
            this.theHintsPane.setEditable(false);
            InputStream inputStream = null;
            try {
                inputStream = HINTS_FILE == null ? this.getClass().getResourceAsStream("/oracle/dbtools/raptor/timesten/advisor/OlapOptimizerHints.properties") : new FileInputStream(HINTS_FILE);
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOGGER.log(Level.SEVERE, "Can't find Hints file", fileNotFoundException);
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = null;
            Document document = this.theHintsPane.getDocument();
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    try {
                        document.insertString(document.getLength(), string, null);
                        document.insertString(document.getLength(), LINE_SEPARATOR, null);
                    }
                    catch (BadLocationException badLocationException) {
                        LOGGER.log(Level.SEVERE, "Error while reading hints", badLocationException);
                    }
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Error while reading hints", iOException);
            }
        }

        public Component getGUI() {
            return this.theHintsPane;
        }

        public String getHints() {
            return this.theHintsPane.getText();
        }
    }

    private class WorkLoadScriptPanel
    extends JPanel {
        private BasicEditorPane _scriptPane;

        private WorkLoadScriptPanel() {
            this.setLayout(new BorderLayout());
            this.initGUI();
        }

        private void setScript(File file) {
            try {
                URL uRL = file.toURI().toURL();
                this.displayScript(file);
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.log(Level.SEVERE, "Bad URL", malformedURLException);
            }
        }

        private void displayScript(final File file) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WorkLoadScriptPanel.this.populatePane(file);
                    WorkLoadScriptPanel.this.invalidate();
                    WorkLoadScriptPanel.this.validate();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InvocationTargetException invocationTargetException) {
                    LOGGER.log(Level.SEVERE, "Invocation exception", invocationTargetException);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.log(Level.SEVERE, "Iterruped exception", interruptedException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void populatePane(File file) {
            BufferedReader bufferedReader = null;
            String string = null;
            Document document = this._scriptPane.getDocument();
            String string2 = TimesTenUtil.getLineSeparator();
            try {
                if (document.getLength() > 0) {
                    document.remove(0, document.getLength());
                }
                bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    document.insertString(document.getLength(), string + string2, null);
                }
                this._scriptPane.invalidate();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Error while writing to SQL  panel", iOException);
            }
            catch (BadLocationException badLocationException) {
                LOGGER.log(Level.SEVERE, "Error while writing to SQL  panel", badLocationException);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.SEVERE, "Error while closing statement", iOException);
                    }
                }
            }
        }

        private void setScript(String string) {
            File file = new File(string);
            if (!file.exists()) {
                MessageDialog.error((Component)this, (Object)Messages.getString("IndexAdvisor.specifiedScriptFileDoesNotExist"), (String)Messages.getString("IndexAdvisor.workloadScriptFileDoesNotExist"), (String)Messages.getString("IndexAdvisor.workloadScriptFileDoesNotExist"));
                return;
            }
            this.setScript(file);
        }

        private void initGUI() {
            this._scriptPane = WorksheetIndexAdvisorPanel.createEditorPane();
            this._scriptPane.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane((Component)this._scriptPane, 22, 32);
            this.add((Component)jScrollPane, "Center");
        }
    }

    private class ConfigurationPanel
    extends JPanel {
        private JLabel _workLoadLabel;
        private JTextField _workLoadScriptField;
        private JButton _browseButton;
        private String _sqlScriptFile;
        private JLabel _captureModeLabel;
        private JComboBox _captureModeMenu;
        private int _captureMode;
        private JCheckBox _advancedCheckBox;
        private JCheckBox _olapOptimizerHints;
        private JButton _olapOptimizerHintsHelp;
        private boolean _includeOlapOptimizerHints;
        private BIServerOptimizerHints _hintsUI;
        private JScrollPane _hintsUIPane;

        private ConfigurationPanel() {
            this.initGUI();
        }

        private void initGUI() {
            this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            this.setLayout(new GridBagLayout());
            this.initConnectionCaptureGUI();
        }

        private boolean includeOlapOptimizerHints() {
            return this._includeOlapOptimizerHints;
        }

        private void initConnectionCaptureGUI() {
            int n = 0;
            Insets insets = new Insets(10, 5, 0, 0);
            n = 0;
            this._captureModeLabel = new JLabel(Messages.getString("IndexAdvisor.captureMode"));
            this._captureModeMenu = new JComboBox<String>(ConnectionCapturePanels.this._captureModes);
            this._captureModeMenu.setSelectedIndex(1);
            this.add((Component)this._captureModeLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this.add((Component)this._captureModeMenu, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this._workLoadLabel = new JLabel(Messages.getString("IndexAdvisor.workloadScript"));
            this._workLoadScriptField = new JTextField(64);
            this._workLoadScriptField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JTextField jTextField = (JTextField)actionEvent.getSource();
                    ConfigurationPanel.this._sqlScriptFile = jTextField.getText();
                    ConnectionCapturePanels.this.getWorkLoadScriptPanel().setScript(jTextField.getText());
                }
            });
            this.add((Component)this._workLoadLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this.add((Component)this._workLoadScriptField, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
            this._browseButton = new JButton(StringUtils.stripMnemonic((String)Messages.getString("IndexAdvisor.browse")));
            this._browseButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("IndexAdvisor.browse")));
            this.add((Component)this._browseButton, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
            this._browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileFilter(new FileFilter(){

                        @Override
                        public String getDescription() {
                            return Messages.getString("IndexAdvisor.SQLFiles");
                        }

                        @Override
                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().toLowerCase().endsWith(".sql");
                        }
                    });
                    int n = jFileChooser.showOpenDialog(ConfigurationPanel.this);
                    if (n == 0) {
                        ConfigurationPanel.this._sqlScriptFile = jFileChooser.getSelectedFile().getAbsolutePath();
                        ConfigurationPanel.this._workLoadScriptField.setText(ConfigurationPanel.this._sqlScriptFile);
                        ConnectionCapturePanels.this.getWorkLoadScriptPanel().setScript(jFileChooser.getSelectedFile().getAbsoluteFile());
                    }
                }
            });
            this._olapOptimizerHints = new JCheckBox(Messages.getString("IndexAdvisor.includeBIOptimizers"));
            this._olapOptimizerHints.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ConfigurationPanel.this._olapOptimizerHints.isSelected()) {
                        ConfigurationPanel.this._includeOlapOptimizerHints = true;
                        ConfigurationPanel.this._hintsUIPane.setVisible(true);
                        ConfigurationPanel.this.invalidate();
                        ConfigurationPanel.this.validate();
                    } else {
                        ConfigurationPanel.this._includeOlapOptimizerHints = false;
                        ConfigurationPanel.this._hintsUIPane.setVisible(false);
                        ConfigurationPanel.this.invalidate();
                        ConfigurationPanel.this.validate();
                    }
                }
            });
            this.add((Component)this._olapOptimizerHints, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this._hintsUI = new BIServerOptimizerHints();
            ConnectionCapturePanels.this._hints = this._hintsUI.getHints();
            Component component = this._hintsUI.getGUI();
            this._hintsUIPane = new JScrollPane(component);
            this._hintsUIPane.setVisible(false);
            this.add((Component)this._hintsUIPane, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 18, 2, insets, 0, 80));
        }

        private void initConnectionCaptureGUINOTUSED() {
            int n = 0;
            Insets insets = new Insets(10, 5, 0, 0);
            final JPanel jPanel = this.initializeAdvancedOptions();
            this._advancedCheckBox = new JCheckBox("Advanced");
            this._advancedCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ConfigurationPanel.this._advancedCheckBox.isSelected()) {
                        jPanel.setEnabled(true);
                        jPanel.setVisible(true);
                    } else {
                        jPanel.setEnabled(false);
                        jPanel.setVisible(false);
                    }
                }
            });
            n = 0;
            this.add((Component)this._advancedCheckBox, new GridBagConstraints(0, n, 0, 1, 0.0, 0.0, 12, 0, insets, 0, 0));
            this._captureModeLabel = new JLabel(Messages.getString("IndexAdvisor.captureMode"));
            this._captureModeMenu = new JComboBox<String>(ConnectionCapturePanels.this._captureModes);
            this._captureModeMenu.setSelectedIndex(0);
            this.add((Component)this._captureModeLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this.add((Component)this._captureModeMenu, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this._workLoadLabel = new JLabel("Workload script");
            this._workLoadScriptField = new JTextField(64);
            this._workLoadScriptField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JTextField jTextField = (JTextField)actionEvent.getSource();
                    ConfigurationPanel.this._sqlScriptFile = jTextField.getText();
                    ConnectionCapturePanels.this.getWorkLoadScriptPanel().setScript(jTextField.getText());
                }
            });
            this.add((Component)this._workLoadLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this.add((Component)this._workLoadScriptField, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this._browseButton = new JButton(Messages.getString("IndexAdvisor.browse"));
            this.add((Component)this._browseButton, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            this._browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showOpenDialog(ConfigurationPanel.this);
                    if (n == 0) {
                        ConfigurationPanel.this._sqlScriptFile = jFileChooser.getSelectedFile().getAbsolutePath();
                        ConfigurationPanel.this._workLoadScriptField.setText(ConfigurationPanel.this._sqlScriptFile);
                        ConnectionCapturePanels.this.getWorkLoadScriptPanel().setScript(jFileChooser.getSelectedFile().getAbsoluteFile());
                    }
                }
            });
            this.add((Component)jPanel, new GridBagConstraints(0, 3, 0, 1, 0.0, 0.0, 23, 0, insets, 0, 0));
            jPanel.setEnabled(false);
            jPanel.setVisible(false);
        }

        private JPanel initializeAdvancedOptions() {
            int n = 0;
            final String string = TimesTenUtil.getLineSeparator();
            Insets insets = new Insets(10, 5, 0, 0);
            JPanel jPanel = new JPanel(new GridBagLayout());
            this._olapOptimizerHints = new JCheckBox(Messages.getString("IndexAdvisor.includeBIOptimizers"));
            n = 0;
            jPanel.add((Component)this._olapOptimizerHints, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            Icon icon = OracleIcons.getIcon((String)"help.png");
            this._olapOptimizerHintsHelp = new JButton(Messages.getString("IndexAdvisor.whatIsThis"), icon);
            this._olapOptimizerHintsHelp.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    InputStream inputStream = this.getClass().getResourceAsStream("/oracle/dbtools/raptor/timesten/advisor/OlapOptimizerHints.properties");
                    BufferedReader bufferedReader = null;
                    try {
                        StringBuilder stringBuilder = new StringBuilder(2048);
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        String string2 = null;
                        while ((string2 = bufferedReader.readLine()) != null) {
                            stringBuilder.append(string2);
                            stringBuilder.append(string);
                        }
                        MessageDialog.information((Component)ConnectionCapturePanels.this._dialog, (Object)stringBuilder, (String)Messages.getString("IndexAdvisor.olapOptimizerHints"), null);
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.SEVERE, "Can't read optimizer hints", iOException);
                    }
                    finally {
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException) {
                                LOGGER.log(Level.SEVERE, "Can't close stream", iOException);
                            }
                        }
                    }
                }
            });
            jPanel.add((Component)this._olapOptimizerHintsHelp, new GridBagConstraints(1, n, 0, 1, 0.0, 0.0, 24, 0, insets, 0, 0));
            return jPanel;
        }

        private boolean validateSelection() {
            this._sqlScriptFile = this._workLoadScriptField.getText().trim();
            ConnectionCapturePanels.this.getWorkLoadScriptPanel().setScript(this._sqlScriptFile);
            this._captureMode = this._captureModeMenu.getSelectedIndex() == 0 ? 0 : 31;
            return true;
        }
    }
}

