/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.index;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.OracleTypeModeImpl;
import oracle.dbtools.raptor.timesten.dialogs.index.SelectColumnIndexPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.controls.SchemaObjectComboBox;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.sql.IndexObject;

public class IndexInfoPanel
extends BaseEditorPanel<Index>
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Schema defaultSchema;
    private DBObjectListener changeListeners;
    private SelectColumnIndexPanel indexPanel;
    private SchemaObjectComboBox tableCombobox;
    private JLabel labelSchema;
    private JLabel labelTable;
    private JLabel indexType;
    private JLabel pages;
    private JLabel type;
    private JComboBox<String> indexTypeCombo;
    private JComboBox<String> pagesType;
    private NumberTextField pagesNumber;
    private JComboBox<String> indexConfigCombo;
    private Schema latestSelected;
    private final String HASH = Messages.getString("TimestenTable.hash");
    private final String RANGE = Messages.getString("TimestenTable.range");
    private final String CURRENT = Messages.getString("TimestenTable.current");
    private final String PAGES_SIZE = Messages.getString("TimestenTable.pageSize");
    private final String NON_UNIQUE = Messages.getString("IndexEditorPanel.nonUnique");
    private final String UNIQUE = Messages.getString("IndexEditorPanel.unique");
    private final String TT_INDEX_TYPE = "ttIndexType";
    private final String TT_PAGES_SIZE = "ttPagesSize";
    private HashSet<String> schemaSet = new HashSet();
    private static final Logger logger = Logger.getLogger(IndexInfoPanel.class.getPackage().getName());

    public IndexInfoPanel() {
        this.schemaSet.add("SYS");
        this.schemaSet.add("TTREP");
    }

    protected void initialisePanel() {
    }

    protected void initialiseComponents() {
        try {
            this.changeListeners = new DBObjectListener(){

                public void objectUpdated(DBObjectChange dBObjectChange) {
                    IndexInfoPanel.this.checkSchemaChange(((Index)IndexInfoPanel.this.getUpdatedObject()).getSchema());
                }
            };
            ((Index)this.getUpdatedObject()).addObjectListener(this.changeListeners);
            Table table = ((Index)this.getUpdatedObject()).getTable();
            OracleTypeModeImpl oracleTypeModeImpl = (OracleTypeModeImpl)this.getProvider();
            this.latestSelected = this.defaultSchema = this.getProvider().getDefaultSchema();
            this.tableCombobox = new SchemaObjectComboBox();
            this.tableCombobox.init(this.getProvider(), this.defaultSchema, new String[]{"TABLE", "MATERIALIZED VIEW"});
            this.tableCombobox.addActionListener((ActionListener)this);
            this.labelSchema = new JLabel(Messages.getString("TimesTen.common.schema"));
            this.labelTable = new JLabel(Messages.getString("TimesTen.common.table"));
            this.indexType = new JLabel(Messages.getString("TimestenTable.indexType"));
            this.indexTypeCombo = new JComboBox<String>(new String[]{this.RANGE, this.HASH});
            this.indexTypeCombo.addActionListener(this);
            this.pages = new JLabel(Messages.getString("TimestenTable.pages"));
            this.pagesType = new JComboBox<String>(new String[]{this.PAGES_SIZE, this.CURRENT});
            this.pagesType.addActionListener(this);
            this.pagesNumber = new NumberTextField();
            this.pagesNumber.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    IndexInfoPanel.this.refreshSize();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    IndexInfoPanel.this.refreshSize();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    IndexInfoPanel.this.refreshSize();
                }
            });
            this.type = new JLabel(Messages.getString("TimestenTable.uniqueness"));
            this.indexConfigCombo = new JComboBox<String>(new String[]{this.NON_UNIQUE, this.UNIQUE});
            this.indexConfigCombo.addActionListener(this);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add(this.pagesType, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
            jPanel.add((Component)this.pagesNumber, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            this.setLayout(new BorderLayout());
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.add((Component)this.labelTable, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
            jPanel2.add((Component)this.tableCombobox, LayoutControl.GBC.gbc((int)1, (int)0, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            jPanel2.add((Component)this.indexType, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
            jPanel2.add(this.indexTypeCombo, LayoutControl.GBC.gbc((int)1, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            jPanel2.add((Component)this.pages, LayoutControl.GBC.gbc((int)2, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
            jPanel2.add((Component)jPanel, LayoutControl.GBC.gbc((int)3, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            jPanel2.add((Component)this.type, LayoutControl.GBC.gbc((int)0, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
            jPanel2.add(this.indexConfigCombo, LayoutControl.GBC.gbc((int)1, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            this.add(jPanel2, "North");
            try {
                this.indexPanel = new SelectColumnIndexPanel(this, (Index)this.getUpdatedObject());
                this.add(this.indexPanel, "Center");
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Cannot construct panel", exception);
            }
            this.enablePages(false);
            if (table != null) {
                this.initializeControl(table);
            }
            this.setSelectedTable();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Cannot construct panel", exception);
        }
    }

    private void initializeControl(Table table) {
        for (int i = 0; i < this.tableCombobox.getItemCount(); ++i) {
            SchemaObjectDescriptor schemaObjectDescriptor = (SchemaObjectDescriptor)this.tableCombobox.getItemAt(i);
            if (!schemaObjectDescriptor.getObject().equals(table)) continue;
            this.tableCombobox.setSelectedIndex(i);
            return;
        }
    }

    private void setSelectedTable() {
        SchemaObjectDescriptor schemaObjectDescriptor = (SchemaObjectDescriptor)this.tableCombobox.getSelectedItem();
        if (schemaObjectDescriptor == null) {
            IndexObject[] indexObjectArray;
            ((Index)this.getUpdatedObject()).setTable(null);
            for (IndexObject indexObject : indexObjectArray = ((Index)this.getUpdatedObject()).getColumnExpressions()) {
                ((Index)this.getUpdatedObject()).removeColumnExpression(indexObject);
            }
            this.indexPanel.updatePanel();
            return;
        }
        SystemObject systemObject = schemaObjectDescriptor.getObject();
        if (systemObject instanceof Table) {
            IndexObject[] indexObjectArray;
            ((Index)this.getUpdatedObject()).setTable((Table)systemObject);
            for (IndexObject indexObject : indexObjectArray = ((Index)this.getUpdatedObject()).getColumnExpressions()) {
                ((Index)this.getUpdatedObject()).removeColumnExpression(indexObject);
            }
            this.indexPanel.updatePanel();
        }
    }

    private void checkSchemaChange(Schema schema) {
        if (!this.latestSelected.equals((Object)schema)) {
            this.latestSelected = schema;
            this.tableCombobox.init(this.getProvider(), schema, new String[]{"TABLE", "MATERIALIZED VIEW"});
            this.setSelectedTable();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.tableCombobox == actionEvent.getSource()) {
            this.setSelectedTable();
        } else if (this.indexConfigCombo == actionEvent.getSource()) {
            if (this.NON_UNIQUE == this.indexConfigCombo.getSelectedItem()) {
                ((Index)this.getUpdatedObject()).setIndexType(Index.IndexType.NORMAL);
            } else if (this.UNIQUE == this.indexConfigCombo.getSelectedItem()) {
                ((Index)this.getUpdatedObject()).setIndexType(Index.IndexType.UNIQUE);
            }
        } else if (this.indexTypeCombo == actionEvent.getSource()) {
            Object object = this.indexTypeCombo.getSelectedItem();
            if (this.RANGE == object) {
                this.enablePages(false);
                ((Index)this.getUpdatedObject()).setProperty("ttIndexType", null);
                ((Index)this.getUpdatedObject()).setProperty("ttPagesSize", null);
            } else if (this.HASH == object) {
                ((Index)this.getUpdatedObject()).setProperty("ttIndexType", (Object)"HASH");
                this.enablePages(true);
                if (this.CURRENT == this.pagesType.getSelectedItem()) {
                    this.pagesNumber.setEnabled(false);
                    ((Index)this.getUpdatedObject()).setProperty("ttPagesSize", (Object)"PAGES = CURRENT");
                } else {
                    this.pagesNumber.setEnabled(true);
                    this.refreshSize();
                }
            }
        } else if (this.pagesType == actionEvent.getSource()) {
            if (this.CURRENT == this.pagesType.getSelectedItem()) {
                this.pagesNumber.setEnabled(false);
                ((Index)this.getUpdatedObject()).setProperty("ttPagesSize", (Object)"PAGES = CURRENT");
            } else {
                this.pagesNumber.setEnabled(true);
            }
        }
    }

    private void enablePages(boolean bl) {
        this.pages.setEnabled(bl);
        this.pagesType.setEnabled(bl);
        this.pagesNumber.setEnabled(bl);
    }

    private Schema[] removeSystemSchemas(Schema[] schemaArray) {
        ArrayList<Schema> arrayList = new ArrayList<Schema>(schemaArray.length);
        for (Schema schema : schemaArray) {
            if (this.schemaSet.contains(schema.toString())) continue;
            arrayList.add(schema);
        }
        return arrayList.toArray(new Schema[0]);
    }

    private void refreshSize() {
        String string = this.pagesNumber.getText();
        ((Index)this.getUpdatedObject()).setProperty("ttPagesSize", (Object)("PAGES = " + string));
    }
}

