/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.NewStandaloneHostPanel;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.RepositoryObject;
import oracle.dbtools.raptor.timesten.utils.AutoCompleteComponent;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;

public class CreateRepositoryPanel
extends TTGUIBasePanel {
    private static final long serialVersionUID = 1L;
    private JLabel repoNameLabel;
    private JLabel pathLabel;
    private JLabel methodLabel;
    private JLabel addressLabel;
    private AutoCompleteComponent repoNameField;
    private AutoCompleteComponent pathField;
    private JComboBox<RepositoryObject.Method> methodComboBox;
    private AutoCompleteComponent addressField;
    private static Logger logger = Logger.getLogger(NewStandaloneHostPanel.class.getPackage().getName());

    public CreateRepositoryPanel() {
        this.initGUI();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.CREATE_REPOSITORY.toString());
    }

    private void initGUI() {
        this.repoNameLabel = this.getLabel("TimesTenGrid.RepositoryName");
        this.pathLabel = this.getLabel("TimesTenGrid.location");
        this.methodLabel = this.getLabel("TimesTenGrid.RepositoryMethod");
        this.addressLabel = this.getLabel("TimesTenGrid.RepositoryAddress");
        this.repoNameField = new AutoCompleteComponent(15, RepositoryObject.getRepoNameSuggestions());
        this.pathField = new AutoCompleteComponent(15, RepositoryObject.getPathSuggestions());
        this.addressField = new AutoCompleteComponent(15, RepositoryObject.getAddressSuggestions());
        this.addressLabel.setVisible(false);
        this.addressField.setVisible(false);
        this.methodComboBox = new JComboBox<RepositoryObject.Method>(RepositoryObject.Method.values());
        this.methodComboBox.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                RepositoryObject.Method method = (RepositoryObject.Method)((Object)((Object)itemEvent.getItem()));
                if (method == RepositoryObject.Method.MOUNT) {
                    this.addressLabel.setVisible(false);
                    this.addressField.setVisible(false);
                } else if (method == RepositoryObject.Method.SCP) {
                    this.addressLabel.setVisible(true);
                    this.addressField.setVisible(true);
                }
            }
        });
        this.repoNameLabel.setLabelFor(this.repoNameField);
        this.pathLabel.setLabelFor(this.pathField);
        this.methodLabel.setLabelFor(this.methodComboBox);
        this.addressLabel.setLabelFor(this.addressField);
        this.add((Component)this.repoNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.repoNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.pathLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.pathField, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.methodLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add(this.methodComboBox, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.addressLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.addressField, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.setNames();
    }

    private JLabel getLabel(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Messages.getString(string));
        stringBuilder.append(":");
        return new JLabel(stringBuilder.toString());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.validInput()) {
            this.oked = false;
            return;
        }
        super.actionPerformed(actionEvent);
        this.oked = true;
        this.createRepository();
    }

    private boolean validInput() {
        String string = this.repoNameField.getText().trim();
        String string2 = this.pathField.getText().trim();
        RepositoryObject.Method method = (RepositoryObject.Method)((Object)this.methodComboBox.getSelectedItem());
        String string3 = this.addressField.getText().trim();
        if (string.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.RepositoryNoNameError"));
            return false;
        }
        if (string2.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.RepositoryNoPathError"));
            return false;
        }
        if (method == RepositoryObject.Method.SCP && string3.isEmpty()) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.RepositoryNoAddressError"));
            return false;
        }
        if (method == RepositoryObject.Method.SCP && !Common.validAddress(string3)) {
            Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.RepositoryAddressError"));
            return false;
        }
        return true;
    }

    private void createRepository() {
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.RepositoryCreate"), Messages.getString("TimesTenGrid.RepositoryCreating"), null);
        customProgressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                GridCommand gridCommand = null;
                try {
                    GridMouseListener.expander.saveExpansionState();
                    customProgressMonitor.start();
                    String string = CreateRepositoryPanel.this.repoNameField.getText().trim();
                    String string2 = CreateRepositoryPanel.this.pathField.getText().trim();
                    RepositoryObject.Method method = (RepositoryObject.Method)((Object)CreateRepositoryPanel.this.methodComboBox.getSelectedItem());
                    String string3 = CreateRepositoryPanel.this.addressField.getText().trim();
                    if (method == RepositoryObject.Method.MOUNT) {
                        gridCommand = GridCommand.REPOSITORY_CREATE_MOUNT;
                        gridCommand.prepareCommand(string, string2);
                    } else if (method == RepositoryObject.Method.SCP) {
                        gridCommand = GridCommand.REPOSITORY_CREATE_SCP;
                        gridCommand.prepareCommand(string, string2, string3);
                    }
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.RepositoryCreateExecute"), string));
                    CreateRepositoryPanel.this.grid.getExecutor().executeCommandGetString(gridCommand, true);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    CreateRepositoryPanel.this.grid.refreshGridModels();
                    this.firePropertyChange("progress", null, 100);
                }
                catch (GridCommandException gridCommandException) {
                    logger.log(Level.SEVERE, gridCommandException.getMessage());
                    this.firePropertyChange("error", null, gridCommandException.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.finish();
                if (!customProgressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.RepositoryCreateCancelled"));
                    customProgressMonitor.updateMessage(Messages.getString("TimesTenGrid.RepositoryCreateCancelled"));
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    GridMouseListener.expander.restoreExpansionState();
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
        this._dialog.dispose();
    }

    private void setNames() {
        this.repoNameLabel.setName(Messages.getString("TimesTenGrid.RepositoryName"));
        this.pathLabel.setName(Messages.getString("TimesTenGrid.location"));
        this.methodLabel.setName(Messages.getString("TimesTenGrid.RepositoryMethod"));
        this.addressLabel.setName(Messages.getString("TimesTenGrid.RepositoryAddress"));
        this.repoNameField.setName("_repoNameField", "_repoNameCmbBx");
        this.pathField.setName("_locationField", "_locationCmbBx");
        this.methodComboBox.setName("_methodCmbBx");
        this.addressField.setName("_addressField", "_addressCmbBx");
    }
}

