/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.utils.AutoCompleteComponent;
import oracle.ide.Ide;

public class CredentialsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel _instanceAdminLabel;
    private AutoCompleteComponent _instanceAdminTxtField;
    private JPasswordField _pwdField;
    private JCheckBox _savePwdCheckBox;
    private JRadioButton _usePwdBtn;
    private JRadioButton _useKeyFileBtn;
    private AutoCompleteComponent _keyFileTxtField;
    private JButton _browseButton;
    private boolean usePwd = true;
    private boolean includeSavePwd;
    JEWTDialog _dialog;

    CredentialsPanel() {
        this(true);
    }

    public CredentialsPanel(boolean bl) {
        this.includeSavePwd = bl;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.credentials")));
    }

    public void initialize() {
        this._instanceAdminTxtField = new AutoCompleteComponent(20, TTGridRootNode.getStorage().getSuggestion("adminUID"));
        this._keyFileTxtField = new AutoCompleteComponent(20, TTGridRootNode.getStorage().getSuggestion("keyFile"));
        this._keyFileTxtField.setEnabled(false);
        this._pwdField = new JPasswordField(20);
        this._instanceAdminLabel = new JLabel(Messages.getString("TimesTenGrid.instanceAdminLabel"));
        this._instanceAdminLabel.setLabelFor(this._instanceAdminTxtField);
        this._usePwdBtn = new JRadioButton(Messages.getString("TimesTenGrid.usePwdLabel"));
        this._useKeyFileBtn = new JRadioButton(Messages.getString("TimesTenGrid.useKeyFileLabel"));
        this._browseButton = new JButton(Messages.getString("TimesTenGrid.browse"));
        this._browseButton.setEnabled(false);
        this._browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(TTGridRootNode.getInstance().getCurrentDirectory());
                jFileChooser.setFileHidingEnabled(false);
                jFileChooser.setFileSelectionMode(0);
                int n = jFileChooser.showOpenDialog((Component)Ide.getMainWindow());
                if (n == 0) {
                    TTGridRootNode.getInstance().setCurrentDirectory(jFileChooser.getCurrentDirectory().getAbsolutePath());
                    File file = jFileChooser.getSelectedFile();
                    CredentialsPanel.this._keyFileTxtField.setText(file.getAbsolutePath());
                    if (CredentialsPanel.this._dialog != null) {
                        CredentialsPanel.this._dialog.setOKButtonEnabled(true);
                    }
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._usePwdBtn);
        buttonGroup.add(this._useKeyFileBtn);
        PwdKeyFileListener pwdKeyFileListener = new PwdKeyFileListener();
        this._usePwdBtn.addActionListener(pwdKeyFileListener);
        this._usePwdBtn.setSelected(this.usePwd);
        this._useKeyFileBtn.addActionListener(pwdKeyFileListener);
        this.add((Component)this._instanceAdminLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._instanceAdminTxtField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._usePwdBtn, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this._pwdField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (this.includeSavePwd) {
            this._savePwdCheckBox = new JCheckBox(Messages.getString("TimesTenGrid.savePwd"));
            jPanel2.add((Component)this._savePwdCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.add((Component)jPanel2, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._useKeyFileBtn, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this._keyFileTxtField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel3.add((Component)this._browseButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)jPanel3, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setNames();
    }

    public boolean isUsingPassword() {
        return this.usePwd;
    }

    public String getInstanceAdmin() {
        String string = this._instanceAdminTxtField.getText().trim();
        return string.isEmpty() ? null : string;
    }

    public void setInstanceAdmin(String string, boolean bl) {
        this._instanceAdminTxtField.setText(string);
        this._instanceAdminTxtField.setEnabled(bl);
    }

    public char[] getPassword() {
        char[] cArray = this._pwdField.getPassword();
        return cArray.length == 0 ? null : cArray;
    }

    public void setPassword(String string) {
        this._pwdField.setText(string);
        this._usePwdBtn.setSelected(true);
        this.enablePwdComponents(true);
    }

    public boolean getSavePassword() {
        return this.includeSavePwd ? this._savePwdCheckBox.isSelected() : false;
    }

    public void setSavePassword(boolean bl) {
        this._savePwdCheckBox.setSelected(bl);
    }

    public String getKeyFile() {
        String string = this._keyFileTxtField.getText().trim();
        return string.isEmpty() ? null : string;
    }

    public void setKeyFile(String string) {
        this._keyFileTxtField.setText(string);
        this._useKeyFileBtn.setSelected(true);
        this.enablePwdComponents(false);
    }

    private void setNames() {
        this._instanceAdminLabel.setName(Messages.getString("TimesTenGrid.instanceAdminLabel"));
        this._instanceAdminTxtField.setName("_instanceAdminTxtField", "_instanceAdminCmbBox");
        this._usePwdBtn.setName(Messages.getString("TimesTenGrid.usePwdLabel"));
        this._pwdField.setName("_pwdField");
        this._useKeyFileBtn.setName(Messages.getString("TimesTenGrid.useKeyFileLabel"));
        this._keyFileTxtField.setName("_keyFileTxtField");
        this._browseButton.setName("_credBrowseButton");
        if (this.includeSavePwd) {
            this._savePwdCheckBox.setName(Messages.getString("TimesTenGrid.savePwd"));
        }
    }

    public void setDialog(final JEWTDialog jEWTDialog) {
        this._dialog = jEWTDialog;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CredentialsPanel.this.usePwd) {
                    if (CredentialsPanel.this._pwdField.getPassword().length == 0) {
                        Common.displayErrorMsg((Component)jEWTDialog, Messages.getString("TimesTenGrid.noPwdError"));
                        return;
                    }
                } else if (CredentialsPanel.this._keyFileTxtField.getText().trim().length() == 0) {
                    Common.displayErrorMsg((Component)jEWTDialog, Messages.getString("TimesTenGrid.noKeyFileError"));
                    return;
                }
                jEWTDialog.dispose();
            }
        };
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (CredentialsPanel.this.usePwd) {
                    jEWTDialog.setOKButtonEnabled(CredentialsPanel.this._pwdField.getPassword().length != 0);
                } else {
                    jEWTDialog.setOKButtonEnabled(CredentialsPanel.this._keyFileTxtField.getText().trim().length() != 0);
                }
            }
        };
        this._pwdField.addActionListener(actionListener);
        this._pwdField.addKeyListener(keyListener);
        this._keyFileTxtField.addTxtFieldListeners(actionListener, keyListener);
    }

    private void enablePwdComponents(boolean bl) {
        this.usePwd = bl;
        this._pwdField.setEnabled(bl);
        if (this.includeSavePwd) {
            this._savePwdCheckBox.setEnabled(bl);
        }
        this._keyFileTxtField.setEnabled(!bl);
        this._browseButton.setEnabled(!bl);
        if (bl) {
            this._keyFileTxtField.setText("");
        } else {
            this._pwdField.setText("");
            if (this.includeSavePwd) {
                this._savePwdCheckBox.setSelected(false);
            }
        }
    }

    private class PwdKeyFileListener
    implements ActionListener {
        private PwdKeyFileListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CredentialsPanel.this.enablePwdComponents((JRadioButton)actionEvent.getSource() == CredentialsPanel.this._usePwdBtn);
        }
    }
}

