/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.io.File;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.swing.SwingWorker;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.SSHChannel;
import oracle.dbtools.raptor.timesten.grid.TTGridOutputStream;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.Executable;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridJsonObject;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.grid.object.MySSHException;
import oracle.ide.Ide;

public class GridCommandExecutor {
    private SSHChannel sshChannel;
    private String lastCommandOutput;
    private GridJsonObject lastCommandOutputJ;
    private GridCommand lastCommand;
    private WorkingHost workingHost;
    private static final Logger logger = Logger.getLogger(GridCommand.class.getName());

    private GridCommandExecutor(String string, String string2, String string3, char[] cArray) {
        this.workingHost = new WorkingHost(string, string3, string2, cArray);
        this.sshChannel = new SSHChannel(string, string2, string3, cArray);
    }

    private GridCommandExecutor(String string, String string2, String string3, String string4) {
        this.workingHost = new WorkingHost(string, string3, string2, string4);
        this.sshChannel = new SSHChannel(string, string2, string3, string4);
    }

    public static GridCommandExecutor getNewInstance(String string, String string2, String string3, char[] cArray, String string4) {
        if (cArray != null) {
            return new GridCommandExecutor(string, string2, string3, cArray);
        }
        return new GridCommandExecutor(string, string2, string3, string4);
    }

    public SSHChannel getSSHChannel() {
        return this.sshChannel;
    }

    public WorkingHost getWorkingHost() {
        return this.workingHost;
    }

    public String getHostIP() {
        return this.workingHost.getIPaddress();
    }

    public boolean outputIsValid(GridCommand gridCommand, String string) {
        if (string.isEmpty()) {
            logger.log(Level.INFO, "Empty output from:" + gridCommand.getCommand() + "\n Cannot validate.");
            return false;
        }
        this.lastCommand = gridCommand;
        this.lastCommandOutput = string;
        try {
            this.validateStringOutput();
        }
        catch (GridCommandException gridCommandException) {
            logger.log(Level.INFO, gridCommandException.getMessage());
            return false;
        }
        return true;
    }

    private void validateStringOutput() throws GridCommandException {
        switch (this.lastCommand) {
            case TT_INSTANCE_CREATE: {
                if (this.lastCommandOutput.contains("Creating instance") || this.lastCommandOutput.contains("NOTE: The TimesTen daemon startup/shutdown scripts have not been installed.")) break;
                throw new GridCommandException(MessageFormat.format(Messages.getString("TimesTenGrid.commandFailed"), "ttInstanceCreate") + " " + this.lastCommandOutput);
            }
            case MODEL_APPLY: {
                if (this.lastCommandOutput.contains("ttGridAdmin -modelApply complete")) break;
                throw new GridCommandException(MessageFormat.format(Messages.getString("TimesTenGrid.commandFailed"), "ttGridAdmin -modelApply") + " " + this.lastCommandOutput);
            }
            case TT_STATUS: {
                if (this.lastCommandOutput.contains(GridCommand.GRID_MEMBERSHIP.getCommand())) break;
                throw new GridCommandException(MessageFormat.format(Messages.getString("TimesTenGrid.commandFailed"), "ttStatus") + " " + this.lastCommandOutput);
            }
            case TT_STATUS_DB: 
            case TT_STATUS_ALL: {
                if (!this.lastCommandOutput.contains("No TimesTen server running")) break;
                throw new GridCommandException(MessageFormat.format(Messages.getString("TimesTenGrid.commandFailed"), "Server not running: ttStatus") + " " + this.lastCommandOutput);
            }
            case HOST_CREATE: 
            case HOST_CREATE_NODSG: {
                if (this.lastCommandOutput.contains("Host") || this.lastCommandOutput.contains("created in Model")) break;
                throw new GridCommandException(MessageFormat.format(Messages.getString("TimesTenGrid.commandFailed"), "ttGridAdmin -hostCreate") + " " + this.lastCommandOutput);
            }
        }
    }

    public boolean outputIsValid(GridCommand gridCommand, GridJsonObject gridJsonObject) throws GridCommandException {
        if (gridJsonObject == null) {
            logger.log(Level.INFO, "Null output from:" + gridCommand.getCommand() + "\n Cannot validate.");
            return false;
        }
        this.lastCommand = gridCommand;
        this.lastCommandOutputJ = gridJsonObject;
        try {
            this.validateJsonOutput();
        }
        catch (GridCommandException gridCommandException) {
            logger.log(Level.INFO, gridCommandException.getMessage());
            return false;
        }
        return true;
    }

    private void validateJsonOutput() throws GridCommandException {
        Integer n = null;
        boolean bl = false;
        String string = "";
        if (this.lastCommandOutputJ.containsKey("status")) {
            n = this.lastCommandOutputJ.getInt("status");
        }
        if (n == null || n != 0) {
            bl = this.lastCommandOutputJ.containsKey("errmsg");
        }
        if (bl) {
            string = n == null ? Messages.getString("TimesTenGrid.message") + " " + string : Messages.getString("TimesTenGrid.code") + " " + n + ", " + Messages.getString("TimesTenGrid.message") + " " + string;
        } else {
            switch (this.lastCommand) {
                case DB_STATUS: {
                    try {
                        ((JsonObject)this.lastCommandOutputJ.getJsonArray("databases").getValuesAs(JsonObject.class).get(0)).getString("name");
                    }
                    catch (Exception exception) {
                        string = Messages.getString("TimesTenGrid.dbNotCreated");
                        bl = true;
                    }
                    break;
                }
                default: {
                    logger.log(Level.INFO, (Object)((Object)this.lastCommand) + " output has no validation");
                }
            }
        }
        if (bl) {
            throw new GridCommandException(string);
        }
    }

    public synchronized void executeSimpleCommand(GridCommand gridCommand) throws GridCommandException {
        try {
            gridCommand.removeJsonRequest();
            this.lastCommand = gridCommand;
            this.lastCommandOutput = this.sshChannel.executeSimpleCommand(gridCommand);
            if (this.sshChannel.getLastCommandExitStatus() != 0) {
                throw new GridCommandException(this.sshChannel.getLastErrorMessage(), this.lastCommand.getCommand());
            }
            this.validateStringOutput();
        }
        catch (MySSHException mySSHException) {
            throw new GridCommandException(mySSHException.getMessage(), mySSHException.getCause(), this.lastCommand.getCommand());
        }
    }

    public synchronized String executeSimpleCommandGetOutput(GridCommand gridCommand) throws GridCommandException {
        try {
            this.lastCommand = gridCommand;
            this.lastCommandOutput = this.sshChannel.executeSimpleCommand(gridCommand);
            if (this.sshChannel.getLastCommandExitStatus() != 0) {
                throw new GridCommandException(this.sshChannel.getLastErrorMessage(), this.lastCommand.getCommand());
            }
        }
        catch (MySSHException mySSHException) {
            throw new GridCommandException(mySSHException.getMessage(), mySSHException.getCause(), this.lastCommand.getCommand());
        }
        return this.lastCommandOutput;
    }

    public synchronized void executePerlScriptCommand(GridCommand gridCommand, OutputStream outputStream) throws GridCommandException {
        try {
            if (!gridCommand.commandReady()) {
                logger.log(Level.INFO, "Command:" + (Object)((Object)gridCommand) + ", has unset parameters");
            }
            gridCommand.removeJsonRequest();
            gridCommand.setPerlLocation(this.workingHost.getInstanceHome() + this.workingHost.getSystemInfo().getFileSeparator() + "install");
            this.lastCommand = gridCommand;
            this.lastCommandOutput = this.sshChannel.executeCommand(gridCommand, outputStream, true);
            if (this.sshChannel.getLastCommandExitStatus() != 0) {
                throw new GridCommandException(this.sshChannel.getLastErrorMessage(), this.lastCommand.getCommand());
            }
        }
        catch (MySSHException mySSHException) {
            throw new GridCommandException(mySSHException.getMessage(), mySSHException, this.lastCommand.getCommand());
        }
    }

    public synchronized String executeCommandGetString(GridCommand gridCommand, boolean bl) throws GridCommandException {
        try {
            if (!gridCommand.commandReady()) {
                logger.log(Level.INFO, "Command:" + (Object)((Object)gridCommand) + ", has unset parameters");
            }
            gridCommand.removeJsonRequest();
            this.lastCommand = gridCommand;
            this.lastCommandOutput = this.sshChannel.executeCommand(gridCommand);
            if (this.sshChannel.getLastCommandExitStatus() != 0) {
                throw new GridCommandException(this.sshChannel.getLastErrorMessage(), this.lastCommand.getCommand());
            }
            if (bl) {
                this.validateStringOutput();
            }
            return this.lastCommandOutput;
        }
        catch (MySSHException mySSHException) {
            throw new GridCommandException(mySSHException.getMessage(), mySSHException.getCause(), this.lastCommand.getCommand());
        }
    }

    public synchronized JsonObject executeCommandGetJson(GridCommand gridCommand, boolean bl) throws GridCommandException {
        return this.executeCommandGetJson(gridCommand, bl, null);
    }

    public synchronized JsonObject executeCommandGetJson(GridCommand gridCommand, boolean bl, OutputStream outputStream) throws GridCommandException {
        try {
            if (!gridCommand.commandReady()) {
                logger.log(Level.INFO, "Command:" + (Object)((Object)gridCommand) + ", has unset parameters");
            }
            gridCommand.requestJson();
            this.lastCommand = gridCommand;
            this.lastCommandOutput = outputStream == null ? this.sshChannel.executeCommand(gridCommand) : this.sshChannel.executeCommand(gridCommand, outputStream);
            int n = this.sshChannel.getLastCommandExitStatus();
            if (n != 0 && gridCommand != GridCommand.MGMT_EXAMINE && n != 67) {
                throw new GridCommandException(this.sshChannel.getLastErrorMessage(), this.lastCommand.getCommand());
            }
            if (this.lastCommandOutput.indexOf(123) >= 0) {
                this.lastCommandOutput = this.lastCommandOutput.substring(this.lastCommandOutput.indexOf(123), this.lastCommandOutput.length());
                try {
                    this.lastCommandOutputJ = new GridJsonObject(Json.createReader((Reader)new StringReader(this.lastCommandOutput)).readObject());
                }
                catch (JsonException jsonException) {
                    String string = MessageFormat.format(Messages.getString("TimesTenGrid.cannotParseJSON"), this.lastCommand.getCommand(), jsonException.getMessage());
                    logger.log(Level.SEVERE, string);
                    throw new GridCommandException(string, jsonException.getCause(), this.lastCommand.getCommand());
                }
            }
            if (bl) {
                this.validateJsonOutput();
            }
            return this.lastCommandOutputJ;
        }
        catch (MySSHException mySSHException) {
            throw new GridCommandException(mySSHException.getMessage(), mySSHException.getCause(), this.lastCommand.getCommand());
        }
    }

    public synchronized ArrayList<ExecOutput> execCommand(List<? extends Executable> list, GridCommand gridCommand, boolean bl, GridCommand.ExecMode execMode) throws GridCommandException {
        return this.execCommand(list, gridCommand, bl, execMode, 600);
    }

    public synchronized ArrayList<ExecOutput> execCommand(List<? extends Executable> list, GridCommand gridCommand, boolean bl, GridCommand.ExecMode execMode, int n) throws GridCommandException {
        if (list == null || list.isEmpty()) {
            throw new GridCommandException("No objects provided for exec", gridCommand.getCommand());
        }
        try {
            if (bl) {
                gridCommand.requestJson();
            } else {
                gridCommand.removeJsonRequest();
            }
            this.lastCommand = gridCommand;
            ArrayList<ExecOutput> arrayList = new ArrayList<ExecOutput>();
            GridJsonObject gridJsonObject = null;
            GridCommand gridCommand2 = null;
            if (list.get(0) instanceof InstanceObject) {
                gridCommand2 = GridCommand.INSTANCE_EXEC;
                gridCommand2.includeExec(list, gridCommand, n, execMode);
            } else if (list.get(0) instanceof HostObject) {
                gridCommand2 = GridCommand.HOST_EXEC;
                gridCommand2.includeExec(list, gridCommand, n, null);
            }
            this.lastCommandOutput = this.sshChannel.executeCommand(gridCommand2);
            this.lastCommandOutput = this.lastCommandOutput.substring(this.lastCommandOutput.indexOf(123), this.lastCommandOutput.length());
            if (this.sshChannel.getLastCommandExitStatus() != 0) {
                logger.warning("Error while executing: " + gridCommand2.getCommand() + ": " + this.lastCommandOutput);
            }
            try {
                gridJsonObject = new GridJsonObject(Json.createReader((Reader)new StringReader(this.lastCommandOutput)).readObject());
            }
            catch (JsonException jsonException) {
                String string = MessageFormat.format(Messages.getString("TimesTenGrid.cannotParseJSON"), gridCommand2.getCommand(), jsonException.getMessage());
                logger.log(Level.SEVERE, string);
                throw new GridCommandException(string, jsonException.getCause(), gridCommand2.getCommand());
            }
            if (gridJsonObject != null && gridJsonObject.containsKey("errmsg")) {
                String string = gridJsonObject.getString("errmsg");
                int n2 = gridJsonObject.getInt("status");
                string = Messages.getString("TimesTenGrid.code") + " " + n2 + " , " + Messages.getString("TimesTenGrid.message") + " " + string;
                throw new GridCommandException(string);
            }
            for (Executable executable : list) {
                int n3;
                ExecOutput execOutput = new ExecOutput();
                execOutput.setObject(executable);
                JsonObject jsonObject = gridJsonObject.getJsonObject("command").getJsonObject(executable.getTargetName());
                StringBuilder stringBuilder = new StringBuilder();
                try {
                    for (n3 = 0; n3 < jsonObject.getJsonArray("stderr").size(); ++n3) {
                        String string = ((JsonValue)jsonObject.getJsonArray("stderr").get(n3)).toString();
                        int n4 = string.length();
                        if (n4 <= 1 || Common.isWarning(string)) continue;
                        stringBuilder.append(string.substring(1, n4 - 1));
                        stringBuilder.append("\n");
                    }
                    execOutput.setError(stringBuilder.toString());
                }
                catch (Exception exception) {
                    execOutput.setError(null);
                }
                execOutput.setExitCode(jsonObject.getJsonNumber("code").intValue());
                if (jsonObject.getJsonNumber("code").intValue() != 0) {
                    execOutput.setOutput(execOutput.hasError() ? execOutput.getError() + "\n" : "\n");
                    logger.log(Level.INFO, executable.getTargetName() + " did not finish " + this.lastCommand.getCommand() + " successfully:" + (execOutput.hasError() ? stringBuilder.toString() : "No stderr"));
                } else {
                    stringBuilder = new StringBuilder();
                    try {
                        for (n3 = 0; n3 < jsonObject.getJsonArray("stdout").size(); ++n3) {
                            int n5 = ((JsonValue)jsonObject.getJsonArray("stdout").get(n3)).toString().length();
                            if (n5 > 1) {
                                stringBuilder.append(((JsonValue)jsonObject.getJsonArray("stdout").get(n3)).toString().substring(1, n5 - 1));
                            }
                            stringBuilder.append("\n");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    execOutput.setOutput(stringBuilder.toString());
                    if (bl) {
                        execOutput.setOutputJson();
                    }
                }
                arrayList.add(execOutput);
            }
            return arrayList;
        }
        catch (MySSHException mySSHException) {
            throw new GridCommandException(mySSHException.getMessage(), mySSHException.getCause(), this.lastCommand.getCommand());
        }
    }

    public void executeSCP(File file, String string) throws GridCommandException {
        try {
            this.lastCommand = GridCommand.SCP_CMD;
            this.sshChannel.executeSCPCommand(file, string, this.workingHost.getIPaddress());
        }
        catch (MySSHException mySSHException) {
            throw new GridCommandException(mySSHException.getMessage(), mySSHException.getCause(), this.lastCommand.getCommand());
        }
    }

    public void executeSCPRemote2Local(String string, String string2) throws GridCommandException {
        try {
            this.lastCommand = GridCommand.SCP_CMD;
            this.sshChannel.executeSCPFromRemote2LocalCommand(string2, string);
        }
        catch (MySSHException mySSHException) {
            throw new GridCommandException(mySSHException.getMessage(), mySSHException.getCause(), this.lastCommand.getCommand());
        }
    }

    public void executeSCPRemote2Local(String string, String string2, String string3) throws GridCommandException {
        try {
            this.lastCommand = GridCommand.SCP_CMD;
            this.sshChannel.executeSCPFromRemote2LocalCommand(string, string3, string2);
        }
        catch (MySSHException mySSHException) {
            throw new GridCommandException(mySSHException.getMessage(), mySSHException.getCause(), this.lastCommand.getCommand());
        }
    }

    public void executeSCP(String string, String string2, String string3) throws GridCommandException {
        try {
            this.lastCommand = GridCommand.SCP2_CMD;
            this.sshChannel.executeSCPCommand(string, string2, string3, this.workingHost.getIPaddress());
        }
        catch (MySSHException mySSHException) {
            throw new GridCommandException(mySSHException.getMessage(), mySSHException.getCause(), this.lastCommand.getCommand());
        }
    }

    public void executeSCP(File file, String string, String string2) throws GridCommandException {
        try {
            this.lastCommand = GridCommand.SCP_CMD;
            this.sshChannel.executeSCPCommand(file, string, string2, this.workingHost.getIPaddress());
        }
        catch (MySSHException mySSHException) {
            throw new GridCommandException(mySSHException.getMessage(), mySSHException.getCause(), this.lastCommand.getCommand());
        }
    }

    public void setPwd(char[] cArray) {
        this.workingHost.setPwd(cArray);
        this.sshChannel.setPwd(cArray);
    }

    public void setKeyFile(String string) {
        this.workingHost.setKeyFile(string);
        this.sshChannel.setKeyFile(string);
    }

    public void executeApplyModel(final GridObject gridObject) {
        final GridCommand gridCommand = GridCommand.PERL_APPLY_MODEL;
        gridCommand.prepareCommand("");
        String string = Messages.getString("TimesTenGrid.applyingGrid");
        String string2 = Messages.getString("TimesTenGrid.applyChanges");
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), string2, MessageFormat.format(string, gridObject.getShortName()), null);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    customProgressMonitor.start();
                    TTGridOutputStream tTGridOutputStream = new TTGridOutputStream(this);
                    GridCommandExecutor.this.executePerlScriptCommand(gridCommand, tTGridOutputStream);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    gridObject.setGridComponents(gridObject.getExecutor().executeCommandGetJson(GridCommand.EXPORT_MODEL, true), false);
                    gridObject.getGridCurrentModel().setGridComponents(gridObject.getExecutor().executeCommandGetJson(GridCommand.EXPORT_CURRENTMODEL, true), false);
                    gridObject.getGridCurrentModel().diff(gridObject);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    this.firePropertyChange("progress", null, 100);
                }
                catch (GridCommandException gridCommandException) {
                    this.firePropertyChange("error", null, gridCommandException.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                if (this.isCancelled()) {
                    String string = Messages.getString("TimesTenGrid.applyGridFailed");
                    customProgressMonitor.finish();
                    customProgressMonitor.updateMessage(string);
                } else {
                    gridObject.getGridNode().updateIcon(true);
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    public ExecOutput getConnectionInfo(String string, int n, String string2, String string3, boolean bl) throws GridCommandException {
        GridCommand gridCommand = bl ? GridCommand.PERL_GET_CONNECTION_COUNT : GridCommand.PERL_GET_CONNECTION_DETAILS;
        gridCommand.prepareCommand(string, Integer.toString(n), string2, string3);
        this.executePerlScriptCommand(gridCommand, null);
        ExecOutput execOutput = new ExecOutput();
        execOutput.setOutput(this.sshChannel.getLastCommandOutput());
        execOutput.setExitCode(this.sshChannel.getLastCommandExitStatus());
        return execOutput;
    }

    public void stopCurrentExecution() {
        this.sshChannel.forceStop();
    }

    public void disconnectSSHSession() {
        if (this.sshChannel != null) {
            this.sshChannel.forceClose();
        }
    }

    public static class ExecOutput {
        private Executable object;
        private JsonObject outputJson;
        private String output;
        private String error;
        private int exitCode;

        public int getExitCode() {
            return this.exitCode;
        }

        public void setExitCode(int n) {
            this.exitCode = n;
        }

        public Executable getObject() {
            return this.object;
        }

        public void setObject(Executable executable) {
            this.object = executable;
        }

        public JsonObject getOutputJson() {
            return this.outputJson;
        }

        public void setOutputJson() {
            if (this.output != null) {
                try {
                    this.outputJson = Json.createReader((Reader)new StringReader(this.output.replace("\\t", "\t").replace("\\\"", "\""))).readObject();
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Can not parse output to json:" + this.output.replace("\\t", "\t").replace("\\\"", "\""));
                }
            }
        }

        public String getOutput() {
            return this.output;
        }

        public void setOutput(String string) {
            this.output = string;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String string) {
            this.error = string;
        }

        public boolean hasError() {
            return this.error != null;
        }

        public void setInstanceStatus() {
            GridCommandExecutor gridCommandExecutor = TTGridRootNode.getInstance().getGrid(TTGridRootNode.getInstance().getCurrentGrid()).getExecutor();
            if (this.getExitCode() != 0) {
                ((InstanceObject)this.object).setCSState(false);
                ((InstanceObject)this.object).setDaemonStatus(false);
            } else if (!gridCommandExecutor.outputIsValid(GridCommand.TT_STATUS_DB, this.getOutput())) {
                ((InstanceObject)this.object).setCSState(false);
                ((InstanceObject)this.object).setDaemonStatus(true);
            } else {
                ((InstanceObject)this.object).setCSState(true);
                ((InstanceObject)this.object).setDaemonStatus(true);
            }
            ((InstanceObject)this.object).setStatusAvailable(true);
        }
    }

    public static class WorkingHost {
        private String ipAddress;
        private String instanceAdmin;
        private String instanceHome;
        private String instanceName;
        private String hostName;
        private SystemInfo systemInfo;
        private char[] pwd;
        private String keyFile;

        public String getIPaddress() {
            return this.ipAddress;
        }

        public String getInstanceAdmin() {
            return this.instanceAdmin;
        }

        public String getInstanceHome() {
            return this.instanceHome;
        }

        public void setInstanceHome(String string) {
            this.instanceHome = string;
            this.instanceName = new File(string).getName();
        }

        public char[] getPwd() {
            return this.pwd;
        }

        public void setPwd(char[] cArray) {
            this.pwd = cArray;
        }

        public String getKeyFile() {
            return this.keyFile;
        }

        public void setKeyFile(String string) {
            this.keyFile = string;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String string) {
            this.hostName = string;
        }

        public void updateSystemInfo(String string, String string2, String string3, String string4) {
            this.systemInfo = new SystemInfo(this.getTTEnvPath(string2 != null ? string2 : "", string4 != null ? string4 : "/"), string, string3, string4);
        }

        public void setSystemInfo(String string, String string2, String string3, String string4) {
            this.systemInfo = new SystemInfo(string, string2, string3, string4);
        }

        public SystemInfo getSystemInfo() {
            return this.systemInfo;
        }

        private String getTTEnvPath(String string, String string2) {
            String string3 = ". " + this.instanceHome + string2 + "bin" + string2 + "ttenv.sh";
            if (string.contains("csh")) {
                return "source " + this.instanceHome + string2 + "bin" + string2 + "ttenv.csh";
            }
            if (string.contains("mswin")) {
                return this.instanceHome + string2 + "bin" + string2 + "ttenv.bat";
            }
            return string3;
        }

        WorkingHost(String string, String string2, String string3, char[] cArray) {
            this.init(string, string2, string3);
            this.pwd = cArray;
        }

        WorkingHost(String string, String string2, String string3, String string4) {
            this.init(string, string2, string3);
            this.keyFile = string4;
        }

        private void init(String string, String string2, String string3) {
            this.ipAddress = string;
            this.hostName = string;
            this.instanceAdmin = string2;
            this.setInstanceHome(string3);
            this.systemInfo = new SystemInfo(this.getTTEnvPath("", "/"), "linux", "/tmp", "/");
        }

        public class SystemInfo {
            private String ttEnvPath;
            private String osName;
            private String tmpDir;
            private String fileSeparator;

            public SystemInfo(String string, String string2, String string3, String string4) {
                this.osName = string2 != null ? string2 : "linux";
                this.tmpDir = string3 != null ? string3 : "/tmp";
                this.fileSeparator = string4 != null ? string4 : "/";
                this.ttEnvPath = string != null ? string : WorkingHost.this.getTTEnvPath("", this.fileSeparator);
            }

            public String getTTEnvPath() {
                return this.ttEnvPath;
            }

            public String getOSName() {
                return this.osName;
            }

            public String getTmpDir() {
                return this.tmpDir;
            }

            public String getFileSeparator() {
                return this.fileSeparator;
            }
        }
    }
}

