/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import oracle.dbtools.raptor.controls.ShuttlePanel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.PhysicalGroupObject;

public class SelectPhysicalGroupsPanel
extends JPanel {
    private ShuttlePanel<PhysicalGroupObject> pgs;
    private GridObject grid;

    public SelectPhysicalGroupsPanel(GridObject gridObject) {
        this.grid = gridObject;
        this.initGUI();
    }

    public void initGUI() {
        this.setLayout(new GridBagLayout());
        this.pgs = new ShuttlePanel(Messages.getString("TimesTenGrid.physicalGroups"), Messages.getString("TimesTenGrid.Available"), Messages.getString("TimesTenGrid.selected"));
        this.pgs.getShuttle().remove(5);
        this.add((Component)this.pgs, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 10, 0, 10), 0, 0));
    }

    public void setSelection(List<PhysicalGroupObject> list) {
        ArrayList<PhysicalGroupObject> arrayList = new ArrayList<PhysicalGroupObject>();
        for (PhysicalGroupObject physicalGroupObject : this.grid.getPhysicalGroups()) {
            if (list.contains(physicalGroupObject)) continue;
            arrayList.add(physicalGroupObject);
        }
        this.pgs.setFromList(arrayList);
        this.pgs.setToList(list);
    }

    public List<PhysicalGroupObject> getSelected() {
        return this.pgs.getToList();
    }
}

