/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.database.BooleanAttribute;
import oracle.dbtools.raptor.timesten.grid.database.CustomAttribute;
import oracle.dbtools.raptor.timesten.grid.database.DBDefAttribute;
import oracle.dbtools.raptor.timesten.grid.database.DirectoryAttribute;
import oracle.dbtools.raptor.timesten.grid.database.EnumAttribute;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.utils.LongTextEditor;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;

public class AttributesDefinitionPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    static String[] HEADER;
    static final String[] HEADER_WR;
    static final String[] HEADER_RO;
    static final String CUSTOM_ATTRIBUTE = "";
    static final int ATTRIBUTE_COLUMN_INDEX = 0;
    static final int VALUE_COLUMN_INDEX = 1;
    static final int DEFINITION_COLUMN_INDEX = 2;
    static final int STATUS_COLUMN_INDEX = 3;
    private ArrayList<DBDefAttribute> selectedAttributes = new ArrayList();
    private ArrayList<DBDefAttribute> availableAttributes;
    private boolean readOnly;
    private boolean addCustomAttrOption;
    private boolean kSafeEnabled;
    private JTable _table;
    private JButton _addButton;
    private JButton _deleteButton;
    private JComboBox<DBDefAttribute> _availableAttributesComboBox;
    private JScrollPane _scrollPane;
    private DBDefTableModel _model;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private ValueCellEditor vce;
    private DBDefAttribute.DBDefAttributeType type;
    private String dbNameSuffix;

    public void enableAllComponents(boolean bl) {
        if (this._table != null) {
            this._table.setEnabled(bl);
        }
        if (this._addButton != null) {
            this._addButton.setEnabled(bl);
        }
        if (this._deleteButton != null) {
            this._deleteButton.setEnabled(bl);
        }
        if (this._availableAttributesComboBox != null) {
            this._availableAttributesComboBox.setEnabled(bl);
        }
    }

    public AttributesDefinitionPanel(boolean bl, boolean bl2, DBDefAttribute.DBDefAttributeType dBDefAttributeType, GridObject gridObject) {
        this(bl, bl2, dBDefAttributeType, gridObject, null);
    }

    public AttributesDefinitionPanel(boolean bl, boolean bl2, DBDefAttribute.DBDefAttributeType dBDefAttributeType, GridObject gridObject, List<String> list) {
        this.type = dBDefAttributeType;
        if (bl) {
            this.initGUIRO();
        } else {
            this.addCustomAttrOption = bl2;
            if (gridObject != null) {
                this.availableAttributes = gridObject.getAttributesUtil().getAttributes(dBDefAttributeType);
            }
            for (int i = 0; i < this.availableAttributes.size() && list != null; ++i) {
                if (!list.contains(this.availableAttributes.get(i).getAttribute())) continue;
                this.availableAttributes.remove(i);
            }
            this.kSafeEnabled = gridObject.getProperties().getK() > 1;
            this.initGUIWR();
            this.addDefaultAttributes();
        }
    }

    public DBDefAttribute.DBDefAttributeType getType() {
        return this.type;
    }

    public void update(List<DBDefAttribute> list) {
        this.selectedAttributes = (ArrayList)list;
        if (SwingUtilities.isEventDispatchThread()) {
            TableColumnSizer.setColumnsWidthToFit(this._table, true, true);
            this._model.fireTableDataChanged();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TableColumnSizer.setColumnsWidthToFit(AttributesDefinitionPanel.this._table, true, true);
                        AttributesDefinitionPanel.this._model.fireTableDataChanged();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                this.logger.log(Level.INFO, exception.getMessage());
            }
        }
    }

    public void clearTable() {
        this.selectedAttributes.clear();
        this.update(this.selectedAttributes);
    }

    private void initGUIWR() {
        this.setLayout(new GridBagLayout());
        HEADER = HEADER_WR;
        this.readOnly = false;
        this._addButton = new JButton(Messages.getString("TimesTenGrid.add"));
        this._addButton.setName(Messages.getString("TimesTenGrid.add"));
        this._addButton.addActionListener(this);
        this._deleteButton = new JButton(Messages.getString("TimesTenGrid.delete"));
        this._deleteButton.setName(Messages.getString("TimesTenGrid.delete"));
        this._deleteButton.addActionListener(this);
        this._availableAttributesComboBox = new JComboBox();
        this._availableAttributesComboBox.setName("_availableAttributesComboBox");
        for (DBDefAttribute object2 : this.availableAttributes) {
            if (object2.isMandatory()) continue;
            this._availableAttributesComboBox.addItem(object2);
        }
        if (this.addCustomAttrOption) {
            this._availableAttributesComboBox.addItem(new CustomAttribute(Messages.getString("TimesTenGrid.customAttribute"), CUSTOM_ATTRIBUTE));
        }
        this._model = new DBDefTableModel();
        this._table = new JTable(this._model){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = AttributesDefinitionPanel.CUSTOM_ATTRIBUTE;
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                try {
                    string = n2 == 1 && AttributesDefinitionPanel.this.selectedAttributes.get(n) instanceof EnumAttribute ? ((EnumAttribute)AttributesDefinitionPanel.this.selectedAttributes.get(n)).getEnumValueDescription() : AttributesDefinitionPanel.this._table.getValueAt(n, n2).toString();
                }
                catch (RuntimeException runtimeException) {
                    AttributesDefinitionPanel.this.logger.log(Level.INFO, "Attribute description:" + runtimeException.getMessage());
                }
                return string;
            }
        };
        this._table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("TimesTenGrid.delete"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributesDefinitionPanel.this.removeAttributes(AttributesDefinitionPanel.this._table.getSelectedRows(), true);
            }
        });
        jPopupMenu.add(jMenuItem);
        this._table.setComponentPopupMenu(jPopupMenu);
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        tableColumnModel.getColumn(1).setCellRenderer(new MyCellRenderer());
        TableColumn tableColumn = this._table.getColumnModel().getColumn(1);
        this.vce = new ValueCellEditor();
        tableColumn.setCellEditor(this.vce);
        this._scrollPane = new JScrollPane(this._table);
        this.add(this._availableAttributesComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this._addButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 22, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this._deleteButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        TableColumnSizer.setColumnsWidthToFit(this._table, true, true);
    }

    private void initGUIRO() {
        this.setLayout(new GridBagLayout());
        HEADER = HEADER_RO;
        this.readOnly = true;
        this._model = new DBDefTableModel();
        this._table = new JTable(this._model){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = AttributesDefinitionPanel.CUSTOM_ATTRIBUTE;
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                try {
                    string = n2 == 1 && AttributesDefinitionPanel.this.selectedAttributes.get(n) instanceof EnumAttribute ? ((EnumAttribute)AttributesDefinitionPanel.this.selectedAttributes.get(n)).getEnumValueDescription() : AttributesDefinitionPanel.this._table.getValueAt(n, n2).toString();
                }
                catch (RuntimeException runtimeException) {
                    AttributesDefinitionPanel.this.logger.log(Level.SEVERE, "Attribute description:" + runtimeException.getMessage());
                }
                return string;
            }
        };
        this._table.setRowSelectionAllowed(false);
        this._table.setColumnSelectionAllowed(false);
        this._table.setCellSelectionEnabled(false);
        this._scrollPane = new JScrollPane(this._table);
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        TableColumnSizer.setColumnsWidthToFit(this._table, true, true);
    }

    public void setAutoresizeTableOff() {
        this._table.setAutoResizeMode(0);
    }

    private void addDefaultAttributes() {
        for (DBDefAttribute dBDefAttribute : this.availableAttributes) {
            if (!dBDefAttribute.isMandatory()) continue;
            this.addAttribute(dBDefAttribute, -1, false, true);
        }
        this._model.fireTableDataChanged();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._addButton) {
            DBDefAttribute dBDefAttribute = (DBDefAttribute)this._availableAttributesComboBox.getSelectedItem();
            if (dBDefAttribute.getAttributeType() == DBDefAttribute.DBDefAttributeType.CUSTOM) {
                this.addAttribute(new CustomAttribute(CUSTOM_ATTRIBUTE, CUSTOM_ATTRIBUTE), -1, true, false);
            } else {
                this.addAttribute(dBDefAttribute, -1, true, true);
            }
        } else if (actionEvent.getSource() == this._deleteButton) {
            this.removeAttributes(this._table.getSelectedRows(), true);
        }
    }

    private void addAttribute(DBDefAttribute dBDefAttribute, int n, boolean bl, boolean bl2) {
        if (this.selectedAttributes.contains(dBDefAttribute)) {
            String string = Messages.getString("TimesTenGrid.repeatedAttribute");
            Common.displayErrorMsg(this, string);
            return;
        }
        if (bl2) {
            if (dBDefAttribute.getAttribute().equalsIgnoreCase("DurablePrepareToCommit")) {
                if (this.kSafeEnabled) {
                    dBDefAttribute.setValueFromString("0");
                } else {
                    dBDefAttribute.setValueFromString("1");
                }
            } else {
                dBDefAttribute.setValueToDefault();
            }
        }
        if (n == -1) {
            this.selectedAttributes.add(dBDefAttribute);
        } else if (n > 0 && n < this.selectedAttributes.size() - 1) {
            this.selectedAttributes.add(n, dBDefAttribute);
        }
        if (bl) {
            this._model.fireTableDataChanged();
        }
    }

    private void removeAttributes(int[] nArray, boolean bl) {
        Arrays.sort(nArray);
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (this.selectedAttributes.get(nArray[i]).isMandatory()) continue;
            this.selectedAttributes.remove(nArray[i]);
        }
        if (bl) {
            this._model.fireTableDataChanged();
        }
    }

    public ArrayList<DBDefAttribute> getSelectedAttributes() {
        return this.selectedAttributes;
    }

    public boolean setAttributeValue(String string, String string2) {
        for (DBDefAttribute dBDefAttribute : this.selectedAttributes) {
            if (!dBDefAttribute.getAttribute().equalsIgnoreCase(string)) continue;
            dBDefAttribute.setValueFromString(string2);
            return true;
        }
        for (DBDefAttribute dBDefAttribute : this.availableAttributes) {
            if (dBDefAttribute.getAttributeType() == DBDefAttribute.DBDefAttributeType.CUSTOM || !dBDefAttribute.getAttribute().equalsIgnoreCase(string)) continue;
            dBDefAttribute.setValueFromString(string2);
            this.addAttribute(dBDefAttribute, -1, true, false);
            return true;
        }
        return false;
    }

    public void addCustomAttribute(String string, String string2) {
        CustomAttribute customAttribute = new CustomAttribute(string, CUSTOM_ATTRIBUTE);
        customAttribute.setValue(string2);
        this.addAttribute(customAttribute, -1, true, false);
    }

    public boolean areAttributesValid() {
        for (DBDefAttribute dBDefAttribute : this.selectedAttributes) {
            if (dBDefAttribute.isValid()) continue;
            return false;
        }
        return true;
    }

    public void setDBNameAsSuffix(String string) {
        this.dbNameSuffix = "/" + string;
        this.vce.setDBNameSuffix(this.dbNameSuffix, false);
    }

    public void setDBNameAsSuffix(String string, boolean bl) {
        this.dbNameSuffix = "/" + string;
        this.vce.setDBNameSuffix(this.dbNameSuffix, bl);
    }

    public void setLogDir(String string) {
        this.vce.setLogDir(string);
    }

    static {
        HEADER_WR = new String[]{Messages.getString("TimesTenGrid.attributeColumn"), Messages.getString("TimesTenGrid.valueColumn"), Messages.getString("TimesTenGrid.definitionColumn"), Messages.getString("TimesTen.common.status")};
        HEADER_RO = new String[]{Messages.getString("TimesTenGrid.attributeColumn"), Messages.getString("TimesTenGrid.valueColumn")};
    }

    private static class MyCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private MyCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (jTable.getValueAt(n, 0).toString().equalsIgnoreCase("PWDCrypt")) {
                if (object.toString().isEmpty()) {
                    jLabel.setText(AttributesDefinitionPanel.CUSTOM_ATTRIBUTE);
                } else {
                    jLabel.setText("******");
                }
            } else if (object != null) {
                jLabel.setText(object.toString());
            }
            return jLabel;
        }
    }

    private class DBDefTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private DBDefTableModel() {
        }

        @Override
        public int getRowCount() {
            return AttributesDefinitionPanel.this.selectedAttributes.size();
        }

        @Override
        public int getColumnCount() {
            return HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (AttributesDefinitionPanel.this.readOnly) {
                switch (n2) {
                    case 0: {
                        return ((DBDefAttribute)AttributesDefinitionPanel.this.selectedAttributes.get(n)).getAttribute();
                    }
                    case 1: {
                        if (((DBDefAttribute)AttributesDefinitionPanel.this.selectedAttributes.get(n)).getAttribute().equalsIgnoreCase("PWDCrypt")) {
                            return "*****";
                        }
                        return ((DBDefAttribute)AttributesDefinitionPanel.this.selectedAttributes.get(n)).getValueAsString();
                    }
                }
                return null;
            }
            switch (n2) {
                case 0: {
                    return ((DBDefAttribute)AttributesDefinitionPanel.this.selectedAttributes.get(n)).getAttribute();
                }
                case 1: {
                    return ((DBDefAttribute)AttributesDefinitionPanel.this.selectedAttributes.get(n)).getValueAsString();
                }
                case 2: {
                    return ((DBDefAttribute)AttributesDefinitionPanel.this.selectedAttributes.get(n)).getDefinition();
                }
                case 3: {
                    if (((DBDefAttribute)AttributesDefinitionPanel.this.selectedAttributes.get(n)).isValid()) {
                        return Messages.getString("TimesTenGrid.validAttribute");
                    }
                    return ((DBDefAttribute)AttributesDefinitionPanel.this.selectedAttributes.get(n)).getErrorMessage();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (AttributesDefinitionPanel.this.readOnly) {
                return false;
            }
            if (n2 == 3) {
                return false;
            }
            return n2 != 2 && n2 != 0 || ((DBDefAttribute)AttributesDefinitionPanel.this.selectedAttributes.get(n)).getAttributeType() == DBDefAttribute.DBDefAttributeType.CUSTOM;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 0: {
                    ((DBDefAttribute)AttributesDefinitionPanel.this.selectedAttributes.get(n)).setAttribute((String)object);
                    break;
                }
                case 1: {
                    ((DBDefAttribute)AttributesDefinitionPanel.this.selectedAttributes.get(n)).setValueFromString(((String)object).trim());
                    break;
                }
                case 2: {
                    ((DBDefAttribute)AttributesDefinitionPanel.this.selectedAttributes.get(n)).setDefinition(((String)object).trim());
                }
            }
            this.fireTableDataChanged();
        }
    }

    private class ValueCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        private JComboBox<String> _enumAttributeComboBox;
        private JComboBox<String> _booleanAttributeComboBox;
        private JPasswordField _pwdField;
        private JTextField _genericAttrTextField;
        private LongTextEditor _dataStoreAttrTextField;
        private LongTextEditor _logDirAttrTextField;
        private final String YES_OPTION = Messages.getString("TimesTen.common.yes");
        private final String NO_OPTION = Messages.getString("TimesTen.common.no");
        private DocumentFilter DSDocFilter;
        private DirectoryAttribute logDir;
        private boolean useFilter;

        public void setDBNameSuffix(String string, boolean bl) {
            Object object2;
            this.useFilter = false;
            DBDefAttribute dBDefAttribute = null;
            for (Object object2 : AttributesDefinitionPanel.this.selectedAttributes) {
                if (!((DBDefAttribute)object2).getAttribute().equalsIgnoreCase("datastore")) continue;
                dBDefAttribute = object2;
                break;
            }
            int n = dBDefAttribute.getValueAsString().lastIndexOf("/");
            if (bl) {
                if (!dBDefAttribute.getValueAsString().endsWith(string)) {
                    object2 = dBDefAttribute.getValueAsString().substring(0, n);
                    dBDefAttribute.setValueFromString((String)object2 + string);
                }
            } else if (n == -1) {
                dBDefAttribute.setValueFromString(string);
            } else {
                object2 = dBDefAttribute.getValueAsString().substring(0, n);
                dBDefAttribute.setValueFromString((String)object2 + string);
            }
            this._dataStoreAttrTextField.setText(dBDefAttribute.getValueAsString());
            AttributesDefinitionPanel.this._model.fireTableDataChanged();
            this.useFilter = true;
        }

        public ValueCellEditor() {
            this.init();
        }

        public void setLogDir(String string) {
            this._logDirAttrTextField.setText(string);
        }

        private void changeLogDir(String string) {
            if (this.logDir == null) {
                for (DBDefAttribute dBDefAttribute : AttributesDefinitionPanel.this.selectedAttributes) {
                    if (!dBDefAttribute.getAttribute().equalsIgnoreCase("LogDir")) continue;
                    this.logDir = (DirectoryAttribute)dBDefAttribute;
                    break;
                }
            }
            if (this.logDir != null) {
                this.logDir.setValue(string);
            }
        }

        private void init() {
            this._enumAttributeComboBox = new JComboBox();
            this._booleanAttributeComboBox = new JComboBox<String>(new String[]{this.YES_OPTION, this.NO_OPTION});
            this._genericAttrTextField = new JTextField(AttributesDefinitionPanel.CUSTOM_ATTRIBUTE);
            this._dataStoreAttrTextField = new LongTextEditor(true);
            this._logDirAttrTextField = new LongTextEditor();
            this._pwdField = new JPasswordField();
            this._genericAttrTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    String string = ((DBDefAttribute)AttributesDefinitionPanel.this.selectedAttributes.get(AttributesDefinitionPanel.this._table.getSelectedRow())).getValueAsString();
                    ValueCellEditor.this._genericAttrTextField.setText(string);
                }
            });
            this.DSDocFilter = new DocumentFilter(){

                @Override
                public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                    if (!ValueCellEditor.this.useFilter) {
                        super.insertString(filterBypass, n, string, attributeSet);
                        return;
                    }
                    int n2 = ValueCellEditor.this._dataStoreAttrTextField.getText().length() - AttributesDefinitionPanel.this.dbNameSuffix.length();
                    if (n > n2) {
                        ValueCellEditor.this._dataStoreAttrTextField.setCaretPosition(n2);
                        n = n2;
                    }
                    super.insertString(filterBypass, n, string, attributeSet);
                }

                @Override
                public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                    if (!ValueCellEditor.this.useFilter) {
                        super.replace(filterBypass, n, n2, string, attributeSet);
                        return;
                    }
                    int n3 = ValueCellEditor.this._dataStoreAttrTextField.getText().length() - AttributesDefinitionPanel.this.dbNameSuffix.length();
                    if (n > n3) {
                        ValueCellEditor.this._dataStoreAttrTextField.setCaretPosition(n3);
                        n = n3;
                    }
                    if (n + n2 > n3) {
                        n2 = n3 - n;
                        ValueCellEditor.this._dataStoreAttrTextField.setCaretPosition(n3);
                    }
                    super.replace(filterBypass, n, n2, string, attributeSet);
                }

                @Override
                public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
                    if (!ValueCellEditor.this.useFilter) {
                        super.remove(filterBypass, n, n2);
                        return;
                    }
                    int n3 = ValueCellEditor.this._dataStoreAttrTextField.getText().length() - AttributesDefinitionPanel.this.dbNameSuffix.length();
                    if (n >= n3) {
                        return;
                    }
                    if (n + n2 > n3) {
                        n2 = n3 - n;
                    }
                    if (n2 > 0) {
                        super.remove(filterBypass, n, n2);
                    }
                }
            };
            ((AbstractDocument)this._dataStoreAttrTextField.getDocument()).setDocumentFilter(this.DSDocFilter);
            this._dataStoreAttrTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    super.focusGained(focusEvent);
                    int n = ValueCellEditor.this._dataStoreAttrTextField.getText().length() - AttributesDefinitionPanel.this.dbNameSuffix.length();
                    if (ValueCellEditor.this._dataStoreAttrTextField.getCaretPosition() > n) {
                        ValueCellEditor.this._dataStoreAttrTextField.setCaretPosition(n);
                    }
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    super.focusLost(focusEvent);
                    int n = ValueCellEditor.this._dataStoreAttrTextField.getText().length() - AttributesDefinitionPanel.this.dbNameSuffix.length();
                    ValueCellEditor.this.changeLogDir(ValueCellEditor.this._dataStoreAttrTextField.getText().substring(0, n + 1));
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            DBDefAttribute dBDefAttribute = (DBDefAttribute)AttributesDefinitionPanel.this.selectedAttributes.get(AttributesDefinitionPanel.this._table.getSelectedRow());
            if (dBDefAttribute instanceof EnumAttribute) {
                return this._enumAttributeComboBox.getSelectedItem();
            }
            if (dBDefAttribute instanceof BooleanAttribute) {
                return this._booleanAttributeComboBox.getSelectedItem();
            }
            if (dBDefAttribute.getAttribute().equalsIgnoreCase("PWDCrypt")) {
                return new String(this._pwdField.getPassword());
            }
            if (dBDefAttribute.getAttribute().equalsIgnoreCase("datastore")) {
                return this._dataStoreAttrTextField.getText();
            }
            if (dBDefAttribute.getAttribute().equalsIgnoreCase("logdir")) {
                return this._logDirAttrTextField.getText();
            }
            return this._genericAttrTextField.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            DBDefAttribute dBDefAttribute = (DBDefAttribute)AttributesDefinitionPanel.this.selectedAttributes.get(n);
            if (dBDefAttribute instanceof EnumAttribute) {
                EnumAttribute enumAttribute = (EnumAttribute)dBDefAttribute;
                this._enumAttributeComboBox.removeAllItems();
                for (String string : enumAttribute.isShowDefinition() ? enumAttribute.getValues() : enumAttribute.getDbDefValues()) {
                    this._enumAttributeComboBox.addItem(string);
                }
                this._enumAttributeComboBox.setSelectedItem(((EnumAttribute)dBDefAttribute).getValueAsString());
                return this._enumAttributeComboBox;
            }
            if (dBDefAttribute instanceof BooleanAttribute) {
                return this._booleanAttributeComboBox;
            }
            if (dBDefAttribute.getAttribute().equalsIgnoreCase("PWDCrypt")) {
                return this._pwdField;
            }
            if (dBDefAttribute.getAttribute().equalsIgnoreCase("datastore")) {
                this.useFilter = true;
                return this._dataStoreAttrTextField;
            }
            if (dBDefAttribute.getAttribute().equalsIgnoreCase("logdir")) {
                return this._logDirAttrTextField;
            }
            return this._genericAttrTextField;
        }
    }
}

