/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;

public class HostSummaryPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private HostObject hostData;
    private final String[] HEADER = new String[]{Messages.getString("TimesTenGrid.attributeColumn"), Messages.getString("TimesTenGrid.valueColumn")};
    private static final int I_ADDRESS_ROW = 0;
    private static final int E_ADDRESS_ROW = 1;
    private static final int DSG_ROW = 2;
    private static final int PGS_ROW = 3;
    private static final Logger logger = Logger.getLogger(HostSummaryPanel.class.getName());
    private static final int ROWS = 4;
    private SummaryTableModel _model;
    private JTable _table;
    private JScrollPane _scrollPane;

    public HostSummaryPanel() {
        this.initGUI();
    }

    public void initGUI() {
        this.setLayout(new GridBagLayout());
        this._model = new SummaryTableModel();
        this._table = new JTable(this._model){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                try {
                    string = HostSummaryPanel.this._table.getValueAt(n, n2).toString();
                }
                catch (RuntimeException runtimeException) {
                    logger.log(Level.SEVERE, runtimeException.getMessage());
                }
                return string;
            }
        };
        this._table.setAutoResizeMode(0);
        this._table.setRowSelectionAllowed(false);
        this._table.setColumnSelectionAllowed(false);
        this._scrollPane = new JScrollPane(this._table);
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    public void updateHostInfo(HostObject hostObject) {
        this.hostData = hostObject;
        if (SwingUtilities.isEventDispatchThread()) {
            TableColumnSizer.setColumnsWidthToFit(this._table, true, true);
            this._model.fireTableDataChanged();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TableColumnSizer.setColumnsWidthToFit(HostSummaryPanel.this._table, true, true);
                        HostSummaryPanel.this._model.fireTableDataChanged();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                logger.log(Level.INFO, exception.getMessage());
            }
        }
    }

    private class SummaryTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private SummaryTableModel() {
        }

        @Override
        public int getRowCount() {
            return 4;
        }

        @Override
        public int getColumnCount() {
            return HostSummaryPanel.this.HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n) {
                case 0: {
                    return n2 == 0 ? Messages.getString("TimesTenGrid.hostIAddress") : HostSummaryPanel.this.hostData.getInternalAddress();
                }
                case 1: {
                    return n2 == 0 ? Messages.getString("TimesTenGrid.hostEAddress") : HostSummaryPanel.this.hostData.getExternalAddress();
                }
                case 2: {
                    return n2 == 0 ? Messages.getString("TimesTenGrid.hostDSG") : (HostSummaryPanel.this.hostData.getDataSpaceGroup() > 0 ? Integer.valueOf(HostSummaryPanel.this.hostData.getDataSpaceGroup()) : Messages.getString("TimesTen.common.none"));
                }
                case 3: {
                    return n2 == 0 ? Messages.getString("TimesTenGrid.physicalGroups") : HostSummaryPanel.this.hostData.getPhysicalGroupsString();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            return HostSummaryPanel.this.HEADER[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

