/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.GridCommandExecutor;
import oracle.dbtools.raptor.timesten.grid.editors.InstanceStatusPanel;
import oracle.dbtools.raptor.timesten.grid.editors.InstanceSummaryPanel;
import oracle.dbtools.raptor.timesten.grid.editors.TTBaseEditor;
import oracle.dbtools.raptor.timesten.grid.navigator.AbstractNode;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;

public class InstanceEditor
extends TTBaseEditor
implements Controller {
    private HostObject currentHost = null;
    private InstanceObject currentInstance = null;
    private static final Logger logger = Logger.getLogger(InstanceEditor.class.getName());
    private InstanceSummaryPanel _summaryPanel;
    private InstanceStatusPanel _statusPanel;

    public InstanceEditor() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        if (!this.initialized) {
            this._summaryPanel = new InstanceSummaryPanel();
            this._statusPanel = new InstanceStatusPanel();
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.summary"), this._summaryPanel);
            this._tabbedPane.addTab(Messages.getString("TimesTen.common.status"), this._statusPanel);
            this.helpInfo = new HelpInfo(TimesTenHelpID.INSTANCE_EDITOR.toString());
            this.initialized = true;
        }
    }

    @Override
    public void updateContent() {
        this.currentHost = this.currentGrid.getHost(TTGridRootNode.getInstance().getCurrentHost());
        this.currentInstance = this.currentGrid.getInstance(this.currentHost, this.context.getNode().getShortLabel());
        if (this.currentInstance == null) {
            this.currentInstance = this.currentGrid.getInstance(this.context.getNode().getShortLabel().substring(0, this.context.getNode().getShortLabel().lastIndexOf(".")), this.context.getNode().getShortLabel().substring(this.context.getNode().getShortLabel().lastIndexOf(".") + 1));
        }
        ((AbstractNode)this.context.getNode()).setLongLabel(this.currentInstance.getFullName());
        if (!this.currentInstance.isStatusAvailable()) {
            this.refreshInfo(this::viewTabs);
        } else {
            this.viewTabs();
        }
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == REFRESH_ID) {
            this.refreshInfo(this::viewTabs);
            return true;
        }
        return false;
    }

    public void refreshInfo(final Runnable runnable) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){
            StringBuilder errorMessage;
            GridCommandExecutor gridCmdExec;
            {
                super(string, bl, iRaptorTaskRunMode);
                this.errorMessage = new StringBuilder("");
                this.gridCmdExec = InstanceEditor.this.currentGrid.getExecutor();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected Void doWork() throws TaskException {
                JsonObject jsonObject = null;
                GridCommand gridCommand = null;
                try {
                    JsonObject jsonObject2;
                    jsonObject = InstanceEditor.this.currentGrid.getSynchronizedWithModel(true);
                    if (!InstanceEditor.this.currentGrid.updateHostModel(jsonObject, InstanceEditor.this.currentInstance.getHost().getName())) {
                        throw new GridCommandException(Messages.getString("TimesTenGrid.instanceNotExistent"));
                    }
                    if (InstanceEditor.this.currentInstance.isAppliedToCurrent()) {
                        gridCommand = GridCommand.TT_STATUS_ALL;
                        jsonObject2 = this.gridCmdExec.execCommand(Arrays.asList(InstanceEditor.this.currentInstance), gridCommand, false, InstanceEditor.this.currentInstance.isMgmtInstance() ? GridCommand.ExecMode.MGMT : GridCommand.ExecMode.DATA);
                        for (GridCommandExecutor.ExecOutput execOutput : jsonObject2) {
                            execOutput.setInstanceStatus();
                        }
                    } else {
                        InstanceEditor.this.currentInstance.setCSState(false);
                        InstanceEditor.this.currentInstance.setDaemonStatus(false);
                        InstanceEditor.this.currentInstance.setStatusAvailable(false);
                    }
                    if (InstanceEditor.this.currentInstance.isMgmtInstance()) {
                        gridCommand = GridCommand.MGMT_EXAMINE;
                        jsonObject2 = InstanceEditor.this.currentGrid.getExecutor().executeCommandGetJson(gridCommand, true);
                        InstanceEditor.this.currentGrid.updateMgmInstancesModel(jsonObject2);
                    }
                }
                catch (JsonException | GridCommandException throwable) {
                    this.errorMessage.append(throwable.getMessage());
                    for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
                        if (!(editor instanceof InstanceEditor)) continue;
                        List<Editor> list = Arrays.asList(editor);
                        if (!SwingUtilities.isEventDispatchThread()) {
                            try {
                                SwingUtilities.invokeAndWait(() -> EditorManager.getEditorManager().closeEditors(list));
                            }
                            catch (InterruptedException | InvocationTargetException exception) {
                                logger.log(Level.SEVERE, exception.getMessage());
                            }
                            break;
                        }
                        EditorManager.getEditorManager().closeEditors(list);
                        break;
                    }
                }
                if (!this.errorMessage.toString().isEmpty()) {
                    logger.log(Level.SEVERE, this.errorMessage.toString());
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), this.errorMessage.toString());
                    return null;
                }
                runnable.run();
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(MessageFormat.format(Messages.getString("TimesTenGrid.updateInstanceInfoTask"), this.currentInstance.getFullName()));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void viewTabs() {
        this.currentHost = this.currentGrid.getHost(this.currentHost.getName());
        this.currentInstance = this.currentHost.getInstance(this.currentInstance.getName());
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    this._summaryPanel.updateInstanceInfo(this.currentInstance);
                    this._statusPanel.updateInstanceInfo(this.currentInstance);
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                logger.log(Level.SEVERE, "Exception while updating instance panels:" + exception.getMessage());
            }
        } else {
            this._summaryPanel.updateInstanceInfo(this.currentInstance);
            this._statusPanel.updateInstanceInfo(this.currentInstance);
        }
    }
}

