/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.editors.SummaryPanel;
import oracle.dbtools.raptor.timesten.grid.editors.TTBaseEditor;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.help.HelpInfo;

public class InstanceFolderEditor
extends TTBaseEditor {
    private InstanceSummaryPanel _summaryPanel;
    private HostObject currentHost;
    private InstanceObject selectedInstance = null;
    static List<String> ATTRIBUTES = new ArrayList<String>();

    public InstanceFolderEditor() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        if (!this.initialized) {
            this._summaryPanel = new InstanceSummaryPanel();
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.summary"), this._summaryPanel);
            this.helpInfo = new HelpInfo(TimesTenHelpID.INSTANCE_FOLDER_EDITOR.toString());
            this.initialized = true;
        }
    }

    @Override
    public void updateContent() {
        this.refreshInstances();
        this._summaryPanel.updateInfo();
    }

    private void refreshInstances() {
        boolean bl = this.currentHost == null;
        this.currentHost = this.currentGrid.getHost(TTGridRootNode.getInstance().getCurrentHost());
        Collections.sort(this.currentHost.getInstances(), Common.INSTANCE_ORDER);
        if (bl) {
            this._summaryPanel.updateInstList();
        }
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        super.handleEvent(ideAction, context);
        if (ideAction.getCommandId() == REFRESH_ID) {
            this.updateContent();
            return true;
        }
        return false;
    }

    static {
        ATTRIBUTES.add(Messages.getString("TimesTenGrid.instanceName"));
        ATTRIBUTES.add(Messages.getString("TimesTenGrid.instHome"));
        ATTRIBUTES.add(Messages.getString("TimesTenGrid.instType"));
        ATTRIBUTES.add("");
        ATTRIBUTES.add(Messages.getString("TimesTenGrid.installation"));
        ATTRIBUTES.add(Messages.getString("TimesTenGrid.installLoc"));
        ATTRIBUTES.add(Messages.getString("TimesTenGrid.installSrc"));
        ATTRIBUTES.add(Messages.getString("TimesTenGrid.installRelease"));
    }

    private class InstanceSummaryPanel
    extends JPanel
    implements ListSelectionListener {
        private JPanel _leftPanel;
        private JList<String> _instList;
        private JScrollPane _scrollPane;
        private DefaultListModel<String> _listModel;
        private SummaryPanel _summPanel;

        public InstanceSummaryPanel() {
            this.init();
        }

        private void init() {
            this.setLayout(new BorderLayout());
            this.initLeftPanel();
            this.initRightPanel();
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)this._leftPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
            jPanel.add((Component)this._summPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)jPanel, "First");
        }

        private void initRightPanel() {
            this._summPanel = new SummaryPanel();
            this._summPanel.setEmptyBorderOnScrollPane();
        }

        private void initLeftPanel() {
            this._leftPanel = new JPanel(new GridBagLayout());
            this._leftPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.instances")));
            this._instList = new JList();
            this._instList.getSelectionModel().setSelectionMode(0);
            this._instList.addListSelectionListener(this);
            this._scrollPane = new JScrollPane(this._instList, 20, 30);
            this._leftPanel.add((Component)this._scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.updateInstList();
        }

        public void updateInstList() {
            this._listModel = new DefaultListModel();
            this._instList.setModel(this._listModel);
            if (InstanceFolderEditor.this.currentHost == null || InstanceFolderEditor.this.currentHost.getInstances() == null) {
                return;
            }
            for (InstanceObject instanceObject : InstanceFolderEditor.this.currentHost.getInstances()) {
                this._listModel.addElement(instanceObject.getName());
            }
            if (this._instList.getSelectionModel().getMaxSelectionIndex() == -1) {
                this._instList.getSelectionModel().setSelectionInterval(0, 0);
            }
        }

        public void updateInfo() {
            ArrayList arrayList = InstanceFolderEditor.this.currentHost.getInstances().isEmpty() ? new ArrayList() : new ArrayList<String>(ATTRIBUTES);
            List<String> list = this.getValues();
            InstanceFolderEditor.this.context.setProperty("SummaryAttr", arrayList);
            InstanceFolderEditor.this.context.setProperty("SummaryVals", list);
            this._summPanel.loadContent(InstanceFolderEditor.this.context);
        }

        public List<String> getValues() {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = ATTRIBUTES.size();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                arrayList.add("");
            }
            if (InstanceFolderEditor.this.selectedInstance != null) {
                arrayList.set(n2++, InstanceFolderEditor.this.selectedInstance.getName());
                arrayList.set(n2++, InstanceFolderEditor.this.selectedInstance.getHome());
                arrayList.set(n2++, InstanceFolderEditor.this.selectedInstance.isMgmtInstance() ? Messages.getString("TimesTenGrid.management") : Messages.getString("TimesTenGrid.data"));
                arrayList.set(n2++, "");
                arrayList.set(n2++, InstanceFolderEditor.this.selectedInstance.getInstallation().getName());
                arrayList.set(n2++, InstanceFolderEditor.this.selectedInstance.getInstallation().getLocation());
                arrayList.set(n2++, InstanceFolderEditor.this.selectedInstance.getInstallation().getSource());
                arrayList.set(n2++, InstanceFolderEditor.this.selectedInstance.getInstallation().getSourceRelease());
            }
            return arrayList;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = this._instList.getSelectedIndex();
            if (n >= 0 && n < this._listModel.getSize()) {
                InstanceFolderEditor.this.selectedInstance = InstanceFolderEditor.this.currentHost.getInstance(this._listModel.get(n));
            } else {
                InstanceFolderEditor.this.selectedInstance = null;
            }
            InstanceFolderEditor.this.updateContent();
        }
    }
}

