/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.installations;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonException;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.InstallationObject;
import oracle.ide.Ide;

public class InstallationDeletePanel
extends TTGUIBasePanel {
    private static Logger _logger = Logger.getLogger(InstallationDeletePanel.class.getPackage().getName());
    private InstallationObject installation;
    private JLabel _label;

    public InstallationDeletePanel(InstallationObject installationObject) {
        this.installation = installationObject;
        this._label = new JLabel(MessageFormat.format(Messages.getString("TimesTenGrid.installationDeleteConfirmation"), installationObject.getFullName()));
        this.add((Component)this._label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.deleteInstallation();
    }

    private void deleteInstallation() {
        this._progressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.installationDelete"), MessageFormat.format(Messages.getString("TimesTenGrid.installationDelete"), this.installation.getFullName()), null);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    GridMouseListener.expander.saveExpansionState();
                    InstallationDeletePanel.this._progressMonitor.start();
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.installationDeleting"), InstallationDeletePanel.this.installation.getFullName()));
                    GridCommand gridCommand = GridCommand.INSTALLATION_DELETE;
                    gridCommand.prepareCommand(InstallationDeletePanel.this.installation.getHost().getName(), InstallationDeletePanel.this.installation.getName());
                    InstallationDeletePanel.this.grid.getExecutor().executeCommandGetString(gridCommand, false);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    InstallationDeletePanel.this.grid.setGridComponents(InstallationDeletePanel.this.grid.getExecutor().executeCommandGetJson(GridCommand.EXPORT_MODEL, true), false);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    this.firePropertyChange("progress", null, 100);
                }
                catch (JsonException | GridCommandException throwable) {
                    _logger.log(Level.SEVERE, throwable.getMessage());
                    this.firePropertyChange("error", null, throwable.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                if (!InstallationDeletePanel.this._progressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.installationDelCancelled"));
                    InstallationDeletePanel.this._progressMonitor.finish();
                    InstallationDeletePanel.this._progressMonitor.updateMessage(Messages.getString("TimesTenGrid.installationDelCancelled"));
                } else {
                    InstallationDeletePanel.this.showModelNeedsApplyWarning();
                    GridMouseListener.expander.restoreExpansionState();
                }
            }
        };
        swingWorker.addPropertyChangeListener(this._progressMonitor);
        this._progressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }
}

