/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.instance;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public class InstanceActionPanel
extends TTGUIBasePanel {
    private static final long serialVersionUID = 1L;
    private InstanceObject instance;
    private JTextArea messageTxt;
    private JCheckBox forceActionChk;
    private INSTANCE_ACTION action;

    public InstanceActionPanel(InstanceObject instanceObject, INSTANCE_ACTION iNSTANCE_ACTION) {
        super(false);
        this.instance = instanceObject;
        this.action = iNSTANCE_ACTION;
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        String string = null;
        switch (this.action) {
            case START: {
                string = "TimesTenGrid.startInstanceConfirm";
                break;
            }
            case START_SERVER: {
                string = "TimesTenGrid.startServerConfirm";
                break;
            }
            case STOP: {
                string = "TimesTenGrid.stopInstanceConfirm";
                break;
            }
            case STOP_SERVER: {
                string = "TimesTenGrid.stopServerConfirm";
            }
        }
        this.messageTxt = new JTextArea(MessageFormat.format(Messages.getString(string), this.instance.getName(), this.instance.getHost().getName()));
        this.forceActionChk = new JCheckBox(Messages.getString("TimesTenGrid.forceAction"));
        this.forceActionChk.setName(Messages.getString("TimesTenGrid.forceAction"));
        this.messageTxt.setBackground(null);
        this.messageTxt.setEditable(false);
        this.messageTxt.setBorder(null);
        this.messageTxt.setLineWrap(true);
        this.messageTxt.setWrapStyleWord(true);
        this.messageTxt.setFocusable(false);
        this.add((Component)this.messageTxt, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.forceActionChk, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 23, 0, new Insets(5, 10, 5, 10), 0, 0));
    }

    public void sendAction() {
        GridCommand gridCommand = null;
        String string = null;
        switch (this.action) {
            case START: {
                string = "TimesTenGrid.startingInstance";
                gridCommand = GridCommand.START_INSTANCE;
                break;
            }
            case START_SERVER: {
                string = "TimesTenGrid.startingServer";
                gridCommand = GridCommand.START_SERVER;
                break;
            }
            case STOP: {
                string = "TimesTenGrid.stoppingInstance";
                gridCommand = GridCommand.STOP_INSTANCE;
                break;
            }
            case STOP_SERVER: {
                string = "TimesTenGrid.stoppingServer";
                gridCommand = GridCommand.STOP_SERVER;
            }
        }
        gridCommand.prepareCommand(this.instance.getFullName(), this.forceActionChk.isSelected() ? "-force" : "");
        this.grid.executeCommandOnRaptorTask(MessageFormat.format(Messages.getString(string), this.instance.getFullName()), gridCommand, () -> {
            switch (this.action) {
                case START: {
                    this.instance.setDaemonStatus(true);
                    this.instance.setCSState(true);
                    this.instance.setStatusAvailable(true);
                    break;
                }
                case START_SERVER: {
                    this.instance.setCSState(true);
                    break;
                }
                case STOP: {
                    this.instance.setDaemonStatus(false);
                    this.instance.setCSState(false);
                    this.instance.setStatusAvailable(true);
                    break;
                }
                case STOP_SERVER: {
                    this.instance.setCSState(false);
                }
            }
        }, false);
    }

    public static void showStopInstanceDialog(InstanceObject instanceObject) {
        InstanceActionPanel instanceActionPanel = new InstanceActionPanel(instanceObject, INSTANCE_ACTION.STOP);
        HelpSystem.getHelpSystem().registerTopic((JComponent)instanceActionPanel, TimesTenHelpID.INST_STOP.toString());
        InstanceActionPanel.showDialog(instanceActionPanel, "TimesTenGrid.stopInstance");
    }

    public static void showStopServerInstDialog(InstanceObject instanceObject) {
        InstanceActionPanel instanceActionPanel = new InstanceActionPanel(instanceObject, INSTANCE_ACTION.STOP_SERVER);
        HelpSystem.getHelpSystem().registerTopic((JComponent)instanceActionPanel, TimesTenHelpID.INST_STOP_SERVER.toString());
        InstanceActionPanel.showDialog(instanceActionPanel, "TimesTenGrid.stopServer");
    }

    public static void showStartInstanceDialog(InstanceObject instanceObject) {
        InstanceActionPanel instanceActionPanel = new InstanceActionPanel(instanceObject, INSTANCE_ACTION.START);
        HelpSystem.getHelpSystem().registerTopic((JComponent)instanceActionPanel, TimesTenHelpID.INST_START.toString());
        InstanceActionPanel.showDialog(instanceActionPanel, "TimesTenGrid.startInstance");
    }

    public static void showStartServerInstDialog(InstanceObject instanceObject) {
        InstanceActionPanel instanceActionPanel = new InstanceActionPanel(instanceObject, INSTANCE_ACTION.START_SERVER);
        HelpSystem.getHelpSystem().registerTopic((JComponent)instanceActionPanel, TimesTenHelpID.INST_START_SERVER.toString());
        InstanceActionPanel.showDialog(instanceActionPanel, "TimesTenGrid.startServer");
    }

    private static void showDialog(InstanceActionPanel instanceActionPanel, String string) {
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)instanceActionPanel, (String)Messages.getString(string), (ActionListener)instanceActionPanel);
        instanceActionPanel.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(7);
        Dimension dimension = new Dimension(400, 150);
        jEWTDialog.setSize(dimension);
        jEWTDialog.setMinimumSize(dimension);
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.addActionListener((ActionListener)instanceActionPanel);
        jEWTDialog.setVisible(true);
        if (jEWTDialog.isOked()) {
            instanceActionPanel.sendAction();
        }
    }

    public static enum INSTANCE_ACTION {
        START,
        START_SERVER,
        STOP,
        STOP_SERVER;

    }
}

