/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.loginspector;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.loginspector.TTLogEntryFilterPanel;
import oracle.ide.Ide;
import oracle.ide.util.IdeUtil;
import oracle.javatools.ui.calendar.CalendarPanel;

public class DateFilterPanel
extends TTLogEntryFilterPanel {
    private JLabel beginDateLbl;
    private JLabel endDateLbl;
    private CalendarPanel beginDate;
    private CalendarPanel endDate;
    private JButton beginDateBtn;
    private JButton endDateBtn;
    private JEWTDialog dateHourPicker1Dialog;
    private JEWTDialog dateHourPicker2Dialog;
    private boolean beginDateSet;
    private boolean endDateSet;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MM-yy HH:mm:ss.SSS");

    public DateFilterPanel() {
        this.setLayout(new GridBagLayout());
        this.beginDateBtn = new JButton(Messages.getString("TimesTenGrid.selectInstancesMenuItem"));
        this.endDateBtn = new JButton(Messages.getString("TimesTenGrid.selectInstancesMenuItem"));
        this.beginDate = new CalendarPanel();
        this.endDate = new CalendarPanel();
        this.beginDate.setMinimumSize(this.beginDate.getPreferredSize());
        this.endDate.setMinimumSize(this.endDate.getPreferredSize());
        this.beginDate.setSelectedDate(new Date());
        this.beginDate.setShowTime(true);
        this.beginDate.setEditTime(true);
        this.endDate.setSelectedDate(new Date());
        this.endDate.setShowTime(true);
        this.endDate.setEditTime(true);
        this.beginDateLbl = new JLabel(Messages.getString("TimesTenGrid.LogBeginDate"));
        this.endDateLbl = new JLabel(Messages.getString("TimesTenGrid.LogEndDate"));
        this.dateHourPicker1Dialog = UIUtils.createPanelDialog((JPanel)this.beginDate, (String)"Begin date", null);
        this.dateHourPicker2Dialog = UIUtils.createPanelDialog((JPanel)this.endDate, (String)"End date", null);
        this.dateHourPicker1Dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.dateHourPicker1Dialog.setButtonMask(3);
        this.dateHourPicker1Dialog.setDefaultCloseOperation(1);
        this.dateHourPicker2Dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.dateHourPicker2Dialog.setButtonMask(3);
        this.dateHourPicker2Dialog.setDefaultCloseOperation(1);
        this.beginDateBtn.addActionListener(actionEvent -> {
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dateHourPicker1Dialog);
            this.dateHourPicker1Dialog.setVisible(true);
            if (this.dateHourPicker1Dialog.isOked()) {
                this.beginDateSet = true;
                this.beginDateBtn.setText(DATE_FORMAT.format(this.beginDate.getSelectedDates()[0]));
            }
        });
        this.endDateBtn.addActionListener(actionEvent -> {
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dateHourPicker2Dialog);
            this.dateHourPicker2Dialog.setVisible(true);
            if (this.dateHourPicker2Dialog.isOked()) {
                this.endDateSet = true;
                this.endDateBtn.setText(DATE_FORMAT.format(this.endDate.getSelectedDates()[0]));
            }
        });
        this.add((Component)this.beginDateLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.beginDateBtn, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.endDateLbl, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.endDateBtn, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.removeThisFilter, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 24, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setNames();
    }

    @Override
    protected boolean addFilterToLatest() {
        if (!this.beginDateSet || !this.endDateSet) {
            return false;
        }
        if (this.beginDate.getSelectedDates()[0].before(this.endDate.getSelectedDates()[0])) {
            this.filter.addDateRange(this.beginDate.getSelectedDates()[0], this.endDate.getSelectedDates()[0]);
            return true;
        }
        return false;
    }

    private void setNames() {
        this.beginDateLbl.setName(Messages.getString("TimesTenGrid.LogBeginDate"));
        this.endDateLbl.setName(Messages.getString("TimesTenGrid.LogEndDate"));
        this.beginDate.setName("beginDate");
        this.endDate.setName("endDate");
        this.beginDateBtn.setName(Messages.getString("TimesTenGrid.selectInstancesMenuItem"));
        this.endDateBtn.setName("endDateBtn");
    }
}

