/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.loginspector;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.timesten.grid.loginspector.TTLogEntry;

public class LogFilter {
    private static LogFilter instance;
    private List<Date> beginDate;
    private List<Date> endDate;
    private Set<TTLogEntry.TTDiagLogEntryLevel> msgTypes;
    private List<String> msgFilter;
    private List<String> PID_filter;
    private List<String> Prog_Name;
    private int filterVersion;
    private List<FilterMode> msgFilterOpts;
    private List<FilterMode> PID_filterOpts;
    private List<FilterMode> Prog_NameOpts;
    private static final Logger logger;
    final int MSGFIELD = 0;
    final int PIDFIELD = 1;
    final int PGFIELD = 2;

    public static LogFilter getFilterObjectInstance() {
        if (instance == null) {
            instance = new LogFilter();
        }
        return instance;
    }

    private LogFilter() {
        this.clearFilter();
    }

    public void saveFilter() {
        ++this.filterVersion;
    }

    public int getFilterVersion() {
        return this.filterVersion;
    }

    public void clearFilter() {
        this.filterVersion = 0;
        if (this.beginDate == null) {
            this.beginDate = new ArrayList<Date>();
        } else {
            this.beginDate.clear();
        }
        if (this.endDate == null) {
            this.endDate = new ArrayList<Date>();
        } else {
            this.endDate.clear();
        }
        if (this.PID_filter == null) {
            this.PID_filter = new ArrayList<String>();
        } else {
            this.PID_filter.clear();
        }
        if (this.PID_filterOpts == null) {
            this.PID_filterOpts = new ArrayList<FilterMode>();
        } else {
            this.PID_filterOpts.clear();
        }
        if (this.Prog_Name == null) {
            this.Prog_Name = new ArrayList<String>();
        } else {
            this.Prog_Name.clear();
        }
        if (this.Prog_NameOpts == null) {
            this.Prog_NameOpts = new ArrayList<FilterMode>();
        } else {
            this.Prog_NameOpts.clear();
        }
        if (this.msgFilter == null) {
            this.msgFilter = new ArrayList<String>();
        } else {
            this.msgFilter.clear();
        }
        if (this.msgFilterOpts == null) {
            this.msgFilterOpts = new ArrayList<FilterMode>();
        } else {
            this.msgFilterOpts.clear();
        }
        if (this.msgTypes == null) {
            this.msgTypes = new HashSet<TTLogEntry.TTDiagLogEntryLevel>();
        } else {
            this.msgTypes.clear();
        }
        this.msgTypes.add(TTLogEntry.TTDiagLogEntryLevel.ERROR);
        this.msgTypes.add(TTLogEntry.TTDiagLogEntryLevel.WARN);
    }

    public void addMsgFilter(String string, FilterMode filterMode) {
        if (!this.msgFilter.contains(string)) {
            this.msgFilter.add(string);
            this.msgFilterOpts.add(filterMode);
        } else {
            this.msgFilterOpts.set(this.msgFilter.indexOf(string), filterMode);
        }
    }

    public void addProgNameFilter(String string, FilterMode filterMode) {
        if (!this.Prog_Name.contains(string)) {
            this.Prog_Name.add(string);
            this.Prog_NameOpts.add(filterMode);
        } else {
            this.Prog_NameOpts.set(this.Prog_Name.indexOf(string), filterMode);
        }
    }

    public void addPIDFilter(String string, FilterMode filterMode) {
        if (!this.PID_filter.contains(string)) {
            this.PID_filter.add(string);
            this.PID_filterOpts.add(filterMode);
        } else {
            this.PID_filterOpts.set(this.PID_filter.indexOf(string), filterMode);
        }
    }

    public void addDateRange(Date date, Date date2) {
        if (this.beginDate.contains(date) && this.endDate.contains(date2)) {
            return;
        }
        this.beginDate.add(date);
        this.endDate.add(date2);
    }

    public Set<TTLogEntry.TTDiagLogEntryLevel> getMsgTypes() {
        return this.msgTypes;
    }

    public List<Date> getBeginDate() {
        return this.beginDate;
    }

    public List<Date> getEndDate() {
        return this.endDate;
    }

    public List<String> getMsgFilter() {
        return this.msgFilter;
    }

    public List<String> getPID_filter() {
        return this.PID_filter;
    }

    public List<String> getProg_NameFilter() {
        return this.Prog_Name;
    }

    public List<FilterMode> getMsgFilterOpts() {
        return this.msgFilterOpts;
    }

    public List<FilterMode> getPID_filterOpts() {
        return this.PID_filterOpts;
    }

    public List<FilterMode> getProg_NameOpts() {
        return this.Prog_NameOpts;
    }

    public boolean messageMatchesAllCriteria(TTLogEntry tTLogEntry) {
        int n;
        boolean bl = this.beginDate.isEmpty();
        for (n = 0; n < this.beginDate.size(); ++n) {
            if (!this.beforeOrEqual(this.beginDate.get(n), tTLogEntry.getTimeStamp()) || !this.afterOrEqual(this.endDate.get(n), tTLogEntry.getTimeStamp())) continue;
            bl = true;
        }
        boolean bl2 = this.getMsgTypes().contains((Object)tTLogEntry.getLevel());
        for (n = 0; n < this.msgFilter.size(); ++n) {
            bl2 &= this.messageMatches(0, this.msgFilter.get(n), this.msgFilterOpts.get(n), tTLogEntry);
        }
        for (n = 0; n < this.PID_filter.size(); ++n) {
            bl2 &= this.messageMatches(1, this.PID_filter.get(n), this.PID_filterOpts.get(n), tTLogEntry);
        }
        for (n = 0; n < this.Prog_Name.size(); ++n) {
            bl2 &= this.messageMatches(2, this.Prog_Name.get(n), this.Prog_NameOpts.get(n), tTLogEntry);
        }
        return bl2 & bl;
    }

    public boolean isFilterClear() {
        return this.beginDate.isEmpty() && this.endDate.isEmpty() && this.msgFilter.isEmpty() && this.PID_filter.isEmpty() && this.Prog_Name.isEmpty() && this.msgTypes.contains((Object)TTLogEntry.TTDiagLogEntryLevel.WARN) && this.msgTypes.contains((Object)TTLogEntry.TTDiagLogEntryLevel.ERROR);
    }

    private boolean messageMatches(int n, String string, FilterMode filterMode, TTLogEntry tTLogEntry) {
        String string2 = null;
        boolean bl = false;
        switch (filterMode) {
            case LIKE: {
                string2 = string.replace("%", ".*").replace("_", ".{1}");
                break;
            }
            case NOT_LIKE: {
                string2 = string.replace("%", ".*").replace("_", ".{1}");
                bl = true;
                break;
            }
            case EQUAL: 
            case REGEX: {
                string2 = string;
                break;
            }
            case NOT_EQUAL: {
                string2 = string;
                bl = true;
            }
        }
        boolean bl2 = bl;
        Pattern pattern = Pattern.compile(string2);
        switch (n) {
            case 0: {
                if (!bl2) {
                    return pattern.matcher(tTLogEntry.getMessage()).matches();
                }
                return !pattern.matcher(tTLogEntry.getMessage()).matches();
            }
            case 1: {
                if (!bl2) {
                    return pattern.matcher(tTLogEntry.getStrPID()).matches();
                }
                return !pattern.matcher(tTLogEntry.getStrPID()).matches();
            }
            case 2: {
                if (!bl2) {
                    return pattern.matcher(tTLogEntry.getShortProgramName()).matches();
                }
                return !pattern.matcher(tTLogEntry.getShortProgramName()).matches();
            }
        }
        return false;
    }

    private boolean afterOrEqual(Date date, Date date2) {
        return date.getTime() >= date2.getTime();
    }

    private boolean beforeOrEqual(Date date, Date date2) {
        return date.getTime() <= date2.getTime();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Messages with severity...\n");
        for (TTLogEntry.TTDiagLogEntryLevel tTDiagLogEntryLevel : this.msgTypes) {
            stringBuilder.append((Object)((Object)tTDiagLogEntryLevel) + ",");
        }
        if (!this.beginDate.isEmpty()) {
            stringBuilder.append("\n\nDates between...\n");
            for (int i = 0; i < this.beginDate.size(); ++i) {
                stringBuilder.append(this.beginDate.get(i).toString() + "-" + this.endDate.get(i).toString());
            }
        }
        if (!this.Prog_Name.isEmpty()) {
            stringBuilder.append("\n\nProgram Name...\n");
            for (int i = 0; i < this.Prog_Name.size(); ++i) {
                stringBuilder.append((Object)((Object)this.Prog_NameOpts.get(i)) + " " + this.Prog_Name.get(i));
            }
        }
        if (!this.PID_filter.isEmpty()) {
            stringBuilder.append("\n\nPID...\n");
            for (int i = 0; i < this.PID_filter.size(); ++i) {
                stringBuilder.append((Object)((Object)this.PID_filterOpts.get(i)) + " " + this.PID_filter.get(i));
            }
        }
        if (!this.msgFilter.isEmpty()) {
            stringBuilder.append("\n\nMessages...\n");
            for (int i = 0; i < this.msgFilter.size(); ++i) {
                stringBuilder.append((Object)((Object)this.msgFilterOpts.get(i)) + " " + this.msgFilter.get(i));
            }
        }
        return stringBuilder.toString();
    }

    static {
        logger = Logger.getLogger(LogFilter.class.getName());
    }

    public static enum FilterMode {
        LIKE("LIKE"),
        NOT_LIKE("NOT LIKE"),
        EQUAL("="),
        NOT_EQUAL("<>"),
        REGEX("Regular expression");

        public String strVal;

        private FilterMode(String string2) {
            this.strVal = string2;
        }

        public String toString() {
            return this.strVal;
        }
    }
}

