/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.navigator;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.model.DefaultNavigatorTreeNode;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.editors.TTBaseEditor;
import oracle.dbtools.raptor.timesten.grid.navigator.AbstractNode;
import oracle.dbtools.raptor.timesten.grid.navigator.GridNavigatorContextMenu;
import oracle.dbtools.raptor.timesten.grid.navigator.OpenEditorCallback;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ideimpl.explorer.CustomTree;

public class GridMouseListener
extends MouseAdapter
implements TreeWillExpandListener,
TreeSelectionListener {
    private static Logger logger = Logger.getLogger(GridMouseListener.class.getName());
    public static final TreeExpansionUtil expander = new TreeExpansionUtil();
    private static int selectedRow = -1;

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof CustomTree) {
            expander.setTree((CustomTree)mouseEvent.getSource());
            expander.saveExpansionState();
            TreePath treePath = ((CustomTree)mouseEvent.getSource()).getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null) {
                AbstractNode abstractNode;
                AbstractNode abstractNode2;
                for (abstractNode2 = abstractNode = (AbstractNode)((Object)((DefaultNavigatorTreeNode)treePath.getLastPathComponent()).getUserObject()); abstractNode2 != null && !abstractNode2.isGridNode(); abstractNode2 = abstractNode2.getParentNode()) {
                    if (abstractNode2.isInstanceNode()) {
                        TTGridRootNode.getInstance().setCurrentInstance(abstractNode2.getShortLabel());
                    }
                    if (abstractNode2.isHostNode()) {
                        TTGridRootNode.getInstance().setCurrentHost(abstractNode2.getShortLabel());
                    }
                    if (!abstractNode2.isDatabaseNode() && !abstractNode2.isDBDefNode()) continue;
                    TTGridRootNode.getInstance().setCurrentDB(abstractNode2.getShortLabel());
                }
                if (abstractNode2 == null || !abstractNode2.isGridNode()) {
                    return;
                }
                TTGridRootNode.getInstance().setCurrentGrid(abstractNode2.getShortLabel());
                GridObject gridObject = TTGridRootNode.getInstance().getGrid(abstractNode2.getShortLabel());
                gridObject.getGridNode().setCustomTree((CustomTree)mouseEvent.getSource());
                TTGridRootNode.getInstance().setGridPath(treePath);
                ((CustomTree)mouseEvent.getSource()).setToggleClickCount(0);
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && abstractNode.isFolderNode()) {
                    SwingUtilities.invokeLater(() -> {
                        boolean bl = ((CustomTree)mouseEvent.getSource()).isExpanded(treePath);
                        if (!bl) {
                            for (int i = 0; i < 4; ++i) {
                                DefaultNavigatorTreeNode defaultNavigatorTreeNode = (DefaultNavigatorTreeNode)treePath.getLastPathComponent();
                                Enumeration enumeration = defaultNavigatorTreeNode.breadthFirstEnumeration();
                                while (enumeration.hasMoreElements()) {
                                    DefaultNavigatorTreeNode defaultNavigatorTreeNode2 = (DefaultNavigatorTreeNode)enumeration.nextElement();
                                    ((CustomTree)mouseEvent.getSource()).expandPath(new TreePath(defaultNavigatorTreeNode2.getPath()));
                                }
                            }
                        } else {
                            Object[] objectArray;
                            ArrayList<Integer> arrayList = new ArrayList<Integer>();
                            DefaultNavigatorTreeNode defaultNavigatorTreeNode = (DefaultNavigatorTreeNode)treePath.getLastPathComponent();
                            Enumeration enumeration = defaultNavigatorTreeNode.breadthFirstEnumeration();
                            while (enumeration.hasMoreElements()) {
                                objectArray = (Object[])enumeration.nextElement();
                                arrayList.add(((CustomTree)mouseEvent.getSource()).getRowForPath(new TreePath(objectArray.getPath())));
                            }
                            objectArray = arrayList.toArray(new Integer[arrayList.size()]);
                            Arrays.sort(objectArray);
                            for (int i = objectArray.length - 1; i >= 0; --i) {
                                ((CustomTree)mouseEvent.getSource()).collapseRow(((Integer)objectArray[i]).intValue());
                            }
                        }
                    });
                }
                if (mouseEvent.getButton() == 1) {
                    if (abstractNode.isGridNode()) {
                        if (!gridObject.isPopulated() || !gridObject.hasDBStatus()) {
                            GridMouseListener.updateGridInfo(null, null, gridObject, true, !gridObject.hasDBStatus(), gridObject.getShowingVersion());
                        } else {
                            GridMouseListener.openEditor(abstractNode, expander, gridObject);
                        }
                    } else if (abstractNode.isInstanceNode() || abstractNode.isMgmtInstanceNode()) {
                        String string;
                        String string2;
                        if (!abstractNode.getParentNode().isHostNode()) {
                            string2 = abstractNode.getShortLabel().substring(abstractNode.getShortLabel().lastIndexOf(".") + 1);
                            string = abstractNode.getShortLabel().substring(0, abstractNode.getShortLabel().lastIndexOf("."));
                        } else {
                            string2 = abstractNode.getShortLabel();
                            string = abstractNode.getParentNode().getShortLabel();
                        }
                        TTGridRootNode.getInstance().setCurrentHost(string);
                        TTGridRootNode.getInstance().setCurrentInstance(string2);
                        GridMouseListener.openEditor(abstractNode, expander, gridObject);
                    } else if (abstractNode.isHostNode() || abstractNode.isConnectableNode() || abstractNode.isDBDefNode() || abstractNode.isInstallationFolderNode() || abstractNode.isInstanceFolderNode() || abstractNode.isInstallationNode() || abstractNode.isConfigObjectNode() || abstractNode.isDataHostFolderNode() || abstractNode.isDatabaseNode() || abstractNode.isBackupNode() || abstractNode.isExportNode() || abstractNode.isRepositoryNode()) {
                        GridMouseListener.openEditor(abstractNode, expander, gridObject);
                    }
                }
            }
        }
    }

    public static void openEditor(AbstractNode abstractNode, OpenEditorCallback openEditorCallback, GridObject gridObject) {
        Context context = Context.newIdeContext((Node)abstractNode);
        context.setProperty("gridName", (Object)gridObject.getName());
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, TTBaseEditor.class);
        for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
            if (!(editor instanceof TTBaseEditor)) continue;
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(() -> EditorManager.getEditorManager().closeEditors(Arrays.asList(editor)));
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    Logger.getLogger(GridMouseListener.class.getName()).log(Level.SEVERE, exception.getMessage());
                }
                break;
            }
            EditorManager.getEditorManager().closeEditors(Arrays.asList(editor));
            break;
        }
        Runnable runnable = () -> {
            TTBaseEditor tTBaseEditor = null;
            tTBaseEditor = (TTBaseEditor)EditorManager.getEditorManager().openEditor(openEditorOptions);
            if (tTBaseEditor == null) {
                logger.log(Level.SEVERE, "Object editor is not available: Timesten drivers may not be loaded");
            } else {
                tTBaseEditor.setCurrentGrid(gridObject);
                tTBaseEditor.updateContent();
                tTBaseEditor.getDefaultFocusComponent().requestFocusInWindow();
                if (openEditorCallback != null) {
                    openEditorCallback.executeAfterOpen(tTBaseEditor);
                }
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (InterruptedException | InvocationTargetException exception) {
            logger.log(Level.SEVERE, "Exception while openning editor.");
        }
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        DefaultNavigatorTreeNode defaultNavigatorTreeNode;
        TreePath treePath;
        if (treeExpansionEvent.getSource() instanceof CustomTree && (treePath = treeExpansionEvent.getPath()) != null && ((AbstractNode)((Object)(defaultNavigatorTreeNode = (DefaultNavigatorTreeNode)treePath.getLastPathComponent()).getUserObject())).isGridNode()) {
            GridObject gridObject = TTGridRootNode.getInstance().getGrid(defaultNavigatorTreeNode.getShortLabel());
            if (gridObject == null) {
                logger.severe("Grid not found in storage");
                throw new ExpandVetoException(treeExpansionEvent);
            }
            if (!gridObject.isPopulated() && gridObject.isPopulating()) {
                throw new ExpandVetoException(treeExpansionEvent);
            }
            if (!gridObject.isPopulated() && !gridObject.isPopulating()) {
                gridObject.getGridNode().setCustomTree((CustomTree)treeExpansionEvent.getSource());
                TTGridRootNode.getInstance().setCurrentGrid(gridObject.getName());
                GridMouseListener.updateGridInfo((CustomTree)treeExpansionEvent.getSource(), treePath, gridObject, false, false, gridObject.getShowingVersion());
                throw new ExpandVetoException(treeExpansionEvent);
            }
        }
    }

    public static synchronized void updateGridInfo(CustomTree customTree, TreePath treePath, GridObject gridObject, boolean bl, boolean bl2) {
        GridMouseListener.updateGridInfo(customTree, treePath, gridObject, bl, bl2, GridObject.ModelVersion.LATEST);
    }

    public static synchronized void updateGridInfo(final CustomTree customTree, final TreePath treePath, final GridObject gridObject, final boolean bl, final boolean bl2, final GridObject.ModelVersion modelVersion) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                expander.setTree(customTree);
                expander.saveExpansionState();
                try {
                    boolean bl3;
                    boolean bl22 = false;
                    if (gridObject.getExecutor().getWorkingHost().getPwd() == null && gridObject.getExecutor().getWorkingHost().getKeyFile() == null && !(bl3 = GridNavigatorContextMenu.promptForPasswordKeyFile(gridObject))) {
                        return null;
                    }
                    gridObject.getGridNode().setCustomTree(customTree);
                    gridObject.setShowingVersion(modelVersion);
                    if (modelVersion == GridObject.ModelVersion.LATEST) {
                        gridObject.setPopulating(true);
                        gridObject.setGridComponents(gridObject.getExecutor().executeCommandGetJson(GridCommand.EXPORT_MODEL, true), bl22);
                        gridObject.setCurrentModel(gridObject.getExecutor().executeCommandGetJson(GridCommand.EXPORT_CURRENTMODEL, true));
                        gridObject.setPopulating(false);
                    } else if (modelVersion == GridObject.ModelVersion.CURRENT) {
                        gridObject.setGridComponents(gridObject.getExecutor().executeCommandGetJson(GridCommand.EXPORT_CURRENTMODEL, true), bl22);
                        gridObject.setCurrentModel(gridObject.getExecutor().executeCommandGetJson(GridCommand.EXPORT_MODEL, true));
                    }
                    gridObject.getGridCurrentModel().diff(gridObject);
                    if (bl2) {
                        gridObject.updateDatabasesStatus();
                        gridObject.updateDatabasesConnections(false);
                    }
                    if (bl) {
                        GridMouseListener.openEditor(gridObject.getGridNode().getGridRootNode(), expander, gridObject);
                    } else {
                        expander.restoreExpansionState();
                    }
                    if (customTree != null && treePath != null) {
                        try {
                            SwingUtilities.invokeAndWait(() -> customTree.expandPath(treePath));
                        }
                        catch (InterruptedException | InvocationTargetException exception) {
                            Logger.getLogger(GridMouseListener.class.getName()).log(Level.SEVERE, exception.getMessage());
                        }
                    }
                    gridObject.getGridNode().loadStoredHostFilter(gridObject);
                    gridObject.getGridNode().reApplyHostFilter(gridObject);
                }
                catch (Exception exception) {
                    String string = Messages.getString("TimesTenGrid.getGridDataFailed");
                    if (exception instanceof GridCommandException) {
                        string = Messages.getString("TimesTenGrid.updateModelFailed");
                    }
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), string);
                    logger.warning(exception.getMessage());
                    gridObject.setPopulating(false);
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setMessage(Messages.getString("TimesTenGrid.fetchingGrindInfo"));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        CustomTree customTree = (CustomTree)treeSelectionEvent.getSource();
        int n = customTree.getRowForPath(treeSelectionEvent.getPath());
        if (n != -1) {
            selectedRow = n;
        }
    }

    public static class TreeExpansionUtil
    implements OpenEditorCallback {
        private CustomTree tree;
        private String state;

        public void setTree(CustomTree customTree) {
            if (customTree != null) {
                this.tree = customTree;
            }
        }

        public void saveExpansionState() {
            if (this.tree == null) {
                logger.info("Can not retrieve the navigator tree state.");
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                if (!this.tree.isExpanded(i)) continue;
                stringBuilder.append(i).append(",");
            }
            this.state = stringBuilder.toString();
        }

        public void restoreExpansionState() {
            String[] stringArray;
            for (String string : stringArray = this.state.split(",")) {
                int n = Integer.parseInt(string);
                if (SwingUtilities.isEventDispatchThread()) {
                    this.tree.expandRow(n);
                    continue;
                }
                SwingUtilities.invokeLater(() -> this.tree.expandRow(n));
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.repaintSelectedPath();
            } else {
                SwingUtilities.invokeLater(() -> this.repaintSelectedPath());
            }
        }

        private void repaintSelectedPath() {
            if (selectedRow >= 0 && selectedRow < this.tree.getRowCount()) {
                this.tree.setSelectionRow(selectedRow);
            }
        }

        @Override
        public void executeAfterOpen(TTBaseEditor tTBaseEditor) {
            this.restoreExpansionState();
        }
    }
}

