/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.object;

import java.awt.Component;
import java.io.File;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.BasicDeletable;
import oracle.dbtools.raptor.timesten.grid.Deletable;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.database.DBDefAttribute;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.ConnectableObject;
import oracle.dbtools.raptor.timesten.grid.object.DifferenceObject;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.TTGridObject;
import oracle.ide.Ide;

public class DBDefObject
extends TTGridObject
implements Deletable {
    private List<DBDefAttribute> attributes;
    private List<ConnectableObject> connectables;
    private GridObject currentGrid;
    private static Logger logger = Logger.getLogger(DBDefObject.class.getName());

    public List<DBDefAttribute> getAttributes() {
        return this.attributes;
    }

    public DBDefObject(GridObject gridObject, String string) {
        this.currentGrid = gridObject;
        this.GUID = string;
        this.attributes = new ArrayList<DBDefAttribute>();
        this.connectables = new ArrayList<ConnectableObject>();
    }

    public void addAttribute(String string, String string2) {
        if (this.currentGrid == null) {
            logger.log(Level.SEVERE, "AttributesUtil not available. DbDef attributes can not be loaded.");
            return;
        }
        DBDefAttribute dBDefAttribute = this.currentGrid.getAttributesUtil().getAttribute(string);
        dBDefAttribute.setValueFromString(string2);
        this.attributes.add(dBDefAttribute);
    }

    public void addAttribute(DBDefAttribute dBDefAttribute) {
        this.attributes.add(dBDefAttribute);
    }

    public void setDBDefModel(JsonObject jsonObject) {
        this.attributes.clear();
        this.setGUID(jsonObject.getString("guid"));
        JsonObject jsonObject2 = jsonObject.getJsonObject("attrs");
        for (Object object : jsonObject2.keySet()) {
            this.addAttribute((String)object, jsonObject2.getString((String)object));
        }
        this.getConnectables().clear();
        JsonArray jsonArray = jsonObject.getJsonArray("connectables");
        for (JsonObject jsonObject3 : jsonArray.getValuesAs(JsonObject.class)) {
            ConnectableObject connectableObject = new ConnectableObject(this.currentGrid, this);
            connectableObject.setConnectableModel(jsonObject3);
            this.addConnectable(connectableObject);
        }
    }

    public void diff(DifferenceObject differenceObject, DBDefObject dBDefObject) {
        DBDefObject dBDefObject2 = this;
        ArrayList<DBDefAttribute> arrayList = new ArrayList<DBDefAttribute>();
        ArrayList<DBDefAttribute> arrayList2 = new ArrayList<DBDefAttribute>();
        boolean bl = false;
        dBDefObject2.setAppliedToCurrent(true);
        dBDefObject.setAppliedToCurrent(true);
        for (DBDefAttribute object2 : dBDefObject2.getAttributes()) {
            arrayList.add(object2);
        }
        for (DBDefAttribute dBDefAttribute : dBDefObject.getAttributes()) {
            arrayList2.add(dBDefAttribute);
        }
        if (arrayList.size() != arrayList2.size()) {
            differenceObject.gridObjectEdited(dBDefObject, dBDefObject2);
            bl = true;
        }
        if (!bl) {
            for (DBDefAttribute dBDefAttribute : arrayList) {
                boolean bl2 = false;
                for (DBDefAttribute dBDefAttribute2 : arrayList2) {
                    if (dBDefAttribute2.isSameAttribute(dBDefAttribute)) {
                        bl2 = true;
                        if (!dBDefAttribute.equals(dBDefAttribute2)) {
                            differenceObject.gridObjectEdited(dBDefObject, dBDefObject2);
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    break;
                }
                if (!bl2) {
                    differenceObject.gridObjectEdited(dBDefObject, dBDefObject2);
                    bl = true;
                }
                if (!bl) continue;
                break;
            }
        }
        for (ConnectableObject connectableObject : dBDefObject2.getConnectables()) {
            boolean bl2;
            ConnectableObject connectableObject2 = dBDefObject.getConnectable(connectableObject.getName());
            boolean bl3 = bl2 = connectableObject2 != null;
            if (!bl2) {
                differenceObject.gridObjectRemoved(connectableObject);
                continue;
            }
            connectableObject.diff(differenceObject, connectableObject2);
        }
        for (ConnectableObject connectableObject : dBDefObject.getConnectables()) {
            ConnectableObject connectableObject3 = dBDefObject2.getConnectable(connectableObject.getName());
            boolean bl4 = connectableObject3 != null;
            if (bl4) continue;
            differenceObject.gridObjectAdded(connectableObject);
        }
    }

    @Override
    public String getObjectType() {
        return Messages.getString("TimesTenGrid.DBDefObjectName");
    }

    public void addConnectable(ConnectableObject connectableObject) {
        this.connectables.add(connectableObject);
    }

    public List<ConnectableObject> getConnectables() {
        return this.connectables;
    }

    public ConnectableObject getConnectablebyGUID(String string) {
        for (ConnectableObject connectableObject : this.connectables) {
            if (!connectableObject.getGUID().equalsIgnoreCase(string)) continue;
            return connectableObject;
        }
        return null;
    }

    public ConnectableObject getConnectable(String string) {
        for (ConnectableObject connectableObject : this.connectables) {
            if (!connectableObject.getName().equalsIgnoreCase(string)) continue;
            return connectableObject;
        }
        return null;
    }

    public void removeConnectable(String string) {
        for (ConnectableObject connectableObject : this.connectables) {
            if (!connectableObject.getName().equalsIgnoreCase(string)) continue;
            this.connectables.remove(connectableObject);
            return;
        }
    }

    public void exportDBDef() {
        String string = this.getName();
        JFileChooser jFileChooser = new JFileChooser(TTGridRootNode.getInstance().getCurrentDirectory());
        jFileChooser.setSelectedFile(new File(string));
        jFileChooser.setDialogTitle(Messages.getString("TimesTenGrid.exportDbdef"));
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("DBDef File (.dbdef)", "dbdef"));
        jFileChooser.setFileFilter(jFileChooser.getChoosableFileFilters()[1]);
        int n = 0;
        n = jFileChooser.showSaveDialog((Component)Ide.getMainWindow());
        if (n == 0) {
            TTGridRootNode.getInstance().setCurrentDirectory(jFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = jFileChooser.getSelectedFile();
            try {
                if (!file.getAbsolutePath().toLowerCase().endsWith(".dbdef")) {
                    file = new File(jFileChooser.getSelectedFile().getAbsolutePath() + "." + ((FileNameExtensionFilter)jFileChooser.getFileFilter()).getExtensions()[0]);
                }
                PrintWriter printWriter = new PrintWriter(file);
                printWriter.println(this.getDBDefinition());
                printWriter.close();
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, exception.getMessage());
            }
        }
    }

    private String getDBDefinition() {
        StringBuilder stringBuilder = new StringBuilder();
        for (DBDefAttribute dBDefAttribute : this.attributes) {
            stringBuilder.append(dBDefAttribute.getAttribute().toLowerCase());
            stringBuilder.append("=");
            if (!dBDefAttribute.getAttribute().toLowerCase().equalsIgnoreCase("PWDCrypt")) {
                stringBuilder.append(dBDefAttribute.getDBDefValue());
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public void deleteObject(Runnable runnable) {
        BasicDeletable basicDeletable = new BasicDeletable();
        basicDeletable.setCmd(GridCommand.DELETE_DATABASE_DEFINITION);
        basicDeletable.setCmdArgs(this.name);
        basicDeletable.setDeleteMsg(Messages.getString("TimesTenGrid.destroyDBDefConfirmation"));
        basicDeletable.setDeletingObjMsg(Messages.getString("TimesTenGrid.destroyingDBDefCommand"));
        basicDeletable.setDeletingFromModelMsg(MessageFormat.format(Messages.getString("TimesTenGrid.destroyingDBDef"), this.name));
        basicDeletable.setDeleteCancelMsg(Messages.getString("TimesTenGrid.destroyDBDefCancel"));
        basicDeletable.deleteObject(runnable);
    }
}

