/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.object;

import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonObject;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.BasicDeletable;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.Deletable;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.loginspector.InstanceLogWrapper;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.DifferenceObject;
import oracle.dbtools.raptor.timesten.grid.object.Executable;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstallationObject;
import oracle.dbtools.raptor.timesten.grid.object.TTGridObject;

public class InstanceObject
extends TTGridObject
implements Executable,
Deletable {
    private String home;
    private String walletDir;
    private int csPort;
    private int daemonPort;
    private int mgmtPort;
    private boolean csStatusUp;
    private boolean daemonStatusUp;
    private boolean statusAvailable;
    private HostObject host;
    private InstallationObject installation;
    private boolean mgmtInstance;
    private ManagementInstanceRole type;
    private Common.RepAgentStatus repAgentStatus = Common.RepAgentStatus.NOT_APPLICABLE;
    private boolean inMembership;
    private boolean forceStop;
    private InstanceLogWrapper log;
    private static final Logger _logger = Logger.getLogger(InstanceObject.class.getName());

    public InstanceLogWrapper getLog() {
        return this.log;
    }

    public boolean isMgmtInstance() {
        return this.mgmtInstance;
    }

    public void setIsMgmtInstance(boolean bl) {
        this.mgmtInstance = bl;
    }

    public InstallationObject getInstallation() {
        return this.installation;
    }

    public HostObject getHost() {
        return this.host;
    }

    @Override
    public String getFullName() {
        String string = "";
        if (this.host != null) {
            string = this.host.getName() + ".";
        }
        return string + this.name;
    }

    public boolean isStatusAvailable() {
        return this.statusAvailable;
    }

    public void setStatusAvailable(boolean bl) {
        this.statusAvailable = bl;
    }

    public InstanceObject(HostObject hostObject, InstallationObject installationObject) {
        this.host = hostObject;
        this.host.addInstance(this);
        this.installation = installationObject;
        this.statusAvailable = false;
        this.log = new InstanceLogWrapper(this);
    }

    public InstanceObject(HostObject hostObject, InstallationObject installationObject, String string, String string2, int n, int n2) {
        this.host = hostObject;
        this.host.addInstance(this);
        this.installation = installationObject;
        this.name = string;
        this.home = string2;
        this.csPort = n;
        this.daemonPort = n2;
        this.statusAvailable = false;
        this.log = new InstanceLogWrapper(this);
        this.type = ManagementInstanceRole.UNKNOWN;
    }

    public boolean getDaemonStatus() {
        return this.daemonStatusUp;
    }

    public void setDaemonStatus(boolean bl) {
        this.daemonStatusUp = bl;
    }

    public boolean getCSState() {
        return this.csStatusUp;
    }

    public void setCSState(boolean bl) {
        this.csStatusUp = bl;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String string) {
        this.home = string;
    }

    public String getWalletDir() {
        return this.walletDir;
    }

    public void setWalletDir(String string) {
        this.walletDir = string;
    }

    public int getCSPort() {
        return this.csPort;
    }

    public void setCSPort(int n) {
        this.csPort = n;
    }

    public int getDaemonPort() {
        return this.daemonPort;
    }

    public void setDaemonPort(int n) {
        this.daemonPort = n;
    }

    public int getMgmtPort() {
        return this.mgmtPort;
    }

    public void setMgmtPort(int n) {
        this.mgmtPort = n;
    }

    public String getFileSeparator() {
        return "/";
    }

    public void setInstanceModel(JsonObject jsonObject) {
        this.setName(jsonObject.getString("name"));
        this.setHome(jsonObject.getString("instanceHome"));
        this.setWalletDir(jsonObject.getString("walletDir"));
        this.setCSPort(jsonObject.getInt("csPort"));
        this.setDaemonPort(jsonObject.getInt("daemonPort"));
        String string = jsonObject.getString("instanceType");
        if (string.equalsIgnoreCase("M")) {
            this.setIsMgmtInstance(true);
            this.setMgmtPort(jsonObject.getInt("mgmtPort"));
            this.type = ManagementInstanceRole.MGMT;
        } else if (string.equalsIgnoreCase("D")) {
            this.setIsMgmtInstance(false);
            this.type = ManagementInstanceRole.DATA;
        } else {
            this.type = ManagementInstanceRole.UNKNOWN;
            _logger.warning("Instance type of " + this.getName() + " is unknown. Check json model");
        }
        this.statusAvailable = false;
        try {
            this.setGUID(jsonObject.getString("guid"));
        }
        catch (Exception exception) {
            _logger.log(Level.INFO, "Instance " + this.getFullName() + " not applied to grid model");
        }
        this.log = new InstanceLogWrapper(this);
    }

    public boolean isSameInstance(InstanceObject instanceObject) {
        return this.getName().equalsIgnoreCase(instanceObject.getName()) && this.getHost().getExternalAddress().equalsIgnoreCase(instanceObject.getHost().getExternalAddress());
    }

    public void diff(DifferenceObject differenceObject, InstanceObject instanceObject) {
        InstanceObject instanceObject2 = this;
        instanceObject.setAppliedToCurrent(true);
        instanceObject2.setAppliedToCurrent(true);
        if (!instanceObject2.getName().equalsIgnoreCase(instanceObject.getName()) || !instanceObject2.getInstallation().getName().equalsIgnoreCase(instanceObject.getInstallation().getName()) || instanceObject2.getCSPort() != instanceObject.getCSPort() || instanceObject2.getDaemonPort() != instanceObject.getDaemonPort()) {
            differenceObject.gridObjectEdited(instanceObject, instanceObject2);
        }
    }

    @Override
    public String getObjectType() {
        return Messages.getString("TimesTenGrid.InstanceObjectName");
    }

    @Override
    public String getTargetName() {
        return this.getFullName();
    }

    @Override
    public boolean isAvailableForExec() {
        return this.isAppliedToCurrent() && !this.isMgmtInstance();
    }

    public void updateSuggestions() {
        TTGridRootNode.getStorage().saveSuggestion("instanceName", this.getName());
        TTGridRootNode.getStorage().saveSuggestion("instanceHome", this.getHome());
        TTGridRootNode.getStorage().saveSuggestion("csPort", String.valueOf(this.getCSPort()));
        TTGridRootNode.getStorage().saveSuggestion("daemonPort", String.valueOf(this.getDaemonPort()));
        if (this.isMgmtInstance()) {
            TTGridRootNode.getStorage().saveSuggestion("mgmtPort", String.valueOf(this.getMgmtPort()));
        }
    }

    public static List<String> getInstanceNameSuggestions() {
        return TTGridRootNode.getStorage().getSuggestion("instanceName");
    }

    public static List<String> getInstanceHomeSuggestions() {
        return TTGridRootNode.getStorage().getSuggestion("instanceHome");
    }

    public static List<String> getInstanceCSPortSuggestions() {
        return TTGridRootNode.getStorage().getSuggestion("csPort");
    }

    public static List<String> getInstanceDaemonPortSuggestions() {
        return TTGridRootNode.getStorage().getSuggestion("daemonPort");
    }

    public static List<String> getInstanceMgmtPortSuggestions() {
        return TTGridRootNode.getStorage().getSuggestion("mgmtPort");
    }

    @Override
    public int getDSG() {
        return this.getHost().getDataSpaceGroup();
    }

    public String toString() {
        return this.getFullName();
    }

    public ManagementInstanceRole getType() {
        return this.type;
    }

    public void setType(ManagementInstanceRole managementInstanceRole) {
        this.type = managementInstanceRole;
    }

    public Common.RepAgentStatus getRepAgentStatus() {
        return this.repAgentStatus;
    }

    public void setRepAgentStatus(Common.RepAgentStatus repAgentStatus) {
        this.repAgentStatus = repAgentStatus;
    }

    boolean inMembership() {
        return this.inMembership;
    }

    void setInMembership(boolean bl) {
        this.inMembership = bl;
    }

    public boolean forceStop() {
        return this.forceStop;
    }

    public void setForceStop(boolean bl) {
        this.forceStop = bl;
    }

    @Override
    public void deleteObject(Runnable runnable) {
        BasicDeletable basicDeletable = new BasicDeletable();
        basicDeletable.setCmd(GridCommand.INSTANCE_DELETE);
        basicDeletable.setCmdArgs(this.host.getName(), this.name);
        basicDeletable.setDeleteMsg(Messages.getString("TimesTenGrid.deleteInstance"));
        basicDeletable.setDeletingObjMsg(MessageFormat.format(Messages.getString("TimesTenGrid.deletingInstancePW"), this.getFullName()));
        basicDeletable.setDeletingFromModelMsg(MessageFormat.format(Messages.getString("TimesTenGrid.deletingInstance"), this.name, this.host.getName()));
        basicDeletable.setDeleteCancelMsg(Messages.getString("TimesTenGrid.instDeletionCancelled"));
        basicDeletable.deleteObject(runnable);
    }

    public static enum ManagementInstanceRole {
        ACTIVE,
        STANDBY,
        IDLE,
        MGMT,
        DATA,
        UNKNOWN,
        DOWN;

    }
}

