/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.physicalGroups;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.json.JsonException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import oracle.dbtools.raptor.controls.ShuttlePanel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.PhysicalGroupObject;
import oracle.dbtools.raptor.timesten.utils.AutoCompleteComponent;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;

public class PhysicalGroupCreatePanel
extends TTGUIBasePanel {
    private JLabel _nameLbl;
    private ShuttlePanel<HostObject> hostShuttle;
    private AutoCompleteComponent _nameTxtFld;
    private static final Logger _logger = Logger.getLogger(PhysicalGroupCreatePanel.class.getName());
    private boolean isManagePGMode;
    private PhysicalGroupObject PG;
    private List<HostObject> originalExcludedHosts;
    private List<HostObject> originalSelectedHosts;

    public PhysicalGroupCreatePanel() {
        this((PhysicalGroupObject)null);
    }

    public PhysicalGroupCreatePanel(PhysicalGroupObject physicalGroupObject) {
        this.isManagePGMode = physicalGroupObject != null;
        this.PG = physicalGroupObject;
        this.initGUI();
        if (physicalGroupObject == null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.NEW_PHYSICAL_GROUP.toString());
        } else {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, TimesTenHelpID.PHYSICAL_GROUP_EDIT.toString());
        }
    }

    private void initGUI() {
        this._nameLbl = new JLabel(Messages.getString("TimesTenGrid.PGName"));
        this._nameLbl.setName(Messages.getString("TimesTenGrid.PGName"));
        this._nameTxtFld = new AutoCompleteComponent(30, PhysicalGroupObject.getPhysicalGroupNameSuggestions());
        this._nameTxtFld.setName("_nameTxtFld", "_nameCmbBox");
        this._nameTxtFld.setMinimumSize(this._nameTxtFld.getPreferredSize());
        this.hostShuttle = new ShuttlePanel(Messages.getString("TimesTenGrid.assignRemoveHostsPG"), Messages.getString("TimesTenGrid.Available"), Messages.getString("TimesTenGrid.selected"));
        this.hostShuttle.setName("hostShuttle");
        this._nameTxtFld.setText(this.PG != null ? this.PG.getName() : "");
        this._nameTxtFld.setEnabled(!this.isManagePGMode);
        this.hostShuttle.getShuttle().remove(5);
        this.hostShuttle.setFromList(this.grid.getHosts().stream().filter(hostObject -> !hostObject.belongsToPG(this.PG)).collect(Collectors.toList()));
        this.hostShuttle.setToList(this.grid.getHosts().stream().filter(hostObject -> hostObject.belongsToPG(this.PG)).collect(Collectors.toList()));
        this.originalExcludedHosts = this.hostShuttle.getFromList();
        this.originalSelectedHosts = this.hostShuttle.getToList();
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.add((Component)this._nameLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._nameTxtFld, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.hostShuttle, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isManagePGMode) {
            if (this.originalExcludedHosts.equals(this.hostShuttle.getFromList()) && this.originalSelectedHosts.equals(this.hostShuttle.getToList())) {
                this._dialog.dispose();
                return;
            }
        } else {
            if (this._nameTxtFld.getText().trim().isEmpty()) {
                Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.PGNameInvalid"));
                return;
            }
            String string = Common.validateName(this._nameTxtFld.getText(), this._nameTxtFld.getText());
            if (string != null) {
                Common.displayErrorMsg(this, string);
                return;
            }
            if (this.grid.getPhysicalGroup(this._nameTxtFld.getText().trim()) != null) {
                Common.displayErrorMsg(this, Messages.getString("TimesTenGrid.PGNameTaken"));
                return;
            }
        }
        super.actionPerformed(actionEvent);
        this.createPG();
    }

    private void createPG() {
        String string = this.isManagePGMode ? Messages.getString("TimesTenGrid.assigningPG") : Messages.getString("TimesTenGrid.creatingPG");
        final CustomProgressMonitor customProgressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), string, string, null);
        customProgressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    GridCommand gridCommand;
                    GridMouseListener.expander.saveExpansionState();
                    customProgressMonitor.start();
                    if (!PhysicalGroupCreatePanel.this.isManagePGMode) {
                        this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.createPGcommand"));
                        gridCommand = GridCommand.PHYSICAL_CREATE;
                        gridCommand.prepareCommand(PhysicalGroupCreatePanel.this._nameTxtFld.getText());
                        PhysicalGroupCreatePanel.this.grid.getExecutor().executeCommandGetString(gridCommand, false);
                    }
                    for (HostObject hostObject : PhysicalGroupCreatePanel.this.hostShuttle.getToList()) {
                        if (hostObject.belongsToPG(PhysicalGroupCreatePanel.this.PG)) continue;
                        this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.modifyingHost"), hostObject.getName()));
                        gridCommand = GridCommand.HOST_MODIFY_ADD_PGS;
                        gridCommand.prepareCommand(hostObject.getName(), PhysicalGroupCreatePanel.this._nameTxtFld.getText());
                        PhysicalGroupCreatePanel.this.grid.getExecutor().executeCommandGetString(gridCommand, false);
                    }
                    if (PhysicalGroupCreatePanel.this.isManagePGMode) {
                        for (HostObject hostObject : PhysicalGroupCreatePanel.this.hostShuttle.getFromList()) {
                            if (!hostObject.belongsToPG(PhysicalGroupCreatePanel.this.PG)) continue;
                            this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.modifyingHost"), hostObject.getName()));
                            hostObject.getPhysicalGroups().remove(PhysicalGroupCreatePanel.this.PG);
                            gridCommand = GridCommand.HOST_MODIFY_REMOVE_PG;
                            gridCommand.prepareCommand(hostObject.getName(), PhysicalGroupCreatePanel.this.PG.getName());
                            PhysicalGroupCreatePanel.this.grid.getExecutor().executeCommandGetString(gridCommand, false);
                        }
                    }
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    PhysicalGroupCreatePanel.this.grid.refreshGridModels();
                    this.firePropertyChange("progress", null, 100);
                }
                catch (JsonException | GridCommandException throwable) {
                    _logger.log(Level.SEVERE, throwable.getMessage());
                    this.firePropertyChange("error", null, throwable.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                customProgressMonitor.finish();
                if (!customProgressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskCancelled"));
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    PhysicalGroupCreatePanel.this.showModelNeedsApplyWarning();
                    GridMouseListener.expander.restoreExpansionState();
                }
            }
        };
        swingWorker.addPropertyChangeListener(customProgressMonitor);
        customProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }
}

