/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.shell.swing;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.timesten.grid.shell.buffer.CurrentScreenBuffer;
import oracle.dbtools.raptor.timesten.grid.shell.buffer.PreviousLinesBuffer;

public class TestPanel
extends JFrame {
    JButton refresh;
    private JTextArea text;
    private CurrentScreenBuffer buffer;
    private Font fontS;
    private PreviousLinesBuffer previousLines;
    private boolean autoRefresh;

    public TestPanel(CurrentScreenBuffer currentScreenBuffer, boolean bl) {
        this.setTitle("Current");
        this.autoRefresh = bl;
        this.buffer = currentScreenBuffer;
        this.buildComponent();
    }

    public TestPanel(PreviousLinesBuffer previousLinesBuffer, boolean bl) {
        this.setTitle("Back");
        this.autoRefresh = bl;
        this.previousLines = previousLinesBuffer;
        this.buildComponent();
    }

    private void buildComponent() {
        this.refresh = new JButton("Refresh");
        this.add((Component)this.refresh, "North");
        this.text = new JTextArea();
        this.fontS = Font.decode("Monospaced-14");
        this.text.setFont(this.fontS);
        this.add((Component)new JScrollPane(this.text), "Center");
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TestPanel.this.buffer != null) {
                    TestPanel.this.text.setText(TestPanel.this.buffer.toString());
                }
                if (TestPanel.this.previousLines != null) {
                    TestPanel.this.text.setText(TestPanel.this.previousLines.toString());
                }
            }
        });
        this.pack();
        this.setSize(300, 400);
        this.setVisible(true);
        Thread thread = new Thread(){

            @Override
            public void run() {
                do {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (TestPanel.this.buffer != null) {
                                TestPanel.this.text.setText(TestPanel.this.buffer.toString());
                            }
                            if (TestPanel.this.previousLines != null) {
                                TestPanel.this.text.setText(TestPanel.this.previousLines.toString());
                            }
                        }
                    });
                } while (TestPanel.this.autoRefresh);
            }
        };
        thread.start();
    }
}

