/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleLongProperty;
import javafx.scene.chart.Axis;
import javafx.util.StringConverter;

public final class DateAxis
extends Axis<Date> {
    private final LongProperty currentLowerBound = new SimpleLongProperty((Object)this, "currentLowerBound");
    private final LongProperty currentUpperBound = new SimpleLongProperty((Object)this, "currentUpperBound");
    private final ObjectProperty<StringConverter<Date>> tickLabelFormatter = new ObjectPropertyBase<StringConverter<Date>>(){

        protected void invalidated() {
            if (!DateAxis.this.isAutoRanging()) {
                DateAxis.this.invalidateRange();
                DateAxis.this.requestAxisLayout();
            }
        }

        public Object getBean() {
            return DateAxis.this;
        }

        public String getName() {
            return "tickLabelFormatter";
        }
    };
    private Date minDate;
    private Date maxDate;
    private ObjectProperty<Date> lowerBound = new ObjectPropertyBase<Date>(){

        protected void invalidated() {
            if (!DateAxis.this.isAutoRanging()) {
                DateAxis.this.invalidateRange();
                DateAxis.this.requestAxisLayout();
            }
        }

        public Object getBean() {
            return DateAxis.this;
        }

        public String getName() {
            return "lowerBound";
        }
    };
    private ObjectProperty<Date> upperBound = new ObjectPropertyBase<Date>(){

        protected void invalidated() {
            if (!DateAxis.this.isAutoRanging()) {
                DateAxis.this.invalidateRange();
                DateAxis.this.requestAxisLayout();
            }
        }

        public Object getBean() {
            return DateAxis.this;
        }

        public String getName() {
            return "upperBound";
        }
    };
    private Object currentAnimationID;
    private Interval actualInterval = Interval.DECADE;

    public DateAxis() {
    }

    public DateAxis(Date date, Date date2) {
        this();
        this.setAutoRanging(false);
        this.setLowerBound(date);
        this.setUpperBound(date2);
    }

    public DateAxis(String string, Date date, Date date2) {
        this(date, date2);
        this.setLabel(string);
    }

    public void invalidateRange(List<Date> list) {
        super.invalidateRange(list);
        Collections.sort(list);
        if (list.isEmpty()) {
            this.minDate = this.maxDate = new Date();
        } else if (list.size() == 1) {
            this.minDate = this.maxDate = list.get(0);
        } else if (list.size() > 1) {
            this.minDate = list.get(0);
            this.maxDate = list.get(list.size() - 1);
        }
    }

    protected Object autoRange(double d) {
        if (this.isAutoRanging()) {
            return new Object[]{this.minDate, this.maxDate};
        }
        if (this.getLowerBound() == null || this.getUpperBound() == null) {
            throw new IllegalArgumentException("If autoRanging is false, a lower and upper bound must be set.");
        }
        return this.getRange();
    }

    protected void setRange(Object object, boolean bl) {
        Object[] objectArray = (Object[])object;
        Date date = this.getLowerBound();
        Date date2 = this.getUpperBound();
        Date date3 = (Date)objectArray[0];
        Date date4 = (Date)objectArray[1];
        this.setLowerBound(date3);
        this.setUpperBound(date4);
        this.currentLowerBound.set(this.getLowerBound().getTime());
        this.currentUpperBound.set(this.getUpperBound().getTime());
    }

    protected Object getRange() {
        return new Object[]{this.getLowerBound(), this.getUpperBound()};
    }

    public double getZeroPosition() {
        return 0.0;
    }

    public double getDisplayPosition(Date date) {
        double d = this.getSide().isHorizontal() ? this.getWidth() : this.getHeight();
        double d2 = this.currentUpperBound.get() - this.currentLowerBound.get();
        double d3 = d - this.getZeroPosition();
        double d4 = (double)(date.getTime() - this.currentLowerBound.get()) / d2;
        if (this.getSide().isVertical()) {
            return this.getHeight() - d4 * d3 + this.getZeroPosition();
        }
        return d4 * d3 + this.getZeroPosition();
    }

    public Date getValueForDisplay(double d) {
        double d2 = this.getSide().isHorizontal() ? this.getWidth() : this.getHeight();
        double d3 = this.currentUpperBound.get() - this.currentLowerBound.get();
        double d4 = d2 - this.getZeroPosition();
        if (this.getSide().isVertical()) {
            return new Date((long)((d - this.getZeroPosition() - this.getHeight()) / -d4 * d3 + (double)this.currentLowerBound.get()));
        }
        return new Date((long)((d - this.getZeroPosition()) / d4 * d3 + (double)this.currentLowerBound.get()));
    }

    public boolean isValueOnAxis(Date date) {
        return date.getTime() > this.currentLowerBound.get() && date.getTime() < this.currentUpperBound.get();
    }

    public double toNumericValue(Date date) {
        return date.getTime();
    }

    public Date toRealValue(double d) {
        return new Date((long)d);
    }

    protected List<Date> calculateTickValues(double d, Object object) {
        Object[] objectArray = (Object[])object;
        Date date = (Date)objectArray[0];
        Date date2 = (Date)objectArray[1];
        ArrayList<Date> arrayList = new ArrayList<Date>();
        Calendar calendar = Calendar.getInstance();
        double d2 = 100.0;
        double d3 = d / d2;
        ArrayList<Date> arrayList2 = new ArrayList<Date>();
        Interval interval = Interval.values()[0];
        for (Interval object2 : Interval.values()) {
            calendar.setTime(date);
            arrayList.clear();
            arrayList2.clear();
            this.actualInterval = object2;
            while (calendar.getTime().getTime() <= date2.getTime()) {
                arrayList.add(calendar.getTime());
                calendar.add(object2.interval, object2.amount);
            }
            if ((double)arrayList.size() > d3) {
                calendar.setTime(date);
                while (calendar.getTime().getTime() <= date2.getTime()) {
                    arrayList2.add(calendar.getTime());
                    calendar.add(interval.interval, interval.amount);
                }
                break;
            }
            interval = object2;
        }
        if ((double)arrayList2.size() - d3 > d3 - (double)arrayList.size()) {
            arrayList = arrayList2;
            this.actualInterval = interval;
        }
        arrayList.add(date2);
        List<Date> list = this.makeDatesEven(arrayList, calendar);
        if (list.size() > 2) {
            Date date3 = (Date)list.get(1);
            Date date4 = (Date)list.get(2);
            Date date5 = (Date)list.get(arrayList.size() - 2);
            Date date6 = (Date)list.get(arrayList.size() - 3);
            if (date3.getTime() - date.getTime() < (date4.getTime() - date3.getTime()) / 2L) {
                list.remove(date3);
            }
            if (date2.getTime() - date5.getTime() < (date5.getTime() - date6.getTime()) / 2L) {
                list.remove(date5);
            }
        }
        return list;
    }

    protected void layoutChildren() {
        if (!this.isAutoRanging()) {
            this.currentLowerBound.set(this.getLowerBound().getTime());
            this.currentUpperBound.set(this.getUpperBound().getTime());
        }
        super.layoutChildren();
    }

    protected String getTickMarkLabel(Date date) {
        DateFormat dateFormat;
        StringConverter<Date> stringConverter = this.getTickLabelFormatter();
        if (stringConverter != null) {
            return stringConverter.toString((Object)date);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (this.actualInterval.interval == 1 && calendar.get(2) == 0 && calendar.get(5) == 1) {
            dateFormat = new SimpleDateFormat("yyyy");
        } else if (this.actualInterval.interval == 2 && calendar.get(5) == 1) {
            dateFormat = new SimpleDateFormat("MMM yy");
        } else {
            switch (this.actualInterval.interval) {
                default: {
                    dateFormat = DateFormat.getDateInstance(2);
                    break;
                }
                case 10: 
                case 12: {
                    dateFormat = DateFormat.getTimeInstance(3);
                    break;
                }
                case 13: {
                    dateFormat = DateFormat.getTimeInstance(2);
                    break;
                }
                case 14: {
                    dateFormat = DateFormat.getTimeInstance(0);
                }
            }
        }
        return dateFormat.format(date);
    }

    private List<Date> makeDatesEven(List<Date> list, Calendar calendar) {
        if (list.size() > 2) {
            ArrayList<Date> arrayList = new ArrayList<Date>();
            for (int i = 0; i < list.size(); ++i) {
                calendar.setTime(list.get(i));
                switch (this.actualInterval.interval) {
                    case 1: {
                        if (i != 0 && i != list.size() - 1) {
                            calendar.set(2, 0);
                            calendar.set(5, 1);
                        }
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 6);
                        break;
                    }
                    case 2: {
                        if (i != 0 && i != list.size() - 1) {
                            calendar.set(5, 1);
                        }
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 5);
                        break;
                    }
                    case 3: {
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 4);
                        break;
                    }
                    case 5: {
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 3);
                        break;
                    }
                    case 10: {
                        if (i != 0 && i != list.size() - 1) {
                            calendar.set(12, 0);
                            calendar.set(13, 0);
                        }
                        calendar.set(14, 2);
                        break;
                    }
                    case 12: {
                        if (i != 0 && i != list.size() - 1) {
                            calendar.set(13, 0);
                        }
                        calendar.set(14, 1);
                        break;
                    }
                    case 13: {
                        calendar.set(14, 0);
                    }
                }
                arrayList.add(calendar.getTime());
            }
            return arrayList;
        }
        return list;
    }

    public final ObjectProperty<Date> lowerBoundProperty() {
        return this.lowerBound;
    }

    public final Date getLowerBound() {
        return (Date)this.lowerBound.get();
    }

    public final void setLowerBound(Date date) {
        this.lowerBound.set((Object)date);
    }

    public final ObjectProperty<Date> upperBoundProperty() {
        return this.upperBound;
    }

    public final Date getUpperBound() {
        return (Date)this.upperBound.get();
    }

    public final void setUpperBound(Date date) {
        this.upperBound.set((Object)date);
    }

    public final StringConverter<Date> getTickLabelFormatter() {
        return (StringConverter)this.tickLabelFormatter.getValue();
    }

    public final void setTickLabelFormatter(StringConverter<Date> stringConverter) {
        this.tickLabelFormatter.setValue(stringConverter);
    }

    public final ObjectProperty<StringConverter<Date>> tickLabelFormatterProperty() {
        return this.tickLabelFormatter;
    }

    private static enum Interval {
        DECADE(1, 10),
        YEAR(1, 1),
        MONTH_6(2, 6),
        MONTH_3(2, 3),
        MONTH_1(2, 1),
        WEEK(3, 1),
        DAY(5, 1),
        HOUR_12(10, 12),
        HOUR_6(10, 6),
        HOUR_3(10, 3),
        HOUR_1(10, 1),
        MINUTE_15(12, 15),
        MINUTE_5(12, 5),
        MINUTE_1(12, 1),
        SECOND_15(13, 15),
        SECOND_5(13, 5),
        SECOND_1(13, 1),
        MILLISECOND(14, 1);

        private final int amount;
        private final int interval;

        private Interval(int n2, int n3) {
            this.interval = n2;
            this.amount = n3;
        }
    }
}

