/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.performancemonitor.GenericPerformanceMonitorNode;
import oracle.dbtools.raptor.timesten.performancemonitor.GridSummaryPane;
import oracle.dbtools.raptor.timesten.performancemonitor.PerformanceDataEditor;
import oracle.dbtools.raptor.timesten.performancemonitor.data.DashboardSummaryInfo;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;

public class GaugeChart
extends Region {
    private int maxValue = 100;
    private int minValue = 0;
    private DashboardSummaryInfo value;
    private static final int GAUGE_BORDER = 10;
    private final int HEADER_SIZE = 80;
    private int greenSize;
    private int yellowSize;
    private int redSize;
    private String title;
    private String subtitle;
    private boolean percentage;
    private static final double MIN_SIZE = 250.0;
    private final int LINE_WIDTH = 15;
    private Color backgroundColor;
    private ToggleButton button;
    private boolean showDetails;
    private double titleHeight;
    EventHandler<MouseEvent> doubleClick = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        GenericPerformanceMonitorNode genericPerformanceMonitorNode = null;
                        genericPerformanceMonitorNode = new GenericPerformanceMonitorNode(GaugeChart.this.title, GenericPerformanceMonitorNode.SUMMARY_INFO);
                        genericPerformanceMonitorNode.setFieldData(GaugeChart.this.value);
                        Context context = Context.newIdeContext((oracle.ide.model.Node)genericPerformanceMonitorNode);
                        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, PerformanceDataEditor.class);
                        List list = EditorManager.getEditorManager().getAllEditors();
                        ArrayList<Editor> arrayList = new ArrayList<Editor>();
                        for (Editor editor : list) {
                            if (!(editor instanceof PerformanceDataEditor)) continue;
                            arrayList.add(editor);
                        }
                        EditorManager.getEditorManager().closeEditors(arrayList);
                        Editor editor = EditorManager.getEditorManager().openEditor(openEditorOptions);
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    };

    public GaugeChart(int n, int n2, int n3, int n4, int n5, boolean bl) {
        this(n, n2, n3, n4, n5, bl, null, null);
    }

    public GaugeChart(int n, int n2, int n3, int n4, int n5, boolean bl, String string, String string2) {
        this.minValue = n;
        this.maxValue = n2;
        this.value = null;
        this.greenSize = n3;
        this.yellowSize = n4;
        this.redSize = n5;
        this.percentage = bl;
        this.setPrefHeight(250.0);
        this.backgroundColor = Color.WHITE;
        this.title = string;
        this.subtitle = string2;
        this.button = new ToggleButton(Messages.getString("TimestenGrid.details"));
        this.button.setFont(GridSummaryPane.TITLE_FONT);
        this.button.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                if (number2.doubleValue() > 0.0) {
                    GaugeChart.this.button.setTranslateX(GaugeChart.this.getWidth() - number2.doubleValue() - 10.0);
                }
            }
        });
        this.addEvents();
        this.redraw(this.getWidth(), this.getHeight());
        this.setOnMouseClicked(this.doubleClick);
    }

    private void addEvents() {
        this.button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                GaugeChart.this.showDetails = GaugeChart.this.button.isSelected();
                GaugeChart.this.redraw(GaugeChart.this.getWidth(), GaugeChart.this.getHeight());
            }
        });
    }

    public GaugeChart(boolean bl, String string) {
        this(0, 100, 100, 101, 101, bl, string, null);
    }

    public GaugeChart(boolean bl, String string, String string2) {
        this(0, 100, 100, 101, 101, bl, string, string2);
    }

    public void setBackgroungColor(Color color) {
        this.backgroundColor = color;
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, null, null)}));
        this.redraw(this.getWidth(), this.getHeight());
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void resize(double d, double d2) {
        super.resize(d, d2);
        this.redraw(this.getWidth(), this.getHeight());
    }

    public void setValue(DashboardSummaryInfo dashboardSummaryInfo) {
        if (dashboardSummaryInfo != null && dashboardSummaryInfo.getAverage() >= (double)this.minValue && dashboardSummaryInfo.getAverage() <= (double)this.maxValue) {
            this.value = dashboardSummaryInfo;
            this.redraw(this.getWidth(), this.getHeight());
        }
    }

    protected void redraw(double d, double d2) {
        if (this.value != null) {
            double d3 = (Math.min(d, d2) - 80.0) / 2.0;
            double d4 = d / 2.0;
            double d5 = d2 / 2.0;
            this.titleHeight = 0.0;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            this.button.setTranslateY(5.0);
            if (this.title != null) {
                arrayList.add(this.createTitle(d3, d4, d5));
            }
            if (this.showDetails) {
                double d6 = (d2 - 80.0) / 3.0;
                double d7 = d - 20.0;
                arrayList.add(this.createBar(this.value.getMin(), d, d2, d7, d6, 10.0, this.titleHeight + 20.0, Color.DARKGREEN, "Min."));
                arrayList.add(this.createBar(this.value.getAverage(), d, d2, d7, d6, 10.0, this.titleHeight + d6 + 30.0, Color.DARKORANGE, "Avg."));
                arrayList.add(this.createBar(this.value.getMax(), d, d2, d7, d6, 10.0, this.titleHeight + 2.0 * d6 + 40.0, Color.DARKRED, "Max."));
            } else {
                arrayList.add(this.createGauge(d3, d4, d5));
                arrayList.add(this.createScale(d3, d4, d5));
                arrayList.add(this.createValue(d3, d4, d5));
                arrayList.add(this.createCenter(d3, d4, d5));
                arrayList.add(this.createValueText(d3, d4, d5));
                if (this.subtitle != null) {
                    arrayList.add(this.createSubTitle(d2, d4, d5));
                }
            }
            arrayList.add(this.button);
            this.getChildren().clear();
            this.getChildren().addAll(arrayList);
        }
    }

    private Node createBar(double d, double d2, double d3, double d4, double d5, double d6, double d7, Color color, String string) {
        String string2 = string + " " + Integer.toString((int)d);
        if (this.percentage) {
            string2 = string2 + "%";
        }
        StackPane stackPane = new StackPane();
        Text text = new Text(string2);
        text.setFill((Paint)Color.BLACK);
        text.setFont(Font.font((double)13.0));
        double d8 = 0.0;
        d8 = this.percentage ? d * d4 / 100.0 : d * 100.0 / this.value.getMax();
        Rectangle rectangle = new Rectangle(d4, d5, (Paint)Color.DARKGRAY);
        Rectangle rectangle2 = new Rectangle(d8, d5, (Paint)color);
        rectangle2.setTranslateX(-1.0 * (d4 / 2.0 - d8 / 2.0));
        stackPane.getChildren().addAll((Object[])new Node[]{rectangle, rectangle2, text});
        stackPane.setTranslateX(d6);
        stackPane.setTranslateY(d7);
        return stackPane;
    }

    private Node createTitle(double d, double d2, double d3) {
        Text text = new Text(0.0, 0.0, this.title);
        text.setFont(GridSummaryPane.TITLE_FONT);
        Bounds bounds = text.getLayoutBounds();
        text.setTranslateX(10.0);
        text.setTranslateY(bounds.getHeight());
        this.titleHeight = bounds.getHeight();
        return text;
    }

    private Node createSubTitle(double d, double d2, double d3) {
        Text text = new Text(d2, d, this.subtitle);
        text.setFont(Font.font((double)17.0));
        Bounds bounds = text.getLayoutBounds();
        text.setTranslateX(bounds.getWidth() / 2.0 * -1.0);
        text.setTranslateY(bounds.getHeight());
        return text;
    }

    private Node createValueText(double d, double d2, double d3) {
        String string = Integer.toString((int)this.value.getAverage());
        if (this.percentage) {
            string = string + '%';
        }
        Text text = new Text(d2, d3, string);
        text.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)(Font.getDefault().getSize() + 35.0)));
        int n = 34;
        while (d > 0.0 && text.getLayoutBounds().getWidth() > d - 20.0) {
            text.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)(Font.getDefault().getSize() + (double)n--)));
        }
        Bounds bounds = text.getLayoutBounds();
        text.setTranslateX(bounds.getWidth() / 2.0 * -1.0);
        text.setTranslateY(bounds.getHeight() / 4.0);
        text.setFill((Paint)Color.DARKGRAY);
        return text;
    }

    private Node createCenter(double d, double d2, double d3) {
        Circle circle = new Circle(d2, d3, d - 15.0);
        circle.setFill((Paint)this.backgroundColor);
        return circle;
    }

    private Node createScale(double d, double d2, double d3) {
        Arc arc = new Arc();
        arc.setCenterX(d2);
        arc.setCenterY(d3);
        arc.setRadiusX(d + 1.0);
        arc.setRadiusY(d + 1.0);
        arc.setStartAngle(260.0);
        arc.setLength(20.0);
        arc.setType(ArcType.ROUND);
        arc.setFill((Paint)this.backgroundColor);
        return arc;
    }

    private Node createValue(double d, double d2, double d3) {
        int n = 340 - (int)this.value.getAverage() * 340 / 100;
        Arc arc = new Arc();
        arc.setCenterX(d2);
        arc.setCenterY(d3);
        arc.setRadiusX(d);
        arc.setRadiusY(d);
        arc.setStartAngle(280.0);
        arc.setLength((double)n);
        arc.setType(ArcType.ROUND);
        arc.setFill((Paint)Color.DARKGRAY);
        return arc;
    }

    private Node createGauge(double d, double d2, double d3) {
        Circle circle = new Circle(d2, d3, d);
        if (this.value.getAverage() <= (double)this.greenSize) {
            circle.setFill((Paint)Color.DARKGREEN);
        } else if (this.value.getAverage() > (double)this.greenSize && this.value.getAverage() <= (double)this.yellowSize) {
            circle.setFill((Paint)Color.DARKORANGE);
        } else if (this.value.getAverage() > (double)this.yellowSize && this.value.getAverage() <= (double)this.redSize) {
            circle.setFill((Paint)Color.DARKRED);
        }
        return circle;
    }
}

