/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor;

import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.performancemonitor.PerformanceConstants;
import oracle.dbtools.raptor.timesten.performancemonitor.TopologyEditor;
import oracle.dbtools.raptor.timesten.performancemonitor.TopologyNode;
import oracle.dbtools.raptor.timesten.performancemonitor.data.DashboardSummaryInfo;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;

public class PerformanceDataPane
extends SplitPane {
    final CategoryAxis xAxis = new CategoryAxis();
    final NumberAxis yAxis = new NumberAxis();
    final BarChart<String, Number> barChart = new BarChart((Axis)this.xAxis, (Axis)this.yAxis);
    private Button details;
    private DashboardSummaryInfo info;
    private TableView<DashboardSummaryInfo.DashboadInfo> table = new TableView();
    EventHandler<ActionEvent> detailsClick = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent actionEvent) {
            PerformanceDataPane.this.showDetails();
        }
    };

    public PerformanceDataPane(DashboardSummaryInfo dashboardSummaryInfo) {
        DashboardSummaryInfo.DashboadInfo dashboadInfo2;
        this.info = dashboardSummaryInfo;
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 2, Locale.getDefault());
        String string = ((SimpleDateFormat)dateFormat).toLocalizedPattern();
        final SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        this.xAxis.setLabel(Messages.getString("TimestenGrid.elementId"));
        this.yAxis.setLabel(Messages.getString("TimestenGrid.value"));
        XYChart.Series series = new XYChart.Series();
        series.setName(Messages.getString("TimestenGrid.data"));
        for (DashboardSummaryInfo.DashboadInfo dashboadInfo2 : dashboardSummaryInfo.getInfo()) {
            series.getData().add((Object)new XYChart.Data((Object)dashboadInfo2.getElementId().toString(), (Object)dashboadInfo2.getValue()));
        }
        this.barChart.getData().add((Object)series);
        TableColumn tableColumn = new TableColumn(Messages.getString("TimestenGrid.elementId"));
        dashboadInfo2 = new TableColumn(Messages.getString("TimestenGrid.value"));
        TableColumn tableColumn2 = new TableColumn(Messages.getString("TimestenGrid.collectionTime"));
        tableColumn.setCellValueFactory((Callback)new PropertyValueFactory("elementId"));
        dashboadInfo2.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        tableColumn2.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<DashboardSummaryInfo.DashboadInfo, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<DashboardSummaryInfo.DashboadInfo, String> cellDataFeatures) {
                if (cellDataFeatures.getValue() != null && ((DashboardSummaryInfo.DashboadInfo)cellDataFeatures.getValue()).getCollected() != null) {
                    return new ReadOnlyObjectWrapper((Object)simpleDateFormat.format(((DashboardSummaryInfo.DashboadInfo)cellDataFeatures.getValue()).getCollected()));
                }
                return new ReadOnlyObjectWrapper((Object)"");
            }
        });
        this.table.getColumns().addAll((Object[])new TableColumn[]{tableColumn, dashboadInfo2, tableColumn2});
        this.table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        ObservableList observableList = FXCollections.observableArrayList();
        observableList.addAll(dashboardSummaryInfo.getInfo());
        this.table.setItems(observableList);
        this.setOrientation(Orientation.VERTICAL);
        BorderPane borderPane = new BorderPane();
        HBox hBox = new HBox(10.0);
        hBox.setPadding(new Insets(10.0));
        hBox.setAlignment(Pos.TOP_RIGHT);
        this.details = new Button(Messages.getString("TimestenGrid.details"));
        hBox.getChildren().add((Object)this.details);
        this.details.setDisable(true);
        this.details.setOnAction(this.detailsClick);
        borderPane.setTop((Node)hBox);
        borderPane.setCenter(this.table);
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<DashboardSummaryInfo.DashboadInfo>(){

            public void changed(ObservableValue<? extends DashboardSummaryInfo.DashboadInfo> observableValue, DashboardSummaryInfo.DashboadInfo dashboadInfo, DashboardSummaryInfo.DashboadInfo dashboadInfo2) {
                int n = PerformanceDataPane.this.table.getSelectionModel().getSelectedItems().size();
                PerformanceDataPane.this.details.setDisable(n == 0);
            }
        });
        this.getItems().addAll((Object[])new Node[]{this.barChart, borderPane});
    }

    private TreeSet<Integer> getIds() {
        ObservableList observableList = this.table.getSelectionModel().getSelectedItems();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (DashboardSummaryInfo.DashboadInfo dashboadInfo : observableList) {
            treeSet.add(dashboadInfo.getElementId());
        }
        return treeSet;
    }

    public void showDetails() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TopologyEditor topologyEditor2;
                    TopologyNode topologyNode = null;
                    topologyNode = new TopologyNode(PerformanceDataPane.this.info.getConnection(), Messages.getString("TimestenGrid.topology"), TopologyNode.Type.TOPOLOGY);
                    Context context = Context.newIdeContext((oracle.ide.model.Node)topologyNode);
                    OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, TopologyEditor.class);
                    List list = EditorManager.getEditorManager().getAllEditors();
                    ArrayList<TopologyEditor> arrayList = new ArrayList<TopologyEditor>();
                    if (list != null && !list.isEmpty()) {
                        for (TopologyEditor topologyEditor2 : list) {
                            if (!(topologyEditor2 instanceof TopologyEditor)) continue;
                            TopologyEditor topologyEditor3 = topologyEditor2;
                            arrayList.add(topologyEditor2);
                        }
                    }
                    if (!arrayList.isEmpty()) {
                        EditorManager.getEditorManager().closeEditors(arrayList);
                    }
                    Editor editor = EditorManager.getEditorManager().openEditor(openEditorOptions);
                    topologyEditor2 = (TopologyEditor)editor;
                    topologyEditor2.activate();
                    topologyEditor2.show();
                    PerformanceDataPane.this.refreshEditor(topologyEditor2, PerformanceDataPane.this.getIds(), PerformanceDataPane.this.info.getGraphType());
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    private void refreshEditor(TopologyEditor topologyEditor, TreeSet<Integer> treeSet, PerformanceConstants.PerformanceChartTypes performanceChartTypes) {
        if (Platform.isFxApplicationThread()) {
            topologyEditor.getTopologyPane().showTimeInformation(treeSet, this.info.getGraphType());
        } else {
            Platform.runLater(() -> topologyEditor.getTopologyPane().showTimeInformation(treeSet, this.info.getGraphType()));
        }
    }
}

