/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor.distribution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.transform.Scale;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.performancemonitor.distribution.ComparableGraphPane;
import oracle.dbtools.raptor.timesten.performancemonitor.distribution.ElementSelectionListener;
import oracle.dbtools.raptor.timesten.performancemonitor.distribution.TopologyInfoSplitPane;
import oracle.dbtools.raptor.timesten.performancemonitor.distribution.TopologyInformer;

public class TopologyPanel
extends BorderPane {
    private final String ID = Messages.getString("TimestenGrid.id");
    private final String HOST = Messages.getString("TimestenGrid.host");
    private final String NAME = Messages.getString("TimestenGrid.instance");
    private static final long serialVersionUID = 1L;
    private TopologyInformer informer;
    private static int FIELD_WIDTH = 250;
    private static Image menu = new Image(TopologyInfoSplitPane.class.getResourceAsStream("menu.png"));
    private static Image warning = new Image(TopologyInfoSplitPane.class.getResourceAsStream("warning.png"));
    private static int FIELD_HEIGHT = (int)(60.0 + menu.getHeight());
    private static int COMPONENT_PADDING = 10;
    private static int MAX_TEXT_WIDTH = FIELD_WIDTH - COMPONENT_PADDING - COMPONENT_PADDING;
    private Scale scale = new Scale(1.0, 1.0);
    private Group root;
    private double zoomFactor = 1.0;
    private double orgSceneX;
    private double orgSceneY;
    private double orgTranslateX;
    private double orgTranslateY;
    private Pane internalPane;
    private StackPane selectedPane;
    private Button zoomIn;
    private Button zoomOut;
    private Button center;
    private Color CARRIOT_COLOR = Color.LIGHTGREY;
    private Text t = new Text();
    private final Color[] COLUMN_COLORS;
    private ArrayList<StackPane> replicaSetList;
    private ArrayList<StackPane> dataSpaceGroups;
    private ArrayList<StackPane> elementList;
    private HashMap<String, String> elementPosition;
    private HashMap<String, Integer> nameElement;
    private ElementSelectionListener elementSelection;
    EventHandler<MouseEvent> elementClicked;
    EventHandler<MouseEvent> menuClicked;
    EventHandler<MouseEvent> dsgClicked;
    EventHandler<MouseEvent> rsClicked;
    EventHandler<MouseEvent> rootOnMouseDraggedEventHandler;
    EventHandler<MouseEvent> rootOnMousePressedEventHandler;
    EventHandler<KeyEvent> keyPressed;

    public TopologyPanel(TopologyInformer topologyInformer) {
        this.t.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)13.0));
        this.COLUMN_COLORS = new Color[]{Color.web((String)"0x1ABC9C"), Color.web((String)"0x3498DB"), Color.web((String)"0x9B59B6"), Color.web((String)"0x34495E"), Color.web((String)"0xFF4081"), Color.web((String)"0xE74c3c"), Color.web((String)"0x84009E"), Color.web((String)"0xF50057"), Color.BLANCHEDALMOND, Color.AQUA, Color.BLUEVIOLET, Color.BROWN, Color.AZURE, Color.CHARTREUSE};
        this.replicaSetList = new ArrayList();
        this.dataSpaceGroups = new ArrayList();
        this.elementList = new ArrayList();
        this.elementPosition = new HashMap();
        this.nameElement = new HashMap();
        this.elementClicked = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                StackPane stackPane = (StackPane)mouseEvent.getSource();
                TopologyPanel.this.highLightPane(stackPane);
                if (mouseEvent.getButton() != MouseButton.PRIMARY && mouseEvent.getButton() == MouseButton.SECONDARY) {
                    if (stackPane instanceof ElementField) {
                        TopologyPanel.this.manageSelection((ElementField)stackPane, mouseEvent.getScreenX(), mouseEvent.getScreenY());
                    }
                    mouseEvent.consume();
                }
            }
        };
        this.menuClicked = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                    StackPane stackPane = (StackPane)((Button)mouseEvent.getSource()).getParent();
                    if (stackPane instanceof ElementField) {
                        TopologyPanel.this.manageSelection((ElementField)stackPane, mouseEvent.getScreenX(), mouseEvent.getScreenY());
                    }
                    mouseEvent.consume();
                }
            }
        };
        this.dsgClicked = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                StackPane stackPane = (StackPane)mouseEvent.getSource();
                TopologyPanel.this.highLightPane(stackPane);
                if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                    // empty if block
                }
                mouseEvent.consume();
            }
        };
        this.rsClicked = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                StackPane stackPane = (StackPane)mouseEvent.getSource();
                TopologyPanel.this.highLightPane(stackPane);
                if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                    // empty if block
                }
                mouseEvent.consume();
            }
        };
        this.rootOnMouseDraggedEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                double d = mouseEvent.getSceneX() - TopologyPanel.this.orgSceneX;
                double d2 = mouseEvent.getSceneY() - TopologyPanel.this.orgSceneY;
                double d3 = TopologyPanel.this.orgTranslateX + d;
                double d4 = TopologyPanel.this.orgTranslateY + d2;
                TopologyPanel.this.root.setTranslateX(d3);
                TopologyPanel.this.root.setTranslateY(d4);
            }
        };
        this.rootOnMousePressedEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                TopologyPanel.this.orgSceneX = mouseEvent.getSceneX();
                TopologyPanel.this.orgSceneY = mouseEvent.getSceneY();
                TopologyPanel.this.orgTranslateX = TopologyPanel.this.root.getTranslateX();
                TopologyPanel.this.orgTranslateY = TopologyPanel.this.root.getTranslateY();
            }
        };
        this.keyPressed = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && (keyEvent.getCode() == KeyCode.PLUS || keyEvent.getCode() == KeyCode.ADD)) {
                    TopologyPanel.this.zoomFactor = TopologyPanel.this.zoomFactor + 0.1;
                    TopologyPanel.this.scale.setX(TopologyPanel.this.zoomFactor);
                    TopologyPanel.this.scale.setY(TopologyPanel.this.zoomFactor);
                    TopologyPanel.this.root.requestLayout();
                } else if (keyEvent.isControlDown() && (keyEvent.getCode() == KeyCode.MINUS || keyEvent.getCode() == KeyCode.SUBTRACT) && TopologyPanel.this.zoomFactor > 0.1) {
                    TopologyPanel.this.zoomFactor = TopologyPanel.this.zoomFactor - 0.1;
                    TopologyPanel.this.scale.setX(TopologyPanel.this.zoomFactor);
                    TopologyPanel.this.scale.setY(TopologyPanel.this.zoomFactor);
                    TopologyPanel.this.root.requestLayout();
                }
            }
        };
        this.setOnKeyPressed(this.keyPressed);
        this.informer = topologyInformer;
        this.init();
    }

    public void setElementSelection(ElementSelectionListener elementSelectionListener) {
        this.elementSelection = elementSelectionListener;
    }

    public List<Integer> getSelectedElements() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (StackPane stackPane : this.elementList) {
            ElementField elementField = (ElementField)stackPane;
            if (!elementField.isSelected()) continue;
            arrayList.add(elementField.getElementId());
        }
        return arrayList;
    }

    public void setSelected(TreeSet<Integer> treeSet) {
        for (StackPane stackPane : this.elementList) {
            ElementField elementField = (ElementField)stackPane;
            if (!treeSet.contains(elementField.getElementId())) continue;
            elementField.setSelected(true);
        }
    }

    private void init() {
        this.internalPane = new Pane();
        this.internalPane.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent scrollEvent) {
                TopologyPanel.this.zoomFactor = TopologyPanel.this.zoomFactor + (scrollEvent.getDeltaY() > 0.0 ? 0.1 : -0.1);
                if (TopologyPanel.this.zoomFactor < 0.1) {
                    TopologyPanel.this.zoomFactor = 0.1;
                }
                TopologyPanel.this.scale.setX(TopologyPanel.this.zoomFactor);
                TopologyPanel.this.scale.setY(TopologyPanel.this.zoomFactor);
                TopologyPanel.this.root.requestLayout();
            }
        });
        this.internalPane.setOnMousePressed(this.rootOnMousePressedEventHandler);
        this.internalPane.setOnMouseDragged(this.rootOnMouseDraggedEventHandler);
        this.setCenter((Node)this.internalPane);
        this.createScene();
        this.createToolbar();
    }

    private void createToolbar() {
        ToolBar toolBar = new ToolBar();
        ImageView imageView = new ImageView(new Image(ComparableGraphPane.class.getResourceAsStream("zoomIn.png")));
        ImageView imageView2 = new ImageView(new Image(ComparableGraphPane.class.getResourceAsStream("zoomOut.png")));
        ImageView imageView3 = new ImageView(new Image(ComparableGraphPane.class.getResourceAsStream("center.png")));
        this.zoomIn = new Button();
        this.zoomIn.setGraphic((Node)imageView);
        this.zoomIn.setTooltip(new Tooltip(Messages.getString("TimestenGrid.zoomIn")));
        this.zoomOut = new Button();
        this.zoomOut.setTooltip(new Tooltip(Messages.getString("TimestenGrid.zoomOut")));
        this.zoomOut.setGraphic((Node)imageView2);
        this.center = new Button();
        this.center.setTooltip(new Tooltip(Messages.getString("TimestenGrid.center")));
        this.center.setGraphic((Node)imageView3);
        Region region = new Region();
        HBox.setHgrow((Node)region, (Priority)Priority.ALWAYS);
        toolBar.getItems().addAll((Object[])new Node[]{region, this.zoomOut, this.center, this.zoomIn});
        this.setTop((Node)toolBar);
        this.zoomIn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                TopologyPanel.this.zoomIn();
            }
        });
        this.zoomOut.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                TopologyPanel.this.zoomOut();
            }
        });
        this.center.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                TopologyPanel.this.center();
            }
        });
    }

    private void zoomIn() {
        this.zoomFactor += 0.1;
        this.scale.setX(this.zoomFactor);
        this.scale.setY(this.zoomFactor);
        this.root.requestLayout();
    }

    private void zoomOut() {
        this.zoomFactor -= 0.1;
        if (this.zoomFactor < 0.1) {
            this.zoomFactor = 0.1;
        }
        this.scale.setX(this.zoomFactor);
        this.scale.setY(this.zoomFactor);
        this.root.requestLayout();
    }

    private void center() {
        this.root.setTranslateX(0.0);
        this.root.setTranslateY(0.0);
    }

    private void createScene() {
        this.doCreateReplicaSetElements();
        this.doCreateDataSpaceGroups();
        this.doCreateElements();
        this.root = new Group();
        this.root.setCursor(Cursor.HAND);
        this.internalPane.getChildren().add((Object)this.root);
        this.scale = new Scale(1.0, 1.0);
        this.root.getTransforms().add((Object)this.scale);
        this.root.getChildren().addAll(this.replicaSetList);
        this.root.getChildren().addAll(this.dataSpaceGroups);
    }

    private void doCreateElements() {
        int n;
        int n2 = n = FIELD_WIDTH + COMPONENT_PADDING;
        int n3 = COMPONENT_PADDING + COMPONENT_PADDING + COMPONENT_PADDING + FIELD_HEIGHT;
        int n4 = 0;
        for (int i = 0; i < this.informer.getReplicaSets().length; ++i) {
            for (int j = 0; j < this.informer.getDataSpaceGroups().length; ++j) {
                String[] stringArray = this.informer.getElement(j, i);
                this.elementPosition.put(stringArray[0], j + "/" + i);
                int n5 = this.informer.getElementId(j, i);
                this.nameElement.put(stringArray[0], n5);
                this.dataSpaceGroups.add(this.createElement(n5, stringArray[0], stringArray[1], FIELD_WIDTH, FIELD_HEIGHT, n2, n3, this.COLUMN_COLORS[n4]));
                n2 += FIELD_WIDTH + COMPONENT_PADDING;
                ++n4;
            }
            n3 += FIELD_HEIGHT + COMPONENT_PADDING + COMPONENT_PADDING + COMPONENT_PADDING;
            n2 = n;
            n4 = 0;
        }
    }

    private void doCreateDataSpaceGroups() {
        int n;
        int n2 = n = FIELD_WIDTH + COMPONENT_PADDING;
        int n3 = COMPONENT_PADDING;
        int n4 = 0;
        for (String string : this.informer.getDataSpaceGroups()) {
            this.dataSpaceGroups.add(this.createDSGElement("Data Space Group " + string, FIELD_WIDTH, FIELD_HEIGHT, n2, n3, this.COLUMN_COLORS[n4]));
            n2 += FIELD_WIDTH + COMPONENT_PADDING;
            ++n4;
        }
    }

    private void doCreateReplicaSetElements() {
        int n = this.informer.getDataSpaceGroups().length;
        int n2 = (n + 1) * FIELD_WIDTH + n * COMPONENT_PADDING;
        int n3 = COMPONENT_PADDING + COMPONENT_PADDING + FIELD_HEIGHT;
        int n4 = COMPONENT_PADDING + COMPONENT_PADDING + FIELD_HEIGHT;
        for (String string : this.informer.getReplicaSets()) {
            this.replicaSetList.add(this.createRSElement("Replica Set " + string, n2, n3, COMPONENT_PADDING, n4, this.CARRIOT_COLOR));
            n4 += n3 + COMPONENT_PADDING;
        }
    }

    private StackPane createElement(int n, String string, String string2, int n2, int n3, int n4, int n5, Color color) {
        StackPane stackPane = this.createHelper(n, string, string2, n2, n3, n4, n5, color);
        stackPane.setOnMouseClicked(this.elementClicked);
        this.elementList.add(stackPane);
        return stackPane;
    }

    private StackPane createHelper(int n, String string, String string2, int n2, int n3, int n4, int n5, Color color) {
        return new ElementField(n, string, string2, n2, n3, color, n4, n5);
    }

    private StackPane createHelper(String string, int n, int n2, int n3, int n4, Color color) {
        Label label = new Label(string);
        label.setTextFill((Paint)Color.WHITE);
        label.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)13.0));
        label.setMaxWidth((double)MAX_TEXT_WIDTH);
        Rectangle rectangle = new Rectangle((double)n, (double)n2, (Paint)color);
        final StackPane stackPane = new StackPane();
        stackPane.getChildren().addAll((Object[])new Node[]{rectangle, label});
        stackPane.setTranslateX((double)n3);
        stackPane.setTranslateY((double)n4);
        ImageView imageView = new ImageView(menu);
        final Button button = new Button();
        button.setFocusTraversable(true);
        button.setGraphic((Node)imageView);
        button.setStyle("-fx-background-color: transparent;");
        button.setTranslateX((double)(n / 2) - menu.getWidth() / 2.0);
        button.setTranslateY((double)(-n2 / 2) + menu.getHeight() / 2.0);
        button.setFocusTraversable(true);
        button.setPickOnBounds(true);
        button.setCursor(Cursor.HAND);
        button.setOnMouseClicked(this.menuClicked);
        button.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (bl2.booleanValue()) {
                    Bounds bounds = stackPane.localToScreen(stackPane.getBoundsInLocal());
                    stackPane.fireEvent((Event)new MouseEvent(MouseEvent.MOUSE_CLICKED, button.getLayoutX(), button.getLayoutY(), bounds.getMinX(), bounds.getMinY(), MouseButton.PRIMARY, 1, true, true, true, true, true, true, true, true, true, true, null));
                    TopologyPanel.this.highLightPane(stackPane);
                }
            }
        });
        button.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.SPACE) {
                    Bounds bounds = button.localToScreen(button.getBoundsInLocal());
                    button.fireEvent((Event)new MouseEvent(MouseEvent.MOUSE_CLICKED, button.getLayoutX(), button.getLayoutY(), bounds.getMinX(), bounds.getMinY(), MouseButton.PRIMARY, 1, true, true, true, true, true, true, true, true, true, true, null));
                }
            }
        });
        stackPane.getChildren().add((Object)button);
        Tooltip tooltip = new Tooltip(string);
        Tooltip.install((Node)stackPane, (Tooltip)tooltip);
        return stackPane;
    }

    private StackPane createDSGElement(String string, int n, int n2, int n3, int n4, Color color) {
        StackPane stackPane = this.createHelper(string, n, n2, n3, n4, color);
        stackPane.setOnMouseClicked(this.dsgClicked);
        return stackPane;
    }

    private StackPane createRSElement(String string, int n, int n2, int n3, int n4, Color color) {
        Label label = new Label(string);
        label.setTextFill((Paint)Color.WHITE);
        label.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)13.0));
        Rectangle rectangle = new Rectangle((double)n, (double)n2, (Paint)color);
        final StackPane stackPane = new StackPane();
        stackPane.setAlignment(Pos.CENTER_LEFT);
        StackPane.setMargin((Node)label, (Insets)new Insets(0.0, 0.0, 0.0, (double)COMPONENT_PADDING));
        stackPane.getChildren().addAll((Object[])new Node[]{rectangle, label});
        stackPane.setTranslateX((double)n3);
        stackPane.setTranslateY((double)n4);
        stackPane.setOnMouseClicked(this.rsClicked);
        ImageView imageView = new ImageView(menu);
        final Button button = new Button();
        button.setFocusTraversable(true);
        button.setGraphic((Node)imageView);
        button.setStyle("-fx-background-color: transparent;");
        button.setTranslateY((double)(-n2 / 2) + menu.getHeight() / 2.0);
        button.setFocusTraversable(true);
        button.setPickOnBounds(true);
        button.setCursor(Cursor.HAND);
        button.setOnMouseClicked(this.menuClicked);
        button.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (bl2.booleanValue()) {
                    TopologyPanel.this.highLightPane(stackPane);
                }
            }
        });
        button.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.SPACE) {
                    Bounds bounds = button.localToScreen(button.getBoundsInLocal());
                    button.fireEvent((Event)new MouseEvent(MouseEvent.MOUSE_CLICKED, button.getLayoutX(), button.getLayoutY(), bounds.getMinX(), bounds.getMinY(), MouseButton.PRIMARY, 1, true, true, true, true, true, true, true, true, true, true, null));
                }
            }
        });
        stackPane.getChildren().add((Object)button);
        return stackPane;
    }

    private void manageSelection(final ElementField elementField, double d, double d2) {
        ContextMenu contextMenu = new ContextMenu();
        if (elementField.isSelected()) {
            MenuItem menuItem = new MenuItem("Deselect");
            contextMenu.getItems().add((Object)menuItem);
            menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    elementField.setSelected(false);
                    TopologyPanel.this.manageSelection(elementField, false);
                    if (TopologyPanel.this.elementSelection != null) {
                        TopologyPanel.this.elementSelection.elementSelectionChanged();
                    }
                }
            });
        } else {
            MenuItem menuItem = new MenuItem("Select");
            contextMenu.getItems().add((Object)menuItem);
            menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    elementField.setSelected(true);
                    TopologyPanel.this.manageSelection(elementField, true);
                    if (TopologyPanel.this.elementSelection != null) {
                        TopologyPanel.this.elementSelection.elementSelectionChanged();
                    }
                }
            });
        }
        contextMenu.show((Node)elementField, d, d2);
    }

    private void manageSelection(ElementField elementField, boolean bl) {
    }

    private void highLightPane(StackPane stackPane) {
        Rectangle rectangle;
        if (this.selectedPane != null) {
            rectangle = (Rectangle)this.selectedPane.getChildren().get(0);
            rectangle.setStroke(rectangle.getFill());
        }
        rectangle = (Rectangle)stackPane.getChildren().get(0);
        rectangle.setStroke((Paint)Color.RED);
        rectangle.setStrokeWidth(1.8);
        this.selectedPane = stackPane;
    }

    private class ElementField
    extends StackPane {
        int elementId;
        String host;
        String instance;
        double width;
        double height;
        double posX;
        double posY;
        Color color;
        boolean selected;

        public ElementField(int n, String string, String string2, double d, double d2, Color color, double d3, double d4) {
            this.elementId = n;
            this.host = string;
            this.instance = string2;
            this.color = color;
            this.width = d;
            this.height = d2;
            this.posX = d3;
            this.posY = d4;
            this.setup();
        }

        public int getElementId() {
            return this.elementId;
        }

        private void setup() {
            Label label = new Label(TopologyPanel.this.ID + " " + this.elementId);
            Label label2 = new Label(TopologyPanel.this.HOST + " " + this.host);
            Label label3 = new Label(TopologyPanel.this.NAME + " " + this.instance);
            label3.setTextFill((Paint)Color.WHITE);
            label3.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)13.0));
            label3.setMaxWidth((double)MAX_TEXT_WIDTH);
            label2.setTextFill((Paint)Color.WHITE);
            label2.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)13.0));
            label2.setMaxWidth((double)MAX_TEXT_WIDTH);
            label.setTextFill((Paint)Color.WHITE);
            label.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)13.0));
            label.setMaxWidth((double)MAX_TEXT_WIDTH);
            label.setTranslateY(-TopologyPanel.this.t.getBoundsInLocal().getHeight());
            label3.setTranslateY(TopologyPanel.this.t.getBoundsInLocal().getHeight());
            Rectangle rectangle = new Rectangle(this.width, this.height, (Paint)this.color);
            this.getChildren().addAll((Object[])new Node[]{rectangle, label3, label2, label});
            this.setTranslateX(this.posX);
            this.setTranslateY(this.posY);
            ImageView imageView = new ImageView(menu);
            final Button button = new Button();
            button.setFocusTraversable(true);
            button.setGraphic((Node)imageView);
            button.setStyle("-fx-background-color: transparent;");
            button.setTranslateX(this.width / 2.0 - menu.getWidth() / 2.0);
            button.setTranslateY(-this.height / 2.0 + menu.getHeight() / 2.0);
            button.setFocusTraversable(true);
            button.setPickOnBounds(true);
            button.setCursor(Cursor.HAND);
            button.setOnMouseClicked(TopologyPanel.this.menuClicked);
            button.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                    if (bl2.booleanValue()) {
                        Bounds bounds = ElementField.this.localToScreen(ElementField.this.getBoundsInLocal());
                        ElementField.this.fireEvent((Event)new MouseEvent(MouseEvent.MOUSE_CLICKED, button.getLayoutX(), button.getLayoutY(), bounds.getMinX(), bounds.getMinY(), MouseButton.PRIMARY, 1, true, true, true, true, true, true, true, true, true, true, null));
                        TopologyPanel.this.highLightPane(ElementField.this);
                    }
                }
            });
            button.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent keyEvent) {
                    if (keyEvent.getCode() == KeyCode.SPACE) {
                        Bounds bounds = button.localToScreen(button.getBoundsInLocal());
                        button.fireEvent((Event)new MouseEvent(MouseEvent.MOUSE_CLICKED, button.getLayoutX(), button.getLayoutY(), bounds.getMinX(), bounds.getMinY(), MouseButton.PRIMARY, 1, true, true, true, true, true, true, true, true, true, true, null));
                    }
                }
            });
            this.getChildren().add((Object)button);
            Tooltip tooltip = new Tooltip(this.instance);
            Tooltip.install((Node)this, (Tooltip)tooltip);
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
            Circle circle = new Circle(6.0);
            circle.setFill((Paint)Color.WHITE);
            circle.setTranslateX(12.0 - this.width / 2.0);
            circle.setTranslateY(12.0 - this.height / 2.0);
            this.removeSelected();
            if (bl) {
                this.getChildren().add((Object)circle);
            }
        }

        public boolean isSelected() {
            return this.selected;
        }

        private void removeSelected() {
            for (int i = 0; i < this.getChildren().size(); ++i) {
                if (!(this.getChildren().get(i) instanceof Circle)) continue;
                this.getChildren().remove(i);
                return;
            }
        }
    }
}

