/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor.metrics;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.sql.Connection;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import oracle.dbtools.raptor.timesten.performancemonitor.data.DashboardSummaryInfo;
import oracle.dbtools.raptor.timesten.performancemonitor.data.TopSQLCmdBean;
import oracle.dbtools.raptor.timesten.performancemonitor.metrics.MetricPane;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;

public class JFXMetricPane
extends JFXPanel {
    private static final long serialVersionUID = 1L;
    private MetricPane pane;
    private Connection conn;
    private ObservableList<TopSQLCmdBean> topSQL;
    private ShutdownHook fxShutdownHook;
    private DashboardSummaryInfo info;

    public JFXMetricPane(Connection connection) {
        this.conn = connection;
        this.setUpPane();
    }

    private void setUpPane() {
        this.init();
        Platform.setImplicitExit((boolean)false);
        this.fxShutdownHook = new ShutdownHook(){

            public boolean canShutdown() {
                return true;
            }

            public void shutdown() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Platform.exit();
                    }
                });
            }
        };
        ExitCommand.removeShutdownHook((ShutdownHook)this.fxShutdownHook);
        ExitCommand.addShutdownHook((ShutdownHook)this.fxShutdownHook);
    }

    private void init() {
        if (Platform.isFxApplicationThread()) {
            this.setUpFx();
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    JFXMetricPane.this.setUpFx();
                }
            });
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(final ComponentEvent componentEvent) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JFXMetricPane.this.pane.setMinSize(componentEvent.getComponent().getWidth(), componentEvent.getComponent().getHeight());
                        JFXMetricPane.this.pane.setMaxSize(componentEvent.getComponent().getWidth(), componentEvent.getComponent().getHeight());
                        JFXMetricPane.this.pane.setPrefSize(componentEvent.getComponent().getWidth(), componentEvent.getComponent().getHeight());
                    }
                });
            }
        });
    }

    private void setUpFx() {
        Scene scene = new Scene((Parent)new Group());
        this.pane = new MetricPane(this.conn);
        ((Group)scene.getRoot()).getChildren().add((Object)this.pane);
        this.setScene(scene);
    }
}

