/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor.metrics;

import java.io.IOException;
import java.net.URL;
import oracle.dbtools.util.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class MetricPaneStorage
extends HashStructureAdapter {
    static final String EXT_ID = "oracle.sqldeveloper.timesten";
    public static final String STORE_FILENAME = "ttcanvas.xml";
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"sqldeveloper-timesten");
    private static final String ROOT_NAME = "timesten-metric-canvas";
    private static final String CANVAS = "canvas";
    private final URL storageURL;

    private MetricPaneStorage(HashStructure hashStructure, URL uRL) {
        super(hashStructure);
        this.storageURL = uRL;
    }

    static URL getStorageURL() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        URL uRL = extensionRegistry.getSystemDirectory(EXT_ID);
        return URLFactory.newURL((URL)uRL, (String)STORE_FILENAME);
    }

    static MetricPaneStorage createStorage(URL uRL) {
        HashStructure hashStructure = HashStructure.newInstance();
        MetricPaneStorage metricPaneStorage = new MetricPaneStorage(hashStructure, uRL);
        return metricPaneStorage;
    }

    void load() throws IOException {
        if (URLFileSystem.exists((URL)this.storageURL)) {
            HashStructureIO hashStructureIO = MetricPaneStorage.getIO();
            hashStructureIO.open(this.storageURL, (Object)this.getHashStructure());
        }
    }

    private static HashStructureIO getIO() {
        return new HashStructureIO(NAMESPACE_URI, ROOT_NAME);
    }

    void save() throws IOException {
        HashStructure hashStructure = this.getHashStructure();
        if (hashStructure.isDirty()) {
            HashStructureIO hashStructureIO = MetricPaneStorage.getIO();
            hashStructureIO.save(this.storageURL, (Object)hashStructure);
            hashStructure.markDirty(false);
        }
    }

    private void doSave() {
        try {
            this.save();
        }
        catch (IOException iOException) {
            Logger.severe(MetricPaneStorage.class, (Throwable)iOException);
        }
    }

    public HashStructure getMetricPane(String string) {
        HashStructure hashStructure = this.getHashStructure();
        HashStructure hashStructure2 = hashStructure.getHashStructure(CANVAS);
        if (hashStructure2 == null) {
            return null;
        }
        HashStructure hashStructure3 = hashStructure2.getHashStructure(string);
        return hashStructure3;
    }

    public void addMetricPane(String string, HashStructure hashStructure) {
        HashStructure hashStructure2 = this.getHashStructure();
        HashStructure hashStructure3 = hashStructure2.getHashStructure(CANVAS);
        if (hashStructure3 == null) {
            hashStructure3 = HashStructure.newInstance();
            hashStructure2.putHashStructure(CANVAS, hashStructure3);
        }
        hashStructure3.putHashStructure(string, hashStructure);
        this.doSave();
    }
}

