/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.utils;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.timesten.Messages;

public class ConnectionStrParser {
    public static String PWD_KEY = "PWD";
    public static String ORACLEPWD_KEY = "ORACLEPWD";
    public static String DSN_KEY = "DSN";
    public static String ORACLE_NET_SERVICE_NAME_KEY = "ORACLENETSERVICENAME";
    public static String TTC_SERVER_DSN_KEY = "TTC_SERVER_DSN";
    public static String TTC_SERVER_KEY = "TTC_SERVER";
    public static String TCP_PORT_KEY = "TCP_PORT";
    public static String TTC_TIMEOUT_KEY = "TTC_TIMEOUT";
    private static String braceInsideBraces = Messages.getString("ConnectionStrParser.braceInsideBraces");
    private static String missingClosingBrace = Messages.getString("ConnectionStrParser.missingClosingBrace");
    private static String emptyValue = Messages.getString("ConnectionStrParser.emptyValue");
    private static String loneKey = Messages.getString("ConnectionStrParser.loneKey");

    public static String getConnString(Map<String, String> map) {
        if (map == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append('=');
            if (entry.getValue().contains(";")) {
                stringBuilder.append('{');
                stringBuilder.append(entry.getValue());
                stringBuilder.append('}');
            } else {
                stringBuilder.append(entry.getValue());
            }
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> getProperties(String string) throws ConnectionParsingException {
        if (!string.endsWith(";")) {
            string = string + ";";
        }
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = null;
        String string3 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringBuffer stringBuffer = new StringBuffer();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl4 && c != ';') {
                String string4 = stringBuffer.toString();
                stringBuffer.setLength(0);
                stringBuffer.append('{');
                stringBuffer.append(string4);
                stringBuffer.append('}');
                bl4 = false;
                bl = false;
                stringBuffer.append(c);
                continue;
            }
            switch (c) {
                case '=': {
                    if (bl2) {
                        bl3 = true;
                        bl2 = false;
                        string2 = stringBuffer.toString();
                        stringBuffer.setLength(0);
                        continue block6;
                    }
                    bl3 = false;
                    stringBuffer.append(c);
                    continue block6;
                }
                case '{': {
                    if (bl3) {
                        bl3 = false;
                        bl = true;
                        continue block6;
                    }
                    if (bl) {
                        throw new ConnectionParsingException(braceInsideBraces);
                    }
                    stringBuffer.append(c);
                    continue block6;
                }
                case '}': {
                    if (bl) {
                        bl4 = true;
                        continue block6;
                    }
                    stringBuffer.append(c);
                    continue block6;
                }
                case ';': {
                    if (bl && !bl4) {
                        stringBuffer.append(c);
                        continue block6;
                    }
                    if (string2 == null && string3 == null && stringBuffer.length() == 0) continue block6;
                    if (bl2) {
                        throw new ConnectionParsingException(loneKey);
                    }
                    string3 = stringBuffer.toString();
                    if (string3.isEmpty()) {
                        throw new ConnectionParsingException(emptyValue);
                    }
                    stringBuffer.setLength(0);
                    hashMap.put(string2.toUpperCase(), string3);
                    string2 = null;
                    string3 = null;
                    bl2 = true;
                    bl4 = false;
                    bl = false;
                    bl3 = false;
                    continue block6;
                }
                default: {
                    if (bl3) {
                        bl3 = false;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        if (bl) {
            throw new ConnectionParsingException(missingClosingBrace);
        }
        return hashMap;
    }

    public static class ConnectionParsingException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ConnectionParsingException(String string) {
            super(string);
        }

        public ConnectionParsingException() {
        }
    }
}

