/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlmonitor.nodes;

import java.net.URL;
import oracle.dbtools.sqlmonitor.SqlMonitorArb;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;

public class SqlMonitorEditorNode
extends DefaultContainer
implements Observer {
    public static final int RELATION_NODE_CHANGED_MESSAGE_ID = UpdateMessage.newMessageID((String)(SqlMonitorEditorNode.class.getName() + ".relationNodeChanged"));
    public static final int RELATION_NODE_MODIFIED_MESSAGE_ID = UpdateMessage.newMessageID((String)(SqlMonitorEditorNode.class.getName() + ".relationNodeModified"));
    private Attributes m_attributes = new ElementAttributes();
    private String conn;
    private static int _nodeId = 0;

    public SqlMonitorEditorNode() {
        URL uRL = URLFactory.newURL((String)"sqldev.sqlmonitor", (String)("SqlMonitorEditorNode/" + _nodeId++));
        this.setURL(uRL);
        this.getAttributes().set(ElementAttributes.CLOSEABLE);
    }

    public String getLongLabel() {
        return SqlMonitorArb.getString("LABEL");
    }

    public String getShortLabel() {
        return SqlMonitorArb.getString("LABEL");
    }

    public String getToolTipText() {
        return SqlMonitorArb.getString("LABEL");
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (updateMessage.getMessageID() == UpdateMessage.CONTENT_MODIFIED) {
            this.notifyObservers(object, new UpdateMessage(RELATION_NODE_MODIFIED_MESSAGE_ID, (Object)this));
        }
    }

    public void setViewedObject() {
        this.notifyObservers((Object)this, new UpdateMessage(RELATION_NODE_CHANGED_MESSAGE_ID, (Object)this));
        this.notifyObservers((Object)this, new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)this));
        this.notifyObservers((Object)this, new UpdateMessage(UpdateMessage.OBJECT_RELOADED, (Object)this));
    }

    public Attributes getAttributes() {
        return this.m_attributes;
    }

    public String getConn() {
        return this.conn;
    }

    public void setConn(String string) {
        this.conn = string;
    }
}

