/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.copy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorMultiTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.databasecopy.CopyPanelArb;
import oracle.dbtools.raptor.databasecopy.wizard.CopyWizArb;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.extract.models.ExtractConnectionAccess;
import oracle.dbtools.raptor.extract.models.ExtractConnectionAccessCatalog;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.extract.ui.wizard.ExtractWizSummaryPanel;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutorTask;
import oracle.dbtools.raptor.newscriptrunner.ScriptResult;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.CopyToOracleHint;
import oracle.dbtools.raptor.scriptrunner.utils.OutputRedirector;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.MnemonicUtil;
import oracle.dbtools.thirdparty.copy.ConnectionNames;
import oracle.dbtools.thirdparty.copy.CopyToOracleDataOptionPanel;
import oracle.dbtools.thirdparty.copy.CopyToOracleDdlOptionPanel;
import oracle.dbtools.thirdparty.copy.CopyToOracleLog;
import oracle.dbtools.thirdparty.copy.CopyToOracleResources;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

public abstract class CopyToOracle
extends AbstractMenuAction
implements LayoutControl {
    public static final String CONECTION_ACCESS_CATALOG = "CONNECTION_SCHEMA_CAT";
    public static final String CONTAINS_DATA_OBJECT = "CONTAINS_DATA_OBJECT";
    public static final String IS_DND = "IS_DNS";
    public static final String ANY_EXIST_DEST = "ANY_EXIST_DEST";
    private DefaultMutableTreeNode _connectionsNode;
    private DefaultMutableTreeNode _objectsNode;
    private ExtractListModel _listModel;
    private ExtractConnectionAccessCatalog _connAccessCatalog;
    private CopyToOracleDdlOptionPanel m_copyDdlOptionPanel = new CopyToOracleDdlOptionPanel();
    private JPanel _dataPanel;
    private CopyToOracleDataOptionPanel m_copyDataOptionPanel = new CopyToOracleDataOptionPanel();
    private boolean PARALLEL_COPY = true;
    private ConnectionNames targetConnection;
    private String schemaName = null;
    private ResultsManager resultsManager;
    private LogManager logManager;

    public boolean useSchema() {
        return true;
    }

    public String quoteMe(String string) {
        return "[" + string + "]";
    }

    public boolean isSupportedType(String string) {
        return string.equals("TABLE");
    }

    public boolean isTruncateSupported() {
        return true;
    }

    public boolean isDisableDDLSupported() {
        return false;
    }

    public void launch() {
        Object object;
        AbstractAction[] abstractActionArray;
        Element[] elementArray;
        Context context = this.getContext();
        this.initContext(context);
        boolean bl = false;
        if (context.getProperty(IS_DND) != null) {
            bl = true;
        }
        if ((elementArray = context.getSelection()) == null || elementArray.length == 0) {
            elementArray = new Element[]{context.getNode()};
        }
        final Element[] elementArray2 = elementArray;
        this.getListModel(elementArray2);
        boolean bl2 = context.getBoolean(CONTAINS_DATA_OBJECT);
        this._connAccessCatalog = (ExtractConnectionAccessCatalog)context.getProperty(CONECTION_ACCESS_CATALOG);
        if (this._connAccessCatalog == null) {
            this._connAccessCatalog = new ExtractConnectionAccessCatalog(this._listModel.getList(0));
        }
        String[] stringArray = Connections.getInstance().getConnNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!Connections.getInstance().isOracle(stringArray[i])) continue;
            arrayList.add(Connections.getConnectionName((String)stringArray[i]));
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(objectArray);
        AbstractAction[] abstractActionArray2 = null;
        if (objectArray != null && objectArray.length > 0) {
            abstractActionArray = new AbstractAction[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                abstractActionArray[i] = new AbstractAction((String)object){
                    final /* synthetic */ String val$nls_txt;
                    {
                        this.val$nls_txt = string;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                    }

                    public String toString() {
                        return this.val$nls_txt;
                    }
                };
                abstractActionArray[i].putValue("org_val", objectArray[i]);
            }
            abstractActionArray2 = abstractActionArray;
        }
        if (abstractActionArray2 != null) {
            JComponent jComponent;
            JComponent jComponent2;
            abstractActionArray = this.getTargetConnection();
            final JComboBox jComboBox = null == abstractActionArray ? new JComboBox(abstractActionArray2) : new JComboBox<Object>(new Object[]{abstractActionArray});
            object = jComboBox;
            if (abstractActionArray != null) {
                object = this.getSchemaName() == null ? new JLabel(abstractActionArray.getShortName()) : new JLabel(abstractActionArray.getShortName() + "." + this.getSchemaName());
            }
            JPanel jPanel = LayoutControl.GBC.createPanel();
            if (object instanceof JComboBox) {
                jComponent2 = LayoutControl.GBC.createPanel();
                jComponent = new JLabel();
                ResourceUtils.resLabel((JLabel)jComponent, jComboBox, (String)CopyToOracleResources.getString("COPY_TO_ORACLE_DESTINATION_DATABASE"));
                ((JLabel)jComponent).setHorizontalAlignment(4);
                jComponent2.add((Component)jComponent, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
                jComponent2.add((Component)object, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
                jPanel.add((Component)jComponent2, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
                jPanel.add((Component)this.getOptionsUI(bl2), LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
                LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)2);
            } else {
                jPanel.add((Component)this.getOptionsUI(bl2), LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
                LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)2);
            }
            jComponent2 = new JTabbedPane();
            jComponent = LayoutControl.GBC.createPanel();
            jComponent.add((Component)jPanel, LayoutControl.GBC.DIALOG_MAIN_PANEL);
            ((JTabbedPane)jComponent2).add(CopyToOracleResources.getString("OPTIONS"), jComponent);
            ChangeListener changeListener = new ChangeListener((JTabbedPane)jComponent2, elementArray2){
                final /* synthetic */ JTabbedPane val$dndPane;
                final /* synthetic */ Element[] val$els;
                {
                    this.val$dndPane = jTabbedPane;
                    this.val$els = elementArray;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (this.val$dndPane.getSelectedIndex() == 1) {
                        this.val$dndPane.removeChangeListener(this);
                        this.val$dndPane.remove(1);
                        this.val$dndPane.add(CopyToOracleResources.getString("OBJECTS"), new JScrollPane(CopyToOracle.this.getSummaryComponent(CopyToOracle.this.isUseDDLSelected(), CopyToOracle.this.isIncludeDataSelected(), CopyToOracle.this.isAppendSelected(), CopyToOracle.this.isReplaceSelected(), CopyToOracle.this.isTruncateSelected(), this.val$els, CopyToOracle.this._connAccessCatalog), 20, 30));
                        this.val$dndPane.setSelectedIndex(1);
                        this.val$dndPane.addChangeListener(this);
                    }
                }
            };
            ((JTabbedPane)jComponent2).addChangeListener(changeListener);
            ((JTabbedPane)jComponent2).add(CopyToOracleResources.getString("OBJECTS"), new JScrollPane(this.getSummaryComponent(this.isUseDDLSelected(), this.isIncludeDataSelected(), this.isAppendSelected(), this.isReplaceSelected(), this.isTruncateSelected(), elementArray2, this._connAccessCatalog), 20, 30));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jComponent2, "Center");
            HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel2, "f1_copy2oracle_html");
            final JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel2, null, (String)CopyToOracleResources.getString("COPY_TO_ORACLE_CHOOSE_DATABASE"), (int)7);
            jEWTDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand() == "apply") {
                        CopyToOracle.this.doCopyToOracle(jComboBox.getSelectedItem().toString(), CopyToOracle.this.isUseDDLSelected(), CopyToOracle.this.isIncludeDataSelected(), CopyToOracle.this.isAppendSelected(), CopyToOracle.this.isReplaceSelected(), CopyToOracle.this.isTruncateSelected(), CopyToOracle.this.isSkipSelected(), elementArray2);
                    }
                    jEWTDialog.dispose();
                }
            });
            Dimension dimension = jPanel.getPreferredSize();
            int n = (int)dimension.getHeight() + 200;
            int n2 = (int)dimension.getWidth() + 200;
            jEWTDialog.setSize(n2, n);
            jEWTDialog.setPreferredSize(n2, n);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
            jEWTDialog.runDialog();
            if (jEWTDialog.isOked()) {
                this.doCopyToOracle(jComboBox.getSelectedItem().toString(), this.isUseDDLSelected(), this.isIncludeDataSelected(), this.isAppendSelected(), this.isReplaceSelected(), this.isTruncateSelected(), this.isSkipSelected(), elementArray2);
                jEWTDialog.dispose();
            }
        } else {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)CopyToOracleResources.getString("COPY_TO_ORACLE_NO_TARGET_MSG"), (String)CopyToOracleResources.getString("COPY_TO_ORACLE_NO_TARGET_TITLE"), null);
        }
    }

    public void initContext(Context context) {
    }

    protected JComponent getSummaryComponent(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Element[] elementArray, ExtractConnectionAccessCatalog extractConnectionAccessCatalog) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        JTree jTree = new JTree();
        jTree.setCellRenderer((TreeCellRenderer)new ExtractWizSummaryPanel.NodeRenderer(new ExtractWizSummaryPanel()));
        jScrollPane.setViewportView(jTree);
        jTree.setModel(this.getSummaryTreeModel(CopyWizArb.getString((String)"DATABASECOPY_SUMMARY"), bl, bl2, bl3, bl4, bl5, elementArray, extractConnectionAccessCatalog));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 5, 5, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public DefaultTreeModel getSummaryTreeModel(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Element[] elementArray, ExtractConnectionAccessCatalog extractConnectionAccessCatalog) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        ExtractListModel extractListModel = this.getListModel(elementArray);
        defaultMutableTreeNode.add(this.getConnectionsNode(extractConnectionAccessCatalog));
        defaultMutableTreeNode.add(this.getOptionsNode(bl, bl2, bl3, bl4, bl5));
        defaultMutableTreeNode.add(this.getObjectsNode(extractListModel, extractConnectionAccessCatalog));
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    public DefaultMutableTreeNode getConnectionsNode(ExtractConnectionAccessCatalog extractConnectionAccessCatalog) {
        if (this._connectionsNode == null) {
            Serializable serializable;
            Object object;
            Object object222;
            this._connectionsNode = new DefaultMutableTreeNode(ExtractResources.getString((String)"CONNECTIONS"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object222 : extractConnectionAccessCatalog.getExtractConnectionAccessCatalog()) {
                object = object222.getConnectionName();
                if (arrayList.contains(object)) continue;
                arrayList.add((String)object);
            }
            Object object3 = null;
            object222 = "";
            if (arrayList.size() > 1) {
                object3 = new DefaultMutableTreeNode(CopyToOracleResources.getString("SOURCE"));
                this._connectionsNode.add((MutableTreeNode)object3);
            } else {
                object222 = ExtractResources.getString((String)"SOURCE") + ": ";
            }
            for (String object4 : arrayList) {
                serializable = new JLabel();
                ((JLabel)serializable).setText((String)object222 + Connections.getDisplayName((String)object4));
                ((JLabel)serializable).setIcon(ExtractResources.getIcon((String)"CONNECTION_ICON"));
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(serializable);
                for (ExtractConnectionAccess extractConnectionAccess : extractConnectionAccessCatalog.getExtractConnectionAccessCatalog()) {
                    if (!object4.equals(extractConnectionAccess.getConnectionName())) continue;
                    if (!extractConnectionAccess.getDbName().isEmpty()) {
                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(CopyToOracleResources.getString("CATALOG") + " " + extractConnectionAccess.getDbName()));
                    }
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(CopyToOracleResources.getString("SCHEMA") + " " + extractConnectionAccess.getSchemaName()));
                }
                if (object3 != null) {
                    ((DefaultMutableTreeNode)object3).add(defaultMutableTreeNode);
                    continue;
                }
                this._connectionsNode.add(defaultMutableTreeNode);
            }
            object = this.getTargetConnection();
            if (object != null) {
                JLabel jLabel = new JLabel();
                jLabel.setText(ExtractResources.getString((String)"DEST") + ": " + ((ConnectionNames)object).getShortName());
                jLabel.setIcon(ExtractResources.getIcon((String)"CONNECTION_ICON"));
                serializable = new DefaultMutableTreeNode(jLabel);
                this._connectionsNode.add((MutableTreeNode)((Object)serializable));
                if (this.getSchemaName() != null) {
                    ((DefaultMutableTreeNode)serializable).add(new DefaultMutableTreeNode(CopyToOracleResources.getString("SCHEMA") + " " + this.getSchemaName()));
                }
            }
        }
        return this._connectionsNode;
    }

    public DefaultMutableTreeNode getOptionsNode(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(CopyToOracleResources.getString("COPY_OPTIONS"));
        DefaultMutableTreeNode defaultMutableTreeNode2 = ExtractListModel.getSummaryBooleanItem((String)MnemonicUtil.extractLabelTextWithoutMnemonic((String)CopyWizArb.getString((String)"COPY_DDL_OPTION")), (boolean)bl);
        defaultMutableTreeNode2.add(ExtractListModel.getSummaryBooleanItem((String)MnemonicUtil.extractLabelTextWithoutMnemonic((String)CopyWizArb.getString((String)"DO_REPLACE_DEST")), (boolean)bl4));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        Context context = this.getContext();
        this.initContext(context);
        boolean bl6 = context.getBoolean(CONTAINS_DATA_OBJECT);
        if (bl6) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = ExtractListModel.getSummaryBooleanItem((String)MnemonicUtil.extractLabelTextWithoutMnemonic((String)CopyWizArb.getString((String)"COPY_DATA_OPTION")), (boolean)bl2);
            if (!bl4) {
                String string = null;
                string = bl3 ? MnemonicUtil.extractLabelTextWithoutMnemonic((String)CopyWizArb.getString((String)"APPEND_DATA_COPY")) : (bl5 ? MnemonicUtil.extractLabelTextWithoutMnemonic((String)CopyWizArb.getString((String)"TRUNCATE_DATA_COPY_SHORT")) : MnemonicUtil.extractLabelTextWithoutMnemonic((String)CopyWizArb.getString((String)"DO_NOT_DATA_COPY")));
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(string));
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getObjectsNode(ExtractListModel extractListModel, ExtractConnectionAccessCatalog extractConnectionAccessCatalog) {
        if (this._objectsNode == null) {
            Cloneable cloneable;
            this._objectsNode = new DefaultMutableTreeNode(CopyToOracleResources.getString("COPY_OBJECTS"));
            DDLTypes dDLTypes = new DDLTypes();
            List<String> list = this.getSupportedTypes(dDLTypes);
            List list2 = null;
            ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
            for (ExtractConnectionAccess object : extractConnectionAccessCatalog.getExtractConnectionAccessCatalog()) {
                cloneable = new ArrayList();
                for (Object object2 : extractListModel.getList(0)) {
                    if (!object2.getDBObject().getConnectionName().equals(object.getConnectionName()) || !object2.getDBObject().getSchemaName().equals(object.getSchemaName())) continue;
                    ((ArrayList)cloneable).add(object2);
                }
                if (((ArrayList)cloneable).isEmpty()) continue;
                arrayList.add(cloneable);
            }
            for (String string : list) {
                cloneable = new DefaultMutableTreeNode(DDLTypes.getFolderLabel((String)string));
                boolean bl = false;
                for (ArrayList arrayList2 : arrayList) {
                    list2 = extractListModel.getSummaryMetaObjectForType((List)arrayList2, string, true);
                    for (JLabel jLabel : list2) {
                        bl = true;
                        ((DefaultMutableTreeNode)cloneable).add(new DefaultMutableTreeNode(jLabel));
                    }
                }
                if (!bl) continue;
                this._objectsNode.add((MutableTreeNode)((Object)cloneable));
            }
        }
        return this._objectsNode;
    }

    protected JComponent getOptionsUI(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this._dataPanel = this.m_copyDataOptionPanel.getPanel();
        this.m_copyDataOptionPanel.setChkbxCopyData(bl);
        if (bl) {
            this.m_copyDataOptionPanel.setCompAppendData(true);
        } else {
            this.m_copyDataOptionPanel.setCompDoNotCopyData(true);
        }
        this._dataPanel.setVisible(bl);
        this.m_copyDdlOptionPanel.showDDLCheckBox(this.isDisableDDLSupported());
        jPanel.add((Component)this.m_copyDdlOptionPanel.getPanel(), LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)this._dataPanel, LayoutControl.GBC.gbc((int)0, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                CopyToOracle.this.m_copyDataOptionPanel.enableOptions(CopyToOracle.this.m_copyDataOptionPanel.getChkbxCopyData() && (!CopyToOracle.this.m_copyDdlOptionPanel.getChkbxCopyDDL() || CopyToOracle.this.m_copyDdlOptionPanel.getChkbxCopyDDL() && !CopyToOracle.this.m_copyDdlOptionPanel.getDoReplaceDest()));
            }
        };
        this.m_copyDataOptionPanel.addDataCopyListener(itemListener);
        this.m_copyDdlOptionPanel.addReplaceListener(itemListener);
        if (this.isDisableDDLSupported()) {
            this.m_copyDdlOptionPanel.addDdlCopyListener(itemListener);
        }
        return jPanel;
    }

    protected boolean isUseDDLSelected() {
        return this.m_copyDdlOptionPanel.getChkbxCopyDDL();
    }

    protected boolean isIncludeDataSelected() {
        return this.m_copyDataOptionPanel.getChkbxCopyData();
    }

    protected boolean isSkipSelected() {
        return this.m_copyDataOptionPanel.getCompDoCopyNotData();
    }

    protected boolean isAppendSelected() {
        return this.m_copyDataOptionPanel.getCompAppendData();
    }

    protected boolean isReplaceSelected() {
        return this.m_copyDdlOptionPanel.getDoReplaceDest();
    }

    protected boolean isTruncateSelected() {
        return this.m_copyDataOptionPanel.getChkbxTruncData();
    }

    public List<String> getSupportedTypes(DDLTypes dDLTypes) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("TABLE");
        return arrayList;
    }

    public ArrayList<String> getArrayListOfBridges(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Element[] elementArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        DBObject dBObject = null;
        for (Element element : elementArray) {
            String string2;
            String string3 = null;
            dBObject = new DBObject(element);
            String string4 = DBURLFormatHelper.getCatalog((URL)dBObject.getURL());
            String string5 = dBObject.getSchemaName();
            String string6 = string2 = dBObject.getObjectName();
            if (string5 != null && string5.trim().length() > 0) {
                string5 = string5.trim();
            }
            if (string5 != null && string5.trim().length() > 0) {
                string5 = this.quoteMe(string5);
            }
            if (string2 != null && string2.trim().length() > 0) {
                string2 = this.quoteMe(string2);
            }
            if (string4 != null && string4.trim().length() > 0) {
                string4 = this.quoteMe(string4);
            }
            string3 = this.getFullName(string4, string5, string2);
            String string7 = "where 1=1";
            if (!bl) {
                string7 = "where 1=2";
            }
            String string8 = string6.replace(" ", "_");
            String string9 = "";
            if (bl3) {
                string9 = "replace";
            } else if (bl5) {
                string9 = "skip";
            } else if (bl4) {
                string9 = "truncate";
            } else if (bl2) {
                string9 = "append";
            }
            arrayList.add("BRIDGE " + string + "(" + string8 + ") AS (" + CopyToOracleHint.createCopyToOracleHint((String)DBURLFormatHelper.getCatalog((URL)dBObject.getURL()), (String)dBObject.getSchemaName(), (String)dBObject.getObjectName()) + "SELECT * FROM " + string3 + " " + string7 + ")" + string9 + ";\n");
        }
        return arrayList;
    }

    protected String getFullName(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.useSchema()) {
            if (string != null && string.trim().length() > 0) {
                stringBuffer.append(string);
                stringBuffer.append(".");
            }
            if (string2 != null && string2.trim().length() > 0) {
                stringBuffer.append(string2);
                stringBuffer.append(".");
            } else if (string != null && string.trim().length() > 0) {
                stringBuffer.append(".");
            }
        }
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private void doCopyToOracle(final String string, final boolean bl, final boolean bl2, final boolean bl3, final boolean bl4, final boolean bl5, final boolean bl6, final Element[] elementArray) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(CopyToOracleResources.get("COPY_TO_ORACLE_TASK_SETUP"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            protected Void doWork() throws TaskException {
                CopyToOracle.this.doCopyToOracleImpl(string, bl, bl2, bl3, bl4, bl5, bl6, elementArray);
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    protected void doCopyToOracleImpl(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Element[] elementArray) {
        ArrayList<String> arrayList = null;
        arrayList = this.getArrayListOfBridges(string, bl2, bl3, bl4, bl5, bl6, elementArray);
        if (arrayList.isEmpty()) {
            Logger.severe(((Object)((Object)this)).getClass(), (String)CopyToOracleResources.getString("COPY_TO_ORACLE_NO_TABLES_FOUND"));
            SwingUtilities.invokeLater(() -> {
                try {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)CopyToOracleResources.getString("COPY_TO_ORACLE_NO_TABLES_FOUND"), (String)CopyToOracleResources.getString("COPY_TO_ORACLE_TASK_SHORT_NAME"), null);
                }
                catch (Exception exception) {
                    Logger.ignore(((Object)((Object)this)).getClass(), (Throwable)exception);
                }
            });
            return;
        }
        if (this.PARALLEL_COPY) {
            RaptorTask<?> raptorTask = this.createCopyTask(string, bl, bl2, bl3, bl4, bl5, elementArray, arrayList);
            String string2 = Connections.ConnectionKey.createConnectionKey((String)"IdeConnections", (String)string).getQualifiedName();
            DatabaseConnection databaseConnection = Databases.getConnectionNode((String)string2, (boolean)false);
            DBObject pipedOutputStream = new DBObject((Element)databaseConnection);
            this.attachPostProcessCallback(raptorTask, pipedOutputStream, true);
            ObjectAction bufferedOutputStream = this.getObjectAction();
            bufferedOutputStream.setReload(true);
            bufferedOutputStream.setReloadParent(false);
            bufferedOutputStream.setRemoveFromParent(false);
            RaptorTaskManager.getInstance().addTask(raptorTask);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            Collections.sort(arrayList);
            for (String object : arrayList) {
                stringBuffer.append(object);
            }
            if (stringBuffer.toString().equals("")) {
                // empty if block
            }
            try {
                BasicEditorPane basicEditorPane = new BasicEditorPane();
                basicEditorPane.setDocument((Document)new BasicDocument());
                PipedInputStream pipedInputStream = new PipedInputStream();
                PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(pipedOutputStream);
                ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
                scriptRunnerContext.setScanOn(false);
                WrapListenBufferOutputStream wrapListenBufferOutputStream = new WrapListenBufferOutputStream((OutputStream)bufferedOutputStream, null);
                wrapListenBufferOutputStream.setRemoveForcePrint(true);
                scriptRunnerContext.putProperty("sqldev.error.any.in", (Object)Boolean.FALSE);
                scriptRunnerContext.setOutputStreamWrapper((BufferedOutputStream)wrapListenBufferOutputStream);
                scriptRunnerContext.consumerRuning(true);
                scriptRunnerContext.setEscape(false);
                scriptRunnerContext.setSqlError(0);
                scriptRunnerContext.consumerRuning(true);
                final OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, basicEditorPane.getDocument(), basicEditorPane);
                outputRedirector.start();
                ScriptExecutorTask scriptExecutorTask = new ScriptExecutorTask(CopyToOracleResources.getString("COPY_TO_ORACLE_TASK"), IRaptorTaskRunMode.MODAL_OPTIONAL, true, true){

                    protected void cleanup() throws ExecutionException {
                        super.cleanup();
                        try {
                            this.flushOut(true);
                            outputRedirector.join();
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.warn(ScriptExecutorTask.class, (Throwable)interruptedException);
                        }
                    }

                    protected void afterRunStatementProcessing() throws ExecutionException {
                        if (this.wasErrorEncountered()) {
                            this.getScriptRunnerContext().putProperty("sqldev.error.any.in", (Object)Boolean.TRUE);
                        }
                    }
                };
                scriptExecutorTask.setOut((BufferedOutputStream)wrapListenBufferOutputStream);
                scriptExecutorTask.setScriptRunnerContext(scriptRunnerContext);
                scriptExecutorTask.setConnection(new DBObject(elementArray[0]).getConnection());
                scriptExecutorTask.setStmt(stringBuffer.toString());
                String string2 = Connections.ConnectionKey.createConnectionKey((String)"IdeConnections", (String)string).getQualifiedName();
                DatabaseConnection databaseConnection = Databases.getConnectionNode((String)string2, (boolean)false);
                DBObject dBObject = new DBObject((Element)databaseConnection);
                this.attachPostProcessCallback((RaptorTask)scriptExecutorTask, dBObject);
                ObjectAction objectAction = this.getObjectAction();
                objectAction.setReload(true);
                objectAction.setReloadParent(false);
                objectAction.setRemoveFromParent(false);
                this.runTask(scriptExecutorTask, CopyToOracleResources.getString("COPY_TO_ORACLE_TASK"), basicEditorPane);
            }
            catch (IOException iOException) {
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)iOException);
            }
        }
    }

    private RaptorTask<?> createCopyTask(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Element[] elementArray, ArrayList<String> arrayList) {
        ScriptExecutorTask scriptExecutorTask = null;
        String string2 = new DBObject(elementArray[0]).getConnectionName();
        String string3 = CopyToOracleResources.getString("COPY_TO_ORACLE_TASK_PRE");
        String string4 = null;
        if (bl) {
            string4 = this.getPreScript(string, bl, bl2, bl3, bl4, elementArray);
        }
        ScriptExecutorTask scriptExecutorTask2 = null == string4 ? null : this.createScriptExecutorTask(string3, string4, string);
        string3 = CopyToOracleResources.getString("COPY_TO_ORACLE_TASK_POST");
        String string5 = null;
        if (bl) {
            string5 = this.getPostScript(string, bl, bl2, bl3, bl4, elementArray);
        }
        ScriptExecutorTask scriptExecutorTask3 = null == string4 ? null : this.createScriptExecutorTask(string3, string5, string);
        RaptorMultiTask raptorMultiTask = new RaptorMultiTask(CopyToOracleResources.getString("COPY_TO_ORACLE_TASK_SHORT_NAME"), IRaptorTaskRunMode.TASKVIEWER);
        int n = 0;
        for (String string6 : arrayList) {
            string3 = CopyToOracleResources.format("COPY_TO_ORACLE_TASK", elementArray[n++].getShortLabel());
            raptorMultiTask.addTask((RaptorTask)this.createScriptExecutorTask(string3, string6, string2));
        }
        if (this._listModel != null) {
            this._listModel.setDestConnName(Connections.ConnectionKey.createConnectionKey((String)"IdeConnections", (String)string).getQualifiedName());
            this._listModel.isDDLEnabled(true);
            this._listModel.isDataEnabled(bl2);
        }
        this.initLogManager(this._listModel, bl2, bl3, bl4, bl5);
        this.initResultsManager(scriptExecutorTask2, (RaptorMultiTask<ScriptExecutorTask>)raptorMultiTask, scriptExecutorTask3, this.logManager);
        if (scriptExecutorTask2 != null) {
            scriptExecutorTask = scriptExecutorTask2;
            this.addStartTaskOnFinishListener((RaptorTask<?>)scriptExecutorTask, (RaptorTask<?>)raptorMultiTask);
            this.addShowResultsOnCancelFailListener((RaptorTask<?>)raptorMultiTask);
        } else {
            scriptExecutorTask = raptorMultiTask;
        }
        this.addShowTaskProgressListener((RaptorTask<?>)scriptExecutorTask);
        this.addShowResultsOnCancelFailListener((RaptorTask<?>)scriptExecutorTask);
        if (scriptExecutorTask3 != null) {
            this.addStartTaskOnFinishListener((RaptorTask<?>)raptorMultiTask, (RaptorTask<?>)scriptExecutorTask3);
            this.addShowResultsOnFinishListener((RaptorTask<?>)scriptExecutorTask3);
        } else {
            this.addShowResultsOnFinishListener((RaptorTask<?>)raptorMultiTask);
        }
        return scriptExecutorTask;
    }

    private void addShowResultsOnFinishListener(RaptorTask<?> raptorTask) {
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                CopyToOracle.this.getResultsManager().reportResults(raptorTaskEvent, "COPY_TO_ORACLE_TASK_FINISHED");
            }
        });
    }

    private void addShowResultsOnCancelFailListener(RaptorTask<?> raptorTask) {
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                CopyToOracle.this.getResultsManager().reportResults(raptorTaskEvent, "COPY_TO_ORACLE_TASK_CANCELLED");
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                CopyToOracle.this.getResultsManager().reportResults(raptorTaskEvent, "COPY_TO_ORACLE_TASK_FAILED");
            }
        });
    }

    private void addShowTaskProgressListener(RaptorTask<?> raptorTask) {
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
                IdeAction ideAction = IdeAction.find((String)"TaskProgress.Show");
                if (ideAction != null) {
                    SwingUtilities.invokeLater(() -> {
                        try {
                            ideAction.performAction();
                        }
                        catch (Exception exception) {
                            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
                        }
                    });
                }
            }
        });
    }

    private void addStartTaskOnFinishListener(RaptorTask<?> raptorTask, final RaptorTask<?> raptorTask2) {
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                RaptorTaskManager.getInstance().addTask(raptorTask2);
            }
        });
    }

    protected String getPreScript(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, Element[] elementArray) {
        return null;
    }

    protected String getPostScript(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, Element[] elementArray) {
        return null;
    }

    private ScriptExecutorTask createScriptExecutorTask(String string, String string2, final String string3) {
        ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
        scriptRunnerContext.setScanOn(false);
        scriptRunnerContext.putProperty("sqldev.error.any.in", (Object)Boolean.FALSE);
        scriptRunnerContext.consumerRuning(true);
        scriptRunnerContext.setEscape(false);
        scriptRunnerContext.setSqlError(0);
        ScriptExecutorTask scriptExecutorTask = new ScriptExecutorTask(string, IRaptorTaskRunMode.TASKVIEWER, true, true){

            public void afterLoopProcessing() throws ExecutionException {
                super.afterLoopProcessing();
                if (this.wasErrorEncountered()) {
                    throw new ExecutionException((Throwable)new TaskException(this.getStatementErrorMessage()));
                }
            }

            public Connection getConnection() {
                if (null == super.getConnection()) {
                    try {
                        this.setConnection(Connections.getInstance().cloneConnection(string3));
                    }
                    catch (Exception exception) {
                        Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
                    }
                }
                return super.getConnection();
            }
        };
        scriptExecutorTask.setScriptRunnerContext(scriptRunnerContext);
        scriptExecutorTask.setStmt(string2);
        return scriptExecutorTask;
    }

    private void runTask(ScriptExecutorTask scriptExecutorTask, String string, BasicEditorPane basicEditorPane) {
        scriptExecutorTask.setCancellable(true);
        scriptExecutorTask.setPausable(true);
        scriptExecutorTask.getDescriptor().addListener((IRaptorTaskListener)new SchemaTaskListener(string, basicEditorPane, scriptExecutorTask));
        RaptorTaskManager.getInstance().addTask((RaptorTask)scriptExecutorTask);
    }

    public void setArgs(String string) {
    }

    public void setTargetConnection(ConnectionNames connectionNames) {
        this.targetConnection = connectionNames;
    }

    public ConnectionNames getTargetConnection() {
        return this.targetConnection;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public ExtractListModel getListModel(Element[] elementArray) {
        if (this._listModel == null) {
            ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
            for (Element element : elementArray) {
                DBObject dBObject = new DBObject(element);
                arrayList.add(dBObject);
            }
            this._listModel = new ExtractListModel(arrayList);
        }
        return this._listModel;
    }

    private void initResultsManager(ScriptExecutorTask scriptExecutorTask, RaptorMultiTask<ScriptExecutorTask> raptorMultiTask, ScriptExecutorTask scriptExecutorTask2, LogManager logManager) {
        this.resultsManager = new ResultsManager(scriptExecutorTask, raptorMultiTask, scriptExecutorTask2, logManager);
    }

    protected ResultsManager getResultsManager() {
        return this.resultsManager;
    }

    private void initLogManager(ExtractListModel extractListModel, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.logManager = new LogManager(extractListModel, bl, bl2, bl3, bl4);
    }

    protected LogManager getLogManager() {
        return this.logManager;
    }

    static class LogManager {
        private CopyToOracleLog log;
        private ExtractListModel listModel;
        private boolean withData;
        private boolean append;
        private boolean replace;
        private boolean truncate;

        public LogManager(ExtractListModel extractListModel, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.listModel = extractListModel;
            this.withData = bl;
            this.append = bl2;
            this.replace = bl3;
            this.truncate = bl4;
            this.log = new CopyToOracleLog();
        }

        public void logCopy(String string) {
            if (this.listModel != null) {
                this.log.openLog();
                List list = this.listModel.getList(0, new int[]{107});
                this.log.log(CopyPanelArb.getString((String)"COPIED_OBJECTS"));
                for (ExtractObject extractObject : list) {
                    DBObject dBObject = extractObject.getDBObject();
                    String string2 = DBURLFormatHelper.getCatalog((URL)dBObject.getURL());
                    string2 = string2 == null || string2.isEmpty() ? "" : string2 + ".";
                    this.log.log(dBObject.getObjectName() != null && !dBObject.getObjectName().isEmpty() ? Connections.getDisplayName((String)dBObject.getConnectionName()) + "." + string2 + dBObject.getSchemaName() + "." + dBObject.getObjectType() + "." + dBObject.getObjectName() : Connections.getDisplayName((String)dBObject.getConnectionName()) + "." + dBObject.getSchemaName() + "." + dBObject.getObjectFolderType() + " " + CopyPanelArb.getString((String)"FOLDER"));
                }
                if (this.listModel.getSchemas() == null || this.listModel.getSchemas().length == 0) {
                    this.log.log(CopyPanelArb.getString((String)"DROP_TARGET") + " " + Connections.getDisplayName((String)Connections.getDisplayName((String)this.listModel.getDestConnName())));
                } else {
                    this.log.log(CopyPanelArb.getString((String)"DROP_TARGET") + " " + Connections.getDisplayName((String)Connections.getDisplayName((String)this.listModel.getDestConnName())) + "." + this.listModel.getSchemas()[0]);
                }
                this.log.log(MnemonicUtil.extractLabelTextWithoutMnemonic((String)CopyWizArb.getString((String)"COPY_DDL_OPTION")) + ": " + (this.listModel.isDDLEnabled() ? CopyPanelArb.getString((String)"YES") : CopyPanelArb.getString((String)"NO")));
                if (this.listModel.isDDLEnabled()) {
                    this.log.log(this.replace ? CopyPanelArb.getString((String)"REPLACE") : CopyPanelArb.getString((String)"DO_NOT_REPLACE") + " " + CopyPanelArb.getString((String)"EXISTING_OBJECTS"));
                }
                this.log.log(MnemonicUtil.extractLabelTextWithoutMnemonic((String)CopyWizArb.getString((String)"COPY_DATA_OPTION")) + ": " + (this.withData ? CopyPanelArb.getString((String)"YES") : CopyPanelArb.getString((String)"NO")));
                if (this.withData && !this.replace) {
                    Object object = CopyPanelArb.getString((String)"SKIP_DATA");
                    if (this.append) {
                        object = CopyPanelArb.getString((String)"APPEND");
                    }
                    if (this.truncate) {
                        object = CopyPanelArb.getString((String)"TRUNCATE");
                    }
                    this.log.log((String)object + " " + CopyPanelArb.getString((String)"EXISTING_OBJECTS"));
                }
                this.log.log(string);
            }
            this.log.showLogFile();
        }
    }

    static class ResultsManager {
        private LogManager logManager;
        private ScriptExecutorTask preScriptTask;
        private RaptorMultiTask<ScriptExecutorTask> bridgeTasks;
        private ScriptExecutorTask postScriptTask;
        private String indent = "    ";
        private String nl = "\n";

        public ResultsManager(ScriptExecutorTask scriptExecutorTask, RaptorMultiTask<ScriptExecutorTask> raptorMultiTask, ScriptExecutorTask scriptExecutorTask2, LogManager logManager) {
            this.logManager = logManager;
            this.preScriptTask = scriptExecutorTask;
            this.bridgeTasks = raptorMultiTask;
            this.postScriptTask = scriptExecutorTask2;
        }

        public void reportResults(RaptorTaskEvent raptorTaskEvent, String string) {
            StringBuilder stringBuilder = new StringBuilder(CopyToOracleResources.get(string)).append('\n');
            stringBuilder.append('\n');
            this.resultsAppend(stringBuilder, this.preScriptTask, false);
            this.resultsAppend(stringBuilder, this.bridgeTasks, false);
            this.resultsAppend(stringBuilder, this.postScriptTask, false);
            String string2 = stringBuilder.toString();
            stringBuilder = new StringBuilder(CopyToOracleResources.get(string)).append('\n');
            stringBuilder.append('\n');
            this.resultsAppend(stringBuilder, this.preScriptTask, true);
            this.resultsAppend(stringBuilder, this.bridgeTasks, true);
            this.resultsAppend(stringBuilder, this.postScriptTask, true);
            String string3 = stringBuilder.toString();
            SwingUtilities.invokeLater(() -> {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)string2, (String)CopyToOracleResources.getString("COPY_TO_ORACLE_TASK_SHORT_NAME"), null);
                this.logManager.logCopy(string3);
            });
        }

        private void resultsAppend(StringBuilder stringBuilder, ScriptExecutorTask scriptExecutorTask, boolean bl) {
            if (null == scriptExecutorTask) {
                return;
            }
            if (scriptExecutorTask.getDescriptor().isCancelled()) {
                stringBuilder.append(scriptExecutorTask.getDescriptor().getName());
                this.resultsAppend(stringBuilder, this.indent, CopyToOracleResources.get("COPY_TO_ORACLE_TASK_CANCELLED"));
            } else if (scriptExecutorTask.wasErrorEncountered()) {
                stringBuilder.append(scriptExecutorTask.getDescriptor().getName());
                this.resultsAppend(stringBuilder, this.indent, scriptExecutorTask.getStatementErrorMessage());
            } else {
                String string = this.getScriptResult(scriptExecutorTask);
                if (string != null) {
                    stringBuilder.append(scriptExecutorTask.getDescriptor().getName());
                    this.resultsAppend(stringBuilder, this.indent, string);
                }
            }
            stringBuilder.append('\n');
        }

        private void resultsAppend(StringBuilder stringBuilder, RaptorMultiTask<ScriptExecutorTask> raptorMultiTask, boolean bl) {
            if (null == raptorMultiTask) {
                return;
            }
            List list = raptorMultiTask.getCancelledTasks();
            List list2 = raptorMultiTask.getFailedTasks();
            List list3 = raptorMultiTask.getFinishedTasks();
            if (list.size() > 0) {
                stringBuilder.append(CopyToOracleResources.format("COPY_TO_ORACLE_TABLES_CANCELLED", list.size())).append('\n');
                if (bl) {
                    for (ScriptExecutorTask scriptExecutorTask : list) {
                        this.resultsAppend(stringBuilder, this.indent, scriptExecutorTask.getDescriptor().getName());
                    }
                }
                stringBuilder.append('\n');
            }
            if (list2.size() > 0) {
                stringBuilder.append(CopyToOracleResources.format("COPY_TO_ORACLE_TABLES_FAILED", list2.size())).append('\n');
                if (bl) {
                    for (ScriptExecutorTask scriptExecutorTask : list2) {
                        this.resultsAppend(stringBuilder, this.indent, scriptExecutorTask.getStatementErrorMessage());
                    }
                }
                stringBuilder.append('\n');
            }
            stringBuilder.append(CopyToOracleResources.format("COPY_TO_ORACLE_TABLES_FINISHED", list3.size())).append('\n');
            if (bl) {
                for (ScriptExecutorTask scriptExecutorTask : list3) {
                    String string = this.getScriptResult(scriptExecutorTask);
                    if (string != null) {
                        this.resultsAppend(stringBuilder, this.indent, string);
                        continue;
                    }
                    this.resultsAppend(stringBuilder, this.indent, scriptExecutorTask.getDescriptor().getName() + " " + scriptExecutorTask.getDescriptor().getMessage());
                }
            }
            stringBuilder.append('\n');
        }

        private void resultsAppend(StringBuilder stringBuilder, String string, String string2) {
            String string3 = this.nl + string + string;
            String string4 = string2;
            if (string4.endsWith(this.nl)) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            string4 = string4.replace(this.nl, string3);
            stringBuilder.append(string).append(string4).append(this.nl);
        }

        private String getScriptResult(ScriptExecutorTask scriptExecutorTask) {
            String string = null;
            ArrayList arrayList = (ArrayList)scriptExecutorTask.getScriptRunnerContext().getProperty("script.runner.results");
            if (arrayList != null && !arrayList.isEmpty()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (ScriptResult scriptResult : arrayList) {
                    stringBuffer.append(scriptResult.getReport()).append('\n');
                }
                string = stringBuffer.toString();
            }
            return string;
        }
    }

    static class SchemaTaskListener
    extends RaptorTaskAdapter {
        private String _taskFullName;
        private BasicEditorPane _bep;
        private final ScriptExecutorTask _task;

        SchemaTaskListener(String string, BasicEditorPane basicEditorPane, ScriptExecutorTask scriptExecutorTask) {
            this._taskFullName = string;
            this._bep = basicEditorPane;
            this._task = scriptExecutorTask;
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string = _taskFullName + ". " + CopyToOracleResources.getString("COPY_TO_ORACLE_TASK_FAILED");
                        Logger.severe(this.getClass(), (String)string);
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)CopyToOracleResources.getString("COPY_TO_ORACLE_TASK_SHORT_NAME"), null);
                    }
                    catch (Exception exception) {
                        Logger.warn(this.getClass(), (Throwable)exception);
                    }
                }
            });
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            String string = this._taskFullName + ". " + CopyToOracleResources.getString("COPY_TO_ORACLE_TASK_CANCELLED");
            Logger.warn(((Object)((Object)this)).getClass(), (String)string);
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string = "";
                        boolean bl = true;
                        try {
                            Boolean bl2 = (Boolean)_task.getScriptRunnerContext().getProperty("sqldev.error.any.in");
                            if (bl2 == null || bl2.equals(Boolean.FALSE)) {
                                string = CopyToOracleResources.getString("COPY_TO_ORACLE_TASK_FINISHED");
                            } else {
                                bl = false;
                                ScriptUtils.showError((BasicEditorPane)_bep);
                            }
                        }
                        catch (Exception exception) {
                            string = _taskFullName + ". " + CopyToOracleResources.getString("COPY_TO_ORACLE_TASK_FAILED");
                        }
                        if (bl) {
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)CopyToOracleResources.getString("COPY_TO_ORACLE_TASK_SHORT_NAME"), null);
                        }
                    }
                    catch (Exception exception) {
                        Logger.warn(this.getClass(), (Throwable)exception);
                    }
                }
            });
        }
    }
}

