/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.hive;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.thirdparty.hive.Messages;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class HiveBasicPanel
extends JPanel
implements CDComponentView {
    private static final String DRIVER_CLASSNAME = "com.cloudera.hive.jdbc4.HS2Driver";
    private static final String DRIVER_CLASSNAME_41 = "com.cloudera.hive.jdbc41.HS2Driver";
    private static final String[] drivers = new String[]{"com.cloudera.hive.jdbc4.HS2Driver", "com.cloudera.hive.jdbc41.HS2Driver"};
    private static final String DRIVER_NAME = "CLOUDERA HIVE JDBC 4.0";
    private static final String DRIVER_NAME_41 = "CLOUDERA HIVE JDBC 4.1";
    private static final String[] driverNames = new String[]{"CLOUDERA HIVE JDBC 4.0", "CLOUDERA HIVE JDBC 4.1"};
    private static final String URL_PREFIX = "jdbc:hive2://";
    public static final String PARAM_AUTHMECH = "AuthMech";
    public static final String PARAM_UID = "UID";
    public static final String PARAM_PWD = "PWD";
    public static final String PARAM_SSLKEYSTORE = "SSLKeyStore";
    public static final String PARAM_SSLKEYSTOREPWD = "SSLKeyStorePwd";
    public static final String PARAM_ALLOWSELFSIGNEDCERTS = "AllowSelfSignedCerts";
    public static final String PARAM_CAISSUEDCERTNAMESMISMATCH = "CAIssuedCertNamesMismatch";
    public static final String PARAM_DECIMALCOLUMNSCALE = "DecimalColumnScale";
    public static final String PARAM_DEFAULTSTRINGCOLUMNLENGTH = "DefaultStringColumnLength";
    public static final String PARAM_SOCKETTIMEOUT = "SocketTimeout";
    public static final String PARAM_ROWSFETCHEDPERBLOCK = "RowsFetchedPerBlock";
    public static final String PARAM_KRBSERVICENAME = "KrbServiceName";
    public static final String PARAM_KRBREALM = "KrbRealm";
    public static final String PARAM_KRBHOSTFQDN = "KrbHostFQDN";
    public static final String PARAM_DELEGATIONUID = "DelegationUID";
    public static final String PARAM_USENATIVEQUERY = "UseNativeQuery";
    public static final String PARAM_CATALOGSCHEMASWITCH = "CatalogSchemaSwitch";
    public static final String PARAM_PREPAREDMETALIMITZERO = "PreparedMetaLimitZero";
    public static final String PARAM_DATABASE = "DATABASE";
    public static final String PARAM_PORT = "DBS_PORT";
    public static final String JDBC40 = "JDBC4.0";
    public static final String JDBC41 = "JDBC4.1";
    private Map<String, Object> parameterDefaults = new TreeMap<String, Object>(){
        {
            this.put(HiveBasicPanel.PARAM_PORT, 10000);
            this.put(HiveBasicPanel.PARAM_DATABASE, "default");
        }
    };
    private Map<String, JComponent> parameterEditors = new TreeMap<String, JComponent>(){
        {
            this.put(HiveBasicPanel.PARAM_AUTHMECH, new JComboBox<String>(new String[]{"0", "1", "2", "3", "4"}));
            JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(10000, 1, Integer.MAX_VALUE, 1));
            jSpinner.setEditor(new JSpinner.NumberEditor(jSpinner, "#0"));
            this.put(HiveBasicPanel.PARAM_UID, new JTextField());
            this.put(HiveBasicPanel.PARAM_PWD, new JTextField());
            this.put(HiveBasicPanel.PARAM_SSLKEYSTORE, new JTextField());
            this.put(HiveBasicPanel.PARAM_SSLKEYSTOREPWD, new JTextField());
            this.put(HiveBasicPanel.PARAM_KRBSERVICENAME, new JTextField());
            this.put(HiveBasicPanel.PARAM_KRBREALM, new JTextField());
            this.put(HiveBasicPanel.PARAM_KRBHOSTFQDN, new JTextField());
        }
    };
    private List<String> usedParameters = new Vector<String>();
    private Set<String> availableParameters = new TreeSet<String>(){
        {
            this.add(HiveBasicPanel.PARAM_ALLOWSELFSIGNEDCERTS);
            this.add(HiveBasicPanel.PARAM_AUTHMECH);
            this.add(HiveBasicPanel.PARAM_CAISSUEDCERTNAMESMISMATCH);
            this.add(HiveBasicPanel.PARAM_CATALOGSCHEMASWITCH);
            this.add(HiveBasicPanel.PARAM_DECIMALCOLUMNSCALE);
            this.add(HiveBasicPanel.PARAM_DEFAULTSTRINGCOLUMNLENGTH);
            this.add(HiveBasicPanel.PARAM_DELEGATIONUID);
            this.add(HiveBasicPanel.PARAM_KRBHOSTFQDN);
            this.add(HiveBasicPanel.PARAM_KRBREALM);
            this.add(HiveBasicPanel.PARAM_KRBSERVICENAME);
            this.add(HiveBasicPanel.PARAM_PREPAREDMETALIMITZERO);
            this.add(HiveBasicPanel.PARAM_PWD);
            this.add(HiveBasicPanel.PARAM_ROWSFETCHEDPERBLOCK);
            this.add(HiveBasicPanel.PARAM_SOCKETTIMEOUT);
            this.add(HiveBasicPanel.PARAM_SSLKEYSTORE);
            this.add(HiveBasicPanel.PARAM_SSLKEYSTOREPWD);
            this.add(HiveBasicPanel.PARAM_UID);
            this.add(HiveBasicPanel.PARAM_USENATIVEQUERY);
        }
    };
    private JLabel hostNameLabel = new JLabel();
    private JLabel portLabel = new JLabel();
    private JLabel databaseLabel = new JLabel();
    private JLabel driverLabel = new JLabel();
    private JTextField hostNameTextField = new JTextField();
    private JTextField portField = new JTextField();
    private JTextField databaseTextField = new JTextField();
    private JComboBox<String> driverCombo = new JComboBox();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel connectionParametersPanel = new JPanel();
    private JPanel jPanel1 = new JPanel();
    private JButton addButton = new JButton();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JButton deleteButton = new JButton();
    private JLabel connectionParametersLabel = new JLabel();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JPanel fillerPanel = new JPanel();

    public HiveBasicPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        ResourceUtils.resLabel((JLabel)this.hostNameLabel, (Component)this.hostNameTextField, (String)Messages.getString("HiveBasicPanel.hostNameLabel"));
        ResourceUtils.resLabel((JLabel)this.portLabel, (Component)this.portField, (String)Messages.getString("HiveBasicPanel.PortLabel"));
        ResourceUtils.resLabel((JLabel)this.databaseLabel, (Component)this.databaseTextField, (String)Messages.getString("HiveBasicPanel.databaseLabel"));
        ResourceUtils.resLabel((JLabel)this.driverLabel, this.driverCombo, (String)Messages.getString("HiveBasicPanel.driverLabel"));
        ResourceUtils.resButton((AbstractButton)this.addButton, (String)Messages.getString("HiveBasicPanel.addButton"));
        ResourceUtils.resButton((AbstractButton)this.deleteButton, (String)Messages.getString("HiveBasicPanel.deleteButton"));
        ResourceUtils.resLabel((JLabel)this.connectionParametersLabel, (Component)this.connectionParametersPanel, (String)Messages.getString("HiveBasicPanel.connectionParametersLabel"));
        for (String string : driverNames) {
            this.driverCombo.addItem(string);
        }
        this.driverCombo.setSelectedIndex(0);
        this.connectionParametersPanel.setLayout(this.gridBagLayout3);
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HiveBasicPanel.this.addButton_actionPerformed(actionEvent);
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HiveBasicPanel.this.deleteButton_actionPerformed(actionEvent);
            }
        });
        int n = 0;
        this.add((Component)this.hostNameLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.hostNameTextField, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.portLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.portField, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.databaseLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.databaseTextField, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.driverLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add(this.driverCombo, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.connectionParametersPanel.add((Component)this.fillerPanel, new GridBagConstraints(0, 200, 2, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.connectionParametersPanel, null);
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.jPanel1.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.jPanel1.add((Component)this.deleteButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.jPanel1, new GridBagConstraints(1, ++n, 2, 1, 0.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.connectionParametersLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
    }

    private String getValue(JComponent jComponent) {
        if (jComponent instanceof JComboBox) {
            return ((JComboBox)jComponent).getSelectedItem().toString().trim();
        }
        if (jComponent instanceof JTextField) {
            return ((JTextField)jComponent).getText().trim();
        }
        if (jComponent instanceof JSpinner) {
            return ((JSpinner)jComponent).getValue().toString().trim();
        }
        return null;
    }

    private void setValue(JComponent jComponent, String string) {
        if (jComponent == null || string == null) {
            return;
        }
        if (jComponent instanceof JComboBox) {
            ((JComboBox)jComponent).setSelectedItem(string);
        }
        if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).setText(string);
        }
        if (jComponent instanceof JSpinner) {
            ((JSpinner)jComponent).setValue(Integer.valueOf(string));
        }
    }

    private void refreshPanel() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                HiveBasicPanel.this.connectionParametersPanel.removeAll();
                for (int i = 0; i < HiveBasicPanel.this.usedParameters.size(); ++i) {
                    String string = (String)HiveBasicPanel.this.usedParameters.get(i);
                    JComponent jComponent = (JComponent)HiveBasicPanel.this.parameterEditors.get(string);
                    JLabel jLabel = new JLabel(string);
                    int n = 0;
                    if (jComponent instanceof JTextField) {
                        n = 2;
                    }
                    HiveBasicPanel.this.connectionParametersPanel.add((Component)jLabel, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
                    HiveBasicPanel.this.connectionParametersPanel.add((Component)jComponent, new GridBagConstraints(1, i, 1, 1, 1.0, 0.0, 17, n, new Insets(4, 4, 4, 4), 0, 0));
                }
                HiveBasicPanel.this.connectionParametersPanel.add((Component)HiveBasicPanel.this.fillerPanel, new GridBagConstraints(0, HiveBasicPanel.this.usedParameters.size(), 2, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                HiveBasicPanel.this.connectionParametersPanel.validate();
                HiveBasicPanel.this.jScrollPane1.validate();
                HiveBasicPanel.this.connectionParametersPanel.repaint();
            }
        };
        try {
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addParameter(String string, Object object) {
        if (this.parameterEditors.get(string) == null) {
            return;
        }
        this.setValue(this.parameterEditors.get(string), object == null ? null : object.toString());
        if (this.usedParameters.contains(string) || !this.availableParameters.contains(string)) {
            return;
        }
        this.availableParameters.remove(string);
        this.usedParameters.add(string);
        this.refreshPanel();
    }

    private void deleteParameter(String string) {
        if (!this.usedParameters.contains(string) || this.availableParameters.contains(string)) {
            return;
        }
        this.availableParameters.add(string);
        this.usedParameters.remove(string);
        this.refreshPanel();
    }

    public String[] getSupportedDrivers() {
        return drivers;
    }

    public String getSelectedDriver() {
        if (this.driverCombo == null) {
            return drivers[0];
        }
        return drivers[this.driverCombo.getSelectedIndex()];
    }

    public void generateProperties(Properties properties) {
        String string;
        String string2;
        int n;
        properties.setProperty("hostname", this.hostNameTextField.getText().trim());
        properties.setProperty("port", this.portField.getText().toString());
        properties.setProperty(PARAM_DATABASE, this.databaseTextField.getText().trim());
        properties.setProperty("driver", drivers[this.driverCombo.getSelectedIndex()]);
        String string3 = URL_PREFIX + this.hostNameTextField.getText().trim();
        string3 = string3 + ":" + this.portField.getText().trim();
        string3 = string3 + "/" + this.databaseTextField.getText().trim();
        for (n = 0; n < this.usedParameters.size(); ++n) {
            string2 = this.usedParameters.get(n);
            string = this.getValue(this.parameterEditors.get(string2));
            if (string == null || string.length() == 0) continue;
            properties.setProperty(string2, string);
        }
        if (this.usedParameters.size() > 0) {
            for (n = 0; n < this.usedParameters.size(); ++n) {
                if (!string3.trim().endsWith(";")) {
                    string3 = string3.trim() + ";";
                }
                if ((string = this.getValue(this.parameterEditors.get(string2 = this.usedParameters.get(n)))).length() == 0) continue;
                if (string.contains(",")) {
                    string = "'" + string + "'";
                }
                string3 = string3 + string2 + "=" + string;
            }
        }
        if (properties.getProperty("user") != null && properties.getProperty("user").trim().length() > 0) {
            string3 = string3 + ";UID=" + properties.getProperty("user");
        } else {
            properties.put("user", "   ");
        }
        if (properties.getProperty("password") != null && properties.getProperty("password").trim().length() > 0) {
            string3 = string3 + ";PWD=" + properties.getProperty("password");
        } else {
            properties.put("password", "   ");
        }
        properties.setProperty("customUrl", string3);
    }

    public void clear() {
        this.hostNameTextField.setText("");
        this.availableParameters.addAll(this.usedParameters);
        this.usedParameters.clear();
        this.refreshPanel();
    }

    public void setDefaultPrompts() {
        this.clear();
        this.addParameter(PARAM_DATABASE, this.parameterDefaults.get(PARAM_DATABASE));
        this.addParameter(PARAM_PORT, this.parameterDefaults.get(PARAM_PORT));
    }

    public void updatePrompts(Properties properties) {
        this.clear();
        if (properties.containsKey("hostname")) {
            this.hostNameTextField.setText(properties.getProperty("hostname"));
        }
        if (properties.containsKey(PARAM_DATABASE)) {
            this.databaseTextField.setText(properties.getProperty(PARAM_DATABASE));
        } else {
            this.addParameter(PARAM_DATABASE, this.parameterDefaults.get(PARAM_DATABASE));
            this.databaseTextField.setText(this.parameterDefaults.get(PARAM_DATABASE).toString());
        }
        if (properties.containsKey("driver")) {
            int n = 0;
            String string = properties.getProperty("driver");
            for (int i = 0; i < drivers.length; ++i) {
                if (!drivers[i].equals(string)) continue;
                n = i;
            }
            this.driverCombo.setSelectedIndex(n);
        } else {
            this.driverCombo.setSelectedIndex(0);
        }
        if (properties.containsKey("port")) {
            this.addParameter(PARAM_PORT, properties.getProperty("port"));
            this.portField.setText(properties.getProperty("port"));
        } else {
            this.portField.setText(this.parameterDefaults.get("port").toString());
        }
        for (String string : properties.stringPropertyNames()) {
            if (this.availableParameters.contains(string)) {
                this.addParameter(string, properties.getProperty(string));
                continue;
            }
            if (!this.usedParameters.contains(string)) continue;
            this.addParameter(string, properties.getProperty(string));
        }
    }

    private void addButton_actionPerformed(ActionEvent actionEvent) {
        actionEvent.getSource();
        AddDeletePanel addDeletePanel = new AddDeletePanel(Messages.getString("HiveBasicPanel.addParametersMessage"), this.availableParameters.toArray(new String[this.availableParameters.size()]));
        boolean bl = MessageDialog.confirm((Component)this, (Object)addDeletePanel, (String)Messages.getString("HiveBasicPanel.addParametersTitle"), (String)"f1_adddeleteteradataparam_html", (boolean)false, (String)Messages.getString("HiveBasicPanel.OK"), (String)Messages.getString("HiveBasicPanel.Cancel"));
        if (bl) {
            String[] stringArray;
            for (String string : stringArray = addDeletePanel.getSelection()) {
                this.addParameter(string, null);
            }
        }
    }

    private void deleteButton_actionPerformed(ActionEvent actionEvent) {
        actionEvent.getSource();
        AddDeletePanel addDeletePanel = new AddDeletePanel(Messages.getString("HiveBasicPanel.deleteParametersMessage"), this.usedParameters.toArray(new String[this.usedParameters.size()]));
        boolean bl = MessageDialog.confirm((Component)this, (Object)addDeletePanel, (String)Messages.getString("HiveBasicPanel.deleteParametersTitle"), (String)"f1_adddeleteteradataparam_html", (boolean)false, (String)Messages.getString("HiveBasicPanel.OK"), (String)Messages.getString("HiveBasicPanel.Cancel"));
        if (bl) {
            String[] stringArray;
            for (String string : stringArray = addDeletePanel.getSelection()) {
                this.deleteParameter(string);
            }
        }
    }

    private static class AddDeletePanel
    extends JPanel {
        private BorderLayout borderLayout1 = new BorderLayout();
        private JLabel messageLabel = new JLabel();
        private JScrollPane scrollPane = new JScrollPane();
        private JList propertyList = new JList();
        private String[] propertyValues;
        private String message;
        private DefaultListModel propertyModel = new DefaultListModel();

        public AddDeletePanel(String string, String[] stringArray) {
            try {
                this.propertyValues = stringArray;
                this.message = string;
                this.jbInit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void jbInit() throws Exception {
            this.setLayout(this.borderLayout1);
            this.messageLabel.setText(this.message);
            this.add((Component)this.messageLabel, "North");
            for (String string : this.propertyValues) {
                this.propertyModel.addElement(string);
            }
            this.propertyList.setModel(this.propertyModel);
            this.scrollPane.getViewport().add((Component)this.propertyList, null);
            this.add((Component)this.scrollPane, "Center");
        }

        public String[] getSelection() {
            int[] nArray = this.propertyList.getSelectedIndices();
            if (nArray == null) {
                return new String[0];
            }
            String[] stringArray = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                stringArray[i] = this.propertyValues[nArray[i]];
            }
            return stringArray;
        }
    }
}

