/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.graphics;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import oracle.bali.share.collection.StringKey;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.UIManager;
import oracle.ewt.graphics.HitTestMask;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.graphics.NullImageFilter;
import oracle.ewt.graphics.TransparencyTester;

public class SynthesizingImageSet
implements ImageSet {
    public static final Object NO_MOUSE_FILTER = new StringKey("noMouseFilter");
    private static final int _COMPUTING_TRANSPARENCY = -1;
    private static final int _IS_NOT_TRANSPARENT = 0;
    private static final int _IS_TRANSPARENT = 1;
    private transient boolean _imageLoaded;
    private transient int _width;
    private transient int _height;
    private transient Image[] _images = new Image[160];
    private transient int _isTransparent = -1;
    private transient HitTestMask _hitTester;
    private int _baseImageState;
    private int _synthMask;
    private LookAndFeel _lookAndFeel;

    public SynthesizingImageSet(Image image) {
        this(image, 0, 159);
    }

    public SynthesizingImageSet(Image image, int n) {
        this(image, 0, n);
    }

    public SynthesizingImageSet(Image image, int n, int n2) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        this._images[n] = image;
        this._baseImageState = n;
        this._synthMask = n2;
        this._lookAndFeel = UIManager.getLookAndFeel();
    }

    public Dimension getSize() {
        this._loadImageIfNecessary();
        return new Dimension(this._width, this._height);
    }

    public void paintImage(int n, Graphics graphics, int n2, int n3, ImageObserver imageObserver) {
        this._loadImageIfNecessary();
        graphics.drawImage(this._getImage(n), n2, n3, imageObserver);
    }

    public boolean contains(int n, int n2) {
        if (n >= 0 && n2 >= 0 && n < this._width && n2 < this._height) {
            if (this.isTransparent()) {
                if (this._hitTester == null) {
                    this._hitTester = new HitTestMask(this._images[this._baseImageState]);
                }
                return this._hitTester.contains(n, n2);
            }
            return true;
        }
        return false;
    }

    public boolean isTransparent() {
        if (this._isTransparent == -1) {
            TransparencyTester transparencyTester = new TransparencyTester(this._images[this._baseImageState]);
            this._isTransparent = transparencyTester.isTransparent() ? 1 : 0;
        }
        return this._isTransparent != 0;
    }

    public int getAvailableImageFlags() {
        return this._synthMask;
    }

    private Image _getImage(int n) {
        Image image = this._images[n];
        if (image == null) {
            int n2 = this._baseImageState;
            int n3 = n & (this._synthMask | n2);
            image = this._images[n3];
            if (image == null) {
                UIDefaults uIDefaults;
                ImageFilter imageFilter;
                image = this._images[n2];
                if ((n3 & 1) != 0) {
                    Image image2 = this._images[n2 | 1];
                    if (image2 != null) {
                        image = image2;
                    } else {
                        UIDefaults uIDefaults2 = this._lookAndFeel.getDefaults();
                        ImageFilter imageFilter2 = uIDefaults2.getImageFilter(LookAndFeel.DISABLING_FILTER);
                        image = ImageUtils.createFilteredImage(image, imageFilter2);
                    }
                } else if ((n2 & 0x10) != 0 && (n3 & 0x10) == 0 && (imageFilter = (uIDefaults = this._lookAndFeel.getDefaults()).getImageFilter(NO_MOUSE_FILTER)) != null && imageFilter != NullImageFilter.getImageFilter()) {
                    image = ImageUtils.createFilteredImage(image, imageFilter);
                }
            }
            this._images[n] = image;
        }
        return image;
    }

    private void _loadImageIfNecessary() {
        if (!this._imageLoaded) {
            Image image = this._images[this._baseImageState];
            this._imageLoaded = ImageUtils.loadImage(image);
            this._width = image.getWidth(null);
            this._height = image.getHeight(null);
        }
    }
}

